/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ChromiumLineBreakpoint;

public class ChromiumBreakpointAdapter {
    private static final String JSDT_BREAKPOINT_MODEL_ID = "org.eclipse.wst.jsdt.debug.model";
    private static final Map<IBreakpoint, ChromiumLineBreakpoint> JSDT_TO_CHROMIUM_STORAGE = new HashMap<IBreakpoint, ChromiumLineBreakpoint>();

    public static ChromiumLineBreakpoint tryCastBreakpoint(IBreakpoint breakpoint) {
        ChromiumLineBreakpoint chromiumBreakpoint = null;
        if (ChromiumBreakpointAdapter.isChromiumLineBreakPoint(breakpoint)) {
            chromiumBreakpoint = (ChromiumLineBreakpoint)breakpoint;
        } else if (ChromiumBreakpointAdapter.isJSDTBreakpoint(breakpoint)) {
            chromiumBreakpoint = JSDT_TO_CHROMIUM_STORAGE.get(breakpoint);
        }
        return chromiumBreakpoint;
    }

    public static ChromiumLineBreakpoint tryCastBreakpointOnAddition(IBreakpoint breakpoint) {
        ChromiumLineBreakpoint chromiumBreakpoint = null;
        if (ChromiumBreakpointAdapter.isChromiumLineBreakPoint(breakpoint)) {
            chromiumBreakpoint = (ChromiumLineBreakpoint)breakpoint;
        } else if (ChromiumBreakpointAdapter.isJSDTBreakpoint(breakpoint)) {
            try {
                chromiumBreakpoint = new ChromiumLineBreakpoint(breakpoint);
                JSDT_TO_CHROMIUM_STORAGE.put(breakpoint, chromiumBreakpoint);
            }
            catch (CoreException e) {
                ChromiumDebugPlugin.logError(e.getMessage(), new Object[0]);
            }
        }
        return chromiumBreakpoint;
    }

    public static ChromiumLineBreakpoint tryCastBreakpointOnRemoval(IBreakpoint breakpoint) {
        ChromiumLineBreakpoint chromiumBreakpoint = null;
        if (ChromiumBreakpointAdapter.isChromiumLineBreakPoint(breakpoint)) {
            chromiumBreakpoint = (ChromiumLineBreakpoint)breakpoint;
        } else if (ChromiumBreakpointAdapter.isJSDTBreakpoint(breakpoint)) {
            chromiumBreakpoint = JSDT_TO_CHROMIUM_STORAGE.get(breakpoint);
            JSDT_TO_CHROMIUM_STORAGE.remove(breakpoint);
        }
        return chromiumBreakpoint;
    }

    private static boolean isChromiumLineBreakPoint(IBreakpoint breakpoint) {
        return breakpoint instanceof ChromiumLineBreakpoint && "org.eclipse.wst.jsdt.chromium.debug".equals(breakpoint.getModelIdentifier());
    }

    private static boolean isJSDTBreakpoint(IBreakpoint breakpoint) {
        return JSDT_BREAKPOINT_MODEL_ID.equals(breakpoint.getModelIdentifier());
    }
}

