/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.cdt.core.parser.ISignificantMacros;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.parser.scanner.StreamHasher;

public class SignificantMacros
implements ISignificantMacros {
    public static final char[] DEFINED = new char[1];
    public static final char[] UNDEFINED = new char[]{'\u0001'};
    private static final Comparator<char[]> SORTER = new Comparator<char[]>(){

        @Override
        public int compare(char[] s1, char[] s2) {
            return CharArrayUtils.compare(s1, s2);
        }
    };
    private final char[] fEncoded;
    private int fHash;

    public SignificantMacros(char[] encoded) {
        assert (encoded != null);
        this.fEncoded = encoded;
    }

    public SignificantMacros(CharArrayObjectMap<char[]> sigMacros) {
        this.fEncoded = this.encode(sigMacros);
    }

    private char[] encode(CharArrayObjectMap<char[]> sigMacros) {
        StringBuilder buffer = new StringBuilder();
        char[][] keys = sigMacros.keys();
        Arrays.sort(keys, SORTER);
        char[][] cArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            char[] name = cArray[n2];
            char[] value = sigMacros.get(name);
            buffer.append((char)name.length).append(name);
            buffer.append((char)value.length).append(value);
            ++n2;
        }
        int len = buffer.length();
        char[] result = new char[len];
        buffer.getChars(0, len, result, 0);
        return result;
    }

    public int hashCode() {
        int h = this.fHash;
        if (h == 0) {
            char[] val = this.fEncoded;
            int len = this.fEncoded.length;
            int i = 0;
            while (i < len) {
                h = 31 * h + val[i];
                ++i;
            }
            this.fHash = h;
        }
        return h;
    }

    public boolean equals(Object obj) {
        return obj instanceof SignificantMacros && this.hashCode() == obj.hashCode() && CharArrayUtils.equals(this.fEncoded, ((SignificantMacros)obj).fEncoded);
    }

    @Override
    public boolean accept(ISignificantMacros.IVisitor visitor) {
        char[] encoded = this.fEncoded;
        int len = encoded.length;
        int i = 0;
        while (i < len) {
            char[] value;
            char len2;
            char len1;
            int v;
            if ((v = i + (len1 = encoded[i++])) >= len || v + (len2 = encoded[v++]) > len) break;
            char[] macro = this.extract(encoded, i, len1);
            i = v + len2;
            if (len2 == '\u0001') {
                if (encoded[v] == UNDEFINED[0]) {
                    if (visitor.visitUndefined(macro)) continue;
                    return false;
                }
                if (encoded[v] == DEFINED[0]) {
                    if (visitor.visitDefined(macro)) continue;
                    return false;
                }
            }
            if (visitor.visitValue(macro, value = this.extract(encoded, v, len2))) continue;
            return false;
        }
        return true;
    }

    public char[] extract(char[] source, int from, int length) {
        char[] value = new char[length];
        System.arraycopy(source, from, value, 0, length);
        return value;
    }

    @Override
    public char[] encode() {
        return this.fEncoded;
    }

    public String toString() {
        final StringBuilder buf = new StringBuilder();
        buf.append('{');
        this.accept(new ISignificantMacros.IVisitor(){

            @Override
            public boolean visitValue(char[] macro, char[] value) {
                buf.append(macro).append('=').append(value).append(',');
                return true;
            }

            @Override
            public boolean visitUndefined(char[] macro) {
                buf.append(macro).append('=').append("null,");
                return true;
            }

            @Override
            public boolean visitDefined(char[] macro) {
                buf.append(macro).append('=').append("*,");
                return true;
            }
        });
        int buflen = buf.length();
        if (buflen > 1) {
            buf.setLength(buflen - 1);
        }
        buf.append('}');
        return buf.toString();
    }

    public static char[] shortenValue(char[] expansion) {
        if (expansion.length <= 16) {
            return expansion;
        }
        char[] result = new char[16];
        System.arraycopy(expansion, 0, result, 0, 8);
        StreamHasher hasher = new StreamHasher();
        hasher.addChunk(expansion);
        long hash = hasher.computeHash();
        int i = 0;
        while (i < 8) {
            result[8 + i] = (char)(hash & 0xFFL);
            hash >>= 1;
            ++i;
        }
        return result;
    }
}

