/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.internal.sourcemap;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.chromium.debug.core.internal.sourcemap.SourceMapDecoder;
import org.eclipse.wst.jsdt.chromium.debug.core.internal.sourcemap.SourceMapInfo;
import org.eclipse.wst.jsdt.chromium.debug.core.internal.sourcemap.SourceMapInfoEntry;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.TextSectionMapping;

public class SourceMap {
    private String version;
    private String[] sources;
    private String[] names;
    private String sourceRoot;
    private String[] sourcesContent;
    private String mappings;
    private String file;
    private SourceMapInfoEntry[] entries;
    private Map<String, TextSectionMapping> maps = new HashMap<String, TextSectionMapping>();

    public static SourceMap load(Reader reader) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        SourceMap sourceMap = (SourceMap)gson.fromJson(reader, SourceMap.class);
        if (sourceMap == null) {
            throw new JsonSyntaxException("JSON Syntax error");
        }
        sourceMap.update();
        return sourceMap;
    }

    private void update() {
        if (this.sourceRoot != null && this.sourceRoot.length() > 0) {
            int i = 0;
            while (i < this.sources.length) {
                this.sources[i] = String.valueOf(this.sourceRoot) + this.sources[i];
                ++i;
            }
        }
        List<SourceMapInfoEntry> result = SourceMapDecoder.decode(this.sources, this.names, this.mappings);
        this.entries = result.toArray(new SourceMapInfoEntry[result.size()]);
    }

    public static SourceMap load(InputStream in) {
        SourceMap sourceMap;
        block7: {
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader(in);
                sourceMap = SourceMap.load(reader);
                if (reader == null) break block7;
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((Reader)reader).close();
            }
            catch (IOException iOException) {}
        }
        return sourceMap;
    }

    public TextSectionMapping getMapping(String file) {
        TextSectionMapping mapping = this.maps.get(file);
        if (mapping == null) {
            mapping = new SourceMapTextSectionMapping(file);
            this.maps.put(file, mapping);
        }
        return mapping;
    }

    /*
     * Unable to fully structure code
     */
    public SourceMapInfo getMappingFor(int line, int column) {
        index = this.findIndexForLine(line);
        if (index == -1) {
            return null;
        }
        entry = this.entries[index];
        if (column != -1) ** GOTO lbl14
        return entry.getInfo();
lbl-1000:
        // 1 sources

        {
            entry = this.entries[index];
            if (entry.column <= column) {
                if (entry.endColumn == -1) {
                    return entry.getInfo();
                }
                if (column < entry.endColumn) {
                    return entry.getInfo();
                }
            }
            ++index;
lbl14:
            // 2 sources

            ** while (index < this.entries.length)
        }
lbl15:
        // 1 sources

        return null;
    }

    /*
     * Unable to fully structure code
     */
    private int findIndexForLine(int line) {
        location = Arrays.binarySearch(this.entries, SourceMapInfoEntry.forLine(line), SourceMapInfoEntry.lineComparator());
        if (location >= 0) ** GOTO lbl5
        return -1;
lbl-1000:
        // 1 sources

        {
            --location;
lbl5:
            // 2 sources

            ** while (location > 0 && this.entries[location - 1].line == line)
        }
lbl6:
        // 1 sources

        return location;
    }

    public TextSectionMapping.TextPoint getReverseMappingsFor(String file, int line, int column) {
        SourceMapInfoEntry[] sourceMapInfoEntryArray = this.entries;
        int n = this.entries.length;
        int n2 = 0;
        while (n2 < n) {
            SourceMapInfoEntry entry = sourceMapInfoEntryArray[n2];
            SourceMapInfo info = entry.getInfo();
            if (info != null && line == info.getLine() && file.equals(info.getFile())) {
                return new TextSectionMapping.TextPoint(entry.line, entry.column);
            }
            ++n2;
        }
        return null;
    }

    private class SourceMapTextSectionMapping
    implements TextSectionMapping {
        private String file;

        public SourceMapTextSectionMapping(String file) {
            this.file = file;
        }

        @Override
        public TextSectionMapping.TextPoint transform(TextSectionMapping.TextPoint point, TextSectionMapping.Direction direction) {
            if (direction == TextSectionMapping.Direction.DIRECT) {
                return SourceMap.this.getReverseMappingsFor(this.file, point.getLine(), point.getColumn());
            }
            SourceMapInfo info = SourceMap.this.getMappingFor(point.getLine(), point.getColumn());
            if (info != null) {
                return new TextSectionMapping.TextPoint(info.getLine(), info.getColumn());
            }
            return SourceMap.this.getReverseMappingsFor(this.file, point.getLine(), point.getColumn());
        }
    }
}

