/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model.table;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfVirtualTableModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.VirtualTableLine;

public class TmfVirtualTableModel<L extends VirtualTableLine>
implements ITmfVirtualTableModel<L> {
    private final List<Long> fColumnIds;
    private final List<L> fData;
    private final long fIndex;
    private final long fNbTotalEvents;

    public TmfVirtualTableModel(List<Long> columnIds, List<L> data, long index, long nbTotalEvents) {
        this.fIndex = index;
        this.fColumnIds = ImmutableList.copyOf(columnIds);
        this.fData = ImmutableList.copyOf(data);
        this.fNbTotalEvents = nbTotalEvents;
    }

    @Override
    public List<Long> getColumnIds() {
        return this.fColumnIds;
    }

    @Override
    public List<L> getData() {
        return this.fData;
    }

    @Override
    public long getIndex() {
        return this.fIndex;
    }

    @Override
    public long getNbTotalEntries() {
        return this.fNbTotalEvents;
    }

    public int hashCode() {
        return Objects.hash(this.fIndex, this.fNbTotalEvents, this.fColumnIds, this.fData);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TmfVirtualTableModel other = (TmfVirtualTableModel)obj;
        return this.fIndex == other.getIndex() && this.fNbTotalEvents == other.getNbTotalEntries() && this.fColumnIds.equals(other.fColumnIds) && this.fData.equals(other.fData);
    }

    public String toString() {
        return "Column Ids: " + this.fColumnIds + ", Data: " + this.fData + ", Index: " + this.fIndex + ", Total nb of events: " + this.fNbTotalEvents;
    }
}

