/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.syntax;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.EditFileHyperlink;

public class FileRefHyperlinkDetector
implements IHyperlinkDetector {
    private final List<Pattern> hyperlinkPattern;
    private final IContainer container;

    public FileRefHyperlinkDetector(IContainer container, List<String> hyperlinkPattern) {
        this.container = container;
        this.hyperlinkPattern = this.createHyperlinkPattern(hyperlinkPattern);
    }

    private List<Pattern> createHyperlinkPattern(Collection<String> hyperlinkPattern) {
        ImmutableList.Builder hyperlinkPatternBuilder = ImmutableList.builder();
        hyperlinkPattern.forEach(pattern -> {
            ImmutableList.Builder builder2 = hyperlinkPatternBuilder.add((Object)Pattern.compile(pattern));
        });
        return hyperlinkPatternBuilder.build();
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        Collection<IHyperlink> hyperlinkList;
        block3: {
            IDocument document = textViewer.getDocument();
            try {
                IRegion lineInfo = document.getLineInformationOfOffset(region.getOffset());
                String lineString = document.get(lineInfo.getOffset(), lineInfo.getLength());
                Optional<Matcher> fileRefPatternAtOffset = this.getFileRefMatchAtOffset(lineString, region.getOffset() - lineInfo.getOffset());
                hyperlinkList = this.createHyperlinks(lineInfo, fileRefPatternAtOffset);
                if (!hyperlinkList.isEmpty()) break block3;
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return hyperlinkList.toArray(new IHyperlink[hyperlinkList.size()]);
    }

    private Collection<IHyperlink> createHyperlinks(IRegion lineInfo, Optional<Matcher> fileRefPatternAtOffset) {
        ImmutableList.Builder hyperlinks = ImmutableList.builder();
        fileRefPatternAtOffset.ifPresent(matcher -> {
            Region regionToMatch = new Region(lineInfo.getOffset() + matcher.start(1), matcher.end(1) - matcher.start(1));
            Path path = new Path(matcher.group(1));
            IFile file = this.container.getFile((IPath)path);
            if (file != null && file.exists()) {
                hyperlinks.add((Object)new EditFileHyperlink(file, (IRegion)regionToMatch));
            }
        });
        return hyperlinks.build();
    }

    private Optional<Matcher> getFileRefMatchAtOffset(String lineString, int offset) {
        for (Pattern pattern : this.hyperlinkPattern) {
            Matcher matcher = pattern.matcher(lineString);
            while (matcher.find()) {
                if (matcher.start() > offset || matcher.end() < offset) continue;
                return Optional.of(matcher);
            }
        }
        return Optional.empty();
    }
}

