/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.edit;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableReal;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTrigger;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CSmartSelector;
import org.jkiss.dbeaver.ui.editors.object.struct.EntityEditPage;

public class PostgreTriggerConfigurator
implements DBEObjectConfigurator<PostgreTableReal, PostgreTrigger> {
    protected static final Log log = Log.getLog(PostgreTriggerConfigurator.class);

    public PostgreTrigger configureObject(final DBRProgressMonitor monitor, final PostgreTableReal parent, final PostgreTrigger trigger) {
        return (PostgreTrigger)new UITask<PostgreTrigger>(){

            protected PostgreTrigger runTask() {
                TriggerEditPage editPage = new TriggerEditPage(parent.getDataSource());
                if (!editPage.edit()) {
                    return null;
                }
                try {
                    trigger.setName(editPage.getEntityName());
                    trigger.setFunction(editPage.selectedFunction);
                    trigger.setObjectDefinitionText("CREATE TRIGGER " + DBUtils.getQuotedIdentifier((DBSObject)trigger) + "\n" + "BEFORE UPDATE" + " " + "\n" + "ON " + DBUtils.getQuotedIdentifier((DBSObject)parent) + " FOR EACH ROW" + "\n" + "EXECUTE PROCEDURE " + trigger.getFunction(monitor).getFullQualifiedSignature() + "\n");
                }
                catch (DBException e) {
                    log.error((Object)e);
                }
                return trigger;
            }
        }.execute();
    }

    public class TriggerEditPage
    extends EntityEditPage {
        CSmartSelector functionCombo;
        PostgreProcedure selectedFunction;
        Text processIdText;
        public TriggerEditPage editPage;

        public TriggerEditPage(DBPDataSource dataSource) {
            super(dataSource, DBSEntityType.TRIGGER);
        }

        public TriggerEditPage getEditPage() {
            return this.editPage;
        }

        protected Control createPageContents(Composite parent) {
            Composite pageContents = (Composite)super.createPageContents(parent);
            UIUtils.createControlLabel((Composite)pageContents, (String)"Trigger function");
            this.functionCombo = new PostgreProcedureSelector(pageContents, parent);
            this.functionCombo.setLayoutData((Object)new GridData(768));
            return pageContents;
        }

        private class PostgreProcedureSelector
        extends CSmartSelector<PostgreProcedure> {
            private final Composite parent;

            public PostgreProcedureSelector(Composite pageContents, Composite parent) {
                super(pageContents, 2060, (ILabelProvider)new LabelProvider(){

                    public Image getImage(Object element) {
                        return DBeaverIcons.getImage((DBPImage)DBIcon.TREE_PROCEDURE);
                    }

                    public String getText(Object element) {
                        if (element == null) {
                            return "N/A";
                        }
                        return ((PostgreProcedure)element).getFullQualifiedSignature();
                    }
                });
                this.parent = parent;
            }

            protected void dropDown(boolean drop) {
                DBNModel navigatorModel;
                DBNDatabaseNode dsNode;
                if (drop && (dsNode = (navigatorModel = DBWorkbench.getPlatform().getNavigatorModel()).getNodeByObject((DBSObject)TriggerEditPage.this.getDataSource())) != null) {
                    DBNDatabaseNode curNode = TriggerEditPage.this.selectedFunction == null ? null : navigatorModel.getNodeByObject((DBSObject)TriggerEditPage.this.selectedFunction);
                    DBNNode node = DBWorkbench.getPlatformUI().selectObject((Object)this.parent.getShell(), "Select function for ", (DBNNode)dsNode, (DBNNode)curNode, new Class[]{DBSInstance.class, DBSObjectContainer.class, PostgreProcedure.class}, new Class[]{PostgreProcedure.class}, null);
                    if (node instanceof DBNDatabaseNode && ((DBNDatabaseNode)node).getObject() instanceof PostgreProcedure) {
                        TriggerEditPage.this.functionCombo.removeAll();
                        TriggerEditPage.this.selectedFunction = (PostgreProcedure)((DBNDatabaseNode)node).getObject();
                        TriggerEditPage.this.functionCombo.addItem((Object)TriggerEditPage.this.selectedFunction);
                        TriggerEditPage.this.functionCombo.select((Object)TriggerEditPage.this.selectedFunction);
                    }
                }
            }
        }
    }
}

