/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.ui.locks.manage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jkiss.dbeaver.ext.ui.locks.graph.LockGraph;
import org.jkiss.dbeaver.ext.ui.locks.graph.LockGraphEdge;
import org.jkiss.dbeaver.ext.ui.locks.graph.LockGraphNode;
import org.jkiss.dbeaver.model.admin.locks.DBAServerLock;

public abstract class LockGraphManager {
    private Map<Object, LockGraphNode> nodes = new HashMap<Object, LockGraphNode>();
    private Map<Object, LockGraph> graphIndex = new HashMap<Object, LockGraph>();

    public LockGraph getGraph(DBAServerLock curLock) {
        LockGraphNode selection = this.nodes.get(curLock.getId());
        LockGraph graph = this.graphIndex.get(curLock.getId());
        if (graph != null && selection != null) {
            graph.setSelection(selection);
        }
        return graph;
    }

    private LockGraph createGraph(DBAServerLock root) {
        LockGraph graph = new LockGraph(root);
        int maxWidth = 1;
        int level = 1;
        LockGraphNode nodeRoot = this.nodes.get(root.getId());
        nodeRoot.setLevel(0);
        nodeRoot.setSpan(1);
        graph.getNodes().add(nodeRoot);
        this.graphIndex.put(root.getId(), graph);
        ArrayList<Object> current = new ArrayList<DBAServerLock>();
        HashSet<DBAServerLock> touched = new HashSet<DBAServerLock>();
        current.add(root);
        touched.add(root);
        HashMap<Object, DBAServerLock> childs = new HashMap<Object, DBAServerLock>();
        while (current.size() > 0) {
            if (maxWidth < current.size()) {
                maxWidth = current.size();
            }
            int index = 0;
            while (index < current.size()) {
                DBAServerLock l = (DBAServerLock)current.get(index);
                LockGraphNode node = this.nodes.get(l.getId());
                if (index == 0) {
                    node.setLevelPosition(LockGraphNode.LevelPosition.LEFT);
                } else if (index == current.size() - 1) {
                    node.setLevelPosition(LockGraphNode.LevelPosition.RIGHT);
                } else {
                    node.setLevelPosition(LockGraphNode.LevelPosition.CENTER);
                }
                node.setSpan(current.size());
                for (DBAServerLock c : l.waitThis()) {
                    if (touched.contains(c)) continue;
                    touched.add(c);
                    childs.put(c.getId(), c);
                    this.graphIndex.put(c.getId(), graph);
                    LockGraphNode nodeChild = this.nodes.get(c.getId());
                    graph.getNodes().add(nodeChild);
                    nodeChild.setLevel(level);
                    LockGraphEdge edge = new LockGraphEdge();
                    edge.setSource(node);
                    edge.setTarget(nodeChild);
                }
                ++index;
            }
            ++level;
            current = new ArrayList(childs.values());
            childs.clear();
        }
        graph.setMaxWidth(maxWidth);
        return graph;
    }

    public void buildGraphs(Map<Object, ? extends DBAServerLock> locks) {
        HashSet<DBAServerLock> roots = new HashSet<DBAServerLock>();
        this.nodes.clear();
        this.graphIndex.clear();
        for (DBAServerLock dBAServerLock : locks.values()) {
            if (locks.containsKey(dBAServerLock.getHoldID()) && !dBAServerLock.getHoldID().equals(dBAServerLock.getId())) {
                DBAServerLock holder = locks.get(dBAServerLock.getHoldID());
                dBAServerLock.setHoldBy(holder);
                holder.waitThis().add(dBAServerLock);
            } else {
                roots.add(dBAServerLock);
            }
            this.nodes.put(dBAServerLock.getId(), new LockGraphNode(dBAServerLock));
        }
        for (DBAServerLock dBAServerLock : roots) {
            this.createGraph(dBAServerLock);
        }
    }
}

