/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDDLFormat;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OraclePrivTable;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableConstraint;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableForeignKey;
import org.jkiss.dbeaver.ext.oracle.model.OracleTableTrigger;
import org.jkiss.dbeaver.ext.oracle.model.OracleTriggerColumn;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.ext.oracle.model.source.OracleStatefulObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableColumn;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectState;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.utils.CommonUtils;

public abstract class OracleTableBase
extends JDBCTable<OracleDataSource, OracleSchema>
implements DBPNamedObject2,
DBPRefreshableObject,
OracleStatefulObject {
    private static final Log log = Log.getLog(OracleTableBase.class);
    public final TriggerCache triggerCache = new TriggerCache();
    private final TablePrivCache tablePrivCache = new TablePrivCache();
    protected boolean valid;
    private String comment;

    public abstract TableAdditionalInfo getAdditionalInfo();

    protected abstract String getTableTypeName();

    protected OracleTableBase(OracleSchema schema, String name, boolean persisted) {
        super((DBSObjectContainer)schema, name, persisted);
    }

    protected OracleTableBase(OracleSchema oracleSchema, ResultSet dbResult) {
        super((DBSObjectContainer)oracleSchema, true);
        this.setName(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME"));
        this.valid = "VALID".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATUS"));
    }

    public JDBCStructCache<OracleSchema, ? extends JDBCTable, ? extends JDBCTableColumn> getCache() {
        return ((OracleSchema)this.getContainer()).tableCache;
    }

    @Override
    @NotNull
    public OracleSchema getSchema() {
        return (OracleSchema)super.getContainer();
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Nullable
    public String getDescription() {
        return this.getComment();
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getContainer(), this});
    }

    @Property(viewable=true, editable=true, updatable=true, multiline=true, order=100)
    @LazyProperty(cacheValidator=CommentsValidator.class)
    public String getComment(DBRProgressMonitor monitor) throws DBException {
        if (this.comment == null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table comments");){
                    this.comment = this.queryTableComment(session);
                    if (this.comment == null) {
                        this.comment = "";
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                log.warn((Object)("Can't fetch table '" + this.getName() + "' comment"), (Throwable)e);
            }
        }
        return this.comment;
    }

    protected String queryTableComment(JDBCSession session) throws SQLException {
        return JDBCUtils.queryString((JDBCSession)session, (String)("SELECT COMMENTS FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), (OracleDataSource)session.getDataSource(), "TAB_COMMENTS") + " " + "WHERE OWNER=? AND TABLE_NAME=? AND TABLE_TYPE=?"), (Object[])new Object[]{this.getSchema().getName(), this.getName(), this.getTableTypeName()});
    }

    void loadColumnComments(DBRProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Iterator<OracleTableColumn> iterator = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table column comments");){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement stat = session.prepareStatement("SELECT COLUMN_NAME,COMMENTS FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), (OracleDataSource)session.getDataSource(), "COL_COMMENTS") + " cc " + "WHERE CC.OWNER=? AND cc.TABLE_NAME=?");){
                    stat.setString(1, this.getSchema().getName());
                    stat.setString(2, this.getName());
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet resultSet = stat.executeQuery();){
                        while (resultSet.next()) {
                            String colName = resultSet.getString(1);
                            String colComment = resultSet.getString(2);
                            OracleTableColumn col = this.getAttribute(monitor, colName);
                            if (col == null) {
                                log.warn((Object)("Column '" + colName + "' not found in table '" + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + "'"));
                                continue;
                            }
                            col.setComment(CommonUtils.notEmpty((String)colComment));
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
            for (OracleTableColumn col : this.getAttributes(monitor)) {
                col.cacheComment();
            }
        }
        catch (Exception e) {
            log.warn((Object)("Error fetching table '" + this.getName() + "' column comments"), (Throwable)e);
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Collection<OracleTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((OracleSchema)this.getContainer()).tableCache.getChildren(monitor, (OracleSchema)this.getContainer(), this);
    }

    public OracleTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (OracleTableColumn)((OracleSchema)this.getContainer()).tableCache.getChild(monitor, (OracleSchema)this.getContainer(), this, attributeName);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        ((OracleSchema)this.getContainer()).constraintCache.clearObjectCache(this);
        return ((OracleSchema)this.getContainer()).tableCache.refreshObject(monitor, (OracleSchema)this.getContainer(), this);
    }

    @Association
    public Collection<OracleTableTrigger> getTriggers(DBRProgressMonitor monitor) throws DBException {
        return this.triggerCache.getAllObjects(monitor, this);
    }

    public Collection<? extends DBSTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    @Nullable
    @Association
    public Collection<OracleTableConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return ((OracleSchema)this.getContainer()).constraintCache.getObjects(monitor, (OracleSchema)this.getContainer(), this);
    }

    public OracleTableConstraint getConstraint(DBRProgressMonitor monitor, String ukName) throws DBException {
        return (OracleTableConstraint)((OracleSchema)this.getContainer()).constraintCache.getObject(monitor, (OracleSchema)this.getContainer(), this, ukName);
    }

    public DBSTableForeignKey getForeignKey(DBRProgressMonitor monitor, String ukName) throws DBException {
        return (DBSTableForeignKey)DBUtils.findObject(this.getAssociations(monitor), (String)ukName);
    }

    public Collection<OracleTableForeignKey> getAssociations(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<OracleTableForeignKey> getReferences(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public String getDDL(DBRProgressMonitor monitor, OracleDDLFormat ddlFormat, Map<String, Object> options) throws DBException {
        return OracleUtils.getDDL(monitor, this.getTableTypeName(), this, ddlFormat, options);
    }

    @NotNull
    public DBSObjectState getObjectState() {
        return this.valid ? DBSObjectState.NORMAL : DBSObjectState.INVALID;
    }

    public static OracleTableBase findTable(DBRProgressMonitor monitor, OracleDataSource dataSource, String ownerName, String tableName) throws DBException {
        OracleSchema refSchema = dataSource.getSchema(monitor, ownerName);
        if (refSchema == null) {
            log.warn((Object)("Referenced schema '" + ownerName + "' not found"));
            return null;
        }
        OracleTableBase refTable = (OracleTableBase)refSchema.tableCache.getObject(monitor, refSchema, tableName);
        if (refTable == null) {
            log.warn((Object)("Referenced table '" + tableName + "' not found in schema '" + ownerName + "'"));
        }
        return refTable;
    }

    @Association
    public Collection<OraclePrivTable> getTablePrivs(DBRProgressMonitor monitor) throws DBException {
        return this.tablePrivCache.getAllObjects(monitor, this);
    }

    public static class AdditionalInfoValidator
    implements IPropertyCacheValidator<OracleTableBase> {
        public boolean isPropertyCached(OracleTableBase object, Object propertyId) {
            return object.getAdditionalInfo().isLoaded();
        }
    }

    public static class CommentsValidator
    implements IPropertyCacheValidator<OracleTableBase> {
        public boolean isPropertyCached(OracleTableBase object, Object propertyId) {
            return object.comment != null;
        }
    }

    public static class TableAdditionalInfo {
        volatile boolean loaded = false;

        boolean isLoaded() {
            return this.loaded;
        }
    }

    static class TablePrivCache
    extends JDBCObjectCache<OracleTableBase, OraclePrivTable> {
        TablePrivCache() {
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleTableBase tableBase) throws SQLException {
            boolean hasDBA = ((OracleDataSource)tableBase.getDataSource()).isViewAvailable(session.getProgressMonitor(), "SYS", "DBA_TAB_PRIVS");
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT p.*\nFROM " + (hasDBA ? "DBA_TAB_PRIVS p" : "ALL_TAB_PRIVS p") + "\n" + "WHERE p." + (hasDBA ? "OWNER" : "TABLE_SCHEMA") + "=? AND p.TABLE_NAME =?");
            dbStat.setString(1, tableBase.getSchema().getName());
            dbStat.setString(2, tableBase.getName());
            return dbStat;
        }

        protected OraclePrivTable fetchObject(@NotNull JDBCSession session, @NotNull OracleTableBase tableBase, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OraclePrivTable(tableBase, (ResultSet)resultSet);
        }
    }

    static class TriggerCache
    extends JDBCStructCache<OracleTableBase, OracleTableTrigger, OracleTriggerColumn> {
        TriggerCache() {
            super((Object)"TRIGGER_NAME");
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleTableBase owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT *\nFROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), (OracleDataSource)owner.getDataSource(), "TRIGGERS") + " WHERE TABLE_OWNER=? AND TABLE_NAME=?\n" + "ORDER BY TRIGGER_NAME");
            dbStat.setString(1, owner.getSchema().getName());
            dbStat.setString(2, owner.getName());
            return dbStat;
        }

        protected OracleTableTrigger fetchObject(@NotNull JDBCSession session, @NotNull OracleTableBase owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleTableTrigger(owner, (ResultSet)resultSet);
        }

        protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull OracleTableBase owner, @Nullable OracleTableTrigger forObject) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT TRIGGER_NAME,TABLE_OWNER,TABLE_NAME,COLUMN_NAME,COLUMN_LIST,COLUMN_USAGE\nFROM " + OracleUtils.getSysSchemaPrefix((OracleDataSource)owner.getDataSource()) + "ALL_TRIGGER_COLS WHERE TABLE_OWNER=? AND TABLE_NAME=?" + (forObject == null ? "" : " AND TRIGGER_NAME=?") + "\nORDER BY TRIGGER_NAME");
            dbStat.setString(1, ((OracleSchema)owner.getContainer()).getName());
            dbStat.setString(2, owner.getName());
            if (forObject != null) {
                dbStat.setString(3, forObject.getName());
            }
            return dbStat;
        }

        protected OracleTriggerColumn fetchChild(@NotNull JDBCSession session, @NotNull OracleTableBase owner, @NotNull OracleTableTrigger parent, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            OracleTableBase refTable = OracleTableBase.findTable(session.getProgressMonitor(), (OracleDataSource)owner.getDataSource(), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_OWNER"), JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLE_NAME"));
            if (refTable != null) {
                String columnName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COLUMN_NAME");
                OracleTableColumn tableColumn = refTable.getAttribute(session.getProgressMonitor(), columnName);
                if (tableColumn == null) {
                    log.debug((Object)("Column '" + columnName + "' not found in table '" + refTable.getFullyQualifiedName(DBPEvaluationContext.DDL) + "' for trigger '" + parent.getName() + "'"));
                }
                return new OracleTriggerColumn(session.getProgressMonitor(), parent, tableColumn, (ResultSet)dbResult);
            }
            return null;
        }
    }
}

