/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.SQLServerUtils;
import org.jkiss.dbeaver.ext.mssql.model.QueryTransformerTop;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerAuthentication;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataSourceInfo;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDataType;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDialect;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerStructureAssistant;
import org.jkiss.dbeaver.ext.mssql.model.session.SQLServerSessionManager;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSInstanceContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSObjectSelector;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public class SQLServerDataSource
extends JDBCDataSource
implements DBSObjectSelector,
DBSInstanceContainer,
IAdaptable {
    private static final Log log = Log.getLog(SQLServerDataSource.class);
    private final SystemDataTypeCache dataTypeCache = new SystemDataTypeCache();
    private final DatabaseCache databaseCache = new DatabaseCache();
    private String activeDatabaseName;

    public SQLServerDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container, (SQLDialect)new SQLServerDialect());
    }

    protected DBPDataSourceInfo createDataSourceInfo(@NotNull JDBCDatabaseMetaData metaData) {
        return new SQLServerDataSourceInfo(this, metaData);
    }

    public DBPDataSource getDataSource() {
        return this;
    }

    protected Properties getAllConnectionProperties(DBRProgressMonitor monitor, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        Properties properties = super.getAllConnectionProperties(monitor, purpose, connectionInfo);
        if (!this.getContainer().getPreferenceStore().getBoolean("database.meta.client.name.disable")) {
            properties.put(SQLServerUtils.isDriverJtds(this.getContainer().getDriver()) ? "APPNAME" : "applicationName", CommonUtils.truncateString((String)DBUtils.getClientApplicationName((DBPDataSourceContainer)this.getContainer(), (String)purpose), (int)64));
        }
        this.fillConnectionProperties(connectionInfo, properties);
        SQLServerAuthentication authSchema = SQLServerUtils.detectAuthSchema(connectionInfo);
        authSchema.getInitializer().initializeAuthentication(connectionInfo, properties);
        return properties;
    }

    protected void initializeContextState(DBRProgressMonitor monitor, JDBCExecutionContext context, boolean setActiveObject) throws DBCException {
        SQLServerDatabase defaultObject;
        super.initializeContextState(monitor, context, setActiveObject);
        if (setActiveObject && (defaultObject = this.getDefaultObject()) != null) {
            this.setCurrentDatabase(monitor, context, defaultObject);
        }
    }

    public Object getDataSourceFeature(String featureId) {
        switch (featureId) {
            case "datasource.limit-affects-dml": {
                return true;
            }
            case "datasource.max-string-type-length": {
                return 8000;
            }
        }
        return super.getDataSourceFeature(featureId);
    }

    public void initialize(DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        this.dataTypeCache.getAllObjects(monitor, (DBSObject)this);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load data source meta info");){
                this.activeDatabaseName = SQLServerUtils.getCurrentDatabase(session);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error during connection initialization", e);
        }
    }

    public DBPDataKind resolveDataKind(String typeName, int valueType) {
        return this.getLocalDataType(valueType).getDataKind();
    }

    public List<SQLServerDataType> getLocalDataTypes() {
        return this.dataTypeCache.getCachedObjects();
    }

    public SQLServerDataType getSystemDataType(int systemTypeId) {
        for (SQLServerDataType dt : this.dataTypeCache.getCachedObjects()) {
            if (dt.getObjectId() != (long)systemTypeId) continue;
            return dt;
        }
        log.debug((Object)("System data type " + systemTypeId + " not found"));
        SQLServerDataType sdt = new SQLServerDataType((DBSObject)this, String.valueOf(systemTypeId), systemTypeId, DBPDataKind.OBJECT, 1111);
        this.dataTypeCache.cacheObject(sdt);
        return sdt;
    }

    public SQLServerDataType getLocalDataType(String typeName) {
        return (SQLServerDataType)this.dataTypeCache.getCachedObject(typeName);
    }

    public SQLServerDataType getLocalDataType(int typeID) {
        DBSDataType dt = super.getLocalDataType(typeID);
        if (dt == null) {
            log.debug((Object)("System data type " + typeID + " not found"));
        }
        return (SQLServerDataType)dt;
    }

    public String getDefaultDataTypeName(DBPDataKind dataKind) {
        switch (dataKind) {
            case BOOLEAN: {
                return "bit";
            }
            case NUMERIC: {
                return "int";
            }
            case STRING: {
                return "varchar";
            }
            case DATETIME: {
                return "datetime";
            }
            case BINARY: {
                return "binary";
            }
            case CONTENT: {
                return "varbinary";
            }
            case ROWID: {
                return "uniqueidentifier";
            }
        }
        return super.getDefaultDataTypeName(dataKind);
    }

    protected boolean isShowAllSchemas() {
        return CommonUtils.toBoolean((Object)this.getContainer().getConnectionConfiguration().getProviderProperty("@dbeaver-show-all-schemas@"));
    }

    protected String getConnectionUserName(DBPConnectionConfiguration connectionInfo) {
        if (SQLServerUtils.isWindowsAuth(connectionInfo)) {
            return "";
        }
        return super.getConnectionUserName(connectionInfo);
    }

    protected String getConnectionUserPassword(DBPConnectionConfiguration connectionInfo) {
        if (SQLServerUtils.isWindowsAuth(connectionInfo)) {
            return "";
        }
        return super.getConnectionUserPassword(connectionInfo);
    }

    public boolean supportsDefaultChange() {
        return true;
    }

    @Nullable
    public SQLServerDatabase getDefaultObject() {
        return this.activeDatabaseName == null ? null : (SQLServerDatabase)this.databaseCache.getCachedObject(this.activeDatabaseName);
    }

    public void setDefaultObject(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object) throws DBException {
        SQLServerDatabase oldSelectedEntity = this.getDefaultObject();
        if (!(object instanceof SQLServerDatabase)) {
            throw new IllegalArgumentException("Invalid object type: " + object);
        }
        JDBCExecutionContext[] jDBCExecutionContextArray = this.getDefaultInstance().getAllContexts();
        int n = jDBCExecutionContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            JDBCExecutionContext context = jDBCExecutionContextArray[n2];
            this.setCurrentDatabase(monitor, context, (SQLServerDatabase)object);
            ++n2;
        }
        this.activeDatabaseName = object.getName();
        if (oldSelectedEntity != null) {
            DBUtils.fireObjectSelect((DBSObject)oldSelectedEntity, (boolean)false);
        }
        if (this.activeDatabaseName != null) {
            DBUtils.fireObjectSelect((DBSObject)object, (boolean)true);
        }
    }

    public boolean refreshDefaultObject(@NotNull DBCSession session) throws DBException {
        try {
            SQLServerDatabase newDatabase;
            String currentSchema = SQLServerUtils.getCurrentDatabase((JDBCSession)session);
            if (currentSchema != null && !CommonUtils.equalObjects((Object)currentSchema, (Object)this.activeDatabaseName) && (newDatabase = (SQLServerDatabase)this.databaseCache.getCachedObject(currentSchema)) != null) {
                this.setDefaultObject(session.getProgressMonitor(), (DBSObject)newDatabase);
                return true;
            }
            return false;
        }
        catch (SQLException e) {
            throw new DBException((Throwable)e, (DBPDataSource)this);
        }
    }

    private void setCurrentDatabase(DBRProgressMonitor monitor, JDBCExecutionContext executionContext, SQLServerDatabase object) throws DBCException {
        if (object == null) {
            log.debug((Object)"Null current schema");
            return;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = executionContext.openSession(monitor, DBCExecutionPurpose.UTIL, "Set active database");){
                SQLServerUtils.setCurrentDatabase(session, object.getName());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, (DBPDataSource)this);
        }
    }

    @Association
    public Collection<SQLServerDatabase> getDatabases(DBRProgressMonitor monitor) throws DBException {
        return this.databaseCache.getAllObjects(monitor, (DBSObject)this);
    }

    public Collection<? extends DBSObject> getChildren(DBRProgressMonitor monitor) throws DBException {
        return this.databaseCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DBSObject getChild(DBRProgressMonitor monitor, String childName) throws DBException {
        return this.databaseCache.getObject(monitor, (DBSObject)this, childName);
    }

    public Class<? extends DBSObject> getChildType(DBRProgressMonitor monitor) throws DBException {
        return SQLServerDatabase.class;
    }

    public void cacheStructure(DBRProgressMonitor monitor, int scope) throws DBException {
        this.databaseCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DBSObject refreshObject(DBRProgressMonitor monitor) throws DBException {
        this.databaseCache.clearCache();
        return super.refreshObject(monitor);
    }

    public DBCQueryTransformer createQueryTransformer(DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerTop();
        }
        return super.createQueryTransformer(type);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast(new SQLServerStructureAssistant(this));
        }
        if (adapter == DBAServerSessionManager.class) {
            return adapter.cast(new SQLServerSessionManager(this));
        }
        return (T)super.getAdapter(adapter);
    }

    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(DBRProgressMonitor monitor, DBCExecutionContext context, String query, Throwable error) {
        Throwable rootCause = GeneralUtils.getRootCause((Throwable)error);
        if (rootCause != null && "com.microsoft.sqlserver.jdbc.SQLServerException".equals(rootCause.getClass().getName())) {
            try {
                Object serverErrorLine;
                Object serverError = rootCause.getClass().getMethod("getSQLServerError", new Class[0]).invoke((Object)rootCause, new Object[0]);
                if (serverError != null && (serverErrorLine = BeanUtils.readObjectProperty((Object)serverError, (String)"lineNumber")) instanceof Number) {
                    DBPErrorAssistant.ErrorPosition pos = new DBPErrorAssistant.ErrorPosition();
                    pos.line = ((Number)serverErrorLine).intValue() - 1;
                    return new DBPErrorAssistant.ErrorPosition[]{pos};
                }
            }
            catch (Throwable throwable) {}
        }
        return super.getErrorPosition(monitor, context, query, error);
    }

    static class DatabaseCache
    extends JDBCObjectCache<SQLServerDataSource, SQLServerDatabase> {
        DatabaseCache() {
            this.setListOrderComparator(DBUtils.nameComparator());
        }

        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull SQLServerDataSource owner) throws SQLException {
            StringBuilder sql = new StringBuilder("SELECT db.* FROM sys.databases db");
            DBSObjectFilter databaseFilters = owner.getContainer().getObjectFilter(SQLServerDatabase.class, null, false);
            if (databaseFilters != null && databaseFilters.isEnabled()) {
                JDBCUtils.appendFilterClause((StringBuilder)sql, (DBSObjectFilter)databaseFilters, (String)"name", (boolean)true);
            }
            sql.append("\nORDER BY db.name");
            JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
            if (databaseFilters != null) {
                JDBCUtils.setFilterParameters((PreparedStatement)dbStat, (int)1, (DBSObjectFilter)databaseFilters);
            }
            return dbStat;
        }

        protected SQLServerDatabase fetchObject(@NotNull JDBCSession session, @NotNull SQLServerDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new SQLServerDatabase(owner, resultSet);
        }
    }

    private class SystemDataTypeCache
    extends JDBCObjectCache<SQLServerDataSource, SQLServerDataType> {
        private SystemDataTypeCache() {
        }

        protected JDBCStatement prepareObjectsStatement(JDBCSession session, SQLServerDataSource sqlServerDataSource) throws SQLException {
            return session.prepareStatement("SELECT * FROM sys.types WHERE is_user_defined = 0 order by name");
        }

        protected SQLServerDataType fetchObject(JDBCSession session, SQLServerDataSource dataSource, JDBCResultSet resultSet) throws SQLException, DBException {
            return new SQLServerDataType((DBSObject)dataSource, (ResultSet)resultSet);
        }
    }
}

