/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.apps;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import software.amazon.ion.IonCatalog;
import software.amazon.ion.IonException;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonSystem;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.system.IonSystemBuilder;
import software.amazon.ion.system.SimpleCatalog;

abstract class BaseApp {
    protected SimpleCatalog myCatalog = new SimpleCatalog();
    protected IonSystem mySystem = IonSystemBuilder.standard().withCatalog(this.myCatalog).build();

    BaseApp() {
    }

    protected static byte[] loadAsByteArray(InputStream in) throws IOException {
        int cnt;
        byte[] buf = new byte[4096];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((cnt = in.read(buf)) != -1) {
            bos.write(buf, 0, cnt);
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] loadAsByteArray(File file2) throws FileNotFoundException, IOException {
        long len = file2.length();
        if (len < 0L || len > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too long: " + file2);
        }
        byte[] buffer = new byte[(int)len];
        FileInputStream in = new FileInputStream(file2);
        try {
            int readBytesCount = in.read(buffer);
            if ((long)readBytesCount != len || in.read() != -1) {
                System.err.println("Read the wrong number of bytes from " + file2);
                byte[] byArray = null;
                return byArray;
            }
        }
        finally {
            in.close();
        }
        return buffer;
    }

    public void doMain(String[] args) {
        int firstFileIndex = this.processOptions(args);
        int fileCount = args.length - firstFileIndex;
        String[] files = new String[fileCount];
        System.arraycopy(args, firstFileIndex, files, 0, fileCount);
        if (this.optionsAreValid(files)) {
            this.processFiles(files);
        }
    }

    protected int processOptions(String[] args) {
        return 0;
    }

    protected boolean optionsAreValid(String[] filePaths) {
        return true;
    }

    protected void processFiles(String[] filePaths) {
        if (filePaths.length == 0) {
            this.processStdIn();
        } else {
            for (int i = 0; i < filePaths.length; ++i) {
                String filePath = filePaths[i];
                this.processFile(filePath);
            }
        }
    }

    protected boolean processFile(String path2) {
        File file2 = new File(path2);
        if (file2.canRead() && file2.isFile()) {
            try {
                this.process(file2);
                return true;
            }
            catch (IonException e2) {
                System.err.println("An error occurred while processing " + path2);
                System.err.println(e2.getMessage());
            }
            catch (IOException e3) {
                System.err.println("An error occurred while processing " + path2);
                System.err.println(e3.getMessage());
            }
        } else {
            System.err.println("Skipping unreadable file: " + path2);
        }
        return false;
    }

    protected void processStdIn() {
        try {
            byte[] buffer = BaseApp.loadAsByteArray(System.in);
            IonReader reader2 = this.mySystem.newReader(buffer);
            this.process(reader2);
        }
        catch (IonException e2) {
            System.err.println("An error occurred while processing stdin");
            System.err.println(e2.getMessage());
        }
        catch (IOException e3) {
            System.err.println("An error occurred while processing stdin");
            System.err.println(e3.getMessage());
        }
    }

    protected void process(File file2) throws IOException, IonException {
        byte[] buffer = BaseApp.loadAsByteArray(file2);
        IonReader reader2 = this.mySystem.newReader(buffer);
        this.process(file2, reader2);
    }

    protected void process(File inputFile, IonReader reader2) throws IOException, IonException {
        this.process(reader2);
    }

    protected void process(IonReader reader2) throws IOException, IonException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadCatalog(String catalogPath) {
        System.err.println("Loading catalog from " + catalogPath);
        File catalogFile = new File(catalogPath);
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(catalogFile));
            try {
                IonReader reader2 = this.mySystem.newReader(in);
                while (reader2.next() != null) {
                    SymbolTable symtab = this.mySystem.newSharedSymbolTable(reader2, true);
                    this.myCatalog.putTable(symtab);
                }
            }
            finally {
                ((InputStream)in).close();
            }
        }
        catch (Exception e2) {
            throw new RuntimeException("Error loading catalog from " + catalogPath + ": " + e2.getMessage(), e2);
        }
        IonCatalog catalog = this.mySystem.getCatalog();
        assert (this.myCatalog == catalog);
    }

    protected SymbolTable getLatestSharedSymtab(String name2) {
        IonCatalog catalog = this.mySystem.getCatalog();
        SymbolTable table = catalog.getTable(name2);
        if (table == null) {
            String message = "There's no symbol table in the catalog named " + name2;
            throw new RuntimeException(message);
        }
        this.logDebug("Found shared symbol table " + name2 + "@" + table.getVersion());
        return table;
    }

    protected void logDebug(String message) {
        System.err.println(message);
    }
}

