"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _electron = require("electron");

var _propTypes2 = require("../prop-types");

var _search = _interopRequireDefault(require("../models/search"));

var _issueishSearchContainer = _interopRequireDefault(require("../containers/issueish-search-container"));

var _currentPullRequestContainer = _interopRequireDefault(require("../containers/current-pull-request-container"));

var _issueishDetailItem = _interopRequireDefault(require("../items/issueish-detail-item"));

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishSearchesController extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {});

    _defineProperty(this, "onOpenIssueish", issueish => {
      return this.props.workspace.open(_issueishDetailItem["default"].buildURI({
        host: this.props.endpoint.getHost(),
        owner: this.props.remote.getOwner(),
        repo: this.props.remote.getRepo(),
        number: issueish.getNumber(),
        workdir: this.props.workingDirectory
      }), {
        pending: true,
        searchAllPanes: true
      }).then(() => {
        (0, _reporterProxy.addEvent)('open-issueish-in-pane', {
          "package": 'github',
          from: 'issueish-list'
        });
      });
    });

    _defineProperty(this, "onOpenSearch", search => {
      const searchURL = search.getWebURL(this.props.remote);
      return new Promise((resolve, reject) => {
        _electron.shell.openExternal(searchURL, {}, err => {
          if (err) {
            reject(err);
          } else {
            resolve();
          }
        });
      });
    });
  }

  static getDerivedStateFromProps(props) {
    return {
      searches: [_search["default"].inRemote(props.remote, 'Open pull requests', 'type:pr state:open')]
    };
  }

  render() {
    return _react["default"].createElement("div", {
      className: "github-IssueishSearch"
    }, _react["default"].createElement(_currentPullRequestContainer["default"], {
      repository: this.props.repository,
      token: this.props.token,
      endpoint: this.props.endpoint,
      remoteOperationObserver: this.props.remoteOperationObserver,
      remote: this.props.remote,
      remotes: this.props.remotes,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      workspace: this.props.workspace,
      workingDirectory: this.props.workingDirectory,
      onOpenIssueish: this.onOpenIssueish,
      onCreatePr: this.props.onCreatePr
    }), this.state.searches.map(search => _react["default"].createElement(_issueishSearchContainer["default"], {
      key: search.getName(),
      token: this.props.token,
      endpoint: this.props.endpoint,
      search: search,
      remoteOperationObserver: this.props.remoteOperationObserver,
      onOpenIssueish: this.onOpenIssueish,
      onOpenSearch: this.onOpenSearch
    })));
  }

}

exports["default"] = IssueishSearchesController;

_defineProperty(IssueishSearchesController, "propTypes", {
  // Relay payload
  repository: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired,
    defaultBranchRef: _propTypes["default"].shape({
      prefix: _propTypes["default"].string.isRequired,
      name: _propTypes["default"].string.isRequired
    })
  }),
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  // Repository model attributes
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  workingDirectory: _propTypes["default"].string,
  remote: _propTypes2.RemotePropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  aheadCount: _propTypes["default"].number,
  pushInProgress: _propTypes["default"].bool.isRequired,
  // Actions
  onCreatePr: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImlzc3VlaXNoLXNlYXJjaGVzLWNvbnRyb2xsZXIuanMiXSwibmFtZXMiOlsiSXNzdWVpc2hTZWFyY2hlc0NvbnRyb2xsZXIiLCJSZWFjdCIsIkNvbXBvbmVudCIsImlzc3VlaXNoIiwicHJvcHMiLCJ3b3Jrc3BhY2UiLCJvcGVuIiwiSXNzdWVpc2hEZXRhaWxJdGVtIiwiYnVpbGRVUkkiLCJob3N0IiwiZW5kcG9pbnQiLCJnZXRIb3N0Iiwib3duZXIiLCJyZW1vdGUiLCJnZXRPd25lciIsInJlcG8iLCJnZXRSZXBvIiwibnVtYmVyIiwiZ2V0TnVtYmVyIiwid29ya2RpciIsIndvcmtpbmdEaXJlY3RvcnkiLCJwZW5kaW5nIiwic2VhcmNoQWxsUGFuZXMiLCJ0aGVuIiwiZnJvbSIsInNlYXJjaCIsInNlYXJjaFVSTCIsImdldFdlYlVSTCIsIlByb21pc2UiLCJyZXNvbHZlIiwicmVqZWN0Iiwic2hlbGwiLCJvcGVuRXh0ZXJuYWwiLCJlcnIiLCJnZXREZXJpdmVkU3RhdGVGcm9tUHJvcHMiLCJzZWFyY2hlcyIsIlNlYXJjaCIsImluUmVtb3RlIiwicmVuZGVyIiwicmVwb3NpdG9yeSIsInRva2VuIiwicmVtb3RlT3BlcmF0aW9uT2JzZXJ2ZXIiLCJyZW1vdGVzIiwiYnJhbmNoZXMiLCJhaGVhZENvdW50IiwicHVzaEluUHJvZ3Jlc3MiLCJvbk9wZW5Jc3N1ZWlzaCIsIm9uQ3JlYXRlUHIiLCJzdGF0ZSIsIm1hcCIsImdldE5hbWUiLCJvbk9wZW5TZWFyY2giLCJQcm9wVHlwZXMiLCJzaGFwZSIsImlkIiwic3RyaW5nIiwiaXNSZXF1aXJlZCIsImRlZmF1bHRCcmFuY2hSZWYiLCJwcmVmaXgiLCJuYW1lIiwiRW5kcG9pbnRQcm9wVHlwZSIsIm9iamVjdCIsIk9wZXJhdGlvblN0YXRlT2JzZXJ2ZXJQcm9wVHlwZSIsIlJlbW90ZVByb3BUeXBlIiwiUmVtb3RlU2V0UHJvcFR5cGUiLCJCcmFuY2hTZXRQcm9wVHlwZSIsImJvb2wiLCJmdW5jIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7O0FBQ0E7O0FBQ0E7O0FBRUE7O0FBR0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7O0FBQ0E7Ozs7OztBQUVlLE1BQU1BLDBCQUFOLFNBQXlDQyxrQkFBTUMsU0FBL0MsQ0FBeUQ7QUFBQTtBQUFBOztBQUFBLG1DQStCOUQsRUEvQjhEOztBQUFBLDRDQTRFckRDLFFBQVEsSUFBSTtBQUMzQixhQUFPLEtBQUtDLEtBQUwsQ0FBV0MsU0FBWCxDQUFxQkMsSUFBckIsQ0FDTEMsK0JBQW1CQyxRQUFuQixDQUE0QjtBQUMxQkMsUUFBQUEsSUFBSSxFQUFFLEtBQUtMLEtBQUwsQ0FBV00sUUFBWCxDQUFvQkMsT0FBcEIsRUFEb0I7QUFFMUJDLFFBQUFBLEtBQUssRUFBRSxLQUFLUixLQUFMLENBQVdTLE1BQVgsQ0FBa0JDLFFBQWxCLEVBRm1CO0FBRzFCQyxRQUFBQSxJQUFJLEVBQUUsS0FBS1gsS0FBTCxDQUFXUyxNQUFYLENBQWtCRyxPQUFsQixFQUhvQjtBQUkxQkMsUUFBQUEsTUFBTSxFQUFFZCxRQUFRLENBQUNlLFNBQVQsRUFKa0I7QUFLMUJDLFFBQUFBLE9BQU8sRUFBRSxLQUFLZixLQUFMLENBQVdnQjtBQUxNLE9BQTVCLENBREssRUFRTDtBQUFDQyxRQUFBQSxPQUFPLEVBQUUsSUFBVjtBQUFnQkMsUUFBQUEsY0FBYyxFQUFFO0FBQWhDLE9BUkssRUFTTEMsSUFUSyxDQVNBLE1BQU07QUFDWCxxQ0FBUyx1QkFBVCxFQUFrQztBQUFDLHFCQUFTLFFBQVY7QUFBb0JDLFVBQUFBLElBQUksRUFBRTtBQUExQixTQUFsQztBQUNELE9BWE0sQ0FBUDtBQVlELEtBekZxRTs7QUFBQSwwQ0EyRnZEQyxNQUFNLElBQUk7QUFDdkIsWUFBTUMsU0FBUyxHQUFHRCxNQUFNLENBQUNFLFNBQVAsQ0FBaUIsS0FBS3ZCLEtBQUwsQ0FBV1MsTUFBNUIsQ0FBbEI7QUFFQSxhQUFPLElBQUllLE9BQUosQ0FBWSxDQUFDQyxPQUFELEVBQVVDLE1BQVYsS0FBcUI7QUFDdENDLHdCQUFNQyxZQUFOLENBQW1CTixTQUFuQixFQUE4QixFQUE5QixFQUFrQ08sR0FBRyxJQUFJO0FBQ3ZDLGNBQUlBLEdBQUosRUFBUztBQUFFSCxZQUFBQSxNQUFNLENBQUNHLEdBQUQsQ0FBTjtBQUFjLFdBQXpCLE1BQStCO0FBQUVKLFlBQUFBLE9BQU87QUFBSztBQUM5QyxTQUZEO0FBR0QsT0FKTSxDQUFQO0FBS0QsS0FuR3FFO0FBQUE7O0FBaUN0RSxTQUFPSyx3QkFBUCxDQUFnQzlCLEtBQWhDLEVBQXVDO0FBQ3JDLFdBQU87QUFDTCtCLE1BQUFBLFFBQVEsRUFBRSxDQUNSQyxtQkFBT0MsUUFBUCxDQUFnQmpDLEtBQUssQ0FBQ1MsTUFBdEIsRUFBOEIsb0JBQTlCLEVBQW9ELG9CQUFwRCxDQURRO0FBREwsS0FBUDtBQUtEOztBQUVEeUIsRUFBQUEsTUFBTSxHQUFHO0FBQ1AsV0FDRTtBQUFLLE1BQUEsU0FBUyxFQUFDO0FBQWYsT0FDRSxnQ0FBQyx1Q0FBRDtBQUNFLE1BQUEsVUFBVSxFQUFFLEtBQUtsQyxLQUFMLENBQVdtQyxVQUR6QjtBQUVFLE1BQUEsS0FBSyxFQUFFLEtBQUtuQyxLQUFMLENBQVdvQyxLQUZwQjtBQUdFLE1BQUEsUUFBUSxFQUFFLEtBQUtwQyxLQUFMLENBQVdNLFFBSHZCO0FBSUUsTUFBQSx1QkFBdUIsRUFBRSxLQUFLTixLQUFMLENBQVdxQyx1QkFKdEM7QUFLRSxNQUFBLE1BQU0sRUFBRSxLQUFLckMsS0FBTCxDQUFXUyxNQUxyQjtBQU1FLE1BQUEsT0FBTyxFQUFFLEtBQUtULEtBQUwsQ0FBV3NDLE9BTnRCO0FBT0UsTUFBQSxRQUFRLEVBQUUsS0FBS3RDLEtBQUwsQ0FBV3VDLFFBUHZCO0FBUUUsTUFBQSxVQUFVLEVBQUUsS0FBS3ZDLEtBQUwsQ0FBV3dDLFVBUnpCO0FBU0UsTUFBQSxjQUFjLEVBQUUsS0FBS3hDLEtBQUwsQ0FBV3lDLGNBVDdCO0FBVUUsTUFBQSxTQUFTLEVBQUUsS0FBS3pDLEtBQUwsQ0FBV0MsU0FWeEI7QUFXRSxNQUFBLGdCQUFnQixFQUFFLEtBQUtELEtBQUwsQ0FBV2dCLGdCQVgvQjtBQVlFLE1BQUEsY0FBYyxFQUFFLEtBQUswQixjQVp2QjtBQWFFLE1BQUEsVUFBVSxFQUFFLEtBQUsxQyxLQUFMLENBQVcyQztBQWJ6QixNQURGLEVBZ0JHLEtBQUtDLEtBQUwsQ0FBV2IsUUFBWCxDQUFvQmMsR0FBcEIsQ0FBd0J4QixNQUFNLElBQzdCLGdDQUFDLG1DQUFEO0FBQ0UsTUFBQSxHQUFHLEVBQUVBLE1BQU0sQ0FBQ3lCLE9BQVAsRUFEUDtBQUdFLE1BQUEsS0FBSyxFQUFFLEtBQUs5QyxLQUFMLENBQVdvQyxLQUhwQjtBQUlFLE1BQUEsUUFBUSxFQUFFLEtBQUtwQyxLQUFMLENBQVdNLFFBSnZCO0FBS0UsTUFBQSxNQUFNLEVBQUVlLE1BTFY7QUFNRSxNQUFBLHVCQUF1QixFQUFFLEtBQUtyQixLQUFMLENBQVdxQyx1QkFOdEM7QUFRRSxNQUFBLGNBQWMsRUFBRSxLQUFLSyxjQVJ2QjtBQVNFLE1BQUEsWUFBWSxFQUFFLEtBQUtLO0FBVHJCLE1BREQsQ0FoQkgsQ0FERjtBQWdDRDs7QUExRXFFOzs7O2dCQUFuRG5ELDBCLGVBQ0E7QUFDakI7QUFDQXVDLEVBQUFBLFVBQVUsRUFBRWEsc0JBQVVDLEtBQVYsQ0FBZ0I7QUFDMUJDLElBQUFBLEVBQUUsRUFBRUYsc0JBQVVHLE1BQVYsQ0FBaUJDLFVBREs7QUFFMUJDLElBQUFBLGdCQUFnQixFQUFFTCxzQkFBVUMsS0FBVixDQUFnQjtBQUNoQ0ssTUFBQUEsTUFBTSxFQUFFTixzQkFBVUcsTUFBVixDQUFpQkMsVUFETztBQUVoQ0csTUFBQUEsSUFBSSxFQUFFUCxzQkFBVUcsTUFBVixDQUFpQkM7QUFGUyxLQUFoQjtBQUZRLEdBQWhCLENBRks7QUFVakI7QUFDQTlDLEVBQUFBLFFBQVEsRUFBRWtELDZCQUFpQkosVUFYVjtBQVlqQmhCLEVBQUFBLEtBQUssRUFBRVksc0JBQVVHLE1BQVYsQ0FBaUJDLFVBWlA7QUFjakI7QUFDQW5ELEVBQUFBLFNBQVMsRUFBRStDLHNCQUFVUyxNQUFWLENBQWlCTCxVQWZYO0FBaUJqQjtBQUNBZixFQUFBQSx1QkFBdUIsRUFBRXFCLDJDQUErQk4sVUFsQnZDO0FBbUJqQnBDLEVBQUFBLGdCQUFnQixFQUFFZ0Msc0JBQVVHLE1BbkJYO0FBb0JqQjFDLEVBQUFBLE1BQU0sRUFBRWtELDJCQUFlUCxVQXBCTjtBQXFCakJkLEVBQUFBLE9BQU8sRUFBRXNCLDhCQUFrQlIsVUFyQlY7QUFzQmpCYixFQUFBQSxRQUFRLEVBQUVzQiw4QkFBa0JULFVBdEJYO0FBdUJqQlosRUFBQUEsVUFBVSxFQUFFUSxzQkFBVW5DLE1BdkJMO0FBd0JqQjRCLEVBQUFBLGNBQWMsRUFBRU8sc0JBQVVjLElBQVYsQ0FBZVYsVUF4QmQ7QUEwQmpCO0FBQ0FULEVBQUFBLFVBQVUsRUFBRUssc0JBQVVlLElBQVYsQ0FBZVg7QUEzQlYsQyIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS0xLjM3LjAvb3V0L2FwcC9ub2RlX21vZHVsZXMvZ2l0aHViIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gJ3JlYWN0JztcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSAncHJvcC10eXBlcyc7XG5pbXBvcnQge3NoZWxsfSBmcm9tICdlbGVjdHJvbic7XG5cbmltcG9ydCB7XG4gIFJlbW90ZVByb3BUeXBlLCBSZW1vdGVTZXRQcm9wVHlwZSwgQnJhbmNoU2V0UHJvcFR5cGUsIE9wZXJhdGlvblN0YXRlT2JzZXJ2ZXJQcm9wVHlwZSwgRW5kcG9pbnRQcm9wVHlwZSxcbn0gZnJvbSAnLi4vcHJvcC10eXBlcyc7XG5pbXBvcnQgU2VhcmNoIGZyb20gJy4uL21vZGVscy9zZWFyY2gnO1xuaW1wb3J0IElzc3VlaXNoU2VhcmNoQ29udGFpbmVyIGZyb20gJy4uL2NvbnRhaW5lcnMvaXNzdWVpc2gtc2VhcmNoLWNvbnRhaW5lcic7XG5pbXBvcnQgQ3VycmVudFB1bGxSZXF1ZXN0Q29udGFpbmVyIGZyb20gJy4uL2NvbnRhaW5lcnMvY3VycmVudC1wdWxsLXJlcXVlc3QtY29udGFpbmVyJztcbmltcG9ydCBJc3N1ZWlzaERldGFpbEl0ZW0gZnJvbSAnLi4vaXRlbXMvaXNzdWVpc2gtZGV0YWlsLWl0ZW0nO1xuaW1wb3J0IHthZGRFdmVudH0gZnJvbSAnLi4vcmVwb3J0ZXItcHJveHknO1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBJc3N1ZWlzaFNlYXJjaGVzQ29udHJvbGxlciBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgLy8gUmVsYXkgcGF5bG9hZFxuICAgIHJlcG9zaXRvcnk6IFByb3BUeXBlcy5zaGFwZSh7XG4gICAgICBpZDogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxuICAgICAgZGVmYXVsdEJyYW5jaFJlZjogUHJvcFR5cGVzLnNoYXBlKHtcbiAgICAgICAgcHJlZml4OiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG4gICAgICAgIG5hbWU6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcbiAgICAgIH0pLFxuICAgIH0pLFxuXG4gICAgLy8gQ29ubmVjdGlvblxuICAgIGVuZHBvaW50OiBFbmRwb2ludFByb3BUeXBlLmlzUmVxdWlyZWQsXG4gICAgdG9rZW46IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcblxuICAgIC8vIEF0b20gZW52aXJvbm1lbnRcbiAgICB3b3Jrc3BhY2U6IFByb3BUeXBlcy5vYmplY3QuaXNSZXF1aXJlZCxcblxuICAgIC8vIFJlcG9zaXRvcnkgbW9kZWwgYXR0cmlidXRlc1xuICAgIHJlbW90ZU9wZXJhdGlvbk9ic2VydmVyOiBPcGVyYXRpb25TdGF0ZU9ic2VydmVyUHJvcFR5cGUuaXNSZXF1aXJlZCxcbiAgICB3b3JraW5nRGlyZWN0b3J5OiBQcm9wVHlwZXMuc3RyaW5nLFxuICAgIHJlbW90ZTogUmVtb3RlUHJvcFR5cGUuaXNSZXF1aXJlZCxcbiAgICByZW1vdGVzOiBSZW1vdGVTZXRQcm9wVHlwZS5pc1JlcXVpcmVkLFxuICAgIGJyYW5jaGVzOiBCcmFuY2hTZXRQcm9wVHlwZS5pc1JlcXVpcmVkLFxuICAgIGFoZWFkQ291bnQ6IFByb3BUeXBlcy5udW1iZXIsXG4gICAgcHVzaEluUHJvZ3Jlc3M6IFByb3BUeXBlcy5ib29sLmlzUmVxdWlyZWQsXG5cbiAgICAvLyBBY3Rpb25zXG4gICAgb25DcmVhdGVQcjogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgfVxuXG4gIHN0YXRlID0ge307XG5cbiAgc3RhdGljIGdldERlcml2ZWRTdGF0ZUZyb21Qcm9wcyhwcm9wcykge1xuICAgIHJldHVybiB7XG4gICAgICBzZWFyY2hlczogW1xuICAgICAgICBTZWFyY2guaW5SZW1vdGUocHJvcHMucmVtb3RlLCAnT3BlbiBwdWxsIHJlcXVlc3RzJywgJ3R5cGU6cHIgc3RhdGU6b3BlbicpLFxuICAgICAgXSxcbiAgICB9O1xuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIHJldHVybiAoXG4gICAgICA8ZGl2IGNsYXNzTmFtZT1cImdpdGh1Yi1Jc3N1ZWlzaFNlYXJjaFwiPlxuICAgICAgICA8Q3VycmVudFB1bGxSZXF1ZXN0Q29udGFpbmVyXG4gICAgICAgICAgcmVwb3NpdG9yeT17dGhpcy5wcm9wcy5yZXBvc2l0b3J5fVxuICAgICAgICAgIHRva2VuPXt0aGlzLnByb3BzLnRva2VufVxuICAgICAgICAgIGVuZHBvaW50PXt0aGlzLnByb3BzLmVuZHBvaW50fVxuICAgICAgICAgIHJlbW90ZU9wZXJhdGlvbk9ic2VydmVyPXt0aGlzLnByb3BzLnJlbW90ZU9wZXJhdGlvbk9ic2VydmVyfVxuICAgICAgICAgIHJlbW90ZT17dGhpcy5wcm9wcy5yZW1vdGV9XG4gICAgICAgICAgcmVtb3Rlcz17dGhpcy5wcm9wcy5yZW1vdGVzfVxuICAgICAgICAgIGJyYW5jaGVzPXt0aGlzLnByb3BzLmJyYW5jaGVzfVxuICAgICAgICAgIGFoZWFkQ291bnQ9e3RoaXMucHJvcHMuYWhlYWRDb3VudH1cbiAgICAgICAgICBwdXNoSW5Qcm9ncmVzcz17dGhpcy5wcm9wcy5wdXNoSW5Qcm9ncmVzc31cbiAgICAgICAgICB3b3Jrc3BhY2U9e3RoaXMucHJvcHMud29ya3NwYWNlfVxuICAgICAgICAgIHdvcmtpbmdEaXJlY3Rvcnk9e3RoaXMucHJvcHMud29ya2luZ0RpcmVjdG9yeX1cbiAgICAgICAgICBvbk9wZW5Jc3N1ZWlzaD17dGhpcy5vbk9wZW5Jc3N1ZWlzaH1cbiAgICAgICAgICBvbkNyZWF0ZVByPXt0aGlzLnByb3BzLm9uQ3JlYXRlUHJ9XG4gICAgICAgIC8+XG4gICAgICAgIHt0aGlzLnN0YXRlLnNlYXJjaGVzLm1hcChzZWFyY2ggPT4gKFxuICAgICAgICAgIDxJc3N1ZWlzaFNlYXJjaENvbnRhaW5lclxuICAgICAgICAgICAga2V5PXtzZWFyY2guZ2V0TmFtZSgpfVxuXG4gICAgICAgICAgICB0b2tlbj17dGhpcy5wcm9wcy50b2tlbn1cbiAgICAgICAgICAgIGVuZHBvaW50PXt0aGlzLnByb3BzLmVuZHBvaW50fVxuICAgICAgICAgICAgc2VhcmNoPXtzZWFyY2h9XG4gICAgICAgICAgICByZW1vdGVPcGVyYXRpb25PYnNlcnZlcj17dGhpcy5wcm9wcy5yZW1vdGVPcGVyYXRpb25PYnNlcnZlcn1cblxuICAgICAgICAgICAgb25PcGVuSXNzdWVpc2g9e3RoaXMub25PcGVuSXNzdWVpc2h9XG4gICAgICAgICAgICBvbk9wZW5TZWFyY2g9e3RoaXMub25PcGVuU2VhcmNofVxuICAgICAgICAgIC8+XG4gICAgICAgICkpfVxuICAgICAgPC9kaXY+XG4gICAgKTtcbiAgfVxuXG4gIG9uT3Blbklzc3VlaXNoID0gaXNzdWVpc2ggPT4ge1xuICAgIHJldHVybiB0aGlzLnByb3BzLndvcmtzcGFjZS5vcGVuKFxuICAgICAgSXNzdWVpc2hEZXRhaWxJdGVtLmJ1aWxkVVJJKHtcbiAgICAgICAgaG9zdDogdGhpcy5wcm9wcy5lbmRwb2ludC5nZXRIb3N0KCksXG4gICAgICAgIG93bmVyOiB0aGlzLnByb3BzLnJlbW90ZS5nZXRPd25lcigpLFxuICAgICAgICByZXBvOiB0aGlzLnByb3BzLnJlbW90ZS5nZXRSZXBvKCksXG4gICAgICAgIG51bWJlcjogaXNzdWVpc2guZ2V0TnVtYmVyKCksXG4gICAgICAgIHdvcmtkaXI6IHRoaXMucHJvcHMud29ya2luZ0RpcmVjdG9yeSxcbiAgICAgIH0pLFxuICAgICAge3BlbmRpbmc6IHRydWUsIHNlYXJjaEFsbFBhbmVzOiB0cnVlfSxcbiAgICApLnRoZW4oKCkgPT4ge1xuICAgICAgYWRkRXZlbnQoJ29wZW4taXNzdWVpc2gtaW4tcGFuZScsIHtwYWNrYWdlOiAnZ2l0aHViJywgZnJvbTogJ2lzc3VlaXNoLWxpc3QnfSk7XG4gICAgfSk7XG4gIH1cblxuICBvbk9wZW5TZWFyY2ggPSBzZWFyY2ggPT4ge1xuICAgIGNvbnN0IHNlYXJjaFVSTCA9IHNlYXJjaC5nZXRXZWJVUkwodGhpcy5wcm9wcy5yZW1vdGUpO1xuXG4gICAgcmV0dXJuIG5ldyBQcm9taXNlKChyZXNvbHZlLCByZWplY3QpID0+IHtcbiAgICAgIHNoZWxsLm9wZW5FeHRlcm5hbChzZWFyY2hVUkwsIHt9LCBlcnIgPT4ge1xuICAgICAgICBpZiAoZXJyKSB7IHJlamVjdChlcnIpOyB9IGVsc2UgeyByZXNvbHZlKCk7IH1cbiAgICAgIH0pO1xuICAgIH0pO1xuICB9XG59XG4iXX0=