/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsDualEntry;
import com.dickimawbooks.bib2gls.Bib2GlsDualIndexAbbrev;
import com.dickimawbooks.bib2gls.GlsResource;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;

public class Bib2GlsTertiaryIndexAbbrevEntry
extends Bib2GlsDualIndexAbbrev {
    public Bib2GlsTertiaryIndexAbbrevEntry(Bib2Gls bib2Gls) {
        this(bib2Gls, "tertiaryindexabbreviationentry");
    }

    public Bib2GlsTertiaryIndexAbbrevEntry(Bib2Gls bib2Gls, String string) {
        super(bib2Gls, string);
    }

    @Override
    public boolean hasTertiary() {
        return true;
    }

    @Override
    protected Bib2GlsDualEntry createDualEntry() {
        return new Bib2GlsTertiaryIndexAbbrevEntry(this.bib2gls, this.getEntryType() + "secondary");
    }

    @Override
    public void checkRequiredFields() {
        super.checkRequiredFields();
        if (this.getField("description") == null) {
            this.missingFieldWarning("description");
        }
    }

    @Override
    public void writeBibEntry(PrintWriter printWriter) throws IOException {
        GlsResource glsResource = this.getResource();
        String string = glsResource.getTertiaryType();
        String string2 = glsResource.getTertiaryCategory();
        String string3 = glsResource.getTertiaryPrefix();
        if (string3 == null) {
            string3 = "";
        }
        printWriter.format("\\%s", this.getCsName());
        StringBuilder stringBuilder = null;
        printWriter.format("{%s}", this.getId());
        if (this.isPrimary()) {
            printWriter.format("{%s}", this.getDual().getId());
        } else {
            printWriter.format("{%s}", string3 + this.getOriginalId());
            stringBuilder = new StringBuilder();
        }
        printWriter.format("%%%n{", new Object[0]);
        String string4 = "";
        String string5 = "";
        String string6 = null;
        String string7 = "";
        String string8 = "";
        Set<String> set = this.getFieldSet();
        for (String string9 : set) {
            if (string9.equals("description")) {
                string5 = this.getFieldValue(string9);
                continue;
            }
            if (string9.equals("name")) {
                string6 = this.getFieldValue(string9);
                continue;
            }
            if (string9.equals("short")) {
                string7 = this.getFieldValue(string9);
                continue;
            }
            if (string9.equals("long")) {
                string8 = this.getFieldValue(string9);
                continue;
            }
            if (!this.bib2gls.isKnownField(string9)) continue;
            printWriter.format("%s", string4);
            string4 = String.format(",%n", new Object[0]);
            String string10 = this.getFieldValue(string9);
            printWriter.format("%s={%s}", string9, string10);
            if (stringBuilder == null || string9.equals("location")) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            if (string != null && string9.equals("type")) {
                string10 = string;
                string = null;
            } else if (string2 != null && string9.equals("category")) {
                string10 = string2;
                string2 = null;
            }
            stringBuilder.append(String.format("%s={%s}", string9, string10));
        }
        if (string6 == null) {
            string6 = this.getFallbackValue("name");
        }
        printWriter.println("}%");
        if (stringBuilder != null) {
            if (string2 != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(String.format("category={%s}", string2));
            }
            if (string != null) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(String.format("type={%s}", string));
            }
            printWriter.format("{%s}", stringBuilder);
        }
        printWriter.println(String.format("{%s}{%s}{%s}%n{%s}", string6, string7, string8, string5));
    }

    @Override
    public void writeCsDefinition(PrintWriter printWriter) throws IOException {
        if (this.isPrimary()) {
            printWriter.println("\\ifdef\\glsuseabbrvfont");
            printWriter.println("{%");
            printWriter.println("  \\providecommand*{\\bibglsuseabbrvfont}{\\glsuseabbrvfont}");
            printWriter.println("}%");
            printWriter.println("{%");
            printWriter.println("  \\providecommand*{\\bibglsuseabbrvfont}[2]{{\\glssetabbrvfmt{#2}\\glsabbrvfont{#1}}}");
            printWriter.println("}%");
            printWriter.format("\\providecommand{\\%s}[7]{%%%n", this.getCsName());
            printWriter.println("  \\longnewglossaryentry*{#1}{%");
            printWriter.println("      name={\\protect\\bibglsuseabbrvfont{#4}{\\glscategory{#2}}},%");
            printWriter.println("      category={index},#3}{}%");
        } else {
            printWriter.println("\\ifdef\\glsuselongfont");
            printWriter.println("{%");
            printWriter.println("  \\providecommand*{\\bibglsuselongfont}{\\glsuselongfont}");
            printWriter.println("}%");
            printWriter.println("{%");
            printWriter.println("  \\providecommand*{\\bibglsuselongfont}[2]{{\\glssetabbrvfmt{#2}\\glslongfont{#1}}}");
            printWriter.println("}%");
            printWriter.format("\\providecommand{\\%s}[8]{%%%n", this.getCsName());
            printWriter.println("  \\newabbreviation[#3]{#1}{#6}{#7}%");
            printWriter.println("  \\longnewglossaryentry*{#2}%");
            printWriter.println("  {name={\\protect\\bibglsuselongfont{#7}{\\glscategory{#1}}},#4}%");
            printWriter.println("  {#8}%");
        }
        printWriter.println("}");
    }
}

