/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class GroupDrawData
extends DrawData {
    public int headerWidth;
    public int headerHeight;
    public Rectangle headerArea;
    static final int GROUP_X = 2;
    static final int GROUP_PAD = 1;
    static final int GROUP_HEADER_X = 9;
    static final int GROUP_HEADER_PAD = 2;

    public GroupDrawData() {
        this.state = new int[1];
    }

    @Override
    void draw(Theme theme, GC gC, Rectangle rectangle) {
        long l = theme.frameHandle;
        long l2 = this.gtk_widget_get_style(l);
        long l3 = OS.GTK3 ? gC.getGCData().cairo : gC.getGCData().drawable;
        theme.transferClipping(gC, l2);
        int n = OS.gtk_style_get_xthickness(l2);
        int n2 = OS.gtk_style_get_ythickness(l2);
        int n3 = rectangle.x;
        int n4 = rectangle.y + this.headerHeight / 2;
        int n5 = rectangle.width;
        int n6 = rectangle.height - this.headerHeight / 2;
        byte[] byArray = Converter.wcsToMbcs(null, "frame", true);
        int n7 = n + 2;
        int n8 = this.headerWidth + 2;
        int n9 = 2;
        int n10 = this.getStateType(0);
        this.gtk_render_shadow_gap(l2, l3, n10, 3, null, l, byArray, n3, n4, n5, n6, n9, n7, n8);
        if (this.headerArea != null) {
            this.headerArea.x = rectangle.x + n7 + 1;
            this.headerArea.y = rectangle.y;
            this.headerArea.width = this.headerWidth;
            this.headerArea.height = this.headerHeight;
        }
        if (this.clientArea != null) {
            this.clientArea.x = rectangle.x + n;
            this.clientArea.y = rectangle.y + n2 + this.headerHeight;
            this.clientArea.width = rectangle.width - 2 * n;
            this.clientArea.height = rectangle.height - 2 * n2 - this.headerHeight;
        }
    }

    @Override
    int getStateType(int n) {
        int n2 = this.state[n];
        int n3 = 0;
        if ((n2 & 0x20) != 0) {
            n3 = 4;
        }
        return n3;
    }

    @Override
    int hit(Theme theme, Point point, Rectangle rectangle) {
        return rectangle.contains(point) ? 0 : -1;
    }

    void gtk_render_shadow_gap(long l, long l2, int n, int n2, GdkRectangle gdkRectangle, long l3, byte[] byArray, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (OS.GTK3) {
            OS.gtk_style_context_save(l);
            OS.gtk_style_context_set_state(l, n);
            OS.gtk_render_frame_gap(l, l2, l, n4, n9, n6, n7, n8, n8 + n9);
        } else {
            OS.gtk_paint_shadow_gap(l, l2, n, n2, gdkRectangle, l3, byArray, n3, n4, n5, n6, n7, n8, n9);
        }
    }
}

