/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_ky extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AUD", "AUD" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BRL", "BRL" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYN", "BYN" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CAD", "CAD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GBP", "GBP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HKD", "HKD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "ILS", "ILS" },
            { "INR", "INR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "KES", "KES" },
            { "KGS", "\u0441\u043e\u043c" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KRW", "KRW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LTL", "LTL" },
            { "LVL", "LVL" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "MNT" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MXN", "MXN" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "NZD", "NZD" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "\u0e3f" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TWD", "TWD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "USD", "USD" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "XCD", "XCD" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "aed", "\u0411\u0438\u0440\u0438\u043a\u043a\u0435\u043d \u0410\u0440\u0430\u0431 \u042d\u043c\u0438\u0440\u0430\u0442\u0442\u0430\u0440\u044b\u043d\u044b\u043d \u0434\u0438\u0440\u0445\u0430\u043c\u044b" },
            { "afn", "\u0410\u0444\u0433\u0430\u043d\u0441\u0442\u0430\u043d \u0430\u0444\u0433\u0430\u043d\u0438\u0441\u0438" },
            { "all", "\u0430\u043b\u0431\u0430\u043d \u043b\u0435\u0433\u0438" },
            { "amd", "\u0410\u0440\u043c\u0435\u043d\u0438\u044f \u0434\u0440\u0430\u043c\u044b" },
            { "ang", "\u043d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434-\u0430\u043d\u0442\u0438\u043b \u0433\u0443\u043b\u0434\u0435\u043d\u0438" },
            { "aoa", "\u0410\u043d\u0433\u043e\u043b\u0430 \u043a\u0432\u0430\u043d\u0437\u0430\u0441\u044b" },
            { "ars", "\u0430\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430 \u043f\u0435\u0441\u043e\u0441\u0443" },
            { "aud", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u044f \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "awg", "\u0430\u0440\u0443\u0431\u0430 \u0444\u043b\u043e\u0440\u0438\u043d\u0438" },
            { "azn", "\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0436\u0430\u043d \u043c\u0430\u043d\u0430\u0442\u044b" },
            { "bam", "\u0431\u043e\u0441\u043d\u0438\u044f-\u0433\u0435\u0440\u0446\u043e\u0433\u043e\u0432\u0438\u043d\u0430 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u044f\u043b\u0430\u043d\u0443\u0443\u0447\u0443 \u043c\u0430\u0440\u043a\u0430\u0441\u044b" },
            { "bbd", "\u0431\u0430\u0440\u0431\u0430\u0434\u043e\u0441 \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "bdt", "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448 \u0442\u0430\u043a\u0430\u0441\u044b" },
            { "bgn", "\u0431\u043e\u043b\u0433\u0430\u0440 \u043b\u0435\u0432\u0438\u0441\u0438" },
            { "bhd", "\u0411\u0430\u0445\u0440\u0435\u0439\u043d \u0434\u0438\u043d\u0430\u0440\u044b" },
            { "bif", "\u0411\u0443\u0440\u0443\u043d\u0434\u0438 \u0444\u0440\u0430\u043d\u043a\u044b" },
            { "bmd", "\u0431\u0435\u0440\u043c\u0443\u0434 \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "bnd", "\u0411\u0440\u0443\u043d\u0435\u0439 \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "bob", "\u0431\u043e\u043b\u0438\u0432\u0438\u044f \u0431\u043e\u043b\u0438\u0432\u0438\u0430\u043d\u043e\u0441\u0443" },
            { "brl", "\u0431\u0440\u0430\u0437\u0438\u043b\u0438\u044f \u0440\u0435\u0430\u043b\u044b" },
            { "bsd", "\u0431\u0430\u0433\u0430\u043c\u0430 \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "btn", "\u0411\u0443\u0442\u0430\u043d \u043d\u0433\u0443\u043b\u0442\u0440\u0443\u043c\u0443" },
            { "bwp", "\u0411\u043e\u0442\u0441\u0432\u0430\u043d\u0430 \u043f\u0443\u043b\u0430\u0441\u044b" },
            { "byn", "\u0431\u0435\u043b\u0430\u0440\u0443\u0441\u044c \u0440\u0443\u0431\u043b\u0443" },
            { "byr", "\u0431\u0435\u043b\u0430\u0440\u0443\u0441\u044c \u0440\u0443\u0431\u043b\u0443 (2000\u20132016)" },
            { "bzd", "\u0431\u0435\u043b\u0438\u0437 \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "cad", "\u043a\u0430\u043d\u0430\u0434\u0430 \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "cdf", "\u041a\u043e\u043d\u0433\u043e \u0444\u0440\u0430\u043d\u043a\u044b" },
            { "chf", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u044f \u0444\u0440\u0430\u043d\u043a\u044b" },
            { "clp", "\u0447\u0438\u043b\u0438 \u043f\u0435\u0441\u043e\u0441\u0443" },
            { "cnh", "CNH" },
            { "cny", "\u041a\u044b\u0442\u0430\u0439 \u044e\u0430\u043d\u044b" },
            { "cop", "\u043a\u043e\u043b\u0443\u043c\u0431\u0438\u044f \u043f\u0435\u0441\u043e\u0441\u0443" },
            { "crc", "\u043a\u043e\u0441\u0442\u0430-\u0440\u0438\u043a\u0430 \u043a\u043e\u043b\u043e\u043d\u0443" },
            { "cuc", "\u043a\u0443\u0431\u0430\u043d\u044b\u043d \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u044f\u043b\u0430\u043d\u0443\u0443\u0447\u0443 \u043f\u0435\u0441\u043e\u0441\u0443" },
            { "cup", "\u043a\u0443\u0431\u0430 \u043f\u0435\u0441\u043e\u0441\u0443" },
            { "cve", "\u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435 \u044d\u0441\u043a\u0443\u0434\u043e\u0441\u0443" },
            { "czk", "\u0447\u0435\u0445 \u043a\u0440\u043e\u043d\u0430\u0441\u044b" },
            { "djf", "\u0416\u0438\u0431\u0443\u0442\u0438 \u0444\u0440\u0430\u043d\u043a\u044b" },
            { "dkk", "\u0434\u0430\u043d\u0438\u044f \u043a\u0440\u043e\u043d\u0443" },
            { "dop", "\u0434\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d \u043f\u0435\u0441\u043e\u0441\u0443" },
            { "dzd", "\u0430\u043b\u0436\u0438\u0440 \u0434\u0438\u043d\u0430\u0440\u044b" },
            { "egp", "\u0435\u0433\u0438\u043f\u0435\u0442 \u0444\u0443\u043d\u0442\u0443" },
            { "ern", "\u042d\u0440\u0438\u0442\u0440\u0435\u0430 \u043d\u0430\u043a\u0444\u0430\u0441\u044b" },
            { "etb", "\u042d\u0444\u0438\u043e\u043f\u0438\u044f \u0431\u0438\u0440\u0440\u0438" },
            { "eur", "\u0415\u0432\u0440\u043e" },
            { "fjd", "\u0424\u0438\u0436\u0438 \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "fkp", "\u0444\u043e\u043b\u043a\u043b\u0435\u043d\u0434 \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b\u043d\u044b\u043d \u0444\u0443\u043d\u0442\u0443" },
            { "gbp", "\u0431\u0440\u0438\u0442\u0430\u043d\u0438\u044f \u0444\u0443\u043d\u0442 \u0441\u0442\u0435\u0440\u043b\u0438\u043d\u0433\u0438" },
            { "gel", "\u0413\u0440\u0443\u0437\u0438\u044f \u043b\u0430\u0440\u0438\u0441\u0438" },
            { "ghs", "\u0413\u0430\u043d\u0430 \u0441\u0435\u0434\u0438\u0441\u0438" },
            { "gip", "\u0433\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440 \u0444\u0443\u043d\u0442\u0443" },
            { "gmd", "\u0413\u0430\u043c\u0431\u0438\u044f \u0434\u0430\u043b\u0430\u0441\u0438\u0441\u0438" },
            { "gnf", "\u0413\u0438\u043d\u0435 \u0444\u0440\u0430\u043d\u043a\u044b" },
            { "gtq", "\u0433\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u0430 \u043a\u0435\u0442\u0441\u0430\u043b\u044b" },
            { "gyd", "\u0433\u0443\u0439\u0430\u043d\u0430 \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "hkd", "\u0413\u043e\u043d\u043a\u043e\u043d\u0433 \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "hnl", "\u0433\u043e\u043d\u0434\u0443\u0440\u0430\u0441 \u043b\u0435\u043c\u043f\u0438\u0440\u0430\u0441\u044b" },
            { "hrk", "\u0445\u043e\u0440\u0432\u0430\u0442 \u043a\u0443\u043d\u0430\u0441\u044b" },
            { "htg", "\u0433\u0430\u0438\u0442\u0438 \u0433\u0443\u0440\u0434\u0443\u0441\u0443" },
            { "huf", "\u0432\u0435\u043d\u0433\u0440 \u0444\u043e\u0440\u0438\u043d\u0442\u0438" },
            { "idr", "\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u044f \u0440\u0443\u043f\u0438\u0439\u0430\u0441\u044b" },
            { "ils", "\u0418\u0437\u0440\u0430\u0438\u043b\u0434\u0438\u043d \u0436\u0430\u04a3\u044b \u0448\u0435\u043a\u0435\u043b\u0438" },
            { "inr", "\u0418\u043d\u0434\u0438\u044f \u0440\u0443\u043f\u0438\u0441\u0438" },
            { "iqd", "\u0418\u0440\u0430\u043a \u0434\u0438\u043d\u0430\u0440\u044b" },
            { "irr", "\u0418\u0440\u0430\u043d \u0440\u0438\u0430\u043b\u044b" },
            { "isk", "\u0438\u0441\u043b\u0430\u043d\u0434\u0438\u044f \u043a\u0440\u043e\u043d\u0443" },
            { "jmd", "\u044f\u043c\u0430\u0439\u043a\u0430 \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "jod", "\u0419\u043e\u0440\u0434\u0430\u043d\u0438\u044f \u0434\u0438\u043d\u0430\u0440\u044b" },
            { "jpy", "\u0416\u0430\u043f\u0430\u043d \u0439\u0435\u043d\u0438" },
            { "kes", "\u041a\u0435\u043d\u0438\u044f \u0448\u0438\u043b\u043b\u0438\u043d\u0433\u0438" },
            { "kgs", "\u041a\u044b\u0440\u0433\u044b\u0437\u0441\u0442\u0430\u043d \u0441\u043e\u043c\u0443" },
            { "khr", "\u041a\u0430\u043c\u0431\u043e\u0436\u0430 \u0440\u0438\u0435\u043b\u0438" },
            { "kmf", "\u041a\u043e\u043c\u043e\u0440\u043e\u0441 \u0444\u0440\u0430\u043d\u043a\u044b" },
            { "kpw", "\u0422\u04af\u043d\u0434\u04af\u043a \u041a\u043e\u0440\u0435\u044f \u0443\u043e\u043d\u0443" },
            { "krw", "\u0422\u04af\u0448\u0442\u04af\u043a \u041a\u043e\u0440\u0435\u044f \u0443\u043e\u043d\u0443" },
            { "kwd", "\u041a\u0443\u0432\u0435\u0439\u0442 \u0434\u0438\u043d\u0430\u0440\u044b" },
            { "kyd", "\u043a\u0430\u0439\u043c\u0430\u043d \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "kzt", "\u041a\u0430\u0437\u0430\u043a\u0441\u0442\u0430\u043d \u0442\u0435\u04ca\u0433\u0435\u0441\u0438" },
            { "lak", "\u041b\u0430\u043e\u0441 \u043a\u0438\u0431\u0438" },
            { "lbp", "\u041b\u0438\u0432\u0430\u043d \u0444\u0443\u043d\u0442\u0443" },
            { "lkr", "\u0428\u0440\u0438 \u041b\u0430\u043d\u043a\u0430 \u0440\u0443\u043f\u0438\u0441\u0438" },
            { "lrd", "\u041b\u0438\u0431\u0435\u0440\u0438\u044f \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "ltl", "\u043b\u0438\u0442\u0432\u0430 \u043b\u0438\u0442\u0430\u0441\u044b" },
            { "lvl", "\u043b\u0430\u0442\u0432\u0438\u044f \u043b\u0430\u0442\u044b" },
            { "lyd", "\u043b\u0438\u0432\u0438\u044f \u0434\u0438\u043d\u0430\u0440\u044b" },
            { "mad", "\u043c\u0430\u0440\u043e\u043a\u043a\u043e \u0434\u0438\u0440\u0445\u0430\u043c\u044b" },
            { "mdl", "\u043c\u043e\u043b\u0434\u043e\u0432\u0430\u043d \u043b\u0435\u0439\u0438" },
            { "mga", "\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440 \u0430\u0440\u0438\u0430\u0440\u0438\u0441\u0438" },
            { "mkd", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d \u0434\u0435\u043d\u0430\u0440\u044b" },
            { "mmk", "\u041c\u0439\u0430\u043d\u043c\u0430\u0440 \u043a\u0439\u0430\u0442\u044b" },
            { "mnt", "\u041c\u043e\u043d\u0433\u043e\u043b \u0442\u0443\u0433\u0440\u0438\u0433\u0438" },
            { "mop", "\u041c\u0430\u043a\u0430\u0443 \u043f\u0430\u0442\u0430\u043a\u0430\u0441\u044b" },
            { "mro", "\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438\u044f \u0443\u0433\u0438\u044f\u0441\u044b (1973\u20132017)" },
            { "mru", "\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438\u044f \u0443\u0433\u0438\u044f\u0441\u044b" },
            { "mur", "\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438\u0439 \u0440\u0443\u043f\u0438\u0441\u0438" },
            { "mvr", "\u041c\u0430\u043b\u0434\u0438\u0432 \u0440\u0443\u0444\u0438\u0439\u0430\u0441\u044b" },
            { "mwk", "\u041c\u0430\u043b\u0430\u0432\u0438 \u043a\u0432\u0430\u0447\u0430\u0441\u044b" },
            { "mxn", "\u043c\u0435\u043a\u0441\u0438\u043a\u0430 \u043f\u0435\u0441\u043e\u0441\u0443" },
            { "myr", "\u041c\u0430\u043b\u0430\u0439\u0437\u0438\u044f \u0440\u0438\u043d\u0433\u0433\u0438\u0442\u0438" },
            { "mzn", "\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a \u043c\u0435\u0442\u0438\u043a\u0430\u043b\u044b" },
            { "nad", "\u041d\u0430\u043c\u0438\u0431\u0438\u044f \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "ngn", "\u041d\u0438\u0433\u0435\u0440\u0438\u044f \u043d\u0430\u0439\u0440\u0430\u0441\u044b" },
            { "nio", "\u043d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430 \u043a\u043e\u0440\u0434\u043e\u0431\u0430\u0441\u044b" },
            { "nok", "\u043d\u043e\u0440\u0432\u0435\u0433\u0438\u044f \u043a\u0440\u043e\u043d\u0443" },
            { "npr", "\u041d\u0435\u043f\u0430\u043b \u0440\u0443\u043f\u0438\u0441\u0438" },
            { "nzd", "\u0416\u0430\u04ca\u044b \u0417\u0435\u043b\u0430\u043d\u0434\u0438\u044f \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "omr", "\u041e\u043c\u0430\u043d \u0440\u0438\u0430\u043b\u044b" },
            { "pab", "\u043f\u0430\u043d\u0430\u043c\u0430 \u0431\u0430\u043b\u0431\u043e\u0430\u0441\u044b" },
            { "pen", "\u043f\u0435\u0440\u0443 \u0441\u043e\u043b\u0443" },
            { "pgk", "\u041f\u0430\u043f\u0443\u0430 \u0416\u0430\u04ca\u044b \u0413\u0432\u0438\u043d\u0435\u044f \u043a\u0438\u043d\u0430\u0441\u044b" },
            { "php", "\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d \u043f\u0435\u0441\u043e\u0441\u0443" },
            { "pkr", "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d \u0440\u0443\u043f\u0438\u0441\u0438" },
            { "pln", "\u043f\u043e\u043b\u044c\u0448\u0430 \u0437\u043b\u043e\u0442\u044b\u0439\u044b" },
            { "pyg", "\u043f\u0430\u0440\u0430\u0433\u0432\u0430\u0439 \u0433\u0443\u0430\u0440\u0430\u043d\u0438\u0441\u0438" },
            { "qar", "\u041a\u0430\u0442\u0430\u0440 \u0440\u0438\u0430\u043b\u044b" },
            { "ron", "\u0440\u0443\u043c\u044b\u043d \u043b\u0435\u0439\u0438" },
            { "rsd", "\u0441\u0435\u0440\u0431 \u0434\u0438\u043d\u0430\u0440\u044b" },
            { "rub", "\u043e\u0440\u0443\u0441 \u0440\u0443\u0431\u043b\u0443" },
            { "rwf", "\u0420\u0443\u0430\u043d\u0434\u0430 \u0444\u0440\u0430\u043d\u043a\u044b" },
            { "sar", "\u0421\u0430\u0443\u0434 \u0440\u0438\u0430\u043b\u044b" },
            { "sbd", "\u0421\u043e\u043b\u043e\u043c\u043e\u043d \u0430\u0440\u0430\u043b\u0434\u0430\u0440\u044b\u043d\u044b\u043d \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "scr", "\u0421\u0435\u0439\u0448\u0435\u043b \u0440\u0443\u043f\u0438\u0441\u0438" },
            { "sdg", "\u0441\u0443\u0434\u0430\u043d \u0444\u0443\u043d\u0442\u0443" },
            { "sek", "\u0448\u0432\u0435\u0446\u0438\u044f \u043a\u0440\u043e\u043d\u0443" },
            { "sgd", "\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440 \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "shp", "\u042b\u0439\u044b\u043a \u0415\u043b\u0435\u043d\u0430 \u0430\u0440\u0430\u043b\u044b\u043d\u044b\u043d \u0444\u0443\u043d\u0442\u0443" },
            { "sll", "\u0421\u0438\u0435\u0440\u0440\u0430-\u041b\u0435\u043e\u043d\u0435 \u043b\u0435\u043e\u043d\u0435\u0441\u0438" },
            { "sos", "\u0421\u043e\u043c\u0430\u043b\u0438 \u0448\u0438\u043b\u043b\u0438\u043d\u0433\u0438" },
            { "srd", "\u0441\u0443\u0440\u0438\u043d\u0430\u043c \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "ssp", "\u0422\u04af\u0448\u0442\u04af\u043a \u0421\u0443\u0434\u0430\u043d \u0444\u0443\u043d\u0442\u0443" },
            { "std", "\u0421\u0430\u043e \u0422\u043e\u043c\u0435 \u0436\u0430\u043d\u0430 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0435 \u0434\u043e\u0431\u0440\u0430\u0441\u044b (1977\u20132017)" },
            { "stn", "\u0421\u0430\u043e \u0422\u043e\u043c\u0435 \u0436\u0430\u043d\u0430 \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0435 \u0434\u043e\u0431\u0440\u0430\u0441\u044b" },
            { "syp", "\u0421\u0438\u0440\u0438\u044f \u0444\u0443\u043d\u0442\u0443" },
            { "szl", "\u0421\u0432\u0430\u0437\u0438 \u043b\u0438\u043b\u0430\u043d\u0433\u0435\u043d\u0438" },
            { "thb", "\u0422\u0430\u0439 \u0431\u0430\u0442\u044b" },
            { "tjs", "\u0422\u0430\u0436\u0438\u043a\u0441\u0442\u0430\u043d \u0441\u043e\u043c\u043e\u043d\u0438\u0441\u0438" },
            { "tmt", "\u0422\u04af\u0440\u043a\u043c\u04e9\u043d\u0441\u0442\u0430\u043d \u043c\u0430\u043d\u0430\u0442\u044b" },
            { "tnd", "\u0442\u0443\u043d\u0438\u0441 \u0434\u0438\u043d\u0430\u0440\u044b" },
            { "top", "\u0422\u043e\u043d\u0433\u0430 \u043f\u0430\u0430\u043d\u0433\u0430\u0441\u044b" },
            { "try", "\u0422\u04af\u0440\u043a\u0438\u044f \u043b\u0438\u0440\u0430\u0441\u044b" },
            { "ttd", "\u0442\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u0436\u0430\u043d\u0430 \u0442\u043e\u0431\u0430\u0433\u043e \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "twd", "\u0422\u0430\u0439\u0432\u0430\u043d\u044c \u0436\u0430\u04ca\u044b \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "tzs", "\u0422\u0430\u043d\u0437\u0430\u043d\u0438\u044f \u0448\u0438\u043b\u043b\u0438\u043d\u0433\u0438" },
            { "uah", "\u0443\u043a\u0440\u0430\u0438\u043d \u0433\u0440\u0438\u0432\u0435\u043d\u0438" },
            { "ugx", "\u0423\u0433\u0430\u043d\u0434\u0430 \u0448\u0438\u043b\u043b\u0438\u043d\u0433\u0438" },
            { "usd", "\u0410\u041a\u0428 \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "uyu", "\u0443\u0440\u0443\u0433\u0432\u0430\u0439 \u043f\u0435\u0441\u043e\u0441\u0443" },
            { "uzs", "\u04e8\u0437\u0431\u0435\u043a\u0441\u0442\u0430\u043d \u0441\u0443\u043c\u0443" },
            { "vef", "\u0432\u0435\u043d\u0435\u0441\u0443\u044d\u043b\u0430 \u0431\u043e\u043b\u0438\u0432\u0430\u0440\u044b" },
            { "vnd", "\u0412\u044c\u0435\u0442\u043d\u0430\u043c \u0434\u043e\u04ca\u0443" },
            { "vuv", "\u0412\u0430\u043d\u0443\u0430\u0442\u0443 \u0432\u0430\u0442\u0443\u0441\u0443" },
            { "wst", "\u0421\u0430\u043c\u043e\u0430 \u0442\u0430\u043b\u0430\u0441\u044b" },
            { "xaf", "\u0411\u043e\u0440\u0431\u043e\u0440\u0434\u0443\u043a \u0410\u0444\u0440\u0438\u043a\u0430 \u041a\u0424\u0410 \u0444\u0440\u0430\u043d\u043a\u044b" },
            { "xcd", "\u0447\u044b\u0433\u044b\u0448 \u043a\u0430\u0440\u0438\u0431 \u0434\u043e\u043b\u043b\u0430\u0440\u044b" },
            { "xof", "\u041a\u0424\u0410 \u0444\u0440\u0430\u043d\u043a\u044b" },
            { "xpf", "\u041a\u0424\u041f \u0444\u0440\u0430\u043d\u043a\u044b" },
            { "xxx", "\u0411\u0435\u043b\u0433\u0438\u0441\u0438\u0437 \u0430\u043a\u0447\u0430" },
            { "yer", "\u0419\u0435\u043c\u0435\u043d \u0440\u0438\u0430\u043b\u044b" },
            { "zar", "\u0422\u04af\u0448\u0442\u04af\u043a \u0410\u0444\u0440\u0438\u043a\u0430 \u0440\u0430\u043d\u0434\u044b" },
            { "zmw", "\u0417\u0430\u043c\u0431\u0438\u044f \u043a\u0432\u0430\u0447\u0430\u0441\u044b" },
        };
        return data;
    }
}
