"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var electron_1 = require("electron");
var primaryWindowId;
var getPrimaryWindow = function () {
    var _a = __read(primaryWindowId ? [electron_1.BrowserWindow.fromId(primaryWindowId)] : electron_1.BrowserWindow.getAllWindows(), 1), primaryWindow = _a[0];
    return primaryWindow;
};
var setPrimaryWindowId = function (newPrimaryWindowId) {
    primaryWindowId = newPrimaryWindowId;
};
var showPrimaryWindow = function () {
    var browserWindow = getPrimaryWindow();
    if (browserWindow) {
        if (browserWindow.isMinimized()) {
            browserWindow.restore();
        }
        else if (!browserWindow.isVisible()) {
            browserWindow.show();
        }
        browserWindow.focus();
    }
};
var sendActionToPrimaryWindow = function (channel) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    var _a;
    var primaryWindow = getPrimaryWindow();
    if (primaryWindow) {
        (_a = primaryWindow.webContents).send.apply(_a, __spread([channel], args));
    }
};
var sendActionAndFocusWindow = function (channel) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    var _a;
    var main = getPrimaryWindow();
    if (main.webContents.isLoading()) {
        main.webContents.once('did-finish-load', function () {
            var _a;
            (_a = main.webContents).send.apply(_a, __spread([channel], args));
        });
    }
    else {
        if (!main.isVisible()) {
            main.show();
            main.focus();
        }
        (_a = main.webContents).send.apply(_a, __spread([channel], args));
    }
};
exports.WindowManager = {
    getPrimaryWindow: getPrimaryWindow,
    sendActionAndFocusWindow: sendActionAndFocusWindow,
    sendActionToPrimaryWindow: sendActionToPrimaryWindow,
    setPrimaryWindowId: setPrimaryWindowId,
    showPrimaryWindow: showPrimaryWindow,
};
//# sourceMappingURL=WindowManager.js.map