/*
 * Decompiled with CFR 0.152.
 */
package hughai.utils;

import hughai.OptionsFromStartScript;
import hughai.PlayerObjects;
import hughai.utils.ConfigSourceReadWriter;
import hughai.utils.ReflectionHelper;
import java.lang.reflect.Field;

public class ConfigStartScriptReader<T>
implements ConfigSourceReadWriter<T> {
    PlayerObjects playerObjects;
    ReflectionHelper reflectionHelper;

    public ConfigStartScriptReader(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
        this.reflectionHelper = new ReflectionHelper(playerObjects);
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    void debug(Object object) {
        this.playerObjects.getLogFile().WriteLine("" + this.getClass().getSimpleName() + ": " + object);
    }

    @Override
    public void loadConfig(T t) {
        OptionsFromStartScript optionsFromStartScript = this.playerObjects.getOptionsFromStartScript();
        for (Field field : t.getClass().getDeclaredFields()) {
            ReflectionHelper.Exclude exclude = field.getAnnotation(ReflectionHelper.Exclude.class);
            if (exclude != null) continue;
            String string = field.getName();
            String string2 = optionsFromStartScript.getOption(string);
            Object object = null;
            if (string2 != null) {
                object = this.reflectionHelper.stringTofieldValue(field.getType(), string2);
                this.debug("found value in startscript: " + string + " = " + object);
            }
            try {
                field.set(t, object);
            }
            catch (Exception exception) {
                this.playerObjects.getLogFile().writeStackTrace(exception);
                throw new RuntimeException(exception);
            }
        }
    }

    @Override
    public void saveConfig(T t) {
        throw new RuntimeException("can't write to start script config");
    }
}

