/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.CommonBundle;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.ide.HelpIdProvider;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.CommitExecutorBase;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.CommitSessionContextAware;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionAction;
import com.intellij.openapi.vcs.changes.actions.diff.lst.LocalChangeListDiffTool;
import com.intellij.openapi.vcs.changes.ui.AlienChangeListBrowser;
import com.intellij.openapi.vcs.changes.ui.AlienLocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangeInfoCalculator;
import com.intellij.openapi.vcs.changes.ui.CommitDialogChangesBrowser;
import com.intellij.openapi.vcs.changes.ui.CommitHelper;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanel;
import com.intellij.openapi.vcs.changes.ui.CommitMessageProvider;
import com.intellij.openapi.vcs.changes.ui.CommitOptionsPanel;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.openapi.vcs.changes.ui.EditChangelistSupport;
import com.intellij.openapi.vcs.changes.ui.MultipleLocalChangeListsBrowser;
import com.intellij.openapi.vcs.changes.ui.SessionDialog;
import com.intellij.openapi.vcs.checkin.BaseCheckinHandlerFactory;
import com.intellij.openapi.vcs.checkin.BeforeCheckinDialogHandler;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinMetaHandler;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.CheckinHandlersManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.PartialChangesUtil;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vcs.ui.Refreshable;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.SplitterWithSecondHideable;
import com.intellij.ui.components.JBBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitChangeListDialog
extends DialogWrapper
implements CheckinProjectPanel,
DataProvider {
    private static final Logger LOG = Logger.getInstance(CommitChangeListDialog.class);
    private static final String HELP_ID = "reference.dialogs.vcs.commit";
    private static final String TITLE = VcsBundle.message((String)"commit.dialog.title", (Object[])new Object[0]);
    private static final int LAYOUT_VERSION = 2;
    private static final String SPLITTER_PROPORTION_OPTION = "CommitChangeListDialog.SPLITTER_PROPORTION_2";
    private static final String DETAILS_SPLITTER_PROPORTION_OPTION = "CommitChangeListDialog.DETAILS_SPLITTER_PROPORTION_2";
    private static final String DETAILS_SHOW_OPTION = "CommitChangeListDialog.DETAILS_SHOW_OPTION_";
    private static final float SPLITTER_PROPORTION_OPTION_DEFAULT = 0.5f;
    private static final float DETAILS_SPLITTER_PROPORTION_OPTION_DEFAULT = 0.6f;
    private static final boolean DETAILS_SHOW_OPTION_DEFAULT = true;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsConfiguration myVcsConfiguration;
    private final boolean myShowVcsCommit;
    @Nullable
    private final AbstractVcs myForceCommitInVcs;
    private final boolean myIsAlien;
    @Nullable
    private final CommitResultHandler myResultHandler;
    @NotNull
    private final Set<AbstractVcs> myAffectedVcses;
    @NotNull
    private final List<CommitExecutor> myExecutors;
    @NotNull
    private final List<CheckinHandler> myHandlers;
    private final boolean myAllOfDefaultChangeListChangesIncluded;
    @NotNull
    private final String myCommitActionName;
    private final boolean myEnablePartialCommit;
    @NotNull
    private final Map<String, String> myListComments;
    @NotNull
    private final List<CommitExecutorAction> myExecutorActions;
    @NotNull
    private final CommitOptionsPanel myCommitOptions;
    @NotNull
    private final CommitContext myCommitContext;
    @NotNull
    private final ChangeInfoCalculator myChangesInfoCalculator;
    @NotNull
    private final CommitDialogChangesBrowser myBrowser;
    @NotNull
    private final MyChangeProcessor myDiffDetails;
    @NotNull
    private final CommitMessage myCommitMessageArea;
    @NotNull
    private final CommitLegendPanel myLegend;
    @NotNull
    private final Splitter mySplitter;
    @NotNull
    private final SplitterWithSecondHideable myDetailsSplitter;
    @NotNull
    private final JBLabel myWarningLabel;
    @Nullable
    private final String myHelpId;
    @Nullable
    private final CommitAction myCommitAction;
    @NotNull
    private final Alarm myOKButtonUpdateAlarm;
    @NotNull
    private final Runnable myUpdateButtonsRunnable;
    private boolean myDisposed;
    private boolean myUpdateDisabled;
    private String myLastKnownComment;
    private String myLastSelectedListName;

    public static boolean commitChanges(@NotNull Project project, @NotNull Collection<? extends Change> changes2, @Nullable LocalChangeList initialSelection, @Nullable CommitExecutor executor, @Nullable String comment) {
        if (project == null) {
            CommitChangeListDialog.$$$reportNull$$$0(0);
        }
        if (changes2 == null) {
            CommitChangeListDialog.$$$reportNull$$$0(1);
        }
        return CommitChangeListDialog.commitChanges(project, changes2, changes2, initialSelection, executor, comment);
    }

    public static boolean commitChanges(@NotNull Project project, @NotNull Collection<? extends Change> changes2, @NotNull Collection<?> included, @Nullable LocalChangeList initialSelection, @Nullable CommitExecutor executor, @Nullable String comment) {
        if (project == null) {
            CommitChangeListDialog.$$$reportNull$$$0(2);
        }
        if (changes2 == null) {
            CommitChangeListDialog.$$$reportNull$$$0(3);
        }
        if (included == null) {
            CommitChangeListDialog.$$$reportNull$$$0(4);
        }
        if (executor == null) {
            return CommitChangeListDialog.commitChanges(project, ContainerUtil.newArrayList(changes2), included, initialSelection, CommitChangeListDialog.collectExecutors(project, changes2), true, null, comment, null, true);
        }
        return CommitChangeListDialog.commitChanges(project, ContainerUtil.newArrayList(changes2), included, initialSelection, Collections.singletonList(executor), false, null, comment, null, true);
    }

    public static boolean commitChanges(@NotNull Project project, @NotNull Collection<? extends Change> changes2, @Nullable LocalChangeList initialSelection, @NotNull List<CommitExecutor> executors, boolean showVcsCommit, @Nullable String comment, @Nullable CommitResultHandler customResultHandler) {
        if (project == null) {
            CommitChangeListDialog.$$$reportNull$$$0(5);
        }
        if (changes2 == null) {
            CommitChangeListDialog.$$$reportNull$$$0(6);
        }
        if (executors == null) {
            CommitChangeListDialog.$$$reportNull$$$0(7);
        }
        return CommitChangeListDialog.commitChanges(project, ContainerUtil.newArrayList(changes2), initialSelection, executors, showVcsCommit, comment, customResultHandler, true);
    }

    public static boolean commitChanges(@NotNull Project project, @NotNull List<Change> changes2, @Nullable LocalChangeList initialSelection, @NotNull List<CommitExecutor> executors, boolean showVcsCommit, @Nullable String comment, @Nullable CommitResultHandler customResultHandler, boolean cancelIfNoChanges) {
        if (project == null) {
            CommitChangeListDialog.$$$reportNull$$$0(8);
        }
        if (changes2 == null) {
            CommitChangeListDialog.$$$reportNull$$$0(9);
        }
        if (executors == null) {
            CommitChangeListDialog.$$$reportNull$$$0(10);
        }
        return CommitChangeListDialog.commitChanges(project, changes2, changes2, initialSelection, executors, showVcsCommit, null, comment, customResultHandler, cancelIfNoChanges);
    }

    public static boolean commitChanges(@NotNull Project project, @NotNull List<Change> changes2, @NotNull Collection<?> included, @Nullable LocalChangeList initialSelection, @NotNull List<CommitExecutor> executors, boolean showVcsCommit, @Nullable AbstractVcs forceCommitInVcs, @Nullable String comment, @Nullable CommitResultHandler customResultHandler, boolean cancelIfNoChanges) {
        if (project == null) {
            CommitChangeListDialog.$$$reportNull$$$0(11);
        }
        if (changes2 == null) {
            CommitChangeListDialog.$$$reportNull$$$0(12);
        }
        if (included == null) {
            CommitChangeListDialog.$$$reportNull$$$0(13);
        }
        if (executors == null) {
            CommitChangeListDialog.$$$reportNull$$$0(14);
        }
        ChangeListManager manager = ChangeListManager.getInstance((Project)project);
        LocalChangeList defaultList = manager.getDefaultChangeList();
        List changeLists = manager.getChangeListsCopy();
        HashSet<AbstractVcs> affectedVcses = new HashSet<AbstractVcs>();
        if (forceCommitInVcs != null) {
            affectedVcses.add(forceCommitInVcs);
        }
        for (LocalChangeList list2 : changeLists) {
            affectedVcses.addAll(ChangesUtil.getAffectedVcses((Collection)list2.getChanges(), (Project)project));
        }
        if (showVcsCommit) {
            List<VirtualFile> unversionedFiles = ChangeListManagerImpl.getInstanceImpl(project).getUnversionedFiles();
            affectedVcses.addAll(ChangesUtil.getAffectedVcsesForFiles(unversionedFiles, (Project)project));
        }
        if (cancelIfNoChanges && affectedVcses.isEmpty()) {
            Messages.showInfoMessage((Project)project, (String)VcsBundle.message((String)"commit.dialog.no.changes.detected.text", (Object[])new Object[0]), (String)VcsBundle.message((String)"commit.dialog.no.changes.detected.title", (Object[])new Object[0]));
            return false;
        }
        for (BaseCheckinHandlerFactory factory : CommitChangeListDialog.getCheckInFactories(project)) {
            BeforeCheckinDialogHandler handler2 = factory.createSystemReadyHandler(project);
            if (handler2 == null || handler2.beforeCommitDialogShown(project, changes2, executors, showVcsCommit)) continue;
            return false;
        }
        CommitChangeListDialog dialog2 = new CommitChangeListDialog(project, changes2, included, initialSelection, executors, showVcsCommit, defaultList, changeLists, affectedVcses, forceCommitInVcs, false, comment, customResultHandler);
        dialog2.show();
        return dialog2.isOK();
    }

    @NotNull
    private static List<BaseCheckinHandlerFactory> getCheckInFactories(@NotNull Project project) {
        if (project == null) {
            CommitChangeListDialog.$$$reportNull$$$0(15);
        }
        List list2 = CheckinHandlersManager.getInstance().getRegisteredCheckinHandlerFactories(ProjectLevelVcsManager.getInstance((Project)project).getAllActiveVcss());
        if (list2 == null) {
            CommitChangeListDialog.$$$reportNull$$$0(16);
        }
        return list2;
    }

    @NotNull
    public static List<CommitExecutor> collectExecutors(@NotNull Project project, @NotNull Collection<? extends Change> changes2) {
        if (project == null) {
            CommitChangeListDialog.$$$reportNull$$$0(17);
        }
        if (changes2 == null) {
            CommitChangeListDialog.$$$reportNull$$$0(18);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (AbstractVcs vcs : ChangesUtil.getAffectedVcses(changes2, (Project)project)) {
            result2.addAll(vcs.getCommitExecutors());
        }
        result2.addAll(ChangeListManager.getInstance((Project)project).getRegisteredExecutors());
        ArrayList arrayList = result2;
        if (arrayList == null) {
            CommitChangeListDialog.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    public static void commitAlienChanges(@NotNull Project project, @NotNull List<Change> changes2, @NotNull AbstractVcs vcs, @NotNull String changelistName, @Nullable String comment) {
        if (project == null) {
            CommitChangeListDialog.$$$reportNull$$$0(20);
        }
        if (changes2 == null) {
            CommitChangeListDialog.$$$reportNull$$$0(21);
        }
        if (vcs == null) {
            CommitChangeListDialog.$$$reportNull$$$0(22);
        }
        if (changelistName == null) {
            CommitChangeListDialog.$$$reportNull$$$0(23);
        }
        AlienLocalChangeList changeList = new AlienLocalChangeList(changes2, changelistName);
        new CommitChangeListDialog(project, changes2, changes2, null, Collections.emptyList(), true, AlienLocalChangeList.DEFAULT_ALIEN, Collections.singletonList(changeList), Collections.singleton(vcs), vcs, true, comment, null).show();
    }

    private CommitChangeListDialog(@NotNull Project project, @NotNull List<Change> changes2, @NotNull Collection<?> included, @Nullable LocalChangeList initialSelection, @NotNull List<CommitExecutor> executors, boolean showVcsCommit, @NotNull LocalChangeList defaultChangeList, @NotNull List<LocalChangeList> changeLists, @NotNull Set<AbstractVcs> affectedVcses, @Nullable AbstractVcs forceCommitInVcs, boolean isAlien, @Nullable String comment, @Nullable CommitResultHandler customResultHandler) {
        Object mainPanel;
        if (project == null) {
            CommitChangeListDialog.$$$reportNull$$$0(24);
        }
        if (changes2 == null) {
            CommitChangeListDialog.$$$reportNull$$$0(25);
        }
        if (included == null) {
            CommitChangeListDialog.$$$reportNull$$$0(26);
        }
        if (executors == null) {
            CommitChangeListDialog.$$$reportNull$$$0(27);
        }
        if (defaultChangeList == null) {
            CommitChangeListDialog.$$$reportNull$$$0(28);
        }
        if (changeLists == null) {
            CommitChangeListDialog.$$$reportNull$$$0(29);
        }
        if (affectedVcses == null) {
            CommitChangeListDialog.$$$reportNull$$$0(30);
        }
        super(project, true, Registry.is((String)"ide.perProjectModality") ? DialogWrapper.IdeModalityType.PROJECT : DialogWrapper.IdeModalityType.IDE);
        this.myHandlers = ContainerUtil.newArrayList();
        this.myOKButtonUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myUpdateButtonsRunnable = () -> {
            this.updateButtons();
            this.updateLegend();
        };
        this.myDisposed = false;
        this.myUpdateDisabled = false;
        this.myLastKnownComment = "";
        this.myCommitContext = new CommitContext();
        this.myProject = project;
        this.myVcsConfiguration = (VcsConfiguration)ObjectUtils.notNull((Object)VcsConfiguration.getInstance((Project)this.myProject));
        this.myShowVcsCommit = showVcsCommit;
        this.myAffectedVcses = affectedVcses;
        this.myExecutors = executors;
        this.myForceCommitInVcs = forceCommitInVcs;
        this.myIsAlien = isAlien;
        this.myResultHandler = customResultHandler;
        this.myListComments = ContainerUtil.newHashMap();
        if (!this.myShowVcsCommit && ContainerUtil.isEmpty(executors)) {
            throw new IllegalArgumentException("nothing found to execute commit with");
        }
        this.myAllOfDefaultChangeListChangesIncluded = ContainerUtil.newHashSet(changes2).containsAll(ContainerUtil.newHashSet((Iterable)defaultChangeList.getChanges()));
        this.myHandlers.addAll(CommitChangeListDialog.createCheckinHandlers(project, this, this.myCommitContext));
        this.setTitle(this.myShowVcsCommit ? TITLE : CommitChangeListDialog.getExecutorPresentableText(executors.get(0)));
        this.myCommitActionName = CommitChangeListDialog.getCommitActionName(this.myAffectedVcses);
        this.myExecutorActions = this.createExecutorActions(executors);
        if (this.myShowVcsCommit) {
            this.myCommitAction = new CommitAction(this.myCommitActionName);
            this.myCommitAction.setOptions(this.myExecutorActions);
        } else {
            this.myCommitAction = null;
            this.myExecutorActions.get(0).putValue("DefaultAction", Boolean.TRUE);
        }
        this.myHelpId = this.myShowVcsCommit ? HELP_ID : CommitChangeListDialog.getHelpId(executors);
        this.myEnablePartialCommit = ContainerUtil.exists(this.myAffectedVcses, AbstractVcs::arePartialChangelistsSupported) && (this.myShowVcsCommit || ContainerUtil.exists(this.myExecutors, executor -> executor.supportsPartialCommit()));
        this.myDiffDetails = new MyChangeProcessor(this.myProject, this.myEnablePartialCommit);
        this.myCommitMessageArea = new CommitMessage(project, true, true, this.myShowVcsCommit);
        JBBox browserBottomPanel = JBBox.createHorizontalBox();
        if (this.myIsAlien) {
            assert (changeLists.size() == 1);
            LocalChangeList changeList = changeLists.get(0);
            this.myBrowser = new AlienChangeListBrowser(project, changeList, changes2);
            this.myBrowser.getViewer().setIncludedChanges(included);
            this.myBrowser.getViewer().rebuildTree();
            this.myCommitMessageArea.setChangeList((ChangeList)changeList);
        } else {
            LineStatusTrackerManager.getInstanceImpl(this.myProject).resetExcludedFromCommitMarkers();
            MultipleLocalChangeListsBrowser browser2 = new MultipleLocalChangeListsBrowser(project, true, true, this.myShowVcsCommit, this.myEnablePartialCommit);
            this.myBrowser = browser2;
            CurrentBranchComponent branchComponent = new CurrentBranchComponent(project, this.myBrowser);
            UIUtil.addBorder((JComponent)((Object)branchComponent), (Border)JBUI.Borders.emptyRight((int)16));
            browserBottomPanel.add((Component)((Object)branchComponent));
            if (initialSelection != null) {
                browser2.setSelectedChangeList(initialSelection);
            }
            this.myCommitMessageArea.setChangeList((ChangeList)browser2.getSelectedChangeList());
            browser2.getViewer().setIncludedChanges(included);
            browser2.getViewer().rebuildTree();
            browser2.getViewer().setKeepTreeState(true);
            DiffCommitMessageEditor commitMessageEditor = new DiffCommitMessageEditor(this.myProject, this.myCommitMessageArea);
            browser2.setBottomDiffComponent(commitMessageEditor);
            browser2.setInclusionChangedListener(() -> {
                this.myHandlers.forEach(CheckinHandler::includedChangesChanged);
                this.updateButtons();
            });
            browser2.setSelectedListChangeListener(() -> {
                this.myCommitMessageArea.setChangeList((ChangeList)browser2.getSelectedChangeList());
                this.updateOnListSelection();
                this.updateWarning();
            });
            browser2.getViewer().addSelectionListener(() -> {
                boolean fromModelRefresh = browser2.getViewer().isModelUpdateInProgress();
                SwingUtilities.invokeLater(() -> this.changeDetails(fromModelRefresh));
            });
        }
        this.myChangesInfoCalculator = new ChangeInfoCalculator();
        this.myLegend = new CommitLegendPanel(this.myChangesInfoCalculator);
        browserBottomPanel.add((Component)this.myLegend.getComponent());
        BorderLayoutPanel topPanel = JBUI.Panels.simplePanel().addToCenter((Component)this.myBrowser).addToBottom((Component)browserBottomPanel);
        this.mySplitter = new Splitter(true);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setFirstComponent((JComponent)topPanel);
        this.mySplitter.setSecondComponent((JComponent)this.myCommitMessageArea);
        this.mySplitter.setProportion(PropertiesComponent.getInstance().getFloat(SPLITTER_PROPORTION_OPTION, 0.5f));
        if (!this.myVcsConfiguration.CLEAR_INITIAL_COMMIT_MESSAGE) {
            this.setComment(initialSelection, comment);
        }
        this.myCommitOptions = new CommitOptionsPanel(this, this.myHandlers, this.getAffectedVcses());
        this.restoreState();
        this.myWarningLabel = new JBLabel();
        this.myWarningLabel.setForeground((Color)JBColor.RED);
        this.myWarningLabel.setBorder((Border)JBUI.Borders.empty((int)5, (int)5, (int)0, (int)5));
        this.updateWarning();
        if (!this.myCommitOptions.isEmpty()) {
            mainPanel = new JPanel((LayoutManager)((Object)new MyOptionsLayout((JComponent)this.mySplitter, (JComponent)((Object)this.myCommitOptions), JBUI.scale((int)150), JBUI.scale((int)400))));
            ((Container)mainPanel).add((Component)this.mySplitter);
            ((Container)mainPanel).add((Component)((Object)this.myCommitOptions));
        } else {
            mainPanel = this.mySplitter;
        }
        BorderLayoutPanel rootPane = JBUI.Panels.simplePanel((Component)mainPanel).addToBottom((Component)this.myWarningLabel);
        this.myDetailsSplitter = new SplitterWithSecondHideable(true, "Diff", (JComponent)rootPane, new SplitterWithSecondHideable.OnOffListener<Integer>(){

            @Override
            public void on(Integer integer) {
                if (integer == 0) {
                    return;
                }
                CommitChangeListDialog.this.myDiffDetails.refresh(false);
                CommitChangeListDialog.this.mySplitter.skipNextLayout();
                CommitChangeListDialog.this.myDetailsSplitter.getComponent().skipNextLayout();
                Dimension dialogSize = CommitChangeListDialog.this.getSize();
                CommitChangeListDialog.this.setSize(dialogSize.width, dialogSize.height + integer);
                CommitChangeListDialog.this.repaint();
            }

            @Override
            public void off(Integer integer) {
                if (integer == 0) {
                    return;
                }
                CommitChangeListDialog.this.myDiffDetails.clear();
                CommitChangeListDialog.this.mySplitter.skipNextLayout();
                CommitChangeListDialog.this.myDetailsSplitter.getComponent().skipNextLayout();
                Dimension dialogSize = CommitChangeListDialog.this.getSize();
                CommitChangeListDialog.this.setSize(dialogSize.width, dialogSize.height - integer);
                CommitChangeListDialog.this.repaint();
            }
        }){

            @Override
            protected RefreshablePanel createDetails() {
                BorderLayoutPanel panel2 = JBUI.Panels.simplePanel((Component)CommitChangeListDialog.this.myDiffDetails.getComponent());
                return new RefreshablePanel((JPanel)panel2){
                    final /* synthetic */ JPanel val$panel;
                    {
                        this.val$panel = jPanel;
                    }

                    @Override
                    public void refresh() {
                    }

                    @Override
                    public JPanel getPanel() {
                        return this.val$panel;
                    }
                };
            }

            @Override
            protected float getSplitterInitialProportion() {
                float value = PropertiesComponent.getInstance().getFloat(CommitChangeListDialog.DETAILS_SPLITTER_PROPORTION_OPTION, 0.6f);
                return (double)value <= 0.05 || (double)value >= 0.95 ? 0.6f : value;
            }
        };
        this.init();
        this.updateButtons();
        this.updateLegend();
        this.updateOnListSelection();
        this.myCommitMessageArea.requestFocusInMessage();
        for (EditChangelistSupport support : (EditChangelistSupport[])EditChangelistSupport.EP_NAME.getExtensions((AreaInstance)project)) {
            support.installSearch(this.myCommitMessageArea.getEditorField(), this.myCommitMessageArea.getEditorField());
        }
        this.showDetailsIfSaved();
    }

    @NotNull
    public static List<CheckinHandler> createCheckinHandlers(@NotNull Project project, @NotNull CheckinProjectPanel checkinPanel, @NotNull CommitContext commitContext) {
        if (project == null) {
            CommitChangeListDialog.$$$reportNull$$$0(31);
        }
        if (checkinPanel == null) {
            CommitChangeListDialog.$$$reportNull$$$0(32);
        }
        if (commitContext == null) {
            CommitChangeListDialog.$$$reportNull$$$0(33);
        }
        ArrayList<CheckinHandler> handlers = new ArrayList<CheckinHandler>();
        for (BaseCheckinHandlerFactory factory : CommitChangeListDialog.getCheckInFactories(project)) {
            CheckinHandler handler2 = factory.createHandler(checkinPanel, commitContext);
            if (CheckinHandler.DUMMY.equals(handler2)) continue;
            handlers.add(handler2);
        }
        ArrayList<CheckinHandler> arrayList = handlers;
        if (arrayList == null) {
            CommitChangeListDialog.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    @NotNull
    private List<CommitExecutorAction> createExecutorActions(@NotNull List<CommitExecutor> executors) {
        if (executors == null) {
            CommitChangeListDialog.$$$reportNull$$$0(35);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        if (this.myShowVcsCommit && UISettings.getShadowInstance().getAllowMergeButtons()) {
            ActionGroup group = (ActionGroup)ActionManager.getInstance().getAction("Vcs.CommitExecutor.Actions");
            result2.addAll(ContainerUtil.map((Object[])group.getChildren(null), x$0 -> new CommitExecutorAction((AnAction)x$0)));
            result2.addAll(ContainerUtil.map((Collection)ContainerUtil.filter(executors, CommitExecutor::useDefaultAction), x$0 -> new CommitExecutorAction((CommitExecutor)x$0)));
        } else {
            result2.addAll(ContainerUtil.map(executors, x$0 -> new CommitExecutorAction((CommitExecutor)x$0)));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            CommitChangeListDialog.$$$reportNull$$$0(36);
        }
        return arrayList;
    }

    @Nullable
    private static String getHelpId(@NotNull List<CommitExecutor> executors) {
        if (executors == null) {
            CommitChangeListDialog.$$$reportNull$$$0(37);
        }
        return StreamEx.of(executors).select(HelpIdProvider.class).map(HelpIdProvider::getHelpId).nonNull().findFirst().orElse(null);
    }

    private void setComment(@Nullable LocalChangeList initialSelection, @Nullable String comment) {
        if (comment != null) {
            this.setCommitMessage(comment);
            this.myLastKnownComment = comment;
            this.myLastSelectedListName = ((LocalChangeList)ObjectUtils.notNull((Object)initialSelection, (Object)this.myBrowser.getSelectedChangeList())).getName();
        } else {
            this.updateComment();
            if (StringUtil.isEmptyOrSpaces((String)this.myCommitMessageArea.getComment())) {
                this.setCommitMessage(this.myVcsConfiguration.LAST_COMMIT_MESSAGE);
                String messageFromVcs = this.getInitialMessageFromVcs();
                if (messageFromVcs != null) {
                    this.myCommitMessageArea.setText(messageFromVcs);
                }
            }
        }
    }

    private void showDetailsIfSaved() {
        boolean showDetails = PropertiesComponent.getInstance().getBoolean(DETAILS_SHOW_OPTION, true);
        if (showDetails) {
            this.myDetailsSplitter.initOn();
        }
        SwingUtilities.invokeLater(() -> this.changeDetails(false));
    }

    private void updateOnListSelection() {
        this.updateComment();
        this.myCommitOptions.onChangeListSelected(this.myBrowser.getSelectedChangeList(), ChangeListManagerImpl.getInstanceImpl(this.myProject).getUnversionedFiles());
    }

    private void updateWarning() {
        if (this.myWarningLabel != null) {
            Object[] messages;
            this.myWarningLabel.setVisible(false);
            VcsException updateException = ChangeListManagerImpl.getInstanceImpl(this.myProject).getUpdateException();
            if (updateException != null && !ArrayUtil.isEmpty((Object[])(messages = updateException.getMessages()))) {
                String message = "Warning: not all local changes may be shown due to an error: " + (String)messages[0];
                String htmlMessage = SwingHelper.buildHtml(UIUtil.getCssFontDeclaration((Font)UIUtil.getLabelFont()), UIUtil.getHtmlBody((String)StringUtil.escapeXml((String)message)));
                this.myWarningLabel.setText(htmlMessage);
                this.myWarningLabel.setVisible(true);
            }
        }
    }

    @Nullable
    protected String getHelpId() {
        return this.myHelpId;
    }

    private boolean addUnversionedFiles() {
        return ScheduleForAdditionAction.addUnversioned(this.myProject, this.myBrowser.getIncludedUnversionedFiles(), ChangeListManagerImpl.getDefaultUnversionedFileCondition(), this.myBrowser);
    }

    @NotNull
    protected Action getOKAction() {
        Action action = this.myCommitAction != null ? this.myCommitAction : (Action)this.myExecutorActions.get(0);
        if (action == null) {
            CommitChangeListDialog.$$$reportNull$$$0(38);
        }
        return action;
    }

    @NotNull
    protected Action[] createActions() {
        ArrayList result2 = ContainerUtil.newArrayList();
        if (this.myCommitAction != null) {
            result2.add(this.myCommitAction);
        } else {
            result2.addAll(this.myExecutorActions);
        }
        result2.add(this.getCancelAction());
        if (this.myHelpId != null) {
            result2.add(this.getHelpAction());
        }
        Action[] actionArray = (Action[])ArrayUtil.toObjectArray((Collection)result2, Action.class);
        if (actionArray == null) {
            CommitChangeListDialog.$$$reportNull$$$0(39);
        }
        return actionArray;
    }

    private void executeDefaultCommitSession(@Nullable CommitExecutor executor) {
        if (!this.myIsAlien && !this.addUnversionedFiles()) {
            return;
        }
        if (!this.saveDialogState()) {
            return;
        }
        this.saveComments(true);
        this.ensureDataIsActual(() -> {
            try {
                DefaultListCleaner defaultListCleaner = new DefaultListCleaner();
                CheckinHandler.ReturnResult result2 = this.performBeforeCommitChecks(executor);
                if (result2 == CheckinHandler.ReturnResult.COMMIT) {
                    this.close(0);
                    this.doCommit(this.myResultHandler);
                    defaultListCleaner.clean();
                }
            }
            catch (InputException ex) {
                ex.show();
            }
        });
    }

    public void execute(@NotNull CommitExecutor commitExecutor) {
        CommitSession session2;
        if (commitExecutor == null) {
            CommitChangeListDialog.$$$reportNull$$$0(40);
        }
        if ((session2 = commitExecutor.createCommitSession()) == CommitSession.VCS_COMMIT) {
            this.executeDefaultCommitSession(commitExecutor);
            return;
        }
        if (!this.checkCommitOptionsSupported(commitExecutor)) {
            return;
        }
        if (!this.saveDialogState()) {
            return;
        }
        this.saveComments(true);
        if (session2 instanceof CommitSessionContextAware) {
            ((CommitSessionContextAware)session2).setContext(this.myCommitContext);
        }
        this.ensureDataIsActual(() -> {
            SessionDialog sessionDialog;
            JComponent configurationUI = SessionDialog.createConfigurationUI(session2, this.getIncludedChanges(), this.getCommitMessage());
            if (configurationUI != null && !(sessionDialog = new SessionDialog(CommitChangeListDialog.getExecutorPresentableText(commitExecutor), this.getProject(), session2, this.getIncludedChanges(), this.getCommitMessage(), configurationUI)).showAndGet()) {
                session2.executionCanceled();
                return;
            }
            DefaultListCleaner defaultListCleaner = new DefaultListCleaner();
            CheckinHandler.ReturnResult result2 = this.performBeforeCommitChecks(commitExecutor);
            if (result2 == CheckinHandler.ReturnResult.COMMIT) {
                boolean success2 = false;
                try {
                    boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> session2.execute(this.getIncludedChanges(), this.getCommitMessage()), commitExecutor.getActionText(), true, this.getProject());
                    if (completed) {
                        LOG.debug("Commit successful");
                        this.myHandlers.forEach(CheckinHandler::checkinSuccessful);
                        success2 = true;
                        defaultListCleaner.clean();
                        this.close(0);
                    } else {
                        LOG.debug("Commit canceled");
                        session2.executionCanceled();
                    }
                }
                catch (Throwable e) {
                    Messages.showErrorDialog((String)VcsBundle.message((String)"error.executing.commit", (Object[])new Object[]{commitExecutor.getActionText(), e.getLocalizedMessage()}), (String)commitExecutor.getActionText());
                    this.myHandlers.forEach(handler2 -> handler2.checkinFailed(Collections.singletonList(new VcsException(e))));
                }
                finally {
                    if (this.myResultHandler != null) {
                        if (success2) {
                            this.myResultHandler.onSuccess(this.getCommitMessage());
                        } else {
                            this.myResultHandler.onFailure();
                        }
                    }
                }
            }
        });
    }

    @Nullable
    private String getInitialMessageFromVcs() {
        Ref result2 = new Ref();
        ChangesUtil.processChangesByVcs((Project)this.myProject, this.getIncludedChanges(), (vcs, changes2) -> {
            CheckinEnvironment checkinEnvironment;
            if (result2.isNull() && (checkinEnvironment = vcs.getCheckinEnvironment()) != null) {
                FilePath[] paths = (FilePath[])ArrayUtil.toObjectArray((Collection)ChangesUtil.getPaths((Collection)changes2), FilePath.class);
                result2.set((Object)checkinEnvironment.getDefaultMessageFor(paths));
            }
        });
        return (String)result2.get();
    }

    private void saveCommentIntoChangeList() {
        if (this.myLastSelectedListName != null) {
            String commitMessage2 = this.myCommitMessageArea.getComment();
            String savedComment = this.myListComments.get(this.myLastSelectedListName);
            if (!Comparing.equal((String)savedComment, (String)commitMessage2)) {
                this.myListComments.put(this.myLastSelectedListName, commitMessage2);
            }
        }
    }

    private void updateComment() {
        if (this.myVcsConfiguration.CLEAR_INITIAL_COMMIT_MESSAGE) {
            return;
        }
        LocalChangeList list2 = this.myBrowser.getSelectedChangeList();
        if (list2.getName().equals(this.myLastSelectedListName)) {
            return;
        }
        if (this.myLastSelectedListName != null) {
            this.saveCommentIntoChangeList();
        }
        this.myLastSelectedListName = list2.getName();
        this.myCommitMessageArea.setText(this.getCommentFromChangelist(list2));
    }

    @Nullable
    private String getCommentFromChangelist(@NotNull LocalChangeList list2) {
        if (list2 == null) {
            CommitChangeListDialog.$$$reportNull$$$0(41);
        }
        for (CommitMessageProvider provider : CommitMessageProvider.EXTENSION_POINT_NAME.getExtensionList()) {
            String message = provider.getCommitMessage(list2, this.getProject());
            if (message == null) continue;
            return message;
        }
        String listComment = list2.getComment();
        if (StringUtil.isEmptyOrSpaces((String)listComment)) {
            listComment = !list2.hasDefaultName() ? list2.getName() : this.myLastKnownComment;
        }
        return listComment;
    }

    public void dispose() {
        this.myDisposed = true;
        Disposer.dispose((Disposable)this.myCommitOptions);
        Disposer.dispose((Disposable)this.myBrowser);
        Disposer.dispose((Disposable)this.myCommitMessageArea);
        Disposer.dispose((Disposable)this.myOKButtonUpdateAlarm);
        super.dispose();
        Disposer.dispose((Disposable)this.myDiffDetails);
        PropertiesComponent.getInstance().setValue(SPLITTER_PROPORTION_OPTION, this.mySplitter.getProportion(), 0.5f);
        float usedProportion = this.myDetailsSplitter.getUsedProportion();
        if (usedProportion > 0.0f) {
            PropertiesComponent.getInstance().setValue(DETAILS_SPLITTER_PROPORTION_OPTION, usedProportion, 0.6f);
        }
        PropertiesComponent.getInstance().setValue(DETAILS_SHOW_OPTION, this.myDetailsSplitter.isOn(), true);
    }

    @NotNull
    public String getCommitActionName() {
        String string = this.myCommitActionName;
        if (string == null) {
            CommitChangeListDialog.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    private static String getCommitActionName(@NotNull Collection<AbstractVcs> affectedVcses) {
        Set names;
        if (affectedVcses == null) {
            CommitChangeListDialog.$$$reportNull$$$0(43);
        }
        if ((names = ContainerUtil.map2SetNotNull(affectedVcses, vcs -> {
            CheckinEnvironment checkinEnvironment = vcs.getCheckinEnvironment();
            return checkinEnvironment != null ? checkinEnvironment.getCheckinOperationName() : null;
        })).size() == 1) {
            String string = (String)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((Collection)names));
            if (string == null) {
                CommitChangeListDialog.$$$reportNull$$$0(44);
            }
            return string;
        }
        String string = VcsBundle.getString((String)"commit.dialog.default.commit.operation.name");
        if (string == null) {
            CommitChangeListDialog.$$$reportNull$$$0(45);
        }
        return string;
    }

    private boolean checkComment() {
        if (this.myVcsConfiguration.FORCE_NON_EMPTY_COMMENT && this.getCommitMessage().isEmpty()) {
            int requestForCheckin = Messages.showYesNoDialog((String)VcsBundle.message((String)"confirmation.text.check.in.with.empty.comment", (Object[])new Object[0]), (String)VcsBundle.message((String)"confirmation.title.check.in.with.empty.comment", (Object[])new Object[0]), (Icon)Messages.getWarningIcon());
            return requestForCheckin == 0;
        }
        return true;
    }

    private void stopUpdate() {
        this.myUpdateDisabled = true;
    }

    private void restartUpdate() {
        this.myUpdateDisabled = false;
        this.myUpdateButtonsRunnable.run();
    }

    @NotNull
    private CheckinHandler.ReturnResult performBeforeCommitChecks(@Nullable CommitExecutor executor) {
        this.stopUpdate();
        Ref compoundResultRef = Ref.create();
        Runnable proceedRunnable = () -> {
            FileDocumentManager.getInstance().saveAllDocuments();
            compoundResultRef.set((Object)this.runBeforeCheckinHandlers(executor));
        };
        Runnable runnable2 = this.wrapIntoCheckinMetaHandlers(proceedRunnable);
        if (this.myIsAlien) {
            runnable2.run();
        } else {
            PartialChangesUtil.runUnderChangeList(this.myProject, this.myBrowser.getSelectedChangeList(), runnable2);
        }
        CheckinHandler.ReturnResult returnResult = (CheckinHandler.ReturnResult)ObjectUtils.notNull((Object)compoundResultRef.get(), (Object)CheckinHandler.ReturnResult.CANCEL);
        if (returnResult == null) {
            CommitChangeListDialog.$$$reportNull$$$0(46);
        }
        return returnResult;
    }

    @NotNull
    private CheckinHandler.ReturnResult runBeforeCheckinHandlers(@Nullable CommitExecutor executor) {
        for (CheckinHandler handler2 : this.myHandlers) {
            if (!handler2.acceptExecutor(executor)) continue;
            LOG.debug("CheckinHandler.beforeCheckin: " + handler2);
            CheckinHandler.ReturnResult result2 = handler2.beforeCheckin(executor, this.myCommitOptions.getAdditionalData());
            if (result2 == CheckinHandler.ReturnResult.COMMIT) continue;
            if (result2 == CheckinHandler.ReturnResult.CANCEL) {
                this.restartUpdate();
                CheckinHandler.ReturnResult returnResult = CheckinHandler.ReturnResult.CANCEL;
                if (returnResult == null) {
                    CommitChangeListDialog.$$$reportNull$$$0(47);
                }
                return returnResult;
            }
            if (result2 != CheckinHandler.ReturnResult.CLOSE_WINDOW) continue;
            LocalChangeList changeList = this.myBrowser.getSelectedChangeList();
            CommitHelper.moveToFailedList((ChangeList)changeList, this.getCommitMessage(), this.getIncludedChanges(), VcsBundle.message((String)"commit.dialog.rejected.commit.template", (Object[])new Object[]{changeList.getName()}), this.myProject);
            this.doCancelAction();
            CheckinHandler.ReturnResult returnResult = CheckinHandler.ReturnResult.CLOSE_WINDOW;
            if (returnResult == null) {
                CommitChangeListDialog.$$$reportNull$$$0(48);
            }
            return returnResult;
        }
        CheckinHandler.ReturnResult returnResult = CheckinHandler.ReturnResult.COMMIT;
        if (returnResult == null) {
            CommitChangeListDialog.$$$reportNull$$$0(49);
        }
        return returnResult;
    }

    private Runnable wrapIntoCheckinMetaHandlers(Runnable runnable2) {
        for (CheckinHandler handler2 : this.myHandlers) {
            if (!(handler2 instanceof CheckinMetaHandler)) continue;
            CheckinMetaHandler metaHandler = (CheckinMetaHandler)handler2;
            Runnable previousRunnable = runnable2;
            runnable2 = () -> {
                LOG.debug("CheckinMetaHandler.runCheckinHandlers: " + handler2);
                metaHandler.runCheckinHandlers(previousRunnable);
            };
        }
        return runnable2;
    }

    private boolean saveDialogState() {
        if (!this.checkComment()) {
            return false;
        }
        this.saveCommentIntoChangeList();
        this.myVcsConfiguration.saveCommitMessage(this.getCommitMessage());
        try {
            this.saveState();
            return true;
        }
        catch (InputException ex) {
            ex.show();
            return false;
        }
    }

    private void saveComments(boolean isOk) {
        if (isOk) {
            int selectedSize = this.getIncludedChanges().size();
            int totalSize = this.myBrowser.getSelectedChangeList().getChanges().size();
            if (totalSize > selectedSize) {
                this.myListComments.remove(this.myLastSelectedListName);
            }
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.myListComments.forEach((changeListName, comment) -> changeListManager.editComment(changeListName, comment));
    }

    private boolean checkCommitOptionsSupported(@NotNull CommitExecutor commitExecutor) {
        boolean hasPartialChanges;
        if (commitExecutor == null) {
            CommitChangeListDialog.$$$reportNull$$$0(50);
        }
        if (this.myIsAlien) {
            return true;
        }
        if (!commitExecutor.supportsPartialCommit() && (hasPartialChanges = ContainerUtil.exists(this.getIncludedChanges(), change -> {
            PartialLocalLineStatusTracker tracker = PartialChangesUtil.getPartialTracker(this.myProject, change);
            return tracker != null && tracker.hasPartialChangesToCommit();
        }))) {
            return 0 == Messages.showYesNoDialog((Project)this.myProject, (String)VcsBundle.message((String)"commit.dialog.partial.commit.warning.body", (Object[])new Object[]{CommitChangeListDialog.getExecutorPresentableText(commitExecutor)}), (String)VcsBundle.message((String)"commit.dialog.partial.commit.warning.title", (Object[])new Object[0]), (String)commitExecutor.getActionText(), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon());
        }
        return true;
    }

    public void doCancelAction() {
        this.myCommitOptions.saveChangeListComponentsState();
        this.saveCommentIntoChangeList();
        this.saveComments(false);
        LineStatusTrackerManager.getInstanceImpl(this.myProject).resetExcludedFromCommitMarkers();
        super.doCancelAction();
    }

    private void doCommit(@Nullable CommitResultHandler customResultHandler) {
        LOG.debug("CommitHelper: Do actual commit");
        CommitHelper helper = new CommitHelper(this.myProject, (ChangeList)this.myBrowser.getSelectedChangeList(), this.getIncludedChanges(), TITLE, this.getCommitMessage(), (List<? extends CheckinHandler>)this.myHandlers, this.myAllOfDefaultChangeListChangesIncluded, false, (NullableFunction<Object, Object>)this.myCommitOptions.getAdditionalData(), customResultHandler, this.myIsAlien, this.myForceCommitInVcs);
        helper.doCommit();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        Splitter splitter = this.myDetailsSplitter.getComponent();
        if (splitter == null) {
            CommitChangeListDialog.$$$reportNull$$$0(51);
        }
        return splitter;
    }

    @NotNull
    public Set<AbstractVcs> getAffectedVcses() {
        Set<Object> set = this.myShowVcsCommit ? this.myAffectedVcses : Collections.emptySet();
        if (set == null) {
            CommitChangeListDialog.$$$reportNull$$$0(52);
        }
        return set;
    }

    @NotNull
    public List<CommitExecutor> getExecutors() {
        List<CommitExecutor> list2 = this.myExecutors;
        if (list2 == null) {
            CommitChangeListDialog.$$$reportNull$$$0(53);
        }
        return list2;
    }

    @NotNull
    public Collection<VirtualFile> getRoots() {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        Set set = ContainerUtil.map2SetNotNull(this.getDisplayedPaths(), filePath -> vcsManager.getVcsRootFor(filePath));
        if (set == null) {
            CommitChangeListDialog.$$$reportNull$$$0(54);
        }
        return set;
    }

    @NotNull
    public JComponent getComponent() {
        Splitter splitter = this.mySplitter;
        if (splitter == null) {
            CommitChangeListDialog.$$$reportNull$$$0(55);
        }
        return splitter;
    }

    public boolean hasDiffs() {
        return !this.getIncludedChanges().isEmpty() || !this.myBrowser.getIncludedUnversionedFiles().isEmpty();
    }

    @NotNull
    public Collection<VirtualFile> getVirtualFiles() {
        List list2 = ContainerUtil.mapNotNull(this.getIncludedPaths(), filePath -> filePath.getVirtualFile());
        if (list2 == null) {
            CommitChangeListDialog.$$$reportNull$$$0(56);
        }
        return list2;
    }

    @NotNull
    public Collection<Change> getSelectedChanges() {
        ArrayList arrayList = ContainerUtil.newArrayList(this.getIncludedChanges());
        if (arrayList == null) {
            CommitChangeListDialog.$$$reportNull$$$0(57);
        }
        return arrayList;
    }

    @NotNull
    public Collection<File> getFiles() {
        List list2 = ContainerUtil.map(this.getIncludedPaths(), filePath -> filePath.getIOFile());
        if (list2 == null) {
            CommitChangeListDialog.$$$reportNull$$$0(58);
        }
        return list2;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            CommitChangeListDialog.$$$reportNull$$$0(59);
        }
        return project;
    }

    public boolean vcsIsAffected(String name) {
        return ProjectLevelVcsManager.getInstance((Project)this.myProject).checkVcsIsActive(name) && ContainerUtil.exists(this.myAffectedVcses, vcs -> Comparing.equal((String)vcs.getName(), (String)name));
    }

    public void setCommitMessage(@Nullable String commitMessage2) {
        this.myLastKnownComment = commitMessage2;
        this.myCommitMessageArea.setText(commitMessage2);
        this.myCommitMessageArea.requestFocusInMessage();
    }

    @NotNull
    public String getCommitMessage() {
        String string = this.myCommitMessageArea.getComment();
        if (string == null) {
            CommitChangeListDialog.$$$reportNull$$$0(60);
        }
        return string;
    }

    public void refresh() {
        ChangeListManager.getInstance((Project)this.myProject).invokeAfterUpdate(() -> {
            this.myBrowser.updateDisplayedChangeLists();
            this.myCommitOptions.refresh();
        }, InvokeAfterUpdateMode.SILENT, "commit dialog", ModalityState.current());
    }

    public void saveState() {
        this.myCommitOptions.saveState();
    }

    public void restoreState() {
        this.myCommitOptions.restoreState();
    }

    @NotNull
    public List<RefreshableOnComponent> getAdditionalComponents() {
        List<RefreshableOnComponent> list2 = this.myCommitOptions.getAdditionalComponents();
        if (list2 == null) {
            CommitChangeListDialog.$$$reportNull$$$0(61);
        }
        return list2;
    }

    private void updateButtons() {
        if (this.myDisposed || this.myUpdateDisabled) {
            return;
        }
        boolean enabled = this.hasDiffs();
        if (this.myCommitAction != null) {
            this.myCommitAction.setEnabled(enabled);
        }
        this.myExecutorActions.forEach(action -> action.updateEnabled(enabled));
        this.myOKButtonUpdateAlarm.cancelAllRequests();
        this.myOKButtonUpdateAlarm.addRequest(this.myUpdateButtonsRunnable, 300, ModalityState.stateForComponent((Component)this.myBrowser));
    }

    private void updateLegend() {
        if (this.myDisposed || this.myUpdateDisabled) {
            return;
        }
        this.myChangesInfoCalculator.update(this.myBrowser.getDisplayedChanges(), this.getIncludedChanges(), this.myBrowser.getDisplayedUnversionedFiles().size(), this.myBrowser.getIncludedUnversionedFiles().size());
        this.myLegend.update();
    }

    @NotNull
    private List<Change> getIncludedChanges() {
        List<Change> list2 = this.myBrowser.getIncludedChanges();
        if (list2 == null) {
            CommitChangeListDialog.$$$reportNull$$$0(62);
        }
        return list2;
    }

    @NotNull
    private List<FilePath> getIncludedPaths() {
        ArrayList<FilePath> paths = new ArrayList<FilePath>();
        for (Change change : this.myBrowser.getIncludedChanges()) {
            paths.add(ChangesUtil.getFilePath((Change)change));
        }
        for (VirtualFile file2 : this.myBrowser.getIncludedUnversionedFiles()) {
            paths.add(VcsUtil.getFilePath((VirtualFile)file2));
        }
        ArrayList<FilePath> arrayList = paths;
        if (arrayList == null) {
            CommitChangeListDialog.$$$reportNull$$$0(63);
        }
        return arrayList;
    }

    @NotNull
    private List<FilePath> getDisplayedPaths() {
        ArrayList<FilePath> paths = new ArrayList<FilePath>();
        for (Change change : this.myBrowser.getDisplayedChanges()) {
            paths.add(ChangesUtil.getFilePath((Change)change));
        }
        for (VirtualFile file2 : this.myBrowser.getDisplayedUnversionedFiles()) {
            paths.add(VcsUtil.getFilePath((VirtualFile)file2));
        }
        ArrayList<FilePath> arrayList = paths;
        if (arrayList == null) {
            CommitChangeListDialog.$$$reportNull$$$0(64);
        }
        return arrayList;
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "CommitChangelistDialog2";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCommitMessageArea.getEditorField();
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            CommitChangeListDialog.$$$reportNull$$$0(65);
        }
        if (Refreshable.PANEL_KEY.is(dataId)) {
            return this;
        }
        return this.myBrowser.getData(dataId);
    }

    @NotNull
    static String getExecutorPresentableText(@NotNull CommitExecutor executor) {
        if (executor == null) {
            CommitChangeListDialog.$$$reportNull$$$0(66);
        }
        String string = CommitChangeListDialog.trimEllipsis(UIUtil.removeMnemonic((String)executor.getActionText()));
        if (string == null) {
            CommitChangeListDialog.$$$reportNull$$$0(67);
        }
        return string;
    }

    @NotNull
    static String trimEllipsis(@NotNull String title) {
        if (title == null) {
            CommitChangeListDialog.$$$reportNull$$$0(68);
        }
        String string = StringUtil.trimEnd((String)StringUtil.trimEnd((String)title, (String)"..."), (String)"\u2026");
        if (string == null) {
            CommitChangeListDialog.$$$reportNull$$$0(69);
        }
        return string;
    }

    private void ensureDataIsActual(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            CommitChangeListDialog.$$$reportNull$$$0(70);
        }
        ChangeListManager.getInstance((Project)this.myProject).invokeAfterUpdate(() -> {
            this.myBrowser.updateDisplayedChangeLists();
            runnable2.run();
        }, InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, "Refreshing changelists...", ModalityState.current());
    }

    private void changeDetails(boolean fromModelRefresh) {
        if (this.myDetailsSplitter.isOn()) {
            this.myDiffDetails.refresh(fromModelRefresh);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 19: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 67: 
            case 69: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 19: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 67: 
            case 69: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 18: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 4: 
            case 13: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "included";
                break;
            }
            case 7: 
            case 10: 
            case 14: 
            case 27: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executors";
                break;
            }
            case 16: 
            case 19: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 67: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changelistName";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultChangeList";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeLists";
                break;
            }
            case 30: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedVcses";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkinPanel";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
            case 40: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitExecutor";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCheckInFactories";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExecutors";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckinHandlers";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutorActions";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 42: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitActionName";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "performBeforeCommitChecks";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "runBeforeCheckinHandlers";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedVcses";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutors";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFiles";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChanges";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitMessage";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalComponents";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedChanges";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedPaths";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayedPaths";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutorPresentableText";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "trimEllipsis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "commitChanges";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCheckInFactories";
                break;
            }
            case 16: 
            case 19: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 67: 
            case 69: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectExecutors";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "commitAlienChanges";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createCheckinHandlers";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createExecutorActions";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getHelpId";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getCommentFromChangelist";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getCommitActionName";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "checkCommitOptionsSupported";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getExecutorPresentableText";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "trimEllipsis";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "ensureDataIsActual";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 19: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 67: 
            case 69: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyOptionsLayout
    extends AbstractLayoutManager {
        @NotNull
        private final JComponent myPanel;
        @NotNull
        private final JComponent myOptions;
        private final int myMinOptionsWidth;
        private final int myMaxOptionsWidth;

        MyOptionsLayout(@NotNull JComponent panel2, @NotNull JComponent options, int minOptionsWidth, int maxOptionsWidth) {
            if (panel2 == null) {
                MyOptionsLayout.$$$reportNull$$$0(0);
            }
            if (options == null) {
                MyOptionsLayout.$$$reportNull$$$0(1);
            }
            this.myPanel = panel2;
            this.myOptions = options;
            this.myMinOptionsWidth = minOptionsWidth;
            this.myMaxOptionsWidth = maxOptionsWidth;
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension size1 = this.myPanel.getPreferredSize();
            Dimension size2 = this.myOptions.getPreferredSize();
            return new Dimension(size1.width + size2.width, Math.max(size1.height, size2.height));
        }

        public void layoutContainer(@NotNull Container parent) {
            if (parent == null) {
                MyOptionsLayout.$$$reportNull$$$0(2);
            }
            Rectangle bounds2 = parent.getBounds();
            int preferredWidth = this.myOptions.getPreferredSize().width;
            int optionsWidth = Math.max(Math.min(this.myMaxOptionsWidth, preferredWidth), this.myMinOptionsWidth);
            this.myPanel.setBounds(new Rectangle(0, 0, bounds2.width - optionsWidth, bounds2.height));
            this.myOptions.setBounds(new Rectangle(bounds2.width - optionsWidth, 0, optionsWidth, bounds2.height));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "panel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$MyOptionsLayout";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "layoutContainer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyChangeProcessor
    extends ChangeViewDiffRequestProcessor {
        MyChangeProcessor(Project project, boolean enablePartialCommit) {
            if (project == null) {
                MyChangeProcessor.$$$reportNull$$$0(0);
            }
            super(project, "CommitDialog");
            this.putContextUserData(DiffUserDataKeysEx.SHOW_READ_ONLY_LOCK, true);
            this.putContextUserData(LocalChangeListDiffTool.ALLOW_EXCLUDE_FROM_COMMIT, enablePartialCommit);
        }

        @Override
        @NotNull
        protected List<ChangeViewDiffRequestProcessor.Wrapper> getSelectedChanges() {
            List<ChangeViewDiffRequestProcessor.Wrapper> list2 = this.wrap(CommitChangeListDialog.this.myBrowser.getSelectedChanges(), CommitChangeListDialog.this.myBrowser.getSelectedUnversionedFiles());
            if (list2 == null) {
                MyChangeProcessor.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @Override
        @NotNull
        protected List<ChangeViewDiffRequestProcessor.Wrapper> getAllChanges() {
            List<ChangeViewDiffRequestProcessor.Wrapper> list2 = this.wrap(CommitChangeListDialog.this.myBrowser.getDisplayedChanges(), CommitChangeListDialog.this.myBrowser.getDisplayedUnversionedFiles());
            if (list2 == null) {
                MyChangeProcessor.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @Override
        protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
            if (change == null) {
                MyChangeProcessor.$$$reportNull$$$0(3);
            }
            CommitChangeListDialog.this.myBrowser.selectEntries(Collections.singletonList(change.getUserObject()));
        }

        @NotNull
        private List<ChangeViewDiffRequestProcessor.Wrapper> wrap(@NotNull Collection<Change> changes2, @NotNull Collection<VirtualFile> unversioned) {
            if (changes2 == null) {
                MyChangeProcessor.$$$reportNull$$$0(4);
            }
            if (unversioned == null) {
                MyChangeProcessor.$$$reportNull$$$0(5);
            }
            List list2 = ContainerUtil.concat((List)ContainerUtil.map(changes2, ChangeViewDiffRequestProcessor.ChangeWrapper::new), (List)ContainerUtil.map(unversioned, ChangeViewDiffRequestProcessor.UnversionedFileWrapper::new));
            if (list2 == null) {
                MyChangeProcessor.$$$reportNull$$$0(6);
            }
            return list2;
        }

        @Override
        protected void onAfterNavigate() {
            CommitChangeListDialog.this.doCancelAction();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$MyChangeProcessor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "change";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changes";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unversioned";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$MyChangeProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSelectedChanges";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllChanges";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "wrap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "selectChange";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "wrap";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DiffCommitMessageEditor
    extends CommitMessage
    implements Disposable {
        DiffCommitMessageEditor(@NotNull Project project, @NotNull CommitMessage commitMessage2) {
            if (project == null) {
                DiffCommitMessageEditor.$$$reportNull$$$0(0);
            }
            if (commitMessage2 == null) {
                DiffCommitMessageEditor.$$$reportNull$$$0(1);
            }
            super(project);
            this.getEditorField().setDocument(commitMessage2.getEditorField().getDocument());
        }

        @Override
        public Dimension getPreferredSize() {
            return new JBDimension(400, 120);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "commitMessage";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$DiffCommitMessageEditor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CommitExecutorAction
    extends AbstractAction {
        @Nullable
        private final CommitExecutor myCommitExecutor;

        CommitExecutorAction(AnAction anAction) {
            if (anAction == null) {
                CommitExecutorAction.$$$reportNull$$$0(0);
            }
            this.putValue("AnAction", anAction);
            this.myCommitExecutor = null;
        }

        CommitExecutorAction(CommitExecutor commitExecutor) {
            if (commitExecutor == null) {
                CommitExecutorAction.$$$reportNull$$$0(1);
            }
            super(commitExecutor.getActionText());
            this.myCommitExecutor = commitExecutor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.myCommitExecutor != null) {
                CommitChangeListDialog.this.execute(this.myCommitExecutor);
            }
        }

        public void updateEnabled(boolean hasDiffs) {
            if (this.myCommitExecutor != null) {
                this.setEnabled(hasDiffs || this.myCommitExecutor instanceof CommitExecutorBase && !((CommitExecutorBase)this.myCommitExecutor).areChangesRequired());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "anAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "commitExecutor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$CommitExecutorAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class DefaultListCleaner {
        private final boolean myToClean;

        private DefaultListCleaner() {
            int selectedSize = CommitChangeListDialog.this.getIncludedChanges().size();
            LocalChangeList selectedList = CommitChangeListDialog.this.myBrowser.getSelectedChangeList();
            int totalSize = selectedList.getChanges().size();
            this.myToClean = totalSize == selectedSize && selectedList.hasDefaultName();
        }

        void clean() {
            if (this.myToClean) {
                ChangeListManager.getInstance((Project)CommitChangeListDialog.this.myProject).editComment(LocalChangeList.DEFAULT_NAME, "");
            }
        }
    }

    private class CommitAction
    extends AbstractAction
    implements OptionAction {
        @NotNull
        private Action[] myOptions;

        private CommitAction(String okActionText) {
            super(okActionText);
            this.myOptions = new Action[0];
            this.putValue("DefaultAction", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommitChangeListDialog.this.executeDefaultCommitSession(null);
        }

        @NotNull
        public Action[] getOptions() {
            if (this.myOptions == null) {
                CommitAction.$$$reportNull$$$0(0);
            }
            return this.myOptions;
        }

        public void setOptions(@NotNull List<? extends Action> actions) {
            if (actions == null) {
                CommitAction.$$$reportNull$$$0(1);
            }
            this.myOptions = (Action[])ArrayUtil.toObjectArray(actions, Action.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$CommitAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/CommitChangeListDialog$CommitAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setOptions";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

