/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.tokens;

import com.intellij.ide.highlighter.custom.tokens.TokenInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.CharTrie;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class KeywordParser {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.highlighter.custom.tokens.KeywordParser");
    private final List<Set<String>> myKeywordSets = new ArrayList<Set<String>>();
    private final CharTrie myTrie = new CharTrie();
    private final TIntHashSet myHashCodes = new TIntHashSet();
    private final boolean myIgnoreCase;

    public KeywordParser(List<Set<String>> keywordSets, boolean ignoreCase) {
        this.myIgnoreCase = ignoreCase;
        LOG.assertTrue(keywordSets.size() == 4);
        for (Set<String> keywordSet : keywordSets) {
            Set<String> normalized = this.normalizeKeywordSet(keywordSet);
            this.myKeywordSets.add(normalized);
            for (String s : normalized) {
                this.myHashCodes.add(this.myTrie.getHashCode((CharSequence)s));
            }
        }
    }

    private Set<String> normalizeKeywordSet(Set<String> keywordSet) {
        if (!this.myIgnoreCase) {
            return new THashSet(keywordSet);
        }
        THashSet result2 = new THashSet();
        for (String s : keywordSet) {
            result2.add(StringUtil.toUpperCase((String)s));
        }
        return result2;
    }

    public boolean hasToken(int position, CharSequence myBuffer, @Nullable TokenInfo tokenInfo) {
        int index = 0;
        int offset = position;
        String longestKeyword = null;
        IElementType longestKeywordType = null;
        block0: while (offset < myBuffer.length()) {
            char c = myBuffer.charAt(offset++);
            int nextIndex = this.myTrie.findSubNode(index, this.myIgnoreCase ? Character.toUpperCase(c) : c);
            if (nextIndex == 0) break;
            index = nextIndex;
            if (!this.myHashCodes.contains(index) || !KeywordParser.isWordEnd(offset, myBuffer)) continue;
            String keyword = myBuffer.subSequence(position, offset).toString();
            String testKeyword = this.myIgnoreCase ? StringUtil.toUpperCase((String)keyword) : keyword;
            for (int i = 0; i < 4; ++i) {
                if (!this.myKeywordSets.get(i).contains(testKeyword)) continue;
                longestKeyword = testKeyword;
                longestKeywordType = KeywordParser.getToken(i);
                continue block0;
            }
        }
        if (longestKeyword != null && tokenInfo != null) {
            tokenInfo.updateData(position, position + longestKeyword.length(), longestKeywordType);
        }
        return longestKeyword != null;
    }

    private static boolean isWordEnd(int offset, CharSequence sequence) {
        if (offset == sequence.length()) {
            return true;
        }
        return !Character.isJavaIdentifierPart(sequence.charAt(offset - 1)) || !Character.isJavaIdentifierPart(sequence.charAt(offset));
    }

    private static IElementType getToken(int keywordSetIndex) {
        switch (keywordSetIndex) {
            case 0: {
                return CustomHighlighterTokenType.KEYWORD_1;
            }
            case 1: {
                return CustomHighlighterTokenType.KEYWORD_2;
            }
            case 2: {
                return CustomHighlighterTokenType.KEYWORD_3;
            }
            case 3: {
                return CustomHighlighterTokenType.KEYWORD_4;
            }
        }
        throw new AssertionError(keywordSetIndex);
    }
}

