/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.ui.RepositoryComboboxListCellRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.DialogManager;
import git4idea.GitCommit;
import git4idea.repo.GitRepository;
import git4idea.ui.GitCommitListWithDiffPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class GitBranchIsNotFullyMergedDialog
extends DialogWrapper {
    @NotNull
    private final Map<GitRepository, List<GitCommit>> myCommits;
    @NotNull
    private final GitCommitListWithDiffPanel myCommitListWithDiffPanel;
    @NotNull
    private final Collection<GitRepository> myRepositories;
    @NotNull
    private final String myRemovedBranch;
    @NotNull
    private final Map<GitRepository, String> myBaseBranches;
    @NotNull
    private final GitRepository myInitialRepository;

    public static boolean showAndGetAnswer(@NotNull Project project, @NotNull Map<GitRepository, List<GitCommit>> commits2, @NotNull Map<GitRepository, String> baseBranches, @NotNull String removedBranch) {
        if (project == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(0);
        }
        if (commits2 == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(1);
        }
        if (baseBranches == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(2);
        }
        if (removedBranch == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(3);
        }
        GitBranchIsNotFullyMergedDialog dialog = new GitBranchIsNotFullyMergedDialog(project, commits2, baseBranches, removedBranch);
        DialogManager.show(dialog);
        return dialog.isOK();
    }

    private GitBranchIsNotFullyMergedDialog(@NotNull Project project, @NotNull Map<GitRepository, List<GitCommit>> commits2, @NotNull Map<GitRepository, String> baseBranches, @NotNull String removedBranch) {
        if (project == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(4);
        }
        if (commits2 == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(5);
        }
        if (baseBranches == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(6);
        }
        if (removedBranch == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(7);
        }
        super(project, false);
        this.myCommits = commits2;
        this.myRepositories = commits2.keySet();
        this.myBaseBranches = baseBranches;
        this.myRemovedBranch = removedBranch;
        this.myInitialRepository = this.calcInitiallySelectedRepository();
        this.myCommitListWithDiffPanel = new GitCommitListWithDiffPanel(project, new ArrayList<GitCommit>((Collection)this.myCommits.get(this.myInitialRepository)));
        this.init();
        this.setTitle("Branch Was Not Fully Merged");
        this.setOKButtonText("Restore");
        this.setOKButtonMnemonic(82);
        this.getCancelAction().putValue("DefaultAction", Boolean.TRUE);
    }

    @NotNull
    private GitRepository calcInitiallySelectedRepository() {
        for (GitRepository repository : this.myRepositories) {
            if (this.myCommits.get(repository).isEmpty()) continue;
            GitRepository gitRepository = repository;
            if (gitRepository == null) {
                GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(8);
            }
            return gitRepository;
        }
        throw new AssertionError((Object)("The dialog shouldn't be shown. Unmerged commits: " + this.myCommits));
    }

    @NotNull
    private String makeDescription(@NotNull GitRepository repository) {
        String baseBranch;
        if (repository == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(9);
        }
        String description = (baseBranch = this.myBaseBranches.get(repository)) == null ? String.format("All commits from branch %s were merged", this.myRemovedBranch) : String.format("The branch %s was not fully merged to %s.<br/>Below is the list of unmerged commits.", this.myRemovedBranch, baseBranch);
        String string = XmlStringUtil.wrapInHtml((CharSequence)description);
        if (string == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(10);
        }
        return string;
    }

    protected JComponent createNorthPanel() {
        final JBLabel descriptionLabel = new JBLabel(this.makeDescription(this.myInitialRepository));
        final JComboBox<Object> repositorySelector = new JComboBox<Object>(ArrayUtil.toObjectArray(this.myRepositories, GitRepository.class));
        repositorySelector.setRenderer((ListCellRenderer<Object>)new RepositoryComboboxListCellRenderer());
        repositorySelector.setSelectedItem(this.myInitialRepository);
        repositorySelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GitRepository selectedRepo = (GitRepository)repositorySelector.getSelectedItem();
                descriptionLabel.setText(GitBranchIsNotFullyMergedDialog.this.makeDescription(selectedRepo));
                GitBranchIsNotFullyMergedDialog.this.myCommitListWithDiffPanel.setCommits((List)GitBranchIsNotFullyMergedDialog.this.myCommits.get(selectedRepo));
            }
        });
        JPanel repoSelectorPanel = new JPanel(new BorderLayout());
        JBLabel label = new JBLabel("Repository: ");
        label.setLabelFor((Component)repoSelectorPanel);
        repoSelectorPanel.add((Component)label, "West");
        repoSelectorPanel.add(repositorySelector);
        if (this.myRepositories.size() < 2) {
            repoSelectorPanel.setVisible(false);
        }
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)descriptionLabel);
        northPanel.add((Component)repoSelectorPanel, "South");
        return northPanel;
    }

    protected JComponent createCenterPanel() {
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.add(this.myCommitListWithDiffPanel);
        return rootPanel;
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        Action[] actionArray = new Action[]{this.getOKAction()};
        if (actionArray == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(11);
        }
        return actionArray;
    }

    @NotNull
    protected Action[] createActions() {
        Action cancelAction = this.getCancelAction();
        cancelAction.putValue("DefaultAction", Boolean.TRUE);
        Action[] actionArray = new Action[]{cancelAction};
        if (actionArray == null) {
            GitBranchIsNotFullyMergedDialog.$$$reportNull$$$0(12);
        }
        return actionArray;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCommitListWithDiffPanel.getPreferredFocusComponent();
    }

    protected String getDimensionServiceKey() {
        return GitBranchIsNotFullyMergedDialog.class.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseBranches";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedBranch";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitBranchIsNotFullyMergedDialog";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitBranchIsNotFullyMergedDialog";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInitiallySelectedRepository";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "makeDescription";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createLeftSideActions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showAndGetAnswer";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "makeDescription";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

