/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jruby.util.ByteList;
import org.jvyamlb.Position;
import org.jvyamlb.PositioningScannerImpl;
import org.jvyamlb.YAMLTestCase;
import org.jvyamlb.exceptions.PositionedScannerException;
import org.jvyamlb.exceptions.ScannerException;
import org.jvyamlb.tokens.PositionedAliasToken;
import org.jvyamlb.tokens.PositionedAnchorToken;
import org.jvyamlb.tokens.PositionedBlockEndToken;
import org.jvyamlb.tokens.PositionedBlockEntryToken;
import org.jvyamlb.tokens.PositionedBlockMappingStartToken;
import org.jvyamlb.tokens.PositionedBlockSequenceStartToken;
import org.jvyamlb.tokens.PositionedDirectiveToken;
import org.jvyamlb.tokens.PositionedDocumentStartToken;
import org.jvyamlb.tokens.PositionedFlowEntryToken;
import org.jvyamlb.tokens.PositionedFlowMappingEndToken;
import org.jvyamlb.tokens.PositionedFlowMappingStartToken;
import org.jvyamlb.tokens.PositionedFlowSequenceEndToken;
import org.jvyamlb.tokens.PositionedFlowSequenceStartToken;
import org.jvyamlb.tokens.PositionedKeyToken;
import org.jvyamlb.tokens.PositionedScalarToken;
import org.jvyamlb.tokens.PositionedStreamEndToken;
import org.jvyamlb.tokens.PositionedStreamStartToken;
import org.jvyamlb.tokens.PositionedTagToken;
import org.jvyamlb.tokens.PositionedValueToken;
import org.jvyamlb.tokens.Token;

public class PositioningScannerImplTest
extends YAMLTestCase {
    public PositioningScannerImplTest(String name) {
        super(name);
    }

    protected List getScan(String input) {
        PositioningScannerImpl s = new PositioningScannerImpl(input);
        ArrayList output = new ArrayList();
        Iterator iter = s.iterator();
        while (iter.hasNext()) {
            output.add(iter.next());
        }
        return output;
    }

    public void testThatEmptyScannerGeneratesPositionedEnvelope() {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(0, 0, 0))));
        List tokens = this.getScan("");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testThatSimpleScalarGeneratesCorrectPositioning() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarToken(this.s("a"), true, '\u0000', new Position.Range(new Position(0, 0, 0), new Position(0, 1, 1))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(0, 1, 1))));
        List tokens = this.getScan("a");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testThatSimpleScalarWithSpaceGeneratesCorrectPositioning() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarToken(this.s("a"), true, '\u0000', new Position.Range(new Position(0, 0, 0), new Position(0, 1, 1))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(0, 2, 2))));
        List tokens = this.getScan("a ");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testThatSimpleScalarWithNewlineGeneratesCorrectPositioning() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarToken(this.s("a"), true, '\u0000', new Position.Range(new Position(0, 0, 0), new Position(0, 1, 1))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(1, 0, 2))));
        List tokens = this.getScan("a\n");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testThatComplicatedeScalarGeneratesCorrectPositioning() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDocumentStartToken(new Position.Range(new Position(0, 0, 0), new Position(0, 3, 3))));
        expected.add(new PositionedScalarToken(this.s("abcdefafgsdfgsdfg sfgdfsg fdsgfgsdf"), false, '\"', new Position.Range(new Position(0, 4, 4), new Position(2, 10, 41))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(2, 10, 41))));
        List tokens = this.getScan("--- \"abcdefafgsdfgsdfg\nsfgdfsg\nfdsgfgsdf\"");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testThatAKeyValuePairGetsCorrectPositioning() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedBlockMappingStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedKeyToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarToken(this.s("a"), true, '\u0000', new Position.Range(new Position(0, 0, 0), new Position(0, 1, 1))));
        expected.add(new PositionedValueToken(new Position.Range(new Position(0, 2, 2))));
        expected.add(new PositionedScalarToken(this.s("b"), true, '\u0000', new Position.Range(new Position(0, 3, 3), new Position(0, 4, 4))));
        expected.add(new PositionedBlockEndToken(new Position.Range(new Position(0, 4, 4))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(0, 4, 4))));
        List tokens = this.getScan("a: b");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testThatTwoKeyValuePairsGetsCorrectPositioning() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedBlockMappingStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedKeyToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarToken(this.s("a"), true, '\u0000', new Position.Range(new Position(0, 0, 0), new Position(0, 1, 1))));
        expected.add(new PositionedValueToken(new Position.Range(new Position(0, 2, 2))));
        expected.add(new PositionedScalarToken(this.s("b"), true, '\u0000', new Position.Range(new Position(0, 3, 3), new Position(0, 4, 4))));
        expected.add(new PositionedKeyToken(new Position.Range(new Position(1, 0, 5))));
        expected.add(new PositionedScalarToken(this.s("c"), true, '\u0000', new Position.Range(new Position(1, 0, 5), new Position(1, 1, 6))));
        expected.add(new PositionedValueToken(new Position.Range(new Position(1, 2, 7))));
        expected.add(new PositionedScalarToken(this.s("d"), true, '\u0000', new Position.Range(new Position(1, 4, 9), new Position(1, 5, 10))));
        expected.add(new PositionedBlockEndToken(new Position.Range(new Position(1, 5, 10))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(1, 5, 10))));
        List tokens = this.getScan("a: b\nc:  d");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testThatAOneItemSequenceWorks() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedBlockSequenceStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedBlockEntryToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarToken(this.s("a"), true, '\u0000', new Position.Range(new Position(0, 2, 2), new Position(0, 3, 3))));
        expected.add(new PositionedBlockEndToken(new Position.Range(new Position(0, 3, 3))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(0, 3, 3))));
        List tokens = this.getScan("- a");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testThatMoreThanOneItemSequenceWorks() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedBlockSequenceStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedBlockEntryToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarToken(this.s("a"), true, '\u0000', new Position.Range(new Position(0, 2, 2), new Position(0, 3, 3))));
        expected.add(new PositionedBlockEntryToken(new Position.Range(new Position(1, 0, 4))));
        expected.add(new PositionedScalarToken(this.s("b"), true, '\u0000', new Position.Range(new Position(1, 4, 8), new Position(1, 5, 9))));
        expected.add(new PositionedBlockEntryToken(new Position.Range(new Position(2, 0, 10))));
        expected.add(new PositionedScalarToken(this.s("c"), true, '\u0000', new Position.Range(new Position(2, 2, 12), new Position(2, 3, 13))));
        expected.add(new PositionedBlockEndToken(new Position.Range(new Position(2, 3, 13))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(2, 3, 13))));
        List tokens = this.getScan("- a\n-   b\n- c");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testThatListedSequenesWorks() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedBlockSequenceStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedBlockEntryToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarToken(this.s("a"), true, '\u0000', new Position.Range(new Position(0, 2, 2), new Position(0, 3, 3))));
        expected.add(new PositionedBlockEntryToken(new Position.Range(new Position(1, 0, 4))));
        expected.add(new PositionedBlockSequenceStartToken(new Position.Range(new Position(1, 2, 6))));
        expected.add(new PositionedBlockEntryToken(new Position.Range(new Position(1, 2, 6))));
        expected.add(new PositionedScalarToken(this.s("foo"), true, '\u0000', new Position.Range(new Position(1, 4, 8), new Position(1, 7, 11))));
        expected.add(new PositionedBlockEntryToken(new Position.Range(new Position(2, 2, 14))));
        expected.add(new PositionedScalarToken(this.s("bar"), true, '\u0000', new Position.Range(new Position(2, 4, 16), new Position(2, 7, 19))));
        expected.add(new PositionedBlockEndToken(new Position.Range(new Position(3, 0, 20))));
        expected.add(new PositionedBlockEntryToken(new Position.Range(new Position(3, 0, 20))));
        expected.add(new PositionedScalarToken(this.s("b"), true, '\u0000', new Position.Range(new Position(3, 2, 22), new Position(3, 3, 23))));
        expected.add(new PositionedBlockEndToken(new Position.Range(new Position(3, 3, 23))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(3, 3, 23))));
        List tokens = this.getScan("- a\n- - foo\n  - bar\n- b");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testThatSimpleFlowMappingWorks() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedFlowMappingStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedKeyToken(new Position.Range(new Position(0, 1, 1))));
        expected.add(new PositionedScalarToken(this.s("a"), true, '\u0000', new Position.Range(new Position(0, 1, 1), new Position(0, 2, 2))));
        expected.add(new PositionedValueToken(new Position.Range(new Position(0, 3, 3))));
        expected.add(new PositionedScalarToken(this.s("b"), true, '\u0000', new Position.Range(new Position(0, 4, 4), new Position(0, 5, 5))));
        expected.add(new PositionedFlowMappingEndToken(new Position.Range(new Position(0, 5, 5))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(0, 6, 6))));
        List tokens = this.getScan("{a: b}");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testThatSimpleFlowSequenceWorks() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedFlowSequenceStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarToken(this.s("a"), true, '\u0000', new Position.Range(new Position(0, 1, 1), new Position(0, 2, 2))));
        expected.add(new PositionedFlowSequenceEndToken(new Position.Range(new Position(0, 2, 2))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(0, 3, 3))));
        List tokens = this.getScan("[a]");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testThatFlowSequenceWithMoreThanOneElementWorks() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedFlowSequenceStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarToken(this.s("a"), true, '\u0000', new Position.Range(new Position(0, 1, 1), new Position(0, 2, 2))));
        expected.add(new PositionedFlowEntryToken(new Position.Range(new Position(0, 3, 3))));
        expected.add(new PositionedScalarToken(this.s("b"), true, '\u0000', new Position.Range(new Position(0, 4, 4), new Position(0, 5, 5))));
        expected.add(new PositionedFlowSequenceEndToken(new Position.Range(new Position(0, 6, 6))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(0, 7, 7))));
        List tokens = this.getScan("[a, b ]");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testScalarWithTag() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedTagToken(new ByteList[]{this.s("!"), this.s("str")}, new Position.Range(new Position(0, 0, 0), new Position(0, 4, 4))));
        expected.add(new PositionedScalarToken(this.s("a"), true, '\u0000', new Position.Range(new Position(0, 5, 5), new Position(0, 6, 6))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(0, 6, 6))));
        List tokens = this.getScan("!str a");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testScalarWithAlias() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedAliasToken("foobar", new Position.Range(new Position(0, 0, 0), new Position(0, 7, 7))));
        expected.add(new PositionedScalarToken(this.s("a"), true, '\u0000', new Position.Range(new Position(0, 8, 8), new Position(0, 9, 9))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(0, 9, 9))));
        List tokens = this.getScan("*foobar a");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testAnchor() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedAnchorToken("foobar", new Position.Range(new Position(0, 0, 0), new Position(0, 7, 7))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(0, 7, 7))));
        List tokens = this.getScan("&foobar");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testDirective() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDirectiveToken("YAML", new String[]{"1", "0"}, new Position.Range(new Position(0, 0, 0), new Position(0, 9, 9))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(0, 9, 9))));
        List tokens = this.getScan("%YAML 1.0");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testDoubleDirective() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDirectiveToken("YAML", new String[]{"1", "0"}, new Position.Range(new Position(0, 0, 0), new Position(0, 9, 9))));
        expected.add(new PositionedDirectiveToken("TAG", new String[]{"!", "abc"}, new Position.Range(new Position(1, 0, 10), new Position(1, 10, 20))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(2, 0, 21))));
        List tokens = this.getScan("%YAML 1.0\n%TAG ! abc\n");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testDoubleDirectiveWithoutNewlineEnd() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedDirectiveToken("YAML", new String[]{"1", "0"}, new Position.Range(new Position(0, 0, 0), new Position(0, 9, 9))));
        expected.add(new PositionedDirectiveToken("TAG", new String[]{"!", "abc"}, new Position.Range(new Position(1, 0, 10), new Position(1, 10, 20))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(1, 10, 20))));
        List tokens = this.getScan("%YAML 1.0\n%TAG ! abc");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testLiteralScalar() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarToken(this.s("abc\nfoobar"), false, '|', new Position.Range(new Position(0, 0, 0), new Position(2, 7, 14))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(2, 7, 14))));
        List tokens = this.getScan("|\n abc\n foobar");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testFoldedScalar() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarToken(this.s("abc foobar"), false, '>', new Position.Range(new Position(0, 0, 0), new Position(2, 7, 14))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(2, 7, 14))));
        List tokens = this.getScan(">\n abc\n foobar");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testSingleQuotedScalar() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarToken(this.s("abc"), false, '\'', new Position.Range(new Position(0, 0, 0), new Position(0, 5, 5))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(0, 5, 5))));
        List tokens = this.getScan("'abc'");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testScannerExceptionIncludesPositioningInformation() throws Exception {
        try {
            this.getScan("!<abc");
            PositioningScannerImplTest.assertTrue((String)"scanning should throw an exception", (boolean)false);
        }
        catch (ScannerException e) {
            PositioningScannerImplTest.assertTrue((String)"Exception should be instance of PositioningScannerException", (boolean)(e instanceof PositionedScannerException));
            PositioningScannerImplTest.assertEquals((String)"Position should be correct for exception", (Object)new Position.Range(new Position(0, 5, 5)), (Object)((PositionedScannerException)e).getRange());
        }
    }

    public void testSimpleObjectWithCommentBefore() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarToken(this.s("abc"), true, '\u0000', new Position.Range(new Position(1, 0, 9), new Position(1, 3, 12))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(1, 3, 12))));
        List tokens = this.getScan("#comment\nabc");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testCommentBeforeFirstKey() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedBlockMappingStartToken(new Position.Range(new Position(1, 0, 5))));
        expected.add(new PositionedKeyToken(new Position.Range(new Position(1, 0, 5))));
        expected.add(new PositionedScalarToken(this.s("a"), true, '\u0000', new Position.Range(new Position(1, 0, 5), new Position(1, 1, 6))));
        expected.add(new PositionedValueToken(new Position.Range(new Position(1, 2, 7))));
        expected.add(new PositionedScalarToken(this.s("b"), true, '\u0000', new Position.Range(new Position(1, 3, 8), new Position(1, 4, 9))));
        expected.add(new PositionedBlockEndToken(new Position.Range(new Position(1, 4, 9))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(1, 4, 9))));
        List tokens = this.getScan("#foo\na: b");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testCommentBeforeSecondKey() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedBlockMappingStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedKeyToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarToken(this.s("a"), true, '\u0000', new Position.Range(new Position(0, 0, 0), new Position(0, 1, 1))));
        expected.add(new PositionedValueToken(new Position.Range(new Position(0, 2, 2))));
        expected.add(new PositionedScalarToken(this.s("b"), true, '\u0000', new Position.Range(new Position(0, 3, 3), new Position(0, 4, 4))));
        expected.add(new PositionedKeyToken(new Position.Range(new Position(2, 0, 10))));
        expected.add(new PositionedScalarToken(this.s("c"), true, '\u0000', new Position.Range(new Position(2, 0, 10), new Position(2, 1, 11))));
        expected.add(new PositionedValueToken(new Position.Range(new Position(2, 2, 12))));
        expected.add(new PositionedScalarToken(this.s("d"), true, '\u0000', new Position.Range(new Position(2, 3, 13), new Position(2, 4, 14))));
        expected.add(new PositionedBlockEndToken(new Position.Range(new Position(2, 4, 14))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(2, 4, 14))));
        List tokens = this.getScan("a: b\n#foo\nc: d");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }

    public void testCommentBeforeSecondKeyWithBlankFirst() throws Exception {
        ArrayList<Token> expected = new ArrayList<Token>();
        expected.add(new PositionedStreamStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedBlockMappingStartToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedKeyToken(new Position.Range(new Position(0, 0, 0))));
        expected.add(new PositionedScalarToken(this.s("a"), true, '\u0000', new Position.Range(new Position(0, 0, 0), new Position(0, 1, 1))));
        expected.add(new PositionedValueToken(new Position.Range(new Position(0, 2, 2))));
        expected.add(new PositionedKeyToken(new Position.Range(new Position(2, 0, 9))));
        expected.add(new PositionedScalarToken(this.s("c"), true, '\u0000', new Position.Range(new Position(2, 0, 9), new Position(2, 1, 10))));
        expected.add(new PositionedValueToken(new Position.Range(new Position(2, 2, 11))));
        expected.add(new PositionedScalarToken(this.s("d"), true, '\u0000', new Position.Range(new Position(2, 3, 12), new Position(2, 4, 13))));
        expected.add(new PositionedBlockEndToken(new Position.Range(new Position(2, 4, 13))));
        expected.add(new PositionedStreamEndToken(new Position.Range(new Position(2, 4, 13))));
        List tokens = this.getScan("a: \n#foo\nc: d");
        PositioningScannerImplTest.assertEquals(expected, (Object)tokens);
    }
}

