/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.performance.utilities;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataOutputStream;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JDialog;
import junit.framework.AssertionFailedError;
import org.netbeans.jellytools.TopComponentOperator;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.DialogWaiter;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.WindowOperator;
import org.netbeans.jemmy.util.PNGEncoder;
import org.netbeans.junit.NbPerformanceTest;
import org.netbeans.modules.performance.guitracker.ActionTracker;
import org.netbeans.modules.performance.guitracker.LoggingRepaintManager;
import org.netbeans.modules.performance.utilities.CommonUtilities;
import org.netbeans.modules.performance.utilities.PerformanceTestCase2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public abstract class PerformanceTestCase
extends PerformanceTestCase2
implements NbPerformanceTest {
    public static final String OPEN_AFTER = "OPEN - after";
    public static final String OPEN_BEFORE = "OPEN - before";
    private static final boolean logMemory = Boolean.getBoolean("org.netbeans.performance.memory.usage.log");
    protected static final long WINDOW_OPEN = 1000L;
    protected static final long UI_RESPONSE = 100L;
    public long expectedTime = 100L;
    public int iteration = 1;
    public int MAX_ITERATION = 10;
    public int WAIT_PAINT = 1000;
    public int WAIT_AFTER_OPEN = 1000;
    public int WAIT_AFTER_PREPARE = 1000;
    public int WAIT_AFTER_CLOSE = 1000;
    public double HEURISTIC_FACTOR = 1.25;
    protected static int repeat = Integer.getInteger("org.netbeans.performance.repeat", 4);
    protected static int repeat_memory = Integer.getInteger("org.netbeans.performance.memory.repeat", -1);
    private static ArrayList<NbPerformanceTest.PerformanceData> data = new ArrayList();
    protected int track_mouse_event = 11;
    protected int MY_START_EVENT = -10;
    protected int MY_END_EVENT = -10;
    protected static final int MY_EVENT_NOT_AVAILABLE = -10;
    private static ActionTracker tr;
    private static LoggingRepaintManager rm;
    private static final Logger LOG;
    private int defaultCaretBlinkRate;
    private boolean caretBlinkingDisabled = false;
    private static final String CARET_BLINK_RATE_KEY = "caret-blink-rate";
    protected ComponentOperator testedComponentOperator;
    protected HashMap<String, String> renamedTestCaseName;
    public boolean useTwoOrderTypes = true;
    private final Object DEFAULT_REFS_GROUP = new Object();
    private static Map<Object, Map<Reference<Object>, String>> tracedRefs;
    private Profile profile;
    PhaseHandler phaseHandler = new PhaseHandler();

    public PerformanceTestCase(String testName) {
        super(testName);
        this.renamedTestCaseName = new HashMap();
    }

    public PerformanceTestCase(String testName, String performanceDataName) {
        this(testName);
        this.setTestCaseName(testName, performanceDataName);
    }

    public void setUp() {
        data = new ArrayList();
    }

    protected LoggingRepaintManager repaintManager() {
        return rm;
    }

    public void tearDown() {
        PerformanceTestCase.closeAllModal();
    }

    public void doMeasurement() {
        if (repeat_memory == -1) {
            this.measureTime();
        } else {
            this.measureMemoryUsage();
        }
        this.restoreEditorCaretBlinking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void measureTime() {
        Exception exceptionDuringMeasurement = null;
        long wait_after_open_heuristic = this.WAIT_AFTER_OPEN;
        long[] measuredTime = new long[repeat + 1];
        JemmyProperties.setCurrentDispatchingModel((int)(JemmyProperties.getCurrentDispatchingModel() | JemmyProperties.ROBOT_MODEL_MASK));
        JemmyProperties.setCurrentTimeout((String)"EventDispatcher.RobotAutoDelay", (long)1L);
        this.log("----------------------- DISPATCHING MODEL = " + JemmyProperties.getCurrentDispatchingModel());
        String performanceDataName = this.setPerformanceName();
        tr.startNewEventList(performanceDataName);
        tr.add(51, "Expected_time=" + this.expectedTime + ", Repeat=" + repeat + ", Wait_after_prepare=" + this.WAIT_AFTER_PREPARE + ", Wait_after_open=" + this.WAIT_AFTER_OPEN + ", Wait_after_close=" + this.WAIT_AFTER_CLOSE + ", Wait_paint=" + this.WAIT_PAINT + ", Max_iteration=" + this.MAX_ITERATION + ", logMemory=" + logMemory);
        this.checkScanFinished();
        try {
            this.initialize();
            for (int i = 1; i <= repeat && exceptionDuringMeasurement == null; ++i) {
                try {
                    this.iteration = i;
                    this.testedComponentOperator = null;
                    tr.startNewEventList("Iteration no." + i);
                    tr.connectToAWT(true);
                    this.prepare();
                    this.waitNoEvent(this.WAIT_AFTER_PREPARE);
                    new QueueTool().waitEmpty();
                    this.logMemoryUsage();
                    tr.add(52, OPEN_BEFORE);
                    this.testedComponentOperator = this.open();
                    tr.add(52, OPEN_AFTER);
                    long wait_time = wait_after_open_heuristic > (long)this.WAIT_AFTER_OPEN ? (long)this.WAIT_AFTER_OPEN : wait_after_open_heuristic;
                    tr.add(51, "Wait_after_open_heuristic=" + wait_time);
                    Thread.sleep(wait_time);
                    this.waitNoEvent(wait_time / 4L);
                    this.logMemoryUsage();
                    new QueueTool().waitEmpty();
                    measuredTime[i] = this.getMeasuredTime();
                    tr.add(50, "Measured Time=" + measuredTime[i], true);
                    if (this.HEURISTIC_FACTOR > 0.0) {
                        wait_after_open_heuristic = (long)((double)measuredTime[i] * this.HEURISTIC_FACTOR);
                    }
                    this.log("Measured Time [" + performanceDataName + " | " + i + "] = " + measuredTime[i]);
                    if (measuredTime[i] < 0L) {
                        System.out.println("@@@ Measured Time is less than 0");
                        measuredTime[i] = 0L;
                    }
                    this.reportPerformance(performanceDataName, measuredTime[i], "ms", i, this.expectedTime);
                    continue;
                }
                catch (Exception exc) {
                    this.log("------- [ " + i + " ] ---------------- Exception rises while measuring performance: " + exc);
                    exc.printStackTrace(this.getLog());
                    this.getScreenshot("exception_during_open");
                    exceptionDuringMeasurement = exc;
                    continue;
                }
                finally {
                    try {
                        tr.add(52, "CLOSE - before");
                        this.close();
                        PerformanceTestCase.closeAllModal();
                        this.waitNoEvent(this.WAIT_AFTER_CLOSE);
                    }
                    catch (Exception e) {
                        this.log("------- [ " + i + " ] ---------------- Exception rises while closing tested component: " + e);
                        e.printStackTrace(this.getLog());
                        this.getScreenshot("exception_during_close");
                        exceptionDuringMeasurement = e;
                    }
                    finally {
                        tr.connectToAWT(false);
                    }
                }
            }
            tr.startNewEventList("shutdown hooks");
            this.shutdown();
            PerformanceTestCase.closeAllDialogs();
            tr.add(50, "AFTER SHUTDOWN");
        }
        catch (Exception e) {
            this.log("----------------------- Exception rises while shuting down / initializing: " + e);
            e.printStackTrace(this.getLog());
            this.getScreenshot("exception_during_init_or_shutdown");
            exceptionDuringMeasurement = e;
        }
        finally {
            this.repaintManager().resetRegionFilters();
        }
        this.dumpLog();
        if (exceptionDuringMeasurement != null) {
            throw new RuntimeException("Exception {" + exceptionDuringMeasurement + "} rises during measurement.", exceptionDuringMeasurement);
        }
        this.compare(performanceDataName, measuredTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void measureMemoryUsage() {
        Exception exceptionDuringMeasurement = null;
        long wait_after_open_heuristic = this.WAIT_AFTER_OPEN;
        long memoryUsageMinimum = 0L;
        long[] memoryUsage = new long[repeat_memory + 1];
        this.useTwoOrderTypes = false;
        JemmyProperties.setCurrentDispatchingModel((int)JemmyProperties.ROBOT_MODEL_MASK);
        JemmyProperties.setCurrentTimeout((String)"EventDispatcher.RobotAutoDelay", (long)1L);
        this.log("----------------------- DISPATCHING MODEL = " + JemmyProperties.getCurrentDispatchingModel());
        this.checkScanFinished();
        this.runGC(5);
        this.initialize();
        for (int i = 1; i <= repeat_memory && exceptionDuringMeasurement == null; ++i) {
            try {
                this.testedComponentOperator = null;
                this.prepare();
                this.waitNoEvent(this.WAIT_AFTER_PREPARE);
                new QueueTool().waitEmpty();
                this.testedComponentOperator = this.open();
                long wait_time = wait_after_open_heuristic > (long)this.WAIT_AFTER_OPEN ? (long)this.WAIT_AFTER_OPEN : wait_after_open_heuristic;
                this.waitNoEvent(wait_time);
                new QueueTool().waitEmpty();
            }
            catch (Exception exc) {
                exc.printStackTrace(this.getLog());
                exceptionDuringMeasurement = exc;
                this.getScreenshot("exception_during_open");
            }
            finally {
                try {
                    this.close();
                    PerformanceTestCase.closeAllModal();
                    this.waitNoEvent(this.WAIT_AFTER_CLOSE);
                }
                catch (Exception e) {
                    e.printStackTrace(this.getLog());
                    this.getScreenshot("exception_during_close");
                    exceptionDuringMeasurement = e;
                }
            }
            this.runGC(3);
            Runtime runtime = Runtime.getRuntime();
            memoryUsage[i] = runtime.totalMemory() - runtime.freeMemory();
            this.log("Used Memory [" + i + "] = " + memoryUsage[i]);
            if (memoryUsageMinimum != 0L && memoryUsageMinimum <= memoryUsage[i]) continue;
            memoryUsageMinimum = memoryUsage[i];
        }
        String performanceDataName = this.setPerformanceName();
        for (int i = 1; i <= repeat_memory; ++i) {
            this.log("Used Memory [" + performanceDataName + " | " + i + "] = " + memoryUsage[i]);
            this.reportPerformance(performanceDataName, memoryUsage[i] - memoryUsageMinimum, "bytes", i);
        }
        try {
            this.shutdown();
            PerformanceTestCase.closeAllDialogs();
        }
        catch (Exception e) {
            e.printStackTrace(this.getLog());
            exceptionDuringMeasurement = e;
        }
        if (exceptionDuringMeasurement != null) {
            throw new RuntimeException("Exception rises during measurement, look at appropriate log file for stack trace(s).");
        }
    }

    protected void initialize() {
    }

    public abstract void prepare();

    public abstract ComponentOperator open();

    public void close() {
        if (this.testedComponentOperator != null && this.testedComponentOperator.isShowing()) {
            if (this.testedComponentOperator instanceof WindowOperator) {
                ((WindowOperator)this.testedComponentOperator).requestClose();
            } else if (this.testedComponentOperator instanceof TopComponentOperator) {
                ((TopComponentOperator)this.testedComponentOperator).close();
            } else if (this.testedComponentOperator instanceof ComponentOperator) {
                this.testedComponentOperator.pushKey(27);
            }
        }
    }

    protected void shutdown() {
    }

    public void reportPerformance(String name, long value, String unit, int runOrder, long threshold) {
        NbPerformanceTest.PerformanceData d = new NbPerformanceTest.PerformanceData();
        d.name = name == null ? this.getName() : name;
        d.value = value;
        d.unit = unit;
        d.runOrder = this.useTwoOrderTypes && runOrder > 1 ? 2 : runOrder;
        d.threshold = threshold;
        data.add(d);
    }

    public void reportPerformance(String name, long value, String unit, int runOrder) {
        NbPerformanceTest.PerformanceData d = new NbPerformanceTest.PerformanceData();
        d.name = name == null ? this.getName() : name;
        d.value = value;
        d.unit = unit;
        d.runOrder = this.useTwoOrderTypes && runOrder > 1 ? 2 : runOrder;
        data.add(d);
    }

    protected void reportReference(String message, Object object, Object group) {
        Object g;
        Object object2 = g = group == null ? this.DEFAULT_REFS_GROUP : group;
        if (!tracedRefs.containsKey(g)) {
            tracedRefs.put(g, new HashMap());
        }
        tracedRefs.get(g).put(new WeakReference<Object>(object), message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTestGC(Object group) throws Exception {
        Object g = group == null ? this.DEFAULT_REFS_GROUP : group;
        try {
            AssertionFailedError afe = null;
            for (Map.Entry<Reference<Object>, String> entry : tracedRefs.get(g).entrySet()) {
                try {
                    PerformanceTestCase.assertGC((String)entry.getValue(), entry.getKey());
                }
                catch (AssertionFailedError e) {
                    if (afe != null) {
                        Throwable t = e;
                        while (t.getCause() != null) {
                            t = t.getCause();
                        }
                        t.initCause(afe);
                    }
                    afe = e;
                }
            }
            if (afe != null) {
                throw afe;
            }
        }
        finally {
            tracedRefs.get(g).clear();
        }
    }

    protected void disableEditorCaretBlinking() {
        Preferences prefs = PerformanceTestCase.getMimeLookupPreferences();
        this.defaultCaretBlinkRate = prefs.getInt(CARET_BLINK_RATE_KEY, 0);
        prefs.putInt(CARET_BLINK_RATE_KEY, 0);
        this.caretBlinkingDisabled = true;
    }

    protected void restoreEditorCaretBlinking() {
        if (this.caretBlinkingDisabled && this.defaultCaretBlinkRate != 0) {
            PerformanceTestCase.getMimeLookupPreferences().putInt(CARET_BLINK_RATE_KEY, this.defaultCaretBlinkRate);
            this.caretBlinkingDisabled = false;
        }
    }

    private static Preferences getMimeLookupPreferences() {
        try {
            Class<?> mimeLookupClass = Class.forName("org.netbeans.api.editor.mimelookup.MimeLookup", true, Thread.currentThread().getContextClassLoader());
            Method getLookupMethod = mimeLookupClass.getDeclaredMethod("getLookup", String.class);
            Lookup lookup = (Lookup)getLookupMethod.invoke(null, "");
            return (Preferences)lookup.lookup(Preferences.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void logMemoryUsage() {
        if (logMemory) {
            Runtime runtime = Runtime.getRuntime();
            long totalMemory = runtime.totalMemory();
            long freeMemory = runtime.freeMemory();
            tr.add(50, "Memory used=" + (totalMemory - freeMemory) + " total=" + totalMemory);
        }
    }

    public void runGC(int i) {
        while (i > 0) {
            try {
                System.runFinalization();
                System.gc();
                Thread.sleep(500L);
                System.gc();
                Thread.sleep(500L);
                System.gc();
                Thread.sleep(500L);
            }
            catch (Exception exc) {
                exc.printStackTrace(System.err);
            }
            --i;
        }
    }

    public String setPerformanceName() {
        String performanceDataName = this.getPerformanceName();
        if (performanceDataName.equalsIgnoreCase("measureTime")) {
            performanceDataName = ((Object)((Object)this)).getClass().getName();
        }
        return performanceDataName;
    }

    public void compare(String performanceDataName, long[] measuredValues) {
        boolean firstTimeUsageFail = false;
        int numberOfFails = 0;
        boolean NUMBER_OF_FAILS_THRESHOLD = true;
        String measuredValuesString = "";
        for (int i = 1; i < measuredValues.length; ++i) {
            measuredValuesString = measuredValuesString + " " + measuredValues[i];
            if (i > 1 && measuredValues[i] > this.expectedTime || i == 1 && measuredValues.length == 1 && measuredValues[i] > this.expectedTime) {
                ++numberOfFails;
                continue;
            }
            if (i != 1 || measuredValues.length <= 1 || measuredValues[i] <= 2L * this.expectedTime) continue;
            ++numberOfFails;
            firstTimeUsageFail = true;
        }
        String suite_fqn = System.getProperty("suitename", "org.netbeans.performance.unknown");
        String suiteName = System.getProperty("suite", "Unknown Test Suite");
        if (numberOfFails > 1 || firstTimeUsageFail) {
            CommonUtilities.xmlTestResults(this.getWorkDirPath(), suiteName, performanceDataName, ((Object)((Object)this)).getClass().getCanonicalName(), suite_fqn, "ms", "failed", this.expectedTime, measuredValues, repeat);
            this.captureScreen = false;
            PerformanceTestCase.fail((String)(numberOfFails + " of the measuredTime(s) [" + measuredValuesString + " ] > expectedTime[" + this.expectedTime + "] - performance issue (it's ok if the first usage is in boundary of 0 to 2*expectedTime) ."));
        }
        CommonUtilities.xmlTestResults(this.getWorkDirPath(), suiteName, performanceDataName, ((Object)((Object)this)).getClass().getCanonicalName(), suite_fqn, "ms", "passed", this.expectedTime, measuredValues, repeat);
    }

    public void checkScanFinished() {
        CommonUtilities.waitScanFinished();
    }

    public long getMeasuredTime() {
        int attempt = 0;
        while (true) {
            block10: {
                ActionTracker.Tuple start = (ActionTracker.Tuple)tr.getCurrentEvents().getFirst();
                ActionTracker.Tuple end = (ActionTracker.Tuple)tr.getCurrentEvents().getFirst();
                try {
                    for (ActionTracker.Tuple tuple : tr.getCurrentEvents()) {
                        if (tuple == null) continue;
                        int code = tuple.getCode();
                        if (code == this.MY_START_EVENT || this.MY_START_EVENT == 53 && code == 52 && tuple.getName().equals(OPEN_BEFORE) || this.MY_START_EVENT == 54 && code == 52 && tuple.getName().equals(OPEN_AFTER)) {
                            start = tuple;
                            continue;
                        }
                        if (this.MY_START_EVENT == -10 && (code == 1 || code == this.track_mouse_event || code == 20)) {
                            start = tuple;
                            continue;
                        }
                        if (code == this.MY_END_EVENT || this.MY_END_EVENT == 53 && code == 52 && tuple.getName().equals(OPEN_BEFORE) || this.MY_END_EVENT == 54 && code == 52 && tuple.getName().equals(OPEN_AFTER)) {
                            end = tuple;
                            continue;
                        }
                        if (this.MY_END_EVENT != -10 || code != 2 && code != 1102 && code != 2102 && code != 3102) continue;
                        end = tuple;
                    }
                }
                catch (ConcurrentModificationException cme) {
                    if (attempt == 10) {
                        throw new Error("Can't calculate result of measureTime for 10 iterations due to " + cme, cme);
                    }
                    break block10;
                }
                start.setMeasured(true);
                end.setMeasured(true);
                long result = end.getTimeMillis() - start.getTimeMillis();
                System.out.println("@@@@ Start tuple:" + start);
                System.out.println("@@@@ End tuple:" + end);
                if (result < 0L || start.getTimeMillis() == 0L) {
                    System.out.println("!!!!! Measuring failed, because start [" + start.getTimeMillis() + "] > end [" + end.getTimeMillis() + "] or start=0. Threads in which the measurements were taken:" + start.getMeasurementThreadName() + "   " + end.getMeasurementThreadName() + " !!!!!");
                    System.out.println("!*!*!Full tuples list for disgnostic purposes");
                    ActionTracker.EventList el = tr.getCurrentEvents();
                    for (ActionTracker.Tuple tuple : el) {
                        System.out.println(tuple);
                    }
                    result = 0L;
                }
                return result;
            }
            ++attempt;
        }
    }

    public void dumpLog() {
        tr.stopRecording();
        try {
            tr.setXslLocation(this.getWorkDirPath());
            tr.exportAsXML(this.getLog("ActionTracker.xml"));
        }
        catch (Exception ex) {
            throw new Error("Exception while generating log", ex);
        }
        tr.forgetAllEvents();
        tr.startRecording();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitNoEvent(long time) {
        if (repeat_memory != -1) {
            try {
                Thread thread = Thread.currentThread();
                synchronized (thread) {
                    Thread.currentThread().wait(time);
                }
            }
            catch (Exception exc) {
                this.log("Exception rises during waiting " + time + " ms");
                exc.printStackTrace(this.getLog());
            }
        } else {
            rm.waitNoPaintEvent(time);
        }
    }

    public NbPerformanceTest.PerformanceData[] getPerformanceData() {
        if (data != null) {
            return data.toArray(new NbPerformanceTest.PerformanceData[0]);
        }
        return null;
    }

    public void setTestCaseName(String oldName, String newName) {
        this.renamedTestCaseName.put(oldName, newName);
    }

    public String getName() {
        String originalTestCaseName = super.getName();
        if (this.renamedTestCaseName.containsKey(originalTestCaseName)) {
            return this.renamedTestCaseName.get(originalTestCaseName).replace('|', '-');
        }
        return ((Object)((Object)this)).getClass().getSimpleName() + "." + originalTestCaseName;
    }

    public String getPerformanceName() {
        String originalTestCaseName = super.getName();
        if (this.renamedTestCaseName.containsKey(originalTestCaseName)) {
            return this.renamedTestCaseName.get(originalTestCaseName);
        }
        return originalTestCaseName;
    }

    public static void closeAllDialogs() {
        JDialog dialog;
        ComponentChooser chooser = new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return comp instanceof JDialog && comp.isShowing();
            }

            public String getDescription() {
                return "Dialog";
            }
        };
        while ((dialog = (JDialog)DialogWaiter.getDialog((ComponentChooser)chooser)) != null) {
            PerformanceTestCase.closeDialogs(PerformanceTestCase.findBottomDialog(dialog, chooser), chooser);
        }
    }

    private static JDialog findBottomDialog(JDialog dialog, ComponentChooser chooser) {
        Window owner = dialog.getOwner();
        if (chooser.checkComponent((Component)owner)) {
            return PerformanceTestCase.findBottomDialog((JDialog)owner, chooser);
        }
        return dialog;
    }

    private static void closeDialogs(JDialog dialog, ComponentChooser chooser) {
        for (Window window : dialog.getOwnedWindows()) {
            if (!chooser.checkComponent((Component)window)) continue;
            PerformanceTestCase.closeDialogs((JDialog)window, chooser);
        }
        new JDialogOperator(dialog).requestClose();
    }

    protected void getScreenshotOfMeasuredIDEInTimeOfMeasurement(int i) {
        try {
            if (this.testedComponentOperator == null) {
                PNGEncoder.captureScreen((String)(this.getWorkDir().getAbsolutePath() + File.separator + "screen_" + i + ".png"), (byte)1);
            } else {
                Point locationOnScreen = this.testedComponentOperator.getLocationOnScreen();
                Rectangle bounds = this.testedComponentOperator.getBounds();
                Rectangle bounds_new = new Rectangle(locationOnScreen.x - 100, locationOnScreen.y - 100, bounds.width + 200, bounds.height + 200);
                Rectangle screen_size = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
                if (bounds_new.height > screen_size.height / 2 || bounds_new.width > screen_size.width / 2) {
                    PNGEncoder.captureScreen((String)(this.getWorkDir().getAbsolutePath() + File.separator + "screen_" + i + ".png"), (byte)1);
                } else {
                    PNGEncoder.captureScreen((Rectangle)bounds_new, (String)(this.getWorkDir().getAbsolutePath() + File.separator + "screen_" + i + ".png"), (byte)1);
                }
            }
        }
        catch (Exception exc) {
            this.log(" Exception rises during capturing screenshot of measurement ");
            exc.printStackTrace(this.getLog());
        }
    }

    protected void getScreenshot(String title) {
        try {
            PNGEncoder.captureScreen((String)(this.getWorkDir().getAbsolutePath() + File.separator + "error_screenshot_" + title + ".png"));
        }
        catch (Exception exc) {
            this.log(" Exception rises during capturing screenshot ");
            exc.printStackTrace(this.getLog());
        }
    }

    public static void disableStatusBarEffects() {
        System.setProperty("org.openide.awt.StatusDisplayer.DISPLAY_TIME", "0");
    }

    public static void disablePHPReadmeHTML() {
        System.setProperty("org.netbeans.modules.php.samples.donotopenreadmehtml", "true");
    }

    public static void prepareForMeasurements() {
        PerformanceTestCase.disableStatusBarEffects();
        PerformanceTestCase.disablePHPReadmeHTML();
    }

    private void initializeProfiling() {
        FileObject fo = FileUtil.getConfigFile((String)"Actions/Profile/org-netbeans-modules-profiler-actions-SelfSamplerAction.instance");
        if (fo == null) {
            return;
        }
        Action a = (Action)fo.getAttribute("delegate");
        if (a == null) {
            return;
        }
        this.profile = new Profile(a.getValue("logger-performance"));
    }

    private void finishProfiling(int round) throws Exception {
        if (this.profile != null) {
            this.profile.stop(round);
        }
    }

    protected void addEditorPhaseHandler() {
        Logger.getLogger("TIMER").setLevel(Level.FINE);
        Logger.getLogger("TIMER").addHandler(this.phaseHandler);
    }

    protected void removeEditorPhaseHandler() {
        Logger.getLogger("TIMER").removeHandler(this.phaseHandler);
        Logger.getLogger("TIMER").setLevel(Level.OFF);
    }

    static {
        LOG = Logger.getLogger(PerformanceTestCase.class.getName());
        if (repeat_memory == -1) {
            tr = ActionTracker.getInstance();
            rm = new LoggingRepaintManager(tr);
            rm.setEnabled(true);
        }
        System.setProperty("org.netbeans.core.TimeableEventQueue.quantum", "100000");
        System.setProperty("swing.disablevistaanimation", "true");
        URL u = PerformanceTestCase.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            if ("jar".equals(u.getProtocol())) {
                u = ((JarURLConnection)u.openConnection()).getJarFileURL();
            }
            for (File f = new File(u.toURI()); f != null; f = f.getParentFile()) {
                File hg = new File(f, ".hg");
                if (!hg.isDirectory()) continue;
                System.setProperty("versioning.unversionedFolders", f.getPath());
                LOG.log(Level.INFO, "ignoring Hg folder: {0}", f);
                break;
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Problem looking up " + u, ex);
        }
        tracedRefs = new HashMap<Object, Map<Reference<Object>, String>>();
    }

    class PhaseHandler
    extends Handler {
        PhaseHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            if (record.getMessage().startsWith("Open Editor, phase ANNOTATIONS")) {
                ActionTracker.getInstance().add(3102, "PhaseHandler - Editor opened.");
                ActionTracker.getInstance().stopRecording();
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }

    private class Profile
    implements Runnable {
        Object profiler;
        boolean profiling;

        public Profile(Object profiler) {
            this.profiler = profiler;
            if (PerformanceTestCase.this.iteration == 1) {
                RequestProcessor.getDefault().post((Runnable)this, (int)PerformanceTestCase.this.expectedTime * 2);
            } else {
                RequestProcessor.getDefault().post((Runnable)this, (int)PerformanceTestCase.this.expectedTime);
            }
        }

        @Override
        public synchronized void run() {
            this.profiling = true;
            if (this.profiler instanceof Runnable) {
                Runnable r = (Runnable)this.profiler;
                r.run();
            }
        }

        private synchronized void stop(int round) throws Exception {
            ActionListener ss = (ActionListener)this.profiler;
            this.profiler = null;
            if (!this.profiling) {
                return;
            }
            FileObject wd = FileUtil.toFileObject((File)PerformanceTestCase.this.getWorkDir());
            String n = FileUtil.findFreeFileName((FileObject)wd, (String)("snapshot-" + round), (String)"nps");
            FileObject snapshot = wd.createData(n, "nps");
            DataOutputStream dos = new DataOutputStream(snapshot.getOutputStream());
            ss.actionPerformed(new ActionEvent(dos, 0, "write"));
            dos.close();
            LOG.log(Level.WARNING, "Profiling snapshot taken into {0}", snapshot.getPath());
        }
    }
}

