/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.treeview;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.Field;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.IteratorSearchRequest;
import org.apache.maven.index.IteratorSearchResponse;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.expr.SourcedSearchExpression;
import org.apache.maven.index.treeview.IndexTreeView;
import org.apache.maven.index.treeview.TreeNode;
import org.apache.maven.index.treeview.TreeViewRequest;
import org.codehaus.plexus.util.StringUtils;

@Singleton
@Named
public class DefaultIndexTreeView
implements IndexTreeView {
    private final Indexer indexer;

    @Inject
    public DefaultIndexTreeView(Indexer indexer) {
        this.indexer = indexer;
    }

    protected Indexer getIndexer() {
        return this.indexer;
    }

    @Override
    public TreeNode listNodes(TreeViewRequest request) throws IOException {
        String name = null;
        if (!"/".equals(request.getPath())) {
            name = request.getPath().endsWith("/") ? request.getPath().substring(0, request.getPath().length() - 1) : request.getPath();
            if (!(name = name.substring(name.lastIndexOf(47) + 1, name.length())).equals("/") && name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
        } else {
            name = "/";
        }
        TreeNode result = request.getFactory().createGNode(this, request, request.getPath(), name);
        if (request.hasFieldHints()) {
            this.listChildren(result, request, null);
        } else if ("/".equals(request.getPath())) {
            Set<String> rootGroups = request.getIndexingContext().getRootGroups();
            for (String group : rootGroups) {
                if (group.length() <= 0) continue;
                result.getChildren().add(request.getFactory().createGNode(this, request, request.getPath() + group + "/", group));
            }
        } else {
            Set<String> allGroups = request.getIndexingContext().getAllGroups();
            this.listChildren(result, request, allGroups);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void listChildren(TreeNode root, TreeViewRequest request, Set<String> allGroups) throws IOException {
        String path = root.getPath();
        HashMap<String, TreeNode> folders = new HashMap<String, TreeNode>();
        String rootPartialGroupId = StringUtils.strip((String)root.getPath().replaceAll("/", "."), (String)".");
        folders.put((Object)((Object)TreeNode.Type.G) + ":" + rootPartialGroupId, root);
        try (IteratorSearchResponse artifacts = this.getArtifacts(root, request);){
            for (ArtifactInfo ai : artifacts) {
                String versionKey = (Object)((Object)TreeNode.Type.V) + ":" + ai.getArtifactId() + ":" + ai.getVersion();
                TreeNode versionResource = (TreeNode)folders.get(versionKey);
                if (versionResource == null) {
                    String artifactKey = (Object)((Object)TreeNode.Type.A) + ":" + ai.getArtifactId();
                    TreeNode artifactResource = (TreeNode)folders.get(artifactKey);
                    if (artifactResource == null) {
                        String[] groupIdElems;
                        TreeNode groupParentResource = root;
                        TreeNode groupResource = root;
                        String partialGroupId = null;
                        for (String groupIdElem : groupIdElems = ai.getGroupId().split("\\.")) {
                            partialGroupId = partialGroupId == null ? groupIdElem : partialGroupId + "." + groupIdElem;
                            String groupKey = (Object)((Object)TreeNode.Type.G) + ":" + partialGroupId;
                            groupResource = (TreeNode)folders.get(groupKey);
                            if (groupResource == null && groupParentResource.getPath().length() < this.getPathForAi(ai, MAVEN.GROUP_ID).length()) {
                                String gNodeName = partialGroupId.lastIndexOf(46) > -1 ? partialGroupId.substring(partialGroupId.lastIndexOf(46) + 1, partialGroupId.length()) : partialGroupId;
                                groupResource = request.getFactory().createGNode(this, request, "/" + partialGroupId.replaceAll("\\.", "/") + "/", gNodeName);
                                groupParentResource.getChildren().add(groupResource);
                                folders.put(groupKey, groupResource);
                                groupParentResource = groupResource;
                                continue;
                            }
                            if (groupResource == null) continue;
                            if (groupResource.getPath().equals(this.getPathForAi(ai, MAVEN.GROUP_ID))) break;
                            groupParentResource = groupResource;
                        }
                        artifactResource = request.getFactory().createANode(this, request, ai, this.getPathForAi(ai, MAVEN.ARTIFACT_ID));
                        groupParentResource.getChildren().add(artifactResource);
                        folders.put(artifactKey, artifactResource);
                    }
                    versionResource = request.getFactory().createVNode(this, request, ai, this.getPathForAi(ai, MAVEN.VERSION));
                    artifactResource.getChildren().add(versionResource);
                    folders.put(versionKey, versionResource);
                }
                String nodePath = this.getPathForAi(ai, null);
                versionResource.getChildren().add(request.getFactory().createArtifactNode(this, request, ai, nodePath));
            }
        }
        if (!request.hasFieldHints()) {
            Set<String> groups = this.getGroups(path, allGroups);
            for (String group : groups) {
                TreeNode groupResource = root.findChildByPath(path + group + "/", TreeNode.Type.G);
                if (groupResource == null) {
                    groupResource = request.getFactory().createGNode(this, request, path + group + "/", group);
                    root.getChildren().add(groupResource);
                    continue;
                }
                this.listChildren(groupResource, request, allGroups);
            }
        }
    }

    protected String getPathForAi(ArtifactInfo ai, Field field) {
        StringBuilder sb = new StringBuilder("/");
        sb.append(ai.getGroupId().replaceAll("\\.", "/"));
        if (MAVEN.GROUP_ID.equals(field)) {
            return sb.append("/").toString();
        }
        sb.append("/").append(ai.getArtifactId());
        if (MAVEN.ARTIFACT_ID.equals(field)) {
            return sb.append("/").toString();
        }
        sb.append("/").append(ai.getVersion());
        if (MAVEN.VERSION.equals(field)) {
            return sb.append("/").toString();
        }
        sb.append("/").append(ai.getArtifactId()).append("-").append(ai.getVersion());
        if (ai.getClassifier() != null) {
            sb.append("-").append(ai.getClassifier());
        }
        sb.append(".").append(ai.getFileExtension() == null ? "jar" : ai.getFileExtension());
        return sb.toString();
    }

    protected Set<String> getGroups(String path, Set<String> allGroups) {
        path = path.substring(1).replace('/', '.');
        int n = path.length();
        HashSet<String> result = new HashSet<String>();
        for (String group : allGroups) {
            if (!group.startsWith(path)) continue;
            int nextDot = (group = group.substring(n)).indexOf(46);
            if (nextDot > -1) {
                group = group.substring(0, nextDot);
            }
            if (group.length() <= 0 || result.contains(group)) continue;
            result.add(group);
        }
        return result;
    }

    protected IteratorSearchResponse getArtifacts(TreeNode root, TreeViewRequest request) throws IOException {
        if (request.hasFieldHints()) {
            return this.getHintedArtifacts(root, request);
        }
        String path = root.getPath();
        IteratorSearchResponse result = null;
        String g = null;
        String a = null;
        String v = null;
        String wp = null;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((result = this.getArtifactsByG(g = (wp = path).substring(1).replace('/', '.'), request)).getTotalHitsCount() > 0) {
            return result;
        }
        result.close();
        if (path.lastIndexOf(47) > 0) {
            wp = path;
            a = wp.substring(wp.lastIndexOf(47) + 1, wp.length());
            g = wp.substring(1, wp.lastIndexOf(47)).replace('/', '.');
            result = this.getArtifactsByGA(g, a, request);
            if (result.getTotalHitsCount() > 0) {
                return result;
            }
            result.close();
            try {
                wp = path;
                v = wp.substring(wp.lastIndexOf(47) + 1, wp.length());
                wp = wp.substring(0, wp.lastIndexOf(47));
                a = wp.substring(wp.lastIndexOf(47) + 1, wp.length());
                g = wp.substring(1, wp.lastIndexOf(47)).replace('/', '.');
                result = this.getArtifactsByGAV(g, a, v, request);
                if (result.getTotalHitsCount() > 0) {
                    return result;
                }
                result.close();
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return IteratorSearchResponse.empty(result.getQuery());
    }

    protected IteratorSearchResponse getHintedArtifacts(TreeNode root, TreeViewRequest request) throws IOException {
        if (request.hasFieldHint(MAVEN.GROUP_ID, MAVEN.ARTIFACT_ID, MAVEN.VERSION)) {
            return this.getArtifactsByGAV(request.getFieldHint(MAVEN.GROUP_ID), request.getFieldHint(MAVEN.ARTIFACT_ID), request.getFieldHint(MAVEN.VERSION), request);
        }
        if (request.hasFieldHint(MAVEN.GROUP_ID, MAVEN.ARTIFACT_ID)) {
            return this.getArtifactsByGA(request.getFieldHint(MAVEN.GROUP_ID), request.getFieldHint(MAVEN.ARTIFACT_ID), request);
        }
        if (request.hasFieldHint(MAVEN.GROUP_ID)) {
            return this.getArtifactsByG(request.getFieldHint(MAVEN.GROUP_ID), request);
        }
        return IteratorSearchResponse.empty(null);
    }

    protected IteratorSearchResponse getArtifactsByG(String g, TreeViewRequest request) throws IOException {
        return this.getArtifactsByGAVField(g, null, null, request);
    }

    protected IteratorSearchResponse getArtifactsByGA(String g, String a, TreeViewRequest request) throws IOException {
        return this.getArtifactsByGAVField(g, a, null, request);
    }

    protected IteratorSearchResponse getArtifactsByGAV(String g, String a, String v, TreeViewRequest request) throws IOException {
        return this.getArtifactsByGAVField(g, a, v, request);
    }

    protected IteratorSearchResponse getArtifactsByGAVField(String g, String a, String v, TreeViewRequest request) throws IOException {
        assert (g != null);
        Query groupIdQ = null;
        Query artifactIdQ = null;
        Query versionQ = null;
        groupIdQ = this.getIndexer().constructQuery(MAVEN.GROUP_ID, new SourcedSearchExpression(g));
        if (StringUtils.isNotBlank((String)a)) {
            artifactIdQ = this.getIndexer().constructQuery(MAVEN.ARTIFACT_ID, new SourcedSearchExpression(a));
        }
        if (StringUtils.isNotBlank((String)v)) {
            versionQ = this.getIndexer().constructQuery(MAVEN.VERSION, new SourcedSearchExpression(v));
        }
        BooleanQuery q = new BooleanQuery();
        q.add(new BooleanClause(groupIdQ, BooleanClause.Occur.MUST));
        if (artifactIdQ != null) {
            q.add(new BooleanClause(artifactIdQ, BooleanClause.Occur.MUST));
        }
        if (versionQ != null) {
            q.add(new BooleanClause(versionQ, BooleanClause.Occur.MUST));
        }
        IteratorSearchRequest searchRequest = new IteratorSearchRequest((Query)q, request.getArtifactInfoFilter());
        searchRequest.getContexts().add(request.getIndexingContext());
        IteratorSearchResponse result = this.getIndexer().searchIterator(searchRequest);
        return result;
    }
}

