/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;

public class BreakpointGroup {
    static final String PROP_FROM_OPEN_PROJECTS = "fromOpenProjects";
    static final String PROP_FROM_CURRENT_SESSION_PROJECTS = "fromCurrentSessionProjects";
    private BreakpointGroup parent;
    private String name;
    private Object id;
    private Group group;
    private List<Breakpoint> breakpoints = new ArrayList<Breakpoint>();
    private List<BreakpointGroup> groups = new ArrayList<BreakpointGroup>();

    BreakpointGroup(Object id, String name, Group group) {
        this.id = id;
        this.name = name;
        this.group = group;
    }

    Object getId() {
        return this.id;
    }

    String getName() {
        return this.name;
    }

    Group getGroup() {
        return this.group;
    }

    List<BreakpointGroup> getSubGroups() {
        if (this.groups == null || this.groups.size() == 0) {
            return Collections.emptyList();
        }
        return this.groups;
    }

    List<Breakpoint> getBreakpoints() {
        return this.breakpoints;
    }

    private void addBreakpoint(Breakpoint b) {
        this.breakpoints.add(b);
    }

    private void addGroup(BreakpointGroup bg) {
        this.groups.add(bg);
        if (bg.parent != null) {
            throw new IllegalStateException("Group " + bg + " already has parent " + bg.parent);
        }
        bg.parent = this;
    }

    Object[] getGroupsAndBreakpoints() {
        ArrayList<BreakpointGroup> groupsAndBreakpoints = new ArrayList<BreakpointGroup>(this.groups.size() + this.breakpoints.size());
        groupsAndBreakpoints.addAll(this.groups);
        groupsAndBreakpoints.addAll(this.breakpoints);
        return groupsAndBreakpoints.toArray();
    }

    static Object[] createGroups(Properties props, Set<Breakpoint> closedProjectsBreakpoints) {
        String[] groupNames = (String[])props.getArray("Grouping", (Object[])new String[]{Group.CUSTOM.name()});
        boolean openProjectsOnly = props.getBoolean(PROP_FROM_OPEN_PROJECTS, true);
        boolean sessionProjectsOnly = props.getBoolean(PROP_FROM_CURRENT_SESSION_PROJECTS, true);
        Object[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
        if (groupNames.length == 0 || groupNames[0].equals(Group.NO.name())) {
            return bs;
        }
        Group[] gs = new Group[groupNames.length];
        HashMap<Object, BreakpointGroup> gm = new HashMap<Object, BreakpointGroup>();
        for (int gi = 0; gi < groupNames.length; ++gi) {
            gs[gi] = Group.valueOf(groupNames[gi]);
        }
        ArrayList<BreakpointGroup> groups = new ArrayList<BreakpointGroup>();
        ArrayList<Object> breakpoints = new ArrayList<Object>();
        ArrayList ids = new ArrayList();
        ArrayList<BreakpointGroup> parentGroups = new ArrayList<BreakpointGroup>();
        ArrayList<BreakpointGroup> rootGroups = new ArrayList<BreakpointGroup>();
        Set<Object> sessionProjects = sessionProjectsOnly ? BreakpointGroup.getCurrentSessionProjects() : null;
        HashSet<Project> openedProjectsCache = new HashSet<Project>();
        HashSet<Project> closedProjectsCache = new HashSet<Project>();
        HashMap<Project, Set<? extends Project>> subProjects = new HashMap<Project, Set<? extends Project>>();
        for (int bi = 0; bi < bs.length; ++bi) {
            Object b = bs[bi];
            Breakpoint.GroupProperties bprops = b.getGroupProperties();
            if (bprops != null) {
                if (bprops.isHidden()) continue;
                if (openProjectsOnly && !BreakpointGroup.isOpened(bprops.getProjects(), openedProjectsCache, closedProjectsCache, subProjects)) {
                    closedProjectsBreakpoints.add((Breakpoint)b);
                    Breakpoint.VALIDITY validity = b.getValidity();
                    if (!Breakpoint.VALIDITY.VALID.equals((Object)validity)) continue;
                }
                if (sessionProjects != null && !BreakpointGroup.contains(sessionProjects, bprops.getProjects())) continue;
            }
            parentGroups.clear();
            rootGroups.clear();
            ids.clear();
            for (int gi = 0; gi < gs.length; ++gi) {
                Group g = gs[gi];
                String propertyName = null;
                String id = null;
                String[] propertyNames = null;
                FileObject[] idz = null;
                block0 : switch (g) {
                    case CUSTOM: {
                        propertyName = b.getGroupName();
                        if (propertyName != null && propertyName.length() == 0) {
                            propertyName = null;
                        }
                        id = propertyName;
                        break;
                    }
                    case FILE: {
                        FileObject[] files;
                        if (bprops == null || (files = bprops.getFiles()) == null || files.length <= 0) break;
                        if (files.length == 1) {
                            propertyName = files[0].getPath();
                            id = files[0];
                            break;
                        }
                        propertyNames = new String[files.length];
                        idz = files;
                        for (int i = 0; i < files.length; ++i) {
                            propertyNames[i] = files[i].getPath();
                        }
                        break;
                    }
                    case LANGUAGE: {
                        if (bprops == null) break;
                        id = propertyName = bprops.getLanguage();
                        break;
                    }
                    case PROJECT: {
                        Project[] prjs;
                        if (bprops == null || (prjs = bprops.getProjects()) == null || prjs.length <= 0) break;
                        if (prjs.length == 1) {
                            if (prjs[0] == null) break;
                            propertyName = ProjectUtils.getInformation((Project)prjs[0]).getDisplayName();
                            id = prjs[0];
                            break;
                        }
                        propertyNames = new String[prjs.length];
                        idz = prjs;
                        for (int i = 0; i < prjs.length; ++i) {
                            if (prjs[i] == null) {
                                propertyNames = null;
                                idz = null;
                                break block0;
                            }
                            propertyNames[i] = ProjectUtils.getInformation((Project)prjs[i]).getDisplayName();
                        }
                        break;
                    }
                    case ENGINE: {
                        DebuggerEngine[] es;
                        if (bprops == null || (es = bprops.getEngines()) == null || es.length <= 0) break;
                        if (es.length == 1) {
                            propertyName = BreakpointGroup.getName(es[0]);
                            id = es[0];
                            break;
                        }
                        propertyNames = new String[es.length];
                        idz = es;
                        for (int i = 0; i < es.length; ++i) {
                            propertyNames[i] = BreakpointGroup.getName(es[i]);
                        }
                        break;
                    }
                    case TYPE: {
                        if (bprops == null) break;
                        id = propertyName = bprops.getType();
                    }
                }
                if (parentGroups.isEmpty()) {
                    if (id != null) {
                        BreakpointGroup bg = (BreakpointGroup)gm.get(id);
                        if (bg == null) {
                            bg = new BreakpointGroup(id, propertyName, g);
                            gm.put(id, bg);
                        }
                        parentGroups.add(bg);
                    } else if (idz != null) {
                        for (int i = 0; i < idz.length; ++i) {
                            BreakpointGroup bg = (BreakpointGroup)gm.get(idz[i]);
                            if (bg == null) {
                                bg = new BreakpointGroup(idz[i], propertyNames[i], g);
                                gm.put(idz[i], bg);
                            }
                            parentGroups.add(bg);
                        }
                    }
                } else if (id != null) {
                    for (int i = 0; i < parentGroups.size(); ++i) {
                        BreakpointGroup pg = (BreakpointGroup)parentGroups.get(i);
                        NestedGroupKey key = new NestedGroupKey(pg, id);
                        BreakpointGroup bg = (BreakpointGroup)gm.get(key);
                        if (bg == null) {
                            bg = new BreakpointGroup(id, propertyName, g);
                            pg.addGroup(bg);
                            gm.put(key, bg);
                        }
                        parentGroups.set(i, bg);
                    }
                } else if (idz != null) {
                    ArrayList<BreakpointGroup> newParentGroups = new ArrayList<BreakpointGroup>(parentGroups.size() * idz.length);
                    for (BreakpointGroup pg : parentGroups) {
                        for (int i = 0; i < idz.length; ++i) {
                            NestedGroupKey key = new NestedGroupKey(pg, idz[i]);
                            BreakpointGroup bg = (BreakpointGroup)gm.get(key);
                            if (bg == null) {
                                bg = new BreakpointGroup(idz[i], propertyNames[i], g);
                                pg.addGroup(bg);
                                gm.put(key, bg);
                            }
                            newParentGroups.add(bg);
                        }
                    }
                    parentGroups.clear();
                    parentGroups.addAll(newParentGroups);
                }
                if (!rootGroups.isEmpty()) continue;
                rootGroups.addAll(parentGroups);
            }
            if (parentGroups.isEmpty()) {
                breakpoints.add(b);
                continue;
            }
            for (BreakpointGroup rg : rootGroups) {
                if (groups.contains(rg)) continue;
                groups.add(rg);
            }
            for (BreakpointGroup pg : parentGroups) {
                pg.addBreakpoint((Breakpoint)b);
            }
        }
        ArrayList<Object> groupsAndBreakpoints = new ArrayList<Object>(groups.size() + breakpoints.size());
        groupsAndBreakpoints.addAll(groups);
        groupsAndBreakpoints.addAll(breakpoints);
        return groupsAndBreakpoints.toArray();
    }

    private static boolean isOpened(Project[] projects, Set<Project> openedProjectsCache, Set<Project> closedProjectsCache, Map<Project, Set<? extends Project>> subProjects) {
        if (projects != null && projects.length > 0) {
            for (Project p : projects) {
                if (p == null) {
                    return true;
                }
                if (openedProjectsCache.contains(p)) {
                    return true;
                }
                if (closedProjectsCache.contains(p)) {
                    return false;
                }
                if (!OpenProjects.getDefault().isProjectOpen(p) && !BreakpointGroup.isDependentOnAnOpened(p, openedProjectsCache, closedProjectsCache, subProjects)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean isDependentOnAnOpened(Project p, Set<Project> openedProjectsCache, Set<Project> closedProjectsCache, Map<Project, Set<? extends Project>> subProjects) {
        for (Project op : OpenProjects.getDefault().getOpenProjects()) {
            if (!BreakpointGroup.isSubProjectOf(p, op, subProjects, new HashSet<Project>())) continue;
            openedProjectsCache.add(p);
            return true;
        }
        closedProjectsCache.add(p);
        return false;
    }

    private static boolean isSubProjectOf(Project p, Project op, Map<Project, Set<? extends Project>> subProjects, Set<Project> allSubProjects) {
        Set sps = subProjects.get(op);
        if (sps == null) {
            SubprojectProvider spp = (SubprojectProvider)op.getLookup().lookup(SubprojectProvider.class);
            if (spp == null) {
                return false;
            }
            sps = spp.getSubprojects();
            subProjects.put(op, sps);
        }
        for (Project sp : sps) {
            if (allSubProjects.contains(sp)) continue;
            allSubProjects.add(sp);
            if (!p.equals(sp) && !BreakpointGroup.isSubProjectOf(p, sp, subProjects, allSubProjects)) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(Set<Project> openProjects, Project[] projects) {
        if (projects != null && projects.length > 0) {
            boolean contains = false;
            for (Project p : projects) {
                if (p == null) {
                    return true;
                }
                if (!openProjects.contains(p)) continue;
                contains = true;
                break;
            }
            return contains;
        }
        return true;
    }

    private static String getName(DebuggerEngine e) {
        Session s = (Session)e.lookupFirst(null, Session.class);
        String name = s.getName();
        String[] ls = s.getSupportedLanguages();
        if (ls.length > 1) {
            for (String l : ls) {
                DebuggerEngine en = s.getEngineForLanguage(l);
                if (en != e) continue;
                name = name + "/" + l;
                break;
            }
        }
        return name;
    }

    private static Set<Project> getCurrentSessionProjects() {
        Session currentSession = DebuggerManager.getDebuggerManager().getCurrentSession();
        if (currentSession == null) {
            return null;
        }
        List sessionProjects = currentSession.lookup(null, Project.class);
        if (sessionProjects.size() == 0) {
            return null;
        }
        return new HashSet<Project>(sessionProjects);
    }

    private static final class NestedGroupKey {
        private Object[] ids;

        public NestedGroupKey(Object[] ids) {
            this.ids = ids;
        }

        private static Object[] createIDs(BreakpointGroup g, Object id) {
            ArrayList<Object> ids = new ArrayList<Object>();
            ids.add(id);
            while (g != null) {
                ids.add(0, g.id);
                g = g.parent;
            }
            return ids.toArray();
        }

        public NestedGroupKey(BreakpointGroup g, Object id) {
            this(NestedGroupKey.createIDs(g, id));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NestedGroupKey)) {
                return false;
            }
            return Arrays.equals(((NestedGroupKey)obj).ids, this.ids);
        }

        public int hashCode() {
            return Arrays.hashCode(this.ids);
        }
    }

    static enum Group {
        NO,
        CUSTOM,
        LANGUAGE,
        TYPE,
        PROJECT,
        FILE,
        ENGINE,
        NESTED;

    }
}

