/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public abstract class AbstractCachingViewResolver
extends WebApplicationObjectSupport
implements ViewResolver {
    public static final int DEFAULT_CACHE_LIMIT = 1024;
    private static final View UNRESOLVED_VIEW = new View(){

        @Override
        public String getContentType() {
            return null;
        }

        @Override
        public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) {
        }
    };
    private volatile int cacheLimit = 1024;
    private boolean cacheUnresolved = true;
    private final Map<Object, View> viewAccessCache = new ConcurrentHashMap<Object, View>(1024);
    private final Map<Object, View> viewCreationCache = new LinkedHashMap<Object, View>(1024, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, View> eldest) {
            if (this.size() > AbstractCachingViewResolver.this.getCacheLimit()) {
                AbstractCachingViewResolver.this.viewAccessCache.remove(eldest.getKey());
                return true;
            }
            return false;
        }
    };

    public void setCacheLimit(int cacheLimit) {
        this.cacheLimit = cacheLimit;
    }

    public int getCacheLimit() {
        return this.cacheLimit;
    }

    public void setCache(boolean cache) {
        this.cacheLimit = cache ? 1024 : 0;
    }

    public boolean isCache() {
        return this.cacheLimit > 0;
    }

    public void setCacheUnresolved(boolean cacheUnresolved) {
        this.cacheUnresolved = cacheUnresolved;
    }

    public boolean isCacheUnresolved() {
        return this.cacheUnresolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public View resolveViewName(String viewName, Locale locale) throws Exception {
        if (!this.isCache()) {
            return this.createView(viewName, locale);
        }
        Object cacheKey = this.getCacheKey(viewName, locale);
        View view = this.viewAccessCache.get(cacheKey);
        if (view == null) {
            Map<Object, View> map = this.viewCreationCache;
            synchronized (map) {
                view = this.viewCreationCache.get(cacheKey);
                if (view == null) {
                    view = this.createView(viewName, locale);
                    if (view == null && this.cacheUnresolved) {
                        view = UNRESOLVED_VIEW;
                    }
                    if (view != null) {
                        this.viewAccessCache.put(cacheKey, view);
                        this.viewCreationCache.put(cacheKey, view);
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace((Object)("Cached view [" + cacheKey + "]"));
                        }
                    }
                }
            }
        }
        return view != UNRESOLVED_VIEW ? view : null;
    }

    protected Object getCacheKey(String viewName, Locale locale) {
        return viewName + "_" + locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCache(String viewName, Locale locale) {
        if (!this.isCache()) {
            this.logger.warn((Object)"View caching is SWITCHED OFF -- removal not necessary");
        } else {
            View cachedView;
            Object cacheKey = this.getCacheKey(viewName, locale);
            Map<Object, View> map = this.viewCreationCache;
            synchronized (map) {
                this.viewAccessCache.remove(cacheKey);
                cachedView = this.viewCreationCache.remove(cacheKey);
            }
            if (this.logger.isDebugEnabled()) {
                if (cachedView == null) {
                    this.logger.debug((Object)("No cached instance for view '" + cacheKey + "' was found"));
                } else {
                    this.logger.debug((Object)("Cache for view " + cacheKey + " has been cleared"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        this.logger.debug((Object)"Clearing entire view cache");
        Map<Object, View> map = this.viewCreationCache;
        synchronized (map) {
            this.viewAccessCache.clear();
            this.viewCreationCache.clear();
        }
    }

    protected View createView(String viewName, Locale locale) throws Exception {
        return this.loadView(viewName, locale);
    }

    protected abstract View loadView(String var1, Locale var2) throws Exception;
}

