/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.doctree.BlockTagTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.DocTreeVisitor;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreeScanner;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.MoveTransformer;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.netbeans.modules.refactoring.java.ui.ChangeParametersPanel;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ChangeParamsTransformer
extends RefactoringVisitor {
    private static final Set<Modifier> ALL_ACCESS_MODIFIERS = EnumSet.of(Modifier.PRIVATE, Modifier.PROTECTED, Modifier.PUBLIC);
    private static final int NOPOS = -2;
    private Set<ElementHandle<ExecutableElement>> allMethods;
    private boolean synthConstructor;
    private Boolean constructorRefactoring;
    private final ChangeParametersRefactoring.ParameterInfo[] paramInfos;
    private Collection<? extends Modifier> newModifiers;
    private String returnType;
    private boolean compatible;
    private final ChangeParametersPanel.Javadoc javaDoc;
    private final TreePathHandle refactoringSource;
    private MethodTree origMethod;
    private final String newName;
    private boolean fromIntroduce = false;
    private Problem problem;
    private LinkedList<ClassTree> problemClasses = new LinkedList();

    public ChangeParamsTransformer(ChangeParametersRefactoring.ParameterInfo[] paramInfo, Collection<? extends Modifier> newModifiers, String returnType, String newName, boolean compatible, ChangeParametersPanel.Javadoc javaDoc, Set<ElementHandle<ExecutableElement>> am, TreePathHandle refactoringSource, boolean fromIntroduce) {
        this(paramInfo, newModifiers, returnType, newName, compatible, javaDoc, am, refactoringSource);
        this.fromIntroduce = fromIntroduce;
    }

    public ChangeParamsTransformer(ChangeParametersRefactoring.ParameterInfo[] paramInfo, Collection<? extends Modifier> newModifiers, String returnType, String newName, boolean compatible, ChangeParametersPanel.Javadoc javaDoc, Set<ElementHandle<ExecutableElement>> am, TreePathHandle refactoringSource) {
        super(true);
        this.paramInfos = paramInfo;
        this.newModifiers = newModifiers;
        this.returnType = returnType;
        this.newName = newName;
        this.compatible = compatible;
        this.javaDoc = javaDoc;
        this.allMethods = am;
        this.refactoringSource = refactoringSource;
    }

    public Problem getProblem() {
        return this.problem;
    }

    @Override
    public void setWorkingCopy(WorkingCopy workingCopy) throws ToPhaseException {
        super.setWorkingCopy(workingCopy);
        if (this.origMethod == null && workingCopy.getFileObject().equals(this.refactoringSource.getFileObject())) {
            TreePath resolvedPath = this.refactoringSource.resolve((CompilationInfo)workingCopy);
            TreePath meth = JavaPluginUtils.findMethod(resolvedPath);
            this.origMethod = (MethodTree)meth.getLeaf();
        }
    }

    private void checkNewModifier(TreePath tree, Element p) throws MissingResourceException {
        if (this.newModifiers == null || this.newModifiers.contains((Object)Modifier.PUBLIC)) {
            return;
        }
        ClassTree classTree = (ClassTree)JavaRefactoringUtils.findEnclosingClass((CompilationInfo)this.workingCopy, tree, true, true, true, true, false).getLeaf();
        if (this.problemClasses.contains(classTree)) {
            return;
        }
        Element el = this.workingCopy.getTrees().getElement(this.workingCopy.getTrees().getPath(this.workingCopy.getCompilationUnit(), classTree));
        if (el == null || p == null) {
            return;
        }
        TypeElement enclosingTypeElement1 = this.workingCopy.getElementUtilities().outermostTypeElement(el);
        TypeElement enclosingTypeElement2 = this.workingCopy.getElementUtilities().outermostTypeElement(p);
        if (!this.workingCopy.getTypes().isSameType(enclosingTypeElement1.asType(), enclosingTypeElement2.asType())) {
            if (this.newModifiers.contains((Object)Modifier.PRIVATE)) {
                this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(ChangeParamsTransformer.class, (String)"ERR_StrongAccMod", (Object)((Object)Modifier.PRIVATE), (Object)enclosingTypeElement1));
                this.problemClasses.add(classTree);
            } else {
                PackageElement package1 = this.workingCopy.getElements().getPackageOf(el);
                PackageElement package2 = this.workingCopy.getElements().getPackageOf(p);
                if (!package1.getQualifiedName().equals(package2.getQualifiedName())) {
                    if (this.newModifiers.contains((Object)Modifier.PROTECTED)) {
                        if (!this.workingCopy.getTypes().isSubtype(enclosingTypeElement1.asType(), enclosingTypeElement2.asType())) {
                            this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(ChangeParamsTransformer.class, (String)"ERR_StrongAccMod", (Object)((Object)Modifier.PROTECTED), (Object)enclosingTypeElement1));
                            this.problemClasses.add(classTree);
                        }
                    } else {
                        this.problem = MoveTransformer.createProblem(this.problem, false, NbBundle.getMessage(ChangeParamsTransformer.class, (String)"ERR_StrongAccMod", (Object)"<default>", (Object)enclosingTypeElement1));
                        this.problemClasses.add(classTree);
                    }
                }
            }
        }
    }

    private void init() {
        if (this.constructorRefactoring == null) {
            Element el;
            ElementHandle<ExecutableElement> handle = this.allMethods.iterator().next();
            this.constructorRefactoring = handle.getKind() == ElementKind.CONSTRUCTOR;
            this.synthConstructor = this.constructorRefactoring != false && (el = handle.resolve((CompilationInfo)this.workingCopy)) != null && this.workingCopy.getElementUtilities().isSynthetic(el);
        }
    }

    public Tree visitCompilationUnit(CompilationUnitTree node, Element p) {
        this.init();
        return (Tree)super.visitCompilationUnit(node, (Object)p);
    }

    public Tree visitClass(ClassTree node, Element p) {
        if (this.compatible) {
            List<? extends Tree> members = node.getMembers();
            for (int i = 0; i < members.size(); ++i) {
                MethodTree newMethod;
                ExecutableElement element;
                Tree tree = members.get(i);
                if (!tree.getKind().equals((Object)Tree.Kind.METHOD) || !p.equals(element = (ExecutableElement)this.workingCopy.getTrees().getElement(new TreePath(this.getCurrentPath(), tree)))) continue;
                List<ExpressionTree> paramList = this.getNewCompatibleArguments(((MethodTree)tree).getParameters());
                MethodInvocationTree methodInvocation = this.make.MethodInvocation(Collections.emptyList(), (ExpressionTree)(this.constructorRefactoring != false ? this.make.Identifier((CharSequence)"this") : this.make.Identifier((Element)element)), paramList);
                TypeMirror methodReturnType = element.getReturnType();
                boolean hasReturn = true;
                Types types = this.workingCopy.getTypes();
                if (types.isSameType(methodReturnType, types.getNoType(TypeKind.VOID))) {
                    hasReturn = false;
                }
                StatementTree statement = null;
                statement = hasReturn ? this.make.Return((ExpressionTree)methodInvocation) : this.make.ExpressionStatement((ExpressionTree)methodInvocation);
                GeneratorUtilities genutils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
                tree = genutils.importComments(tree, this.workingCopy.getCompilationUnit());
                BlockTree body = this.make.Block(Collections.singletonList(statement), false);
                BlockTree oldBody = ((MethodTree)tree).getBody();
                genutils.copyComments((Tree)oldBody, (Tree)body, true);
                genutils.copyComments((Tree)oldBody, (Tree)body, false);
                if (!this.fromIntroduce) {
                    newMethod = this.make.Method(this.make.Modifiers(element.getModifiers()), this.newName == null ? element.getSimpleName() : this.newName, ((MethodTree)tree).getReturnType(), ((MethodTree)tree).getTypeParameters(), ((MethodTree)tree).getParameters(), ((MethodTree)tree).getThrows(), body, null, element.isVarArgs());
                } else {
                    newMethod = this.make.Method(element, body);
                    if (element.getKind() == ElementKind.CONSTRUCTOR) {
                        newMethod = this.make.Method(newMethod.getModifiers(), (CharSequence)newMethod.getName(), null, newMethod.getTypeParameters(), newMethod.getParameters(), newMethod.getThrows(), newMethod.getBody(), (ExpressionTree)newMethod.getDefaultValue(), element.isVarArgs());
                    }
                }
                genutils.copyComments(tree, (Tree)newMethod, true);
                genutils.copyComments(tree, (Tree)newMethod, false);
                ClassTree addMember = this.make.insertClassMember(node, i, (Tree)newMethod);
                this.rewrite(node, addMember);
            }
        }
        return (Tree)super.visitClass(node, (Object)p);
    }

    public Tree visitNewClass(NewClassTree tree, Element p) {
        if (this.constructorRefactoring.booleanValue() && !this.compatible && !this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            ExecutableElement constructor = (ExecutableElement)p;
            Trees trees = this.workingCopy.getTrees();
            Element el = trees.getElement(this.getCurrentPath());
            if (this.isMethodMatch(el = this.resolveAnonymousClassConstructor(el, tree, trees), p)) {
                List<ExpressionTree> arguments = this.getNewArguments(tree.getArguments(), false, constructor);
                NewClassTree nju = this.make.NewClass(tree.getEnclosingExpression(), tree.getTypeArguments(), tree.getIdentifier(), arguments, tree.getClassBody());
                this.rewrite(tree, nju);
            }
        }
        return (Tree)super.visitNewClass(tree, (Object)p);
    }

    @Override
    public DocTree visitDocComment(DocCommentTree node, Element p) {
        if (this.javaDoc != ChangeParametersPanel.Javadoc.UPDATE) {
            return node;
        }
        TreePath path = this.getCurrentDocPath().getTreePath();
        Element el = this.workingCopy.getTrees().getElement(path);
        if (this.isMethodMatch(el, p)) {
            List<? extends DocTree> blockTags = node.getBlockTags();
            LinkedList<DocTree> newTags = new LinkedList<DocTree>();
            HashMap<String, ParamTree> oldParams = new HashMap<String, ParamTree>();
            FakaParamTree fake = new FakaParamTree();
            int index = 0;
            for (DocTree docTree : blockTags) {
                if (docTree.getKind() != DocTree.Kind.PARAM || ((ParamTree)docTree).isTypeParameter()) {
                    if (docTree.getKind() == DocTree.Kind.RETURN) {
                        ReturnTree returnTree = (ReturnTree)docTree;
                    } else {
                        newTags.add(docTree);
                    }
                    if (TagComparator.compareTag(fake, docTree) == -1) continue;
                    ++index;
                    continue;
                }
                ParamTree paramTree = (ParamTree)docTree;
                oldParams.put(paramTree.getName().getName().toString(), paramTree);
            }
            for (ChangeParametersRefactoring.ParameterInfo parameterInfo : this.paramInfos) {
                ParamTree tag;
                if (parameterInfo.getOriginalIndex() == -1) {
                    tag = this.make.Param(false, this.make.DocIdentifier((CharSequence)parameterInfo.getName()), Collections.singletonList(this.make.Text("the value of " + parameterInfo.getName())));
                } else {
                    String name = ((ExecutableElement)el).getParameters().get(parameterInfo.getOriginalIndex()).getSimpleName().toString();
                    tag = (ParamTree)oldParams.get(name);
                    if (tag == null) {
                        tag = this.make.Param(false, this.make.DocIdentifier((CharSequence)parameterInfo.getName()), Collections.singletonList(this.make.Text("the value of " + parameterInfo.getName())));
                    } else if (parameterInfo.getName() != null) {
                        tag = this.make.Param(false, this.make.DocIdentifier((CharSequence)parameterInfo.getName()), tag.getDescription());
                    }
                }
                newTags.add(index++, tag);
            }
            TypeMirror typeMirror = ((ExecutableElement)el).getReturnType();
            String returnTypeString = this.returnType == null ? (typeMirror != null && typeMirror.getKind() != TypeKind.VOID ? typeMirror.toString() : null) : (this.returnType.equals("void") ? null : this.returnType);
            if (returnTypeString != null) {
                newTags.add(this.make.DocReturn(Collections.singletonList(this.make.Text("the " + returnTypeString))));
            }
            this.rewrite(path.getLeaf(), node, this.make.DocComment(node.getFirstSentence(), node.getBody(), newTags));
        }
        return node;
    }

    private Element resolveAnonymousClassConstructor(Element el, NewClassTree tree, Trees trees) {
        Tree t;
        if (el != null && tree.getClassBody() != null && (t = trees.getTree(el)) != null && t.getKind() == Tree.Kind.METHOD) {
            MethodTree constructorTree = (MethodTree)t;
            Tree superCall = constructorTree.getBody().getStatements().get(0);
            TreePath superCallPath = trees.getPath(this.getCurrentPath().getCompilationUnit(), ((ExpressionStatementTree)superCall).getExpression());
            el = trees.getElement(superCallPath);
        }
        return el;
    }

    private List<ExpressionTree> getNewCompatibleArguments(List<? extends VariableTree> parameters) {
        ArrayList<ExpressionTree> arguments = new ArrayList<ExpressionTree>();
        ChangeParametersRefactoring.ParameterInfo[] pi = this.paramInfos;
        for (int i = 0; i < pi.length; ++i) {
            int originalIndex = pi[i].getOriginalIndex();
            String value = originalIndex < 0 ? pi[i].getDefaultValue() : parameters.get(originalIndex).getName().toString();
            SourcePositions[] pos = new SourcePositions[1];
            ExpressionTree vt = this.workingCopy.getTreeUtilities().parseExpression(value, pos);
            arguments.add(vt);
        }
        return arguments;
    }

    private List<VariableTree> getNewParameters(List<? extends VariableTree> currentParameters, TreePath path) {
        ArrayList<VariableTree> arguments = new ArrayList<VariableTree>();
        boolean skipType = currentParameters.size() > 0 && (currentParameters.get(0).getType() == null || this.workingCopy.getTreeUtilities().isSynthetic(new TreePath(path, currentParameters.get(0).getType())));
        ChangeParametersRefactoring.ParameterInfo[] pi = this.paramInfos;
        for (int i = 0; i < pi.length; ++i) {
            VariableTree vt;
            String newType;
            int originalIndex = pi[i].getOriginalIndex();
            boolean isVarArgs = i == pi.length - 1 && pi[i].getType().endsWith("...");
            String string = newType = isVarArgs ? pi[i].getType().replace("...", "") : pi[i].getType();
            if (originalIndex < 0) {
                vt = this.make.Variable(this.make.Modifiers(Collections.emptySet()), (CharSequence)pi[i].getName(), skipType ? null : this.make.Identifier((CharSequence)newType), null);
            } else {
                vt = currentParameters.get(originalIndex);
                if (!skipType) {
                    com.sun.source.tree.IdentifierTree typeTree = null;
                    if (this.origMethod != null) {
                        if (!pi[i].getType().equals(this.origMethod.getParameters().get(originalIndex).getType().toString())) {
                            typeTree = this.make.Identifier((CharSequence)newType);
                        }
                    } else {
                        typeTree = this.make.Identifier((CharSequence)newType);
                    }
                    if (typeTree != null) {
                        vt = this.make.Variable(vt.getModifiers(), (CharSequence)vt.getName(), (Tree)typeTree, vt.getInitializer());
                    }
                }
            }
            arguments.add(vt);
        }
        return arguments;
    }

    private List<ExpressionTree> getNewArguments(List<? extends ExpressionTree> currentArguments, boolean passThrough, ExecutableElement method) {
        ArrayList<ExpressionTree> arguments = new ArrayList<ExpressionTree>();
        ChangeParametersRefactoring.ParameterInfo[] pi = this.paramInfos;
        for (int i = 0; i < pi.length; ++i) {
            ExpressionTree vt;
            int originalIndex = pi[i].getOriginalIndex();
            if (originalIndex < 0) {
                String value;
                SourcePositions[] pos = new SourcePositions[1];
                if (passThrough) {
                    value = pi[i].getName();
                    vt = this.workingCopy.getTreeUtilities().parseExpression(value, pos);
                } else {
                    value = pi[i].getDefaultValue();
                    if (i == pi.length - 1 && pi[i].getType().endsWith("...")) {
                        MethodInvocationTree parsedExpression = (MethodInvocationTree)this.workingCopy.getTreeUtilities().parseExpression("method(" + value + ")", pos);
                        for (ExpressionTree expressionTree : parsedExpression.getArguments()) {
                            arguments.add(this.translateExpression(expressionTree, currentArguments, method));
                        }
                        break;
                    }
                    vt = this.translateExpression(this.workingCopy.getTreeUtilities().parseExpression(value, pos), currentArguments, method);
                }
            } else {
                if (i == pi.length - 1 && pi[i].getType().endsWith("...") && method.isVarArgs() && method.getParameters().size() - 1 == originalIndex) {
                    for (int j = originalIndex; j < currentArguments.size(); ++j) {
                        arguments.add(currentArguments.get(j));
                    }
                    break;
                }
                vt = currentArguments.get(originalIndex);
            }
            arguments.add(vt);
        }
        return arguments;
    }

    public Tree visitMethodInvocation(MethodInvocationTree tree, Element p) {
        if (!(!this.constructorRefactoring.booleanValue() && this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath()) || this.compatible)) {
            ExecutableElement method = (ExecutableElement)p;
            Element el = this.workingCopy.getTrees().getElement(this.getCurrentPath());
            if (this.isMethodMatch(el, method)) {
                Element enclosingElement;
                this.checkNewModifier(this.getCurrentPath(), method);
                boolean passThrough = false;
                TreePath enclosingMethod = JavaPluginUtils.findMethod(this.getCurrentPath());
                if (enclosingMethod != null && this.isMethodMatch(enclosingElement = this.workingCopy.getTrees().getElement(enclosingMethod), method)) {
                    passThrough = true;
                }
                List<ExpressionTree> arguments = this.getNewArguments(tree.getArguments(), passThrough, method);
                MethodInvocationTree nju = this.make.MethodInvocation(tree.getTypeArguments(), this.newName != null ? (ExpressionTree)this.make.setLabel((Tree)tree.getMethodSelect(), (CharSequence)this.newName) : tree.getMethodSelect(), arguments);
                if (this.constructorRefactoring.booleanValue() && this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
                    this.rewriteSyntheticConstructor(nju);
                } else {
                    this.rewrite(tree, nju);
                }
            }
        }
        return (Tree)super.visitMethodInvocation(tree, (Object)p);
    }

    public Tree visitLambdaExpression(LambdaExpressionTree tree, Element p) {
        TreePath path = this.getCurrentPath();
        if (!this.compatible && !this.workingCopy.getTreeUtilities().isSynthetic(path)) {
            ExecutableElement method = (ExecutableElement)p;
            TypeMirror tm = this.workingCopy.getTrees().getTypeMirror(path);
            if (tm != null && this.workingCopy.getTypes().isSameType(tm, method.getEnclosingElement().asType())) {
                this.checkNewModifier(path, method);
                List<VariableTree> params = this.getNewParameters(tree.getParameters(), path);
                LambdaExpressionTree nju = this.make.LambdaExpression(params, tree.getBody());
                this.rewrite(tree, nju);
            }
        }
        return (Tree)super.visitLambdaExpression(tree, (Object)p);
    }

    private void rewriteSyntheticConstructor(MethodInvocationTree nju) {
        TreePath constructorPath;
        for (constructorPath = this.getCurrentPath(); constructorPath != null && constructorPath.getLeaf().getKind() != Tree.Kind.METHOD; constructorPath = constructorPath.getParentPath()) {
        }
        if (constructorPath != null) {
            MethodTree constrTree = (MethodTree)constructorPath.getLeaf();
            BlockTree body = constrTree.getBody();
            body = this.make.removeBlockStatement(body, 0);
            body = this.make.insertBlockStatement(body, 0, (StatementTree)this.make.ExpressionStatement((ExpressionTree)nju));
            if (this.workingCopy.getTreeUtilities().isSynthetic(constructorPath)) {
                MethodTree njuConstructor = this.make.Method(this.make.Modifiers(constrTree.getModifiers().getFlags(), constrTree.getModifiers().getAnnotations()), (CharSequence)constrTree.getName(), constrTree.getReturnType(), constrTree.getTypeParameters(), constrTree.getParameters(), constrTree.getThrows(), body, (ExpressionTree)constrTree.getDefaultValue());
                this.rewrite(constrTree, njuConstructor);
            } else {
                this.rewrite(constrTree.getBody(), body);
            }
        }
    }

    public Tree visitMethod(MethodTree tree, Element p) {
        if (this.constructorRefactoring.booleanValue() && this.isSyntheticConstructorOfAnnonymousClass(this.workingCopy.getTrees().getElement(this.getCurrentPath()))) {
            return tree;
        }
        this.renameDeclIfMatch(this.getCurrentPath(), tree, p);
        return (Tree)super.visitMethod(tree, (Object)p);
    }

    /*
     * WARNING - void declaration
     */
    private void renameDeclIfMatch(TreePath path, Tree tree, Element elementToFind) {
        if (!this.synthConstructor && this.workingCopy.getTreeUtilities().isSynthetic(path)) {
            return;
        }
        GeneratorUtilities genutils = GeneratorUtilities.get((WorkingCopy)this.workingCopy);
        MethodTree current = !this.compatible ? (MethodTree)genutils.importComments((Tree)((MethodTree)tree), this.workingCopy.getCompilationUnit()) : (MethodTree)tree;
        Element el = this.workingCopy.getTrees().getElement(path);
        if (this.isMethodMatch(el, elementToFind)) {
            Object exEl;
            String oldReturnType;
            List<? extends VariableTree> currentParameters = current.getParameters();
            ArrayList<VariableTree> newParameters = new ArrayList<VariableTree>(this.paramInfos.length);
            boolean renameParams = !this.fromIntroduce;
            ExecutableElement oMethod = (ExecutableElement)el;
            ExecutableElement refMethod = (ExecutableElement)elementToFind;
            if (oMethod != refMethod) {
                List<? extends VariableElement> oParams = oMethod.getParameters();
                List<? extends VariableElement> rParams = refMethod.getParameters();
                for (int i = 0; i < oParams.size(); ++i) {
                    if (oParams.get(i).getSimpleName().contentEquals(rParams.get(i).getSimpleName())) continue;
                    renameParams = false;
                    break;
                }
            }
            ChangeParametersRefactoring.ParameterInfo[] p = this.paramInfos;
            for (int i = 0; i < p.length; ++i) {
                VariableTree vt;
                int originalIndex = p[i].getOriginalIndex();
                if (originalIndex < 0) {
                    boolean isVarArgs = i == p.length - 1 && p[i].getType().endsWith("...");
                    vt = this.make.Variable(this.make.Modifiers(Collections.emptySet()), (CharSequence)p[i].getName(), (Tree)this.make.Identifier((CharSequence)(isVarArgs ? p[i].getType().replace("...", "") : p[i].getType())), null);
                } else {
                    void var19_27;
                    String newType;
                    VariableTree originalVt = currentParameters.get(originalIndex);
                    boolean isVarArgs = i == p.length - 1 && p[i].getType().endsWith("...");
                    String string = newType = isVarArgs ? p[i].getType().replace("...", "") : p[i].getType();
                    if (this.origMethod != null) {
                        if (p[i].getType().equals(this.origMethod.getParameters().get(originalIndex).getType().toString())) {
                            Tree tree2 = originalVt.getType();
                        } else {
                            com.sun.source.tree.IdentifierTree identifierTree = this.make.Identifier((CharSequence)newType);
                        }
                    } else {
                        com.sun.source.tree.IdentifierTree identifierTree = this.make.Identifier((CharSequence)newType);
                    }
                    vt = this.make.Variable(originalVt.getModifiers(), renameParams ? p[i].getName() : originalVt.getName(), (Tree)var19_27, originalVt.getInitializer());
                }
                newParameters.add(vt);
            }
            HashSet<Modifier> modifiers = new HashSet<Modifier>(current.getModifiers().getFlags());
            if (this.newModifiers != null && !el.getEnclosingElement().getKind().isInterface()) {
                modifiers.removeAll(ALL_ACCESS_MODIFIERS);
                modifiers.addAll(this.newModifiers);
            }
            boolean applyNewReturnType = false;
            if (this.returnType != null && !this.returnType.equals(oldReturnType = (exEl = (ExecutableElement)el).getReturnType().toString())) {
                applyNewReturnType = true;
            }
            for (VariableTree vt : newParameters) {
                PackageElement packageOf;
                void var19_34;
                Set declaredTypes = this.workingCopy.getClasspathInfo().getClassIndex().getDeclaredTypes(vt.getType().toString(), ClassIndex.NameKind.SIMPLE_NAME, EnumSet.allOf(ClassIndex.SearchScope.class));
                Iterator declaredTypesMirr = new HashSet(declaredTypes);
                Object var19_32 = null;
                for (ElementHandle elementHandle : declaredTypes) {
                    TypeElement te = this.workingCopy.getElements().getTypeElement(elementHandle.getQualifiedName());
                    if (te == null) {
                        Logger.getLogger(ChangeParamsTransformer.class.getName()).log(Level.INFO, "Cannot resolve type element \"{0}\".", elementHandle);
                        continue;
                    }
                    if (!te.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                    declaredTypesMirr.remove(elementHandle);
                }
                if (declaredTypesMirr.size() == 1) {
                    ElementHandle typeName = (ElementHandle)declaredTypesMirr.iterator().next();
                    TypeElement typeElement = this.workingCopy.getElements().getTypeElement(typeName.getQualifiedName());
                    if (typeElement == null) {
                        Logger.getLogger(ChangeParamsTransformer.class.getName()).log(Level.INFO, "Cannot resolve type element \"{0}\".", typeName);
                        continue;
                    }
                    TypeElement typeElement2 = typeElement;
                }
                if (var19_34 == null || (packageOf = this.workingCopy.getElements().getPackageOf((Element)var19_34)).getQualifiedName().toString().equals("java.lang")) continue;
                try {
                    SourceUtils.resolveImport((CompilationInfo)this.workingCopy, (TreePath)path, (String)var19_34.getQualifiedName().toString());
                }
                catch (NullPointerException nullPointerException) {
                    Exceptions.printStackTrace((Throwable)nullPointerException);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            BlockTree body = this.translateBody(current.getBody(), current.getParameters(), (ExecutableElement)el, renameParams);
            MethodTree nju = this.make.Method(this.make.Modifiers(modifiers, current.getModifiers().getAnnotations()), this.newName != null ? this.newName : current.getName(), applyNewReturnType ? this.make.Type(this.returnType) : current.getReturnType(), current.getTypeParameters(), newParameters, current.getThrows(), this.fromIntroduce ? current.getBody() : body, (ExpressionTree)current.getDefaultValue(), p.length > 0 && p[p.length - 1].getType().endsWith("..."));
            genutils.copyComments((Tree)current, (Tree)nju, true);
            genutils.copyComments((Tree)current, (Tree)nju, false);
            if (this.javaDoc == ChangeParametersPanel.Javadoc.GENERATE) {
                String returnTypeString;
                LinkedList<BlockTagTree> tags = new LinkedList<BlockTagTree>();
                for (TypeParameterTree typeParameterTree : current.getTypeParameters()) {
                    tags.add(this.make.Param(true, this.make.DocIdentifier((CharSequence)typeParameterTree.getName()), Collections.EMPTY_LIST));
                }
                for (VariableTree variableTree : newParameters) {
                    tags.add(this.make.Param(false, this.make.DocIdentifier((CharSequence)variableTree.getName()), Collections.singletonList(this.make.Text("the value of " + variableTree.getName()))));
                }
                Tree tree3 = nju.getReturnType();
                if (this.returnType == null) {
                    boolean hasReturn = false;
                    if (tree3 != null && tree3.getKind().equals((Object)Tree.Kind.PRIMITIVE_TYPE) && !((PrimitiveTypeTree)tree3).getPrimitiveTypeKind().equals((Object)TypeKind.VOID)) {
                        hasReturn = true;
                    }
                    returnTypeString = hasReturn ? tree3.toString() : null;
                } else {
                    returnTypeString = this.returnType.equals("void") ? null : this.returnType;
                }
                if (returnTypeString != null) {
                    tags.add(this.make.DocReturn(Collections.singletonList(this.make.Text("the " + returnTypeString))));
                }
                for (ExpressionTree expressionTree : current.getThrows()) {
                    tags.add(this.make.Throws(this.make.Reference(expressionTree, null, null), Collections.EMPTY_LIST));
                }
                DocCommentTree newDoc = this.make.DocComment(Collections.EMPTY_LIST, Collections.EMPTY_LIST, tags);
                this.rewrite(this.synthConstructor ? nju : tree, null, newDoc);
            }
            this.rewrite(tree, this.make.asReplacementOf((Tree)nju, tree));
        }
    }

    private boolean isMethodMatch(Element method, Element p) {
        if (!RefactoringUtils.isExecutableElement(method)) {
            return false;
        }
        if (this.compatible) {
            return method == p;
        }
        if (this.allMethods != null) {
            for (ElementHandle<ExecutableElement> mh : this.allMethods) {
                ExecutableElement baseMethod = (ExecutableElement)mh.resolve((CompilationInfo)this.workingCopy);
                if (baseMethod == null) {
                    Logger.getLogger("org.netbeans.modules.refactoring.java").info("ChangeParamsTransformer cannot resolve " + mh);
                    continue;
                }
                if (!baseMethod.equals(method) && !this.workingCopy.getElements().overrides((ExecutableElement)method, baseMethod, this.workingCopy.getElementUtilities().enclosingTypeElement((Element)baseMethod))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSyntheticConstructorOfAnnonymousClass(Element el) {
        if (el != null && el.getKind() == ElementKind.CONSTRUCTOR && this.workingCopy.getElementUtilities().isSynthetic(el)) {
            Element enclosingElement = el.getEnclosingElement();
            return enclosingElement != null && enclosingElement.getKind().isClass() && ((TypeElement)enclosingElement).getNestingKind() == NestingKind.ANONYMOUS;
        }
        return false;
    }

    private BlockTree translateBody(BlockTree blockTree, final List<? extends VariableTree> parameters, ExecutableElement p, boolean renameParams) {
        final HashMap original2Translated = new HashMap();
        boolean changed = false;
        do {
            original2Translated.clear();
            if (renameParams) {
                ErrorAwareTreeScanner<Void, Void> idScan = new ErrorAwareTreeScanner<Void, Void>(){

                    public Void visitIdentifier(com.sun.source.tree.IdentifierTree node, Void p) {
                        String name = node.getName().toString();
                        if (ChangeParamsTransformer.this.getCurrentPath().getParentPath().getLeaf().getKind() != Tree.Kind.MEMBER_SELECT) {
                            for (int i = 0; i < ChangeParamsTransformer.this.paramInfos.length; ++i) {
                                ChangeParametersRefactoring.ParameterInfo parameterInfo = ChangeParamsTransformer.this.paramInfos[i];
                                if (parameterInfo.getOriginalIndex() < 0 || !((VariableTree)parameters.get(parameterInfo.getOriginalIndex())).getName().contentEquals(name)) continue;
                                original2Translated.put(node, ChangeParamsTransformer.this.make.Identifier((CharSequence)parameterInfo.getName()));
                            }
                        }
                        return (Void)super.visitIdentifier(node, (Object)p);
                    }
                };
                idScan.scan((Tree)blockTree, null);
                blockTree = (BlockTree)this.workingCopy.getTreeUtilities().translate((Tree)blockTree, original2Translated);
            }
            original2Translated.clear();
            ErrorAwareTreeScanner<Boolean, ExecutableElement> methodScanner = new ErrorAwareTreeScanner<Boolean, ExecutableElement>(){

                public Boolean visitMethodInvocation(MethodInvocationTree node, ExecutableElement p) {
                    Element el;
                    boolean changed = false;
                    TreePath path = ChangeParamsTransformer.this.workingCopy.getTrees().getPath(ChangeParamsTransformer.this.workingCopy.getCompilationUnit(), node);
                    if (path != null && ChangeParamsTransformer.this.isMethodMatch(el = ChangeParamsTransformer.this.workingCopy.getTrees().getElement(path), p)) {
                        List arguments = ChangeParamsTransformer.this.getNewArguments(node.getArguments(), false, p);
                        MethodInvocationTree nju = ChangeParamsTransformer.this.make.MethodInvocation(node.getTypeArguments(), ChangeParamsTransformer.this.newName != null ? (ExpressionTree)ChangeParamsTransformer.this.make.setLabel((Tree)node.getMethodSelect(), (CharSequence)ChangeParamsTransformer.this.newName) : node.getMethodSelect(), arguments);
                        original2Translated.put(node, nju);
                        changed = true;
                    }
                    return (Boolean)super.visitMethodInvocation(node, (Object)p) != false || changed;
                }

                public Boolean reduce(Boolean r1, Boolean r2) {
                    return r1 == Boolean.TRUE || r2 == Boolean.TRUE;
                }
            };
            boolean bl = changed = methodScanner.scan((Tree)blockTree, (Object)p) == Boolean.TRUE;
            if (!changed) continue;
            blockTree = (BlockTree)this.workingCopy.getTreeUtilities().translate((Tree)blockTree, original2Translated);
        } while (changed);
        return blockTree;
    }

    private ExpressionTree translateExpression(ExpressionTree expressionTree, final List<? extends ExpressionTree> currentArguments, ExecutableElement p) {
        final HashMap original2Translated = new HashMap();
        boolean changed = false;
        do {
            original2Translated.clear();
            ErrorAwareTreeScanner<Void, Void> idScan = new ErrorAwareTreeScanner<Void, Void>(){

                public Void visitIdentifier(com.sun.source.tree.IdentifierTree node, Void p) {
                    String name = node.getName().toString();
                    if (ChangeParamsTransformer.this.getCurrentPath().getParentPath().getLeaf().getKind() != Tree.Kind.MEMBER_SELECT) {
                        for (int i = 0; i < ChangeParamsTransformer.this.paramInfos.length; ++i) {
                            ChangeParametersRefactoring.ParameterInfo parameterInfo = ChangeParamsTransformer.this.paramInfos[i];
                            if (parameterInfo.getOriginalIndex() < 0 || !parameterInfo.getName().equals(name)) continue;
                            original2Translated.put(node, currentArguments.get(parameterInfo.getOriginalIndex()));
                        }
                    }
                    return (Void)super.visitIdentifier(node, (Object)p);
                }
            };
            idScan.scan((Tree)expressionTree, null);
            expressionTree = (ExpressionTree)this.workingCopy.getTreeUtilities().translate((Tree)expressionTree, original2Translated);
            original2Translated.clear();
            ErrorAwareTreeScanner<Boolean, ExecutableElement> methodScanner = new ErrorAwareTreeScanner<Boolean, ExecutableElement>(){

                public Boolean visitMethodInvocation(MethodInvocationTree node, ExecutableElement p) {
                    Element el;
                    boolean changed = false;
                    TreePath path = ChangeParamsTransformer.this.workingCopy.getTrees().getPath(ChangeParamsTransformer.this.workingCopy.getCompilationUnit(), node);
                    if (path != null && ChangeParamsTransformer.this.isMethodMatch(el = ChangeParamsTransformer.this.workingCopy.getTrees().getElement(path), p)) {
                        List arguments = ChangeParamsTransformer.this.getNewArguments(node.getArguments(), false, p);
                        MethodInvocationTree nju = ChangeParamsTransformer.this.make.MethodInvocation(node.getTypeArguments(), ChangeParamsTransformer.this.newName != null ? (ExpressionTree)ChangeParamsTransformer.this.make.setLabel((Tree)node.getMethodSelect(), (CharSequence)ChangeParamsTransformer.this.newName) : node.getMethodSelect(), arguments);
                        original2Translated.put(node, nju);
                        changed = true;
                    }
                    return (Boolean)super.visitMethodInvocation(node, (Object)p) != false || changed;
                }

                public Boolean reduce(Boolean r1, Boolean r2) {
                    return r1 == Boolean.TRUE || r2 == Boolean.TRUE;
                }
            };
            boolean bl = changed = methodScanner.scan((Tree)expressionTree, (Object)p) == Boolean.TRUE;
            if (!changed) continue;
            expressionTree = (ExpressionTree)this.workingCopy.getTreeUtilities().translate((Tree)expressionTree, original2Translated);
        } while (changed);
        return expressionTree;
    }

    private static class FakaParamTree
    implements ParamTree {
        @Override
        public boolean isTypeParameter() {
            return false;
        }

        @Override
        public IdentifierTree getName() {
            return null;
        }

        @Override
        public List<? extends DocTree> getDescription() {
            return null;
        }

        @Override
        public String getTagName() {
            return null;
        }

        @Override
        public DocTree.Kind getKind() {
            return DocTree.Kind.PARAM;
        }

        @Override
        public <R, D> R accept(DocTreeVisitor<R, D> visitor, D data) {
            return null;
        }
    }

    private static class TagComparator
    implements Comparator<DocTree> {
        private static final int HIGHER = -1;
        private static final int EQUAL = 0;
        private static final int LOWER = 1;

        private TagComparator() {
        }

        @Override
        public int compare(DocTree t, DocTree t1) {
            return TagComparator.compareTag(t, t1);
        }

        public static int compareTag(DocTree t, DocTree t1) {
            if (t.getKind() == t1.getKind()) {
                if (t.getKind() == DocTree.Kind.PARAM) {
                    ParamTree p = (ParamTree)t;
                    ParamTree p1 = (ParamTree)t1;
                    if (p.isTypeParameter() && !p1.isTypeParameter()) {
                        return -1;
                    }
                    if (!p.isTypeParameter() && p1.isTypeParameter()) {
                        return 1;
                    }
                }
                return 0;
            }
            switch (t.getKind()) {
                case AUTHOR: {
                    return -1;
                }
                case VERSION: {
                    if (t1.getKind() == DocTree.Kind.AUTHOR) {
                        return 1;
                    }
                    return -1;
                }
                case PARAM: {
                    if (t1.getKind() == DocTree.Kind.AUTHOR || t1.getKind() == DocTree.Kind.VERSION) {
                        return 1;
                    }
                    return -1;
                }
                case RETURN: {
                    if (t1.getKind() == DocTree.Kind.AUTHOR || t1.getKind() == DocTree.Kind.VERSION || t1.getKind() == DocTree.Kind.PARAM) {
                        return 1;
                    }
                    return -1;
                }
                case EXCEPTION: {
                    if (t1.getKind() == DocTree.Kind.AUTHOR || t1.getKind() == DocTree.Kind.VERSION || t1.getKind() == DocTree.Kind.PARAM || t1.getKind() == DocTree.Kind.RETURN) {
                        return 1;
                    }
                    return -1;
                }
                case THROWS: {
                    if (t1.getKind() == DocTree.Kind.AUTHOR || t1.getKind() == DocTree.Kind.VERSION || t1.getKind() == DocTree.Kind.PARAM || t1.getKind() == DocTree.Kind.RETURN || t1.getKind() == DocTree.Kind.EXCEPTION) {
                        return 1;
                    }
                    return -1;
                }
                case SEE: {
                    if (t1.getKind() == DocTree.Kind.AUTHOR || t1.getKind() == DocTree.Kind.VERSION || t1.getKind() == DocTree.Kind.PARAM || t1.getKind() == DocTree.Kind.RETURN || t1.getKind() == DocTree.Kind.EXCEPTION || t1.getKind() == DocTree.Kind.THROWS) {
                        return 1;
                    }
                    return -1;
                }
                case SINCE: {
                    if (t1.getKind() == DocTree.Kind.AUTHOR || t1.getKind() == DocTree.Kind.VERSION || t1.getKind() == DocTree.Kind.PARAM || t1.getKind() == DocTree.Kind.RETURN || t1.getKind() == DocTree.Kind.EXCEPTION || t1.getKind() == DocTree.Kind.THROWS || t1.getKind() == DocTree.Kind.SEE) {
                        return 1;
                    }
                    return -1;
                }
                case SERIAL: 
                case SERIAL_DATA: 
                case SERIAL_FIELD: {
                    if (t1.getKind() == DocTree.Kind.AUTHOR || t1.getKind() == DocTree.Kind.VERSION || t1.getKind() == DocTree.Kind.PARAM || t1.getKind() == DocTree.Kind.RETURN || t1.getKind() == DocTree.Kind.EXCEPTION || t1.getKind() == DocTree.Kind.THROWS || t1.getKind() == DocTree.Kind.SEE || t1.getKind() == DocTree.Kind.SINCE) {
                        return 1;
                    }
                    return -1;
                }
                case DEPRECATED: {
                    if (t1.getKind() == DocTree.Kind.UNKNOWN_BLOCK_TAG) {
                        return -1;
                    }
                    return 1;
                }
                case UNKNOWN_BLOCK_TAG: {
                    return 1;
                }
            }
            return 1;
        }
    }
}

