/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.adapter.jetty;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketFrame;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.springframework.util.Assert;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.PongMessage;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.adapter.jetty.JettyWebSocketSession;
import org.springframework.web.socket.handler.ExceptionWebSocketHandlerDecorator;

@WebSocket
public class JettyWebSocketHandlerAdapter {
    private static final Log logger = LogFactory.getLog(JettyWebSocketHandlerAdapter.class);
    private final WebSocketHandler webSocketHandler;
    private final JettyWebSocketSession wsSession;

    public JettyWebSocketHandlerAdapter(WebSocketHandler webSocketHandler, JettyWebSocketSession wsSession) {
        Assert.notNull((Object)webSocketHandler, (String)"webSocketHandler must not be null");
        Assert.notNull((Object)wsSession, (String)"wsSession must not be null");
        this.webSocketHandler = webSocketHandler;
        this.wsSession = wsSession;
    }

    @OnWebSocketConnect
    public void onWebSocketConnect(Session session) {
        try {
            this.wsSession.initializeNativeSession(session);
            this.webSocketHandler.afterConnectionEstablished(this.wsSession);
        }
        catch (Throwable t) {
            ExceptionWebSocketHandlerDecorator.tryCloseWithError(this.wsSession, t, logger);
        }
    }

    @OnWebSocketMessage
    public void onWebSocketText(String payload) {
        TextMessage message = new TextMessage(payload);
        try {
            this.webSocketHandler.handleMessage(this.wsSession, message);
        }
        catch (Throwable t) {
            ExceptionWebSocketHandlerDecorator.tryCloseWithError(this.wsSession, t, logger);
        }
    }

    @OnWebSocketMessage
    public void onWebSocketBinary(byte[] payload, int offset, int length) {
        BinaryMessage message = new BinaryMessage(payload, offset, length, true);
        try {
            this.webSocketHandler.handleMessage(this.wsSession, message);
        }
        catch (Throwable t) {
            ExceptionWebSocketHandlerDecorator.tryCloseWithError(this.wsSession, t, logger);
        }
    }

    @OnWebSocketFrame
    public void onWebSocketFrame(Frame frame) {
        if (10 == frame.getOpCode()) {
            PongMessage message = new PongMessage(frame.getPayload());
            try {
                this.webSocketHandler.handleMessage(this.wsSession, message);
            }
            catch (Throwable t) {
                ExceptionWebSocketHandlerDecorator.tryCloseWithError(this.wsSession, t, logger);
            }
        }
    }

    @OnWebSocketClose
    public void onWebSocketClose(int statusCode, String reason) {
        CloseStatus closeStatus = new CloseStatus(statusCode, reason);
        try {
            this.webSocketHandler.afterConnectionClosed(this.wsSession, closeStatus);
        }
        catch (Throwable t) {
            logger.error((Object)("Unhandled error for " + this.wsSession), t);
        }
    }

    @OnWebSocketError
    public void onWebSocketError(Throwable cause) {
        try {
            this.webSocketHandler.handleTransportError(this.wsSession, cause);
        }
        catch (Throwable t) {
            ExceptionWebSocketHandlerDecorator.tryCloseWithError(this.wsSession, t, logger);
        }
    }
}

