/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.util.Locale;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataCollector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxBugzillaQueryContentHandler
extends DefaultHandler {
    private StringBuffer characters;
    private final TaskDataCollector collector;
    private final String repositoryUrl;
    private int resultCount;
    private final TaskAttributeMapper mapper;
    private TaskData taskData;

    public SaxBugzillaQueryContentHandler(String repositoryUrl, TaskDataCollector collector, TaskAttributeMapper mapper) {
        this.repositoryUrl = repositoryUrl;
        this.collector = collector;
        this.mapper = mapper;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.characters.append(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.characters = new StringBuffer();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String parsedText = this.characters.toString();
        BugzillaAttribute tag = BugzillaAttribute.UNKNOWN;
        try {
            String tagName = localName.trim().toUpperCase(Locale.ENGLISH);
            try {
                tag = BugzillaAttribute.valueOf(tagName);
            }
            catch (IllegalArgumentException e) {
                if (tagName.equals("ASSIGNED_TO_REALNAME")) {
                    tag = BugzillaAttribute.ASSIGNED_TO_NAME;
                }
                if (tagName.equals("REPORTER_REALNAME")) {
                    tag = BugzillaAttribute.REPORTER_NAME;
                }
                throw e;
            }
            switch (tag) {
                case QUERY_TIMESTAMP: {
                    if (this.collector instanceof BugzillaTaskDataCollector && parsedText != null && parsedText.length() > 0) {
                        BugzillaTaskDataCollector bCollector = (BugzillaTaskDataCollector)this.collector;
                        bCollector.setQueryTimestamp(parsedText);
                    }
                    break;
                }
                case ID: {
                    this.taskData = new TaskData(this.mapper, this.getConnectorKind(), this.repositoryUrl, parsedText);
                    this.taskData.setPartial(true);
                    break;
                }
                case SHORT_SHORT_DESC: {
                    if (this.taskData != null) {
                        BugzillaTaskDataHandler.createAttribute(this.taskData, BugzillaAttribute.SHORT_DESC).setValue(parsedText);
                    }
                    break;
                }
                case LI: {
                    if (this.taskData != null) {
                        this.collector.accept(this.taskData);
                    }
                    ++this.resultCount;
                    break;
                }
                default: {
                    if (this.taskData != null) {
                        BugzillaTaskDataHandler.createAttribute(this.taskData, tag).setValue(parsedText);
                    }
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            if (e instanceof IllegalArgumentException) {
                return;
            }
            throw e;
        }
    }

    protected String getConnectorKind() {
        return this.mapper.getTaskRepository().getConnectorKind();
    }

    public int getResultCount() {
        return this.resultCount;
    }
}

