// Generated by gmmproc 2.54.1 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_AUDIOBASESRC_H
#define _GSTREAMERMM_AUDIOBASESRC_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/audio/gstaudiobasesrc.h>
#include <gstreamermm/pushsrc.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GstAudioBaseSrc = struct _GstAudioBaseSrc;
using GstAudioBaseSrcClass = struct _GstAudioBaseSrcClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gst
{ class AudioBaseSrc_Class; } // namespace Gst
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gst
{

class AudioRingBuffer;

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var AudioBaseSrcSlaveMethod AUDIO_BASE_SRC_SLAVE_RESAMPLE
 * Resample to match the master clock.
 * 
 *  @var AudioBaseSrcSlaveMethod AUDIO_BASE_SRC_SLAVE_RETIMESTAMP
 * Retimestamp output buffers with master
 * clock time.
 * 
 *  @var AudioBaseSrcSlaveMethod AUDIO_BASE_SRC_SLAVE_SKEW
 * Adjust capture pointer when master clock
 * drifts too much.
 * 
 *  @var AudioBaseSrcSlaveMethod AUDIO_BASE_SRC_SLAVE_NONE
 * No adjustment is done.
 * 
 *  @enum AudioBaseSrcSlaveMethod
 * 
 * Different possible clock slaving algorithms when the internal audio clock was
 * not selected as the pipeline clock.
 *
 * @ingroup gstreamermmEnums
 */
enum AudioBaseSrcSlaveMethod
{
  AUDIO_BASE_SRC_SLAVE_RESAMPLE,
  AUDIO_BASE_SRC_SLAVE_RETIMESTAMP,
  AUDIO_BASE_SRC_SLAVE_SKEW,
  AUDIO_BASE_SRC_SLAVE_NONE
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::AudioBaseSrcSlaveMethod> : public Glib::Value_Enum<Gst::AudioBaseSrcSlaveMethod>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{


/** The base class for audio sources.
 * This is the base class for audio sources. Subclasses need to implement the
 * create_ringbuffer_vfunc vmethod. This base class will then take care of
 * reading samples from the audioringbuffer, synchronisation and flushing.
 *
 * Last reviewed on 2016-04-23 (1.8.0).
 *
 * @ingroup GstBaseClasses
 */

class AudioBaseSrc : public Gst::PushSrc
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = AudioBaseSrc;
  using CppClassType = AudioBaseSrc_Class;
  using BaseObjectType = GstAudioBaseSrc;
  using BaseClassType = GstAudioBaseSrcClass;

  // noncopyable
  AudioBaseSrc(const AudioBaseSrc&) = delete;
  AudioBaseSrc& operator=(const AudioBaseSrc&) = delete;

private:  friend class AudioBaseSrc_Class;
  static CppClassType audiobasesrc_class_;

protected:
  explicit AudioBaseSrc(const Glib::ConstructParams& construct_params);
  explicit AudioBaseSrc(GstAudioBaseSrc* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  AudioBaseSrc(AudioBaseSrc&& src) noexcept;
  AudioBaseSrc& operator=(AudioBaseSrc&& src) noexcept;

  ~AudioBaseSrc() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstAudioBaseSrc*       gobj()       { return reinterpret_cast<GstAudioBaseSrc*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstAudioBaseSrc* gobj() const { return reinterpret_cast<GstAudioBaseSrc*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstAudioBaseSrc* gobj_copy();

private:


public:
  /** Get the Gst::Clock of the Gst::AudioSrc.
   */
  Glib::RefPtr<Gst::Clock> get_clock();
  Glib::RefPtr<const Gst::Clock> get_clock() const;

  
  /** Create and return the Gst::AudioRingBuffer for @a src. This function will call
   * the ::create_ringbuffer vmethod and will set @a src as the parent of the
   * returned buffer (see Gst::Object::set_parent()).
   * 
   * @return The new ringbuffer of @a src.
   */
  Glib::RefPtr<Gst::AudioRingBuffer> create_ring_buffer();

  
  /** Controls whether @a src will provide a clock or not. If @a provide is <tt>true</tt>,
   * Gst::Element::provide_clock() will return a clock that reflects the datarate
   * of @a src. If @a provide is <tt>false</tt>, Gst::Element::provide_clock() will return <tt>nullptr</tt>.
   * 
   * @param provide New state.
   */
  void set_provide_clock(bool provide);
  
  /** Queries whether @a src will provide a clock or not. See also
   * gst_audio_base_src_set_provide_clock.
   * 
   * @return <tt>true</tt> if @a src will provide a clock.
   */
  bool get_provide_clock() const;
  
  /** Controls how clock slaving will be performed in @a src.
   * 
   * @param method The new slave method.
   */
  void set_slave_method(Gst::AudioBaseSrcSlaveMethod method);
  
  /** Get the current slave method used by @a src.
   * 
   * @return The current slave method used by @a src.
   */
  Gst::AudioBaseSrcSlaveMethod get_slave_method() const;

  /** Actual configured size of audio buffer in microseconds.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< gint64 > property_actual_buffer_time() const;


  /** Actual configured audio latency in microseconds.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< gint64 > property_actual_latency_time() const;


  /** Size of audio buffer in microseconds. This is the maximum amount of data that is buffered in the device and the maximum latency that the source reports. This value might be ignored by the element if necessary; see 'actual-buffer-time'.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< gint64 > property_buffer_time() ;

/** Size of audio buffer in microseconds. This is the maximum amount of data that is buffered in the device and the maximum latency that the source reports. This value might be ignored by the element if necessary; see 'actual-buffer-time'.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< gint64 > property_buffer_time() const;

  /** The minimum amount of data to read in each iteration in microseconds. This is the minimum latency that the source reports. This value might be ignored by the element if necessary; see 'actual-latency-time'.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< gint64 > property_latency_time() ;

/** The minimum amount of data to read in each iteration in microseconds. This is the minimum latency that the source reports. This value might be ignored by the element if necessary; see 'actual-latency-time'.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< gint64 > property_latency_time() const;

  /** Provide a clock to be used as the global pipeline clock.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_provide_clock() ;

/** Provide a clock to be used as the global pipeline clock.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_provide_clock() const;


  /** Algorithm used to match the rate of the masterclock.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< AudioBaseSrcSlaveMethod > property_slave_method() ;

/** Algorithm used to match the rate of the masterclock.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< AudioBaseSrcSlaveMethod > property_slave_method() const;


  /** vfunc to create and return a Gst::AudioRingBuffer to read from.
   */
    virtual Glib::RefPtr<Gst::AudioRingBuffer> create_ring_buffer_vfunc();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::AudioBaseSrc
   */
  Glib::RefPtr<Gst::AudioBaseSrc> wrap(GstAudioBaseSrc* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_AUDIOBASESRC_H */

