/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.layout;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LayoutPresetPersistence {
    private Map<String, List<Preset>> presets = new HashMap<String, List<Preset>>();

    public LayoutPresetPersistence() {
        this.loadPresets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePreset(String name, Layout layout) {
        Preset preset = this.addPreset(new Preset(name, layout));
        FileOutputStream fos = null;
        try {
            FileObject folder = FileUtil.getConfigFile((String)"layoutpresets");
            if (folder == null) {
                folder = FileUtil.getConfigRoot().createFolder("layoutpresets");
            }
            File presetFile = new File(FileUtil.toFile((FileObject)folder), name + ".xml");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            document.setXmlVersion("1.0");
            document.setXmlStandalone(true);
            preset.writeXML(document);
            fos = new FileOutputStream(presetFile);
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(fos);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            Logger.getLogger("").log(Level.SEVERE, "Error while writing preset file", e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void loadPreset(Preset preset, Layout layout) {
        for (LayoutProperty p : layout.getProperties()) {
            for (int i = 0; i < preset.propertyNames.size(); ++i) {
                if (!p.getCanonicalName().equalsIgnoreCase((String)preset.propertyNames.get(i)) && !p.getProperty().getName().equalsIgnoreCase((String)preset.propertyNames.get(i))) continue;
                try {
                    p.getProperty().setValue(preset.propertyValues.get(i));
                    continue;
                }
                catch (Exception e) {
                    Logger.getLogger("").log(Level.SEVERE, "Error while setting preset property", e);
                }
            }
        }
    }

    public List<Preset> getPresets(Layout layout) {
        return this.presets.get(layout.getClass().getName());
    }

    private void loadPresets() {
        FileObject folder = FileUtil.getConfigFile((String)"layoutpresets");
        if (folder != null) {
            for (FileObject child : folder.getChildren()) {
                if (!child.isValid() || !child.hasExt("xml")) continue;
                try {
                    InputStream stream = child.getInputStream();
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document document = builder.parse(stream);
                    Preset preset = new Preset(document);
                    this.addPreset(preset);
                }
                catch (Exception e) {
                    Logger.getLogger("").log(Level.SEVERE, "Error while reading preset file", e);
                }
            }
        }
    }

    private Preset addPreset(Preset preset) {
        List<Preset> layoutPresets = this.presets.get(preset.layoutClassName);
        if (layoutPresets == null) {
            layoutPresets = new ArrayList<Preset>();
            this.presets.put(preset.layoutClassName, layoutPresets);
        }
        for (Preset p : layoutPresets) {
            if (!p.equals(preset)) continue;
            return p;
        }
        layoutPresets.add(preset);
        return preset;
    }

    protected static class Preset {
        private List<String> propertyNames = new ArrayList<String>();
        private List<Object> propertyValues = new ArrayList<Object>();
        private String layoutClassName;
        private String name;

        private Preset(String name, Layout layout) {
            this.name = name;
            this.layoutClassName = layout.getClass().getName();
            for (LayoutProperty p : layout.getProperties()) {
                try {
                    Object value = p.getProperty().getValue();
                    if (value == null) continue;
                    this.propertyNames.add(p.getCanonicalName());
                    this.propertyValues.add(value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private Preset(Document document) {
            this.readXML(document);
        }

        public void readXML(Document document) {
            NodeList propertiesList = document.getDocumentElement().getElementsByTagName("properties");
            if (propertiesList.getLength() > 0) {
                for (int j = 0; j < propertiesList.getLength(); ++j) {
                    Node m = propertiesList.item(j);
                    if (m.getNodeType() != 1) continue;
                    Element propertiesE = (Element)m;
                    this.layoutClassName = propertiesE.getAttribute("layoutClassName");
                    this.name = propertiesE.getAttribute("name");
                    NodeList propertyList = propertiesE.getElementsByTagName("property");
                    for (int i = 0; i < propertyList.getLength(); ++i) {
                        String valStr;
                        Node n = propertyList.item(i);
                        if (n.getNodeType() != 1) continue;
                        Element propertyE = (Element)n;
                        String propStr = propertyE.getAttribute("property");
                        String classStr = propertyE.getAttribute("class");
                        Object value = this.parse(classStr, valStr = propertyE.getTextContent());
                        if (value == null) continue;
                        this.propertyNames.add(propStr);
                        this.propertyValues.add(value);
                    }
                    break;
                }
            }
        }

        private Object parse(String classStr, String str) {
            try {
                Class<?> c = Class.forName(classStr);
                if (c.equals(Boolean.class)) {
                    return new Boolean(str);
                }
                if (c.equals(Integer.class)) {
                    return new Integer(str);
                }
                if (c.equals(Float.class)) {
                    return new Float(str);
                }
                if (c.equals(Double.class)) {
                    return new Double(str);
                }
                if (c.equals(Long.class)) {
                    return new Long(str);
                }
                if (c.equals(String.class)) {
                    return str;
                }
            }
            catch (ClassNotFoundException ex) {
                return null;
            }
            return null;
        }

        public void writeXML(Document document) {
            Element rootE = document.createElement("layoutproperties");
            Element propertiesE = document.createElement("properties");
            propertiesE.setAttribute("layoutClassName", this.layoutClassName);
            propertiesE.setAttribute("name", this.name);
            propertiesE.setAttribute("version", "0.7");
            for (int i = 0; i < this.propertyNames.size(); ++i) {
                Element propertyE = document.createElement("property");
                propertyE.setAttribute("property", this.propertyNames.get(i));
                propertyE.setAttribute("class", this.propertyValues.get(i).getClass().getName());
                propertyE.setTextContent(this.propertyValues.get(i).toString());
                propertiesE.appendChild(propertyE);
            }
            rootE.appendChild(propertiesE);
            document.appendChild(rootE);
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Preset other = (Preset)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hash = 3;
            hash = 37 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }
    }
}

