define(["cardBuilder","skinManager","loading","connectionManager","apphost","layoutManager","scrollHelper","focusManager","emby-itemscontainer","emby-scroller"],function(cardBuilder,skinManager,loading,connectionManager,appHost,layoutManager,scrollHelper,focusManager){"use strict";function enableScrollX(){return!0}function MusicSuggestionsTab(view,params){this.view=view,this.params=params,this.apiClient=connectionManager.getApiClient(params.serverId),initLayout(view),this.latestItemsContainer=view.querySelector(".latestSection .itemsContainer"),this.latestItemsContainer.fetchData=fetchLatestItems.bind(this),this.latestItemsContainer.getItemsHtml=getLatestItemsHtml.bind(this),this.latestItemsContainer.parentContainer=view.querySelector(".latestSection"),this.recentlyPlayedItemsContainer=view.querySelector(".recentlyPlayedSection .itemsContainer"),this.recentlyPlayedItemsContainer.fetchData=fetchRecentlyPlayedItems.bind(this),this.recentlyPlayedItemsContainer.getItemsHtml=getRecentlyPlayedItemsHtml.bind(this),this.recentlyPlayedItemsContainer.parentContainer=view.querySelector(".recentlyPlayedSection"),this.frequentlyPlayedItemsContainer=view.querySelector(".frequentlyPlayedSection .itemsContainer"),this.frequentlyPlayedItemsContainer.fetchData=fetchFrequentlyPlayedItems.bind(this),this.frequentlyPlayedItemsContainer.getItemsHtml=getFrequentlyPlayedItemsHtml.bind(this),this.frequentlyPlayedItemsContainer.parentContainer=view.querySelector(".frequentlyPlayedSection"),this.favoriteArtistsItemsContainer=view.querySelector(".favoriteArtistsSection .itemsContainer"),this.favoriteArtistsItemsContainer.fetchData=fetchFavoriteArtists.bind(this),this.favoriteArtistsItemsContainer.getItemsHtml=getFavoriteArtistItemsHtml.bind(this),this.favoriteArtistsItemsContainer.parentContainer=view.querySelector(".favoriteArtistsSection"),this.favoriteAlbumsItemsContainer=view.querySelector(".favoriteAlbumsSection .itemsContainer"),this.favoriteAlbumsItemsContainer.fetchData=fetchFavoriteAlbums.bind(this),this.favoriteAlbumsItemsContainer.getItemsHtml=getFavoriteAlbumItemsHtml.bind(this),this.favoriteAlbumsItemsContainer.parentContainer=view.querySelector(".favoriteAlbumsSection"),this.favoriteSongsItemsContainer=view.querySelector(".favoriteSongsSection .itemsContainer"),this.favoriteSongsItemsContainer.fetchData=fetchFavoriteSongs.bind(this),this.favoriteSongsItemsContainer.getItemsHtml=getFavoriteSongItemsHtml.bind(this),this.favoriteSongsItemsContainer.parentContainer=view.querySelector(".favoriteSongsSection"),params.parentId&&(this.latestItemsContainer.setAttribute("data-parentid",params.parentId),this.recentlyPlayedItemsContainer.setAttribute("data-parentid",params.parentId),this.frequentlyPlayedItemsContainer.setAttribute("data-parentid",params.parentId),this.favoriteArtistsItemsContainer.setAttribute("data-parentid",params.parentId),this.favoriteAlbumsItemsContainer.setAttribute("data-parentid",params.parentId),this.favoriteSongsItemsContainer.setAttribute("data-parentid",params.parentId)),initMoreButtons(view,params)}function initMoreButtons(view,params){[].forEach.call(view.querySelectorAll(".sectionTitleTextButton-link"),function(link){var href=link.getAttribute("data-href");href&&(link.href=skinManager.mapRoute(href+"&serverId="+params.serverId))})}function initLayout(view){for(var containers=view.querySelectorAll(".autoScrollSection"),i=0,length=containers.length;i<length;i++){var html,monitor,section=containers[i];section.classList.contains("recentlyPlayedSection")||section.classList.contains("frequentlyPlayedSection")?monitor="audioplayback":(section.classList.contains("favoriteArtistsSection")||section.classList.contains("favoriteAlbumsSection")||section.classList.contains("favoriteSongsSection"))&&(monitor="markfavorite"),monitor=monitor?' data-monitor="'+monitor+'"':"",html=enableScrollX()?'<div is="emby-scroller" class="padded-top-focusscale padded-bottom-focusscale" data-mousewheel="false" data-centerfocus="true"><div is="emby-itemscontainer" class="itemsContainer scrollSlider focuscontainer-x padded-left padded-right"'+monitor+"></div></div>":'<div is="emby-itemscontainer" class="itemsContainer padded-left padded-right vertical-wrap"'+monitor+"></div>",section.insertAdjacentHTML("beforeend",html)}}function getItemsHtml(items,options){appHost.supports("imageanalysis"),enableScrollX("resume");return cardBuilder.getCardsHtml(Object.assign({items:items,showUnplayedIndicator:!1,showLatestItemsPopup:!1,shape:"autooverflow",showTitle:!0,showParentTitle:!0,centerText:!0,overlayPlayButton:!0,allowBottomPadding:!enableScrollX(),cardLayout:!1,vibrant:!1},options))}function fetchLatestItems(){var apiClient=this.apiClient,parentId=this.params.parentId,limit=enableScrollX()?24:12;return apiClient.getLatestItems({IncludeItemTypes:"Audio",Limit:limit,Fields:"PrimaryImageAspectRatio,BasicSyncInfo",ParentId:parentId,ImageTypeLimit:1,EnableImageTypes:"Primary",EnableTotalRecordCount:!1})}function getLatestItemsHtml(items,options){return getItemsHtml(items,{})}function fetchRecentlyPlayedItems(){var apiClient=this.apiClient,parentId=this.params.parentId,limit=enableScrollX()?24:12;return apiClient.getItems(apiClient.getCurrentUserId(),{SortBy:"DatePlayed",SortOrder:"Descending",IncludeItemTypes:"Audio",Limit:limit,Recursive:!0,Fields:"PrimaryImageAspectRatio,CanDelete",Filters:"IsPlayed",ParentId:parentId,ImageTypeLimit:1,EnableImageTypes:"Primary",EnableTotalRecordCount:!1})}function fetchFrequentlyPlayedItems(){var apiClient=this.apiClient,parentId=this.params.parentId,limit=enableScrollX()?24:12;return apiClient.getItems(apiClient.getCurrentUserId(),{SortBy:"PlayCount",SortOrder:"Descending",IncludeItemTypes:"Audio",Limit:limit,Recursive:!0,Fields:"PrimaryImageAspectRatio,CanDelete",Filters:"IsPlayed",ParentId:parentId,ImageTypeLimit:1,EnableImageTypes:"Primary",EnableTotalRecordCount:!1})}function getRecentlyPlayedItemsHtml(items){return getItemsHtml(items,{action:"play",overlayPlayButton:!1,overlayMoreButton:!0})}function getFrequentlyPlayedItemsHtml(items){return getItemsHtml(items,{action:"play",overlayPlayButton:!1,overlayMoreButton:!0})}function fetchFavoriteArtists(){var apiClient=this.apiClient;this.params.parentId,enableScrollX();return apiClient.getArtists(apiClient.getCurrentUserId(),{SortBy:"SortName",SortOrder:"Ascending",Recursive:!0,Fields:"PrimaryImageAspectRatio,BasicSyncInfo",Filters:"IsFavorite",StartIndex:0,ImageTypeLimit:1,EnableImageTypes:"Primary",EnableTotalRecordCount:!1})}function getFavoriteArtistItemsHtml(items){return getItemsHtml(items,{overlayPlayButton:!0,showParentTitle:!1})}function fetchFavoriteAlbums(){var apiClient=this.apiClient,parentId=this.params.parentId,limit=enableScrollX()?24:12;return apiClient.getItems(apiClient.getCurrentUserId(),{SortBy:"Random",IncludeItemTypes:"MusicAlbum",Limit:limit,Recursive:!0,Fields:"PrimaryImageAspectRatio,CanDelete",Filters:"IsFavorite",ParentId:parentId,ImageTypeLimit:1,EnableImageTypes:"Primary",EnableTotalRecordCount:!1})}function getFavoriteAlbumItemsHtml(items){return getItemsHtml(items,{overlayPlayButton:!0})}function fetchFavoriteSongs(){var apiClient=this.apiClient,parentId=this.params.parentId,limit=enableScrollX()?24:12;return apiClient.getItems(apiClient.getCurrentUserId(),{SortBy:"Random",IncludeItemTypes:"Audio",Limit:limit,Recursive:!0,Fields:"PrimaryImageAspectRatio,CanDelete",Filters:"IsFavorite",ParentId:parentId,ImageTypeLimit:1,EnableImageTypes:"Primary",EnableTotalRecordCount:!1})}function getFavoriteSongItemsHtml(items){return getItemsHtml(items,{action:"play",overlayPlayButton:!1,overlayMoreButton:!0})}return MusicSuggestionsTab.prototype.onResume=function(options){var promises=[];promises.push(this.latestItemsContainer.resume(options)),promises.push(this.recentlyPlayedItemsContainer.resume(options)),promises.push(this.frequentlyPlayedItemsContainer.resume(options)),promises.push(this.favoriteArtistsItemsContainer.resume(options)),promises.push(this.favoriteAlbumsItemsContainer.resume(options)),promises.push(this.favoriteSongsItemsContainer.resume(options));var view=this.view;Promise.all(promises).then(function(){options.autoFocus&&focusManager.autoFocus(view)})},MusicSuggestionsTab.prototype.onPause=function(){this.latestItemsContainer.pause(),this.recentlyPlayedItemsContainer.pause(),this.frequentlyPlayedItemsContainer.pause(),this.favoriteArtistsItemsContainer.pause(),this.favoriteAlbumsItemsContainer.pause(),this.favoriteSongsItemsContainer.pause()},MusicSuggestionsTab.prototype.destroy=function(){this.view=null,this.params=null,this.apiClient=null,this.latestItemsContainer=null,this.recentlyPlayedItemsContainer=null,this.frequentlyPlayedItemsContainer=null,this.favoriteArtistsItemsContainer=null,this.favoriteAlbumsItemsContainer=null,this.favoriteSongsItemsContainer=null},MusicSuggestionsTab});