/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.index.EntryResult;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.internal.core.search.matching.DLTKSearchPattern;

public class TypeDeclarationPattern
extends DLTKSearchPattern
implements IIndexConstants {
    public char[] simpleName;
    public char[] pkg;
    public char[][] enclosingTypeNames;
    public char[][] superTypes;
    public char typeSuffix;
    public int modifiers;
    public boolean secondary = false;
    protected static char[][] CATEGORIES = new char[][]{TYPE_DECL};

    public static char[] createIndexKey(int modifiers, String typeName, String[] packageName, String[] enclosingTypeNames, char[][] superTypes) {
        int typeNameLength = typeName == null ? 0 : typeName.length();
        int packageLength = TypeDeclarationPattern.indexKeyLength(packageName);
        int enclosingNamesLength = TypeDeclarationPattern.indexKeyLength(enclosingTypeNames);
        int superTypesLength = 0;
        if (superTypes != null) {
            int i = 0;
            int length = superTypes.length;
            while (i < length) {
                superTypesLength += superTypes[i].length;
                if (++i >= length) continue;
                ++superTypesLength;
            }
        }
        int resultLength = typeNameLength + packageLength + enclosingNamesLength + superTypesLength + 6;
        char[] result = new char[resultLength];
        int pos = 0;
        if (typeNameLength > 0) {
            typeName.getChars(0, typeNameLength, result, pos);
            pos += typeNameLength;
        }
        result[pos++] = 123;
        pos = TypeDeclarationPattern.encodeNames(packageName, packageLength, result, pos);
        result[pos++] = 123;
        pos = TypeDeclarationPattern.encodeNames(enclosingTypeNames, enclosingNamesLength, result, pos);
        result[pos++] = 123;
        if (superTypes != null && superTypesLength > 0) {
            int i = 0;
            int length = superTypes.length;
            while (i < length) {
                char[] superType = superTypes[i];
                int itsLength = superType.length;
                System.arraycopy(superType, 0, result, pos, itsLength);
                pos += itsLength;
                if (++i >= length) continue;
                result[pos++] = 44;
            }
        }
        result[pos++] = 123;
        result[pos++] = (char)modifiers;
        result[pos] = (char)(modifiers >> 16);
        return result;
    }

    public TypeDeclarationPattern(char[] pkg, char[][] enclosingTypeNames, char[][] superTypes, char[] simpleName, char typeSuffix, int matchRule, IDLTKLanguageToolkit toolkit) {
        this(matchRule, toolkit);
        this.pkg = this.isCaseSensitive() ? pkg : CharOperation.toLowerCase(pkg);
        this.enclosingTypeNames = this.isCaseSensitive() || enclosingTypeNames == null ? enclosingTypeNames : CharOperation.toLowerCase(enclosingTypeNames);
        this.simpleName = this.isCaseSensitive() || this.isCamelCase() ? simpleName : CharOperation.toLowerCase(simpleName);
        this.typeSuffix = typeSuffix;
        this.superTypes = superTypes;
    }

    TypeDeclarationPattern(int matchRule, IDLTKLanguageToolkit toolkit) {
        super(8, matchRule, toolkit);
    }

    @Override
    public void decodeIndexKey(char[] key) {
        int start;
        int slash = CharOperation.indexOf('{', key, 0);
        this.simpleName = CharOperation.subarray(key, 0, slash);
        if (key[start = ++slash] == '{') {
            this.pkg = CharOperation.NO_CHAR;
        } else {
            slash = CharOperation.indexOf('{', key, start);
            this.pkg = internedPackageNames.add(CharOperation.subarray(key, start, slash));
        }
        int last = key.length - 1;
        boolean bl = this.secondary = key[last] == 'S';
        if (this.secondary) {
            last -= 2;
        }
        this.modifiers = last > 0 ? key[last - 1] + (key[last] << 16) : 0;
        this.decodeModifiers();
        start = ++slash;
        this.enclosingTypeNames = start == (last -= 2) ? CharOperation.NO_CHAR_CHAR : (start == (slash = CharOperation.indexOf('{', key, start)) ? CharOperation.NO_CHAR_CHAR : (slash == start + 1 && key[start] == '0' ? ONE_ZERO_CHAR : CharOperation.splitOn('$', key, start, slash)));
        start = ++slash;
        this.superTypes = start == last ? CharOperation.NO_CHAR_CHAR : (last == start + 1 && key[start] == '0' ? ONE_ZERO_CHAR : CharOperation.splitOn(',', key, start, last));
    }

    protected void decodeModifiers() {
        this.typeSuffix = (char)67;
    }

    @Override
    public SearchPattern getBlankPattern() {
        return new TypeDeclarationPattern(8, this.getToolkit());
    }

    @Override
    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    @Override
    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        TypeDeclarationPattern pattern = (TypeDeclarationPattern)decodedPattern;
        block0 : switch (this.typeSuffix) {
            case 'A': {
                if (this.typeSuffix == pattern.typeSuffix) break;
                return false;
            }
            case 'C': {
                switch (pattern.typeSuffix) {
                    case 'C': {
                        break block0;
                    }
                }
                return false;
            }
        }
        if (!this.matchesName(this.simpleName, pattern.simpleName)) {
            return false;
        }
        if (this.pkg != null && !CharOperation.equals(this.pkg, pattern.pkg, this.isCaseSensitive())) {
            return false;
        }
        if (this.enclosingTypeNames != null) {
            if (this.enclosingTypeNames.length == 0) {
                return pattern.enclosingTypeNames.length == 0;
            }
            if (this.enclosingTypeNames.length == 1 && pattern.enclosingTypeNames.length == 1) {
                return CharOperation.equals(this.enclosingTypeNames[0], pattern.enclosingTypeNames[0], this.isCaseSensitive());
            }
            if (pattern.enclosingTypeNames == ONE_ZERO_CHAR) {
                return true;
            }
            return CharOperation.equals(this.enclosingTypeNames, pattern.enclosingTypeNames, this.isCaseSensitive());
        }
        return true;
    }

    @Override
    public EntryResult[] queryIn(Index index) throws IOException {
        char[] key = this.simpleName;
        int matchRule = this.getMatchRule();
        switch (this.getMatchMode()) {
            case 1: {
                break;
            }
            case 0: {
                if (this.isCamelCase) break;
                matchRule &= 0xFFFFFFFF;
                if (this.simpleName != null) {
                    matchRule |= 1;
                    key = this.pkg == null ? CharOperation.append(this.simpleName, '{') : CharOperation.concat(this.simpleName, '{', this.pkg, '{', CharOperation.NO_CHAR);
                    break;
                }
                matchRule |= 2;
            }
            case 2: {
                if (this.pkg == null) {
                    if (this.simpleName == null) {
                        switch (this.typeSuffix) {
                            default: 
                        }
                        break;
                    }
                    if (this.simpleName[this.simpleName.length - 1] == '*') break;
                    key = CharOperation.concat(this.simpleName, ONE_STAR, '{');
                    break;
                }
                key = CharOperation.concat(this.simpleName == null ? ONE_STAR : this.simpleName, '{', this.pkg, '{', ONE_STAR);
                break;
            }
        }
        return index.query(this.getIndexCategories(), key, matchRule);
    }

    @Override
    protected StringBuffer print(StringBuffer output) {
        switch (this.typeSuffix) {
            case 'C': {
                output.append("TypeDeclarationPattern: pkg<");
                break;
            }
            case 'A': {
                output.append("AnnotationTypeDeclarationPattern: pkg<");
                break;
            }
            default: {
                output.append("TypeDeclarationPattern: pkg<");
            }
        }
        if (this.pkg != null) {
            output.append(this.pkg);
        } else {
            output.append("*");
        }
        output.append(">, enclosing<");
        if (this.enclosingTypeNames != null) {
            int i = 0;
            while (i < this.enclosingTypeNames.length) {
                output.append(this.enclosingTypeNames[i]);
                if (i < this.enclosingTypeNames.length - 1) {
                    output.append('$');
                }
                ++i;
            }
        } else {
            output.append("*");
        }
        output.append(">, type<");
        if (this.simpleName != null) {
            output.append(this.simpleName);
        } else {
            output.append("*");
        }
        output.append(">");
        return super.print(output);
    }
}

