/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.data;

import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCStringValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.BeanUtils;

public class PostgreIntervalValueHandler
extends JDBCStringValueHandler {
    private static final Log log = Log.getLog(PostgreIntervalValueHandler.class);
    public static final PostgreIntervalValueHandler INSTANCE = new PostgreIntervalValueHandler();
    private static final DecimalFormat SECONDS_FORMAT = new DecimalFormat("0.00####");

    static {
        DecimalFormatSymbols dfs = SECONDS_FORMAT.getDecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        SECONDS_FORMAT.setDecimalFormatSymbols(dfs);
    }

    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws SQLException {
        return resultSet.getString(index);
    }

    public void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws SQLException {
        if (value == null) {
            statement.setNull(paramIndex, paramType.getTypeID());
        } else {
            statement.setObject(paramIndex, (Object)value.toString(), 1111);
        }
    }

    public String getValueDisplayString(DBSTypedObject column, Object value, DBDDisplayFormat format) {
        if (value != null && value.getClass().getName().equals("org.postgresql.util.PGInterval")) {
            try {
                Number years = (Number)BeanUtils.readObjectProperty((Object)value, (String)"years");
                Number months = (Number)BeanUtils.readObjectProperty((Object)value, (String)"months");
                Number days = (Number)BeanUtils.readObjectProperty((Object)value, (String)"days");
                Number hours = (Number)BeanUtils.readObjectProperty((Object)value, (String)"hours");
                Number minutes = (Number)BeanUtils.readObjectProperty((Object)value, (String)"minutes");
                Number seconds = (Number)BeanUtils.readObjectProperty((Object)value, (String)"seconds");
                StringBuilder str = new StringBuilder();
                if (years != null && years.intValue() > 0) {
                    str.append(years).append(" year").append(years.intValue() > 1 ? "s" : "").append(" ");
                }
                if (months != null && months.intValue() > 0) {
                    str.append(months).append(" month").append(months.intValue() > 1 ? "s" : "").append(" ");
                }
                if (days != null && days.intValue() > 0) {
                    str.append(days).append(" day").append(days.intValue() > 1 ? "s" : "").append(" ");
                }
                str.append(hours).append(":").append(minutes).append(":").append(seconds).append(SECONDS_FORMAT.format(seconds));
                return str.toString();
            }
            catch (Throwable e) {
                log.debug((Object)e);
            }
        }
        return super.getValueDisplayString(column, value, format);
    }
}

