/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRole;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.gis.GisAttribute;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBStructUtils;

public class PostgreTableColumn
extends PostgreAttribute<PostgreTableBase>
implements PostgrePrivilegeOwner,
PostgreScriptObject,
GisAttribute {
    private static final Log log = Log.getLog(PostgreTableColumn.class);
    private GeometryInfo geometryInfo;

    public PostgreTableColumn(PostgreTableBase table) {
        super(table);
    }

    public PostgreTableColumn(DBRProgressMonitor monitor, PostgreTableBase table, JDBCResultSet dbResult) throws DBException {
        super(monitor, table, dbResult);
    }

    @Override
    public PostgreSchema getSchema() {
        return ((PostgreTableBase)this.getTable()).getSchema();
    }

    @Override
    public PostgreRole getOwner(DBRProgressMonitor monitor) throws DBException {
        return ((PostgreTableBase)this.getTable()).getOwner(monitor);
    }

    @Override
    public Collection<PostgrePrivilege> getPrivileges(DBRProgressMonitor monitor, boolean includeNestedObjects) throws DBException {
        return PostgreUtils.extractPermissionsFromACL(monitor, this, this.getAcl());
    }

    @Override
    public String generateChangeOwnerQuery(String owner) {
        return null;
    }

    public int getAttributeGeometrySRID(DBRProgressMonitor monitor) throws DBCException {
        if (this.geometryInfo == null) {
            this.readGeometryInfo(monitor);
        }
        if (this.geometryInfo != null) {
            return this.geometryInfo.srid;
        }
        return -1;
    }

    public String getAttributeGeometryType(DBRProgressMonitor monitor) throws DBCException {
        if (this.geometryInfo == null) {
            this.readGeometryInfo(monitor);
        }
        if (this.geometryInfo != null) {
            return this.geometryInfo.type;
        }
        return null;
    }

    private void readGeometryInfo(DBRProgressMonitor monitor) throws DBCException {
        if (this.geometryInfo != null) {
            return;
        }
        GeometryInfo gi = new GeometryInfo();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load table inheritance info");){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT srid, type,coord_dimension FROM geometry_columns WHERE f_table_schema=? AND f_table_name=? AND f_geometry_column=?");){
                    dbStat.setString(1, this.getSchema().getName());
                    dbStat.setString(2, ((PostgreTableBase)this.getTable()).getName());
                    dbStat.setString(3, this.getName());
                    Throwable throwable3 = null;
                    Object var10_16 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            gi.srid = dbResult.getInt(1);
                            gi.type = dbResult.getString(2);
                            gi.dimension = dbResult.getInt(3);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException("Error reading geometry info", (Throwable)e);
        }
        this.geometryInfo = gi;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        return DBStructUtils.generateObjectDDL((DBRProgressMonitor)monitor, (DBSObject)this, options, (boolean)false);
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
    }

    private static class GeometryInfo {
        private String type;
        private int srid = -1;
        public int dimension;

        private GeometryInfo() {
        }
    }
}

