/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.gis;

import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.data.gis.handlers.GeometryConverter;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.utils.CommonUtils;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;

public class DBGeometry
implements DBDValue {
    private Object rawValue;
    private int srid;
    private Map<String, Object> properties;

    public DBGeometry() {
        this.rawValue = null;
    }

    public DBGeometry(String rawValue) {
        this.rawValue = rawValue;
    }

    public DBGeometry(Geometry rawValue) {
        this.rawValue = rawValue;
        this.srid = rawValue == null ? 0 : rawValue.getSRID();
    }

    public DBGeometry(Object rawValue, int srid) {
        this.rawValue = rawValue;
        this.srid = srid;
    }

    public Geometry getGeometry() {
        return this.rawValue instanceof Geometry ? (Geometry)this.rawValue : null;
    }

    public String getString() {
        return this.rawValue == null ? null : CommonUtils.toString((Object)this.rawValue);
    }

    public Object getRawValue() {
        return this.rawValue;
    }

    public boolean isNull() {
        return this.rawValue == null;
    }

    public boolean isModified() {
        return false;
    }

    public void release() {
    }

    public String toString() {
        return this.rawValue == null ? null : this.rawValue.toString();
    }

    public int getSRID() {
        return this.srid;
    }

    public void setSRID(int srid) {
        this.srid = srid;
    }

    public DBGeometry flipCoordinates() throws DBException {
        Geometry jtsGeometry = this.getGeometry();
        if (jtsGeometry == null) {
            try {
                jtsGeometry = new WKTReader().read(this.getString());
            }
            catch (Exception e) {
                throw new DBException("Error parsing geometry WKT", (Throwable)e);
            }
        } else {
            jtsGeometry = jtsGeometry.copy();
        }
        jtsGeometry.apply((CoordinateFilter)GeometryConverter.INVERT_COORDINATE_FILTER);
        return new DBGeometry(jtsGeometry, this.srid);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }
}

