/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.aggregate;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.aggregate.IAggregateFunction;
import org.jkiss.dbeaver.registry.functions.AggregateFunctionDescriptor;
import org.jkiss.dbeaver.registry.functions.FunctionsRegistry;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPanel;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetSelection;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;

public class AggregateColumnsPanel
implements IResultSetPanel {
    private static final Log log = Log.getLog(AggregateColumnsPanel.class);
    public static final String PANEL_ID = "column-aggregate";
    public static final String SETTINGS_SECTION_AGGREGATE = "panel-column-aggregate";
    public static final String PARAM_GROUP_BY_COLUMNS = "groupByColumns";
    public static final String PARAM_GROUP_AS_STRINGS = "groupAsStrings";
    private static final DecimalFormat DOUBLE_FORMAT = new DecimalFormat("###,###,###,###,###,##0.###");
    private static final DecimalFormat INTEGER_FORMAT = new DecimalFormat("###,###,###,###,###,##0");
    private IResultSetPresentation presentation;
    private Tree aggregateTable;
    private boolean groupByColumns;
    private boolean aggregateAsStrings;
    private IDialogSettings panelSettings;
    private final List<AggregateFunctionDescriptor> enabledFunctions = new ArrayList<AggregateFunctionDescriptor>();

    @Override
    public Control createContents(final IResultSetPresentation presentation, Composite parent) {
        this.presentation = presentation;
        this.panelSettings = ResultSetUtils.getViewerSettings(SETTINGS_SECTION_AGGREGATE);
        this.loadSettings();
        this.aggregateTable = new Tree(parent, 65540);
        this.aggregateTable.setHeaderVisible(true);
        this.aggregateTable.setLinesVisible(true);
        new TreeColumn(this.aggregateTable, 16384).setText("Function");
        new TreeColumn(this.aggregateTable, 131072).setText("Value");
        if (this.presentation instanceof ISelectionProvider) {
            ((ISelectionProvider)this.presentation).addSelectionChangedListener(event -> {
                if (presentation.getController().getVisiblePanel() == this) {
                    this.refresh(false);
                }
            });
        }
        MenuManager menuMgr = new MenuManager();
        menuMgr.addMenuListener(manager -> {
            manager.add((IAction)new CopyAction());
            manager.add((IAction)new CopyAllAction());
            manager.add((IContributionItem)new Separator());
            this.fillToolBar((IContributionManager)manager);
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.aggregateTable.setMenu(menuMgr.createContextMenu((Control)this.aggregateTable));
        this.aggregateTable.addDisposeListener(e -> menuMgr.dispose());
        this.aggregateTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                presentation.getController().updatePanelActions();
            }
        });
        return this.aggregateTable;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    private void loadSettings() {
        this.aggregateAsStrings = this.panelSettings.getBoolean(PARAM_GROUP_AS_STRINGS);
        this.groupByColumns = this.panelSettings.getBoolean(PARAM_GROUP_BY_COLUMNS);
        IDialogSettings functionsSection = this.panelSettings.getSection("functions");
        if (functionsSection != null) {
            HashMap<AggregateFunctionDescriptor, Integer> funcIndexes = new HashMap<AggregateFunctionDescriptor, Integer>();
            IDialogSettings[] iDialogSettingsArray = functionsSection.getSections();
            int n = iDialogSettingsArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDialogSettings funcSection = iDialogSettingsArray[n2];
                String funcId = funcSection.getName();
                if (funcSection.getBoolean("enabled")) {
                    AggregateFunctionDescriptor func = FunctionsRegistry.getInstance().getFunction(funcId);
                    if (func == null) {
                        log.debug((Object)("Function '" + funcId + "' not found"));
                    } else {
                        funcIndexes.put(func, funcSection.getInt("index"));
                        this.enabledFunctions.add(func);
                    }
                }
                ++n2;
            }
            this.enabledFunctions.sort(Comparator.comparingInt(funcIndexes::get));
        }
        if (this.enabledFunctions.isEmpty()) {
            this.loadDefaultFunctions();
        }
    }

    private void loadDefaultFunctions() {
        for (AggregateFunctionDescriptor func : FunctionsRegistry.getInstance().getFunctions()) {
            if (!func.isDefault()) continue;
            this.enabledFunctions.add(func);
        }
        this.enabledFunctions.sort(Comparator.comparing(AggregateFunctionDescriptor::getLabel));
    }

    private void saveSettings() {
        this.panelSettings.put(PARAM_GROUP_BY_COLUMNS, this.groupByColumns);
        this.panelSettings.put(PARAM_GROUP_AS_STRINGS, this.aggregateAsStrings);
        IDialogSettings functionsSection = UIUtils.getSettingsSection((IDialogSettings)this.panelSettings, (String)"functions");
        for (AggregateFunctionDescriptor func : FunctionsRegistry.getInstance().getFunctions()) {
            IDialogSettings funcSection = UIUtils.getSettingsSection((IDialogSettings)functionsSection, (String)func.getId());
            boolean enabled = this.enabledFunctions.contains((Object)func);
            funcSection.put("enabled", enabled);
            if (enabled) {
                funcSection.put("index", this.enabledFunctions.indexOf((Object)func));
                continue;
            }
            funcSection.put("index", -1);
        }
    }

    @Override
    public void activatePanel() {
        this.refresh(false);
    }

    @Override
    public void deactivatePanel() {
    }

    @Override
    public void refresh(boolean force) {
        this.aggregateTable.setRedraw(false);
        try {
            ISelection selection;
            this.aggregateTable.removeAll();
            if (this.presentation instanceof ISelectionProvider && (selection = ((ISelectionProvider)this.presentation).getSelection()) instanceof IResultSetSelection) {
                this.aggregateSelection((IResultSetSelection)selection);
            }
            UIUtils.packColumns((Tree)this.aggregateTable, (boolean)true, null);
        }
        finally {
            this.aggregateTable.setRedraw(true);
        }
        this.saveSettings();
    }

    @Override
    public void contributeActions(IContributionManager manager) {
        this.fillToolBar(manager);
    }

    private void aggregateSelection(IResultSetSelection selection) {
        ResultSetModel model = this.presentation.getController().getModel();
        if (this.groupByColumns) {
            LinkedHashMap<DBDAttributeBinding, List> attrValues = new LinkedHashMap<DBDAttributeBinding, List>();
            for (Object e : selection.toList()) {
                DBDAttributeBinding attr = selection.getElementAttribute(e);
                ResultSetRow row = selection.getElementRow(e);
                Object cellValue = model.getCellValue(attr, row);
                List values = attrValues.computeIfAbsent(attr, k -> new ArrayList());
                values.add(cellValue);
            }
            for (Map.Entry entry : attrValues.entrySet()) {
                TreeItem attrItem = new TreeItem(this.aggregateTable, 0);
                attrItem.setText(((DBDAttributeBinding)entry.getKey()).getName());
                attrItem.setImage(DBeaverIcons.getImage((DBPImage)DBValueFormatting.getObjectImage((DBPObject)((DBPObject)entry.getKey()))));
                this.aggregateValues(attrItem, (Collection)entry.getValue());
                attrItem.setExpanded(true);
            }
        } else {
            ArrayList<Object> allValues = new ArrayList<Object>(selection.size());
            for (Object e : selection.toList()) {
                DBDAttributeBinding attr = selection.getElementAttribute(e);
                ResultSetRow row = selection.getElementRow(e);
                Object cellValue = model.getCellValue(attr, row);
                allValues.add(cellValue);
            }
            this.aggregateValues(null, allValues);
        }
    }

    private void aggregateValues(TreeItem parentItem, Collection<Object> values) {
        List<AggregateFunctionDescriptor> functions = this.enabledFunctions;
        IdentityHashMap<IAggregateFunction, TreeItem> funcMap = new IdentityHashMap<IAggregateFunction, TreeItem>();
        for (AggregateFunctionDescriptor funcDesc : functions) {
            TreeItem funcItem = parentItem == null ? new TreeItem(this.aggregateTable, 0) : new TreeItem(parentItem, 0);
            funcItem.setData((Object)funcDesc);
            funcItem.setText(0, funcDesc.getLabel());
            DBPImage icon = funcDesc.getIcon();
            if (icon != null) {
                funcItem.setImage(0, DBeaverIcons.getImage((DBPImage)icon));
            }
            try {
                IAggregateFunction func = funcDesc.createFunction();
                funcMap.put(func, funcItem);
            }
            catch (DBException e) {
                log.error((Object)e);
            }
        }
        IAggregateFunction[] funcs = funcMap.keySet().toArray(new IAggregateFunction[funcMap.size()]);
        int[] funcCount = new int[funcs.length];
        for (Object element : values) {
            int i = 0;
            while (i < funcs.length) {
                if (funcs[i].accumulate(element, this.aggregateAsStrings)) {
                    int n = i;
                    funcCount[n] = funcCount[n] + 1;
                }
                ++i;
            }
        }
        int i = 0;
        while (i < funcs.length) {
            IAggregateFunction func;
            Object result;
            if (funcCount[i] > 0 && (result = (func = funcs[i]).getResult(funcCount[i])) != null) {
                TreeItem treeItem = (TreeItem)funcMap.get(func);
                String strValue = result instanceof Double || result instanceof Float || result instanceof BigDecimal ? DOUBLE_FORMAT.format(result) : (result instanceof Integer || result instanceof Long || result instanceof Short ? INTEGER_FORMAT.format(result) : result.toString());
                treeItem.setText(1, strValue);
            }
            ++i;
        }
    }

    public void clearValue() {
        this.aggregateTable.removeAll();
    }

    private void fillToolBar(IContributionManager contributionManager) {
        contributionManager.add((IAction)new AddFunctionAction());
        contributionManager.add((IAction)new RemoveFunctionAction());
        contributionManager.add((IAction)new ResetFunctionsAction());
        contributionManager.add((IContributionItem)new Separator());
        contributionManager.add((IAction)new GroupByColumnsAction());
        contributionManager.add((IAction)new ValueTypeToggleAction());
    }

    private class AddFunctionAction
    extends Action {
        public AddFunctionAction() {
            super("Add function", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.OBJ_ADD));
        }

        public void run() {
            ArrayList<AggregateFunctionDescriptor> missingFunctions = new ArrayList<AggregateFunctionDescriptor>();
            for (AggregateFunctionDescriptor func : FunctionsRegistry.getInstance().getFunctions()) {
                if (AggregateColumnsPanel.this.enabledFunctions.contains((Object)func)) continue;
                missingFunctions.add(func);
            }
            if (!missingFunctions.isEmpty()) {
                Point location = AggregateColumnsPanel.this.aggregateTable.getDisplay().map((Control)AggregateColumnsPanel.this.aggregateTable, null, new Point(10, 10));
                MenuManager menuManager = new MenuManager();
                for (AggregateFunctionDescriptor func : missingFunctions) {
                    menuManager.add((IAction)new AddFunctionItemAction(func));
                }
                Menu contextMenu = menuManager.createContextMenu((Control)AggregateColumnsPanel.this.aggregateTable);
                contextMenu.setLocation(location);
                contextMenu.setVisible(true);
                AggregateColumnsPanel.this.aggregateTable.addDisposeListener(e -> menuManager.dispose());
            }
        }
    }

    private class AddFunctionItemAction
    extends Action {
        private final AggregateFunctionDescriptor func;

        public AddFunctionItemAction(AggregateFunctionDescriptor func) {
            super(func.getLabel(), DBeaverIcons.getImageDescriptor((DBPImage)func.getIcon()));
            this.func = func;
        }

        public void run() {
            AggregateColumnsPanel.this.enabledFunctions.add(this.func);
            AggregateColumnsPanel.this.refresh(false);
        }
    }

    private class CopyAction
    extends Action {
        public CopyAction() {
            super("Copy Value");
        }

        public void run() {
            StringBuilder result = new StringBuilder();
            TreeItem[] treeItemArray = AggregateColumnsPanel.this.aggregateTable.getSelection();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (result.length() > 0) {
                    result.append("\n");
                }
                if (item.getData() instanceof AggregateFunctionDescriptor) {
                    result.append(item.getText(1));
                } else {
                    result.append(item.getText(0));
                }
                ++n2;
            }
            UIUtils.setClipboardContents((Display)AggregateColumnsPanel.this.aggregateTable.getDisplay(), (Transfer)TextTransfer.getInstance(), (Object)result.toString());
        }
    }

    private class CopyAllAction
    extends Action {
        public CopyAllAction() {
            super("Copy All");
        }

        public void run() {
            StringBuilder result = new StringBuilder();
            if (!AggregateColumnsPanel.this.groupByColumns) {
                TreeItem[] treeItemArray = AggregateColumnsPanel.this.aggregateTable.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    if (result.length() > 0) {
                        result.append("\n");
                    }
                    result.append(item.getText(0)).append("=").append(item.getText(1));
                    ++n2;
                }
            } else {
                TreeItem[] treeItemArray = AggregateColumnsPanel.this.aggregateTable.getItems();
                int n = treeItemArray.length;
                int n3 = 0;
                while (n3 < n) {
                    TreeItem item = treeItemArray[n3];
                    if (result.length() > 0) {
                        result.append("\n");
                    }
                    result.append(item.getText(0));
                    TreeItem[] treeItemArray2 = item.getItems();
                    int n4 = treeItemArray2.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        TreeItem funcItem = treeItemArray2[n5];
                        result.append("\n\t");
                        result.append(funcItem.getText(0)).append("=").append(funcItem.getText(1));
                        ++n5;
                    }
                    ++n3;
                }
            }
            UIUtils.setClipboardContents((Display)AggregateColumnsPanel.this.aggregateTable.getDisplay(), (Transfer)TextTransfer.getInstance(), (Object)result.toString());
        }
    }

    private class GroupByColumnsAction
    extends Action {
        public GroupByColumnsAction() {
            super("Group by columns", 2);
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.GROUP_BY_ATTR));
            this.setChecked(AggregateColumnsPanel.this.groupByColumns);
        }

        public void run() {
            AggregateColumnsPanel.this.groupByColumns = !AggregateColumnsPanel.this.groupByColumns;
            this.setChecked(AggregateColumnsPanel.this.groupByColumns);
            AggregateColumnsPanel.this.refresh(false);
        }
    }

    private class RemoveFunctionAction
    extends Action {
        public RemoveFunctionAction() {
            super("Remove function", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.OBJ_REMOVE));
        }

        public boolean isEnabled() {
            return AggregateColumnsPanel.this.aggregateTable != null && !AggregateColumnsPanel.this.aggregateTable.isDisposed() && AggregateColumnsPanel.this.aggregateTable.getSelectionCount() > 0;
        }

        public void run() {
            TreeItem[] treeItemArray = AggregateColumnsPanel.this.aggregateTable.getSelection();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                AggregateFunctionDescriptor func = (AggregateFunctionDescriptor)((Object)item.getData());
                AggregateColumnsPanel.this.enabledFunctions.remove((Object)func);
                ++n2;
            }
            AggregateColumnsPanel.this.refresh(false);
        }
    }

    private class ResetFunctionsAction
    extends Action {
        public ResetFunctionsAction() {
            super("Reset", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.OBJ_REFRESH));
        }

        public void run() {
            AggregateColumnsPanel.this.enabledFunctions.clear();
            AggregateColumnsPanel.this.loadDefaultFunctions();
            AggregateColumnsPanel.this.refresh(false);
        }
    }

    private class ValueTypeToggleAction
    extends Action {
        public ValueTypeToggleAction() {
            super("Toggle numbers/strings aggregation", 2);
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)(AggregateColumnsPanel.this.aggregateAsStrings ? DBIcon.TYPE_STRING : DBIcon.TYPE_NUMBER)));
            this.setChecked(AggregateColumnsPanel.this.aggregateAsStrings);
        }

        public void run() {
            AggregateColumnsPanel.this.aggregateAsStrings = !AggregateColumnsPanel.this.aggregateAsStrings;
            this.setChecked(AggregateColumnsPanel.this.aggregateAsStrings);
            AggregateColumnsPanel.this.presentation.getController().updatePanelActions();
            AggregateColumnsPanel.this.refresh(false);
        }
    }
}

