/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.Collections;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingElement;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class CollectionElementData {
    private static final Log log = Log.getLog(CollectionElementData.class);
    final DBDAttributeBinding collectionBinding;
    final DBDAttributeBindingElement[] elements;

    public CollectionElementData(DBDAttributeBinding collectionBinding, DBDCollection collection) {
        this.collectionBinding = collectionBinding;
        int count = collection.getItemCount();
        this.elements = new DBDAttributeBindingElement[count];
        int i = 0;
        while (i < count) {
            this.elements[i] = new DBDAttributeBindingElement(collectionBinding, collection, i);
            ++i;
        }
        Throwable throwable = null;
        Object var5_7 = null;
        try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)new VoidProgressMonitor(), (DBSObject)collectionBinding, (String)"Collection types read");){
            Object[] row = new Object[1];
            List<Object[]> rows = Collections.singletonList(row);
            int i2 = 0;
            while (i2 < count) {
                row[0] = collection.getItem(i2);
                try {
                    this.elements[i2].lateBinding(session, rows);
                }
                catch (DBException e) {
                    log.error((Object)"Error binding collection element", (Throwable)e);
                }
                ++i2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public DBDAttributeBinding getCollectionBinding() {
        return this.collectionBinding;
    }

    public DBDAttributeBindingElement[] getElements() {
        return this.elements;
    }
}

