"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _moment = _interopRequireDefault(require("moment"));

var _classnames = _interopRequireDefault(require("classnames"));

var _nodeEmoji = require("node-emoji");

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _commitView = _interopRequireDefault(require("./commit-view"));

var _timeago = _interopRequireDefault(require("./timeago"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class RecentCommitView extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "undoLastCommit", event => {
      event.stopPropagation();
      this.props.undoLastCommit();
    });

    this.refRoot = new _refHolder["default"]();
  }

  componentDidMount() {
    if (this.props.isSelected) {
      this.refRoot.map(root => root.scrollIntoViewIfNeeded(false));
    }
  }

  componentDidUpdate(prevProps) {
    if (this.props.isSelected && !prevProps.isSelected) {
      this.refRoot.map(root => root.scrollIntoViewIfNeeded(false));
    }
  }

  render() {
    const authorMoment = (0, _moment["default"])(this.props.commit.getAuthorDate() * 1000);
    const fullMessage = this.props.commit.getFullMessage();
    return _react["default"].createElement("li", {
      ref: this.refRoot.setter,
      className: (0, _classnames["default"])('github-RecentCommit', {
        'most-recent': this.props.isMostRecent,
        'is-selected': this.props.isSelected
      }),
      onClick: this.props.openCommit
    }, this.renderAuthors(), _react["default"].createElement("span", {
      className: "github-RecentCommit-message",
      title: (0, _nodeEmoji.emojify)(fullMessage)
    }, (0, _nodeEmoji.emojify)(this.props.commit.getMessageSubject())), this.props.isMostRecent && _react["default"].createElement("button", {
      className: "btn github-RecentCommit-undoButton",
      onClick: this.undoLastCommit
    }, "Undo"), _react["default"].createElement(_timeago["default"], {
      className: "github-RecentCommit-time",
      type: "time",
      displayStyle: "short",
      time: authorMoment,
      title: authorMoment.format('MMM Do, YYYY')
    }));
  }

  renderAuthor(email) {
    const match = email.match(/^(\d+)\+[^@]+@users.noreply.github.com$/);
    let avatarUrl;

    if (match) {
      avatarUrl = 'https://avatars.githubusercontent.com/u/' + match[1] + '?s=32';
    } else {
      avatarUrl = 'https://avatars.githubusercontent.com/u/e?email=' + encodeURIComponent(email) + '&s=32';
    }

    return _react["default"].createElement("img", {
      className: "github-RecentCommit-avatar",
      key: email,
      src: avatarUrl,
      title: email,
      alt: `${email}'s avatar'`
    });
  }

  renderAuthors() {
    const coAuthorEmails = this.props.commit.getCoAuthors().map(author => author.email);
    const authorEmails = [this.props.commit.getAuthorEmail(), ...coAuthorEmails];
    return _react["default"].createElement("span", {
      className: "github-RecentCommit-authors"
    }, authorEmails.map(this.renderAuthor));
  }

}

_defineProperty(RecentCommitView, "propTypes", {
  commit: _propTypes["default"].object.isRequired,
  undoLastCommit: _propTypes["default"].func.isRequired,
  isMostRecent: _propTypes["default"].bool.isRequired,
  openCommit: _propTypes["default"].func.isRequired,
  isSelected: _propTypes["default"].bool.isRequired
});

class RecentCommitsView extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "openSelectedCommit", () => this.props.openCommit({
      sha: this.props.selectedCommitSha,
      preserveFocus: false
    }));

    this.refRoot = new _refHolder["default"]();
  }

  setFocus(focus) {
    if (focus === this.constructor.focus.RECENT_COMMIT) {
      return this.refRoot.map(element => {
        element.focus();
        return true;
      }).getOr(false);
    }

    return false;
  }

  getFocus(element) {
    return this.refRoot.map(e => e.contains(element)).getOr(false) ? this.constructor.focus.RECENT_COMMIT : null;
  }

  render() {
    return _react["default"].createElement("div", {
      className: "github-RecentCommits",
      tabIndex: "-1",
      ref: this.refRoot.setter
    }, _react["default"].createElement(_commands["default"], {
      registry: this.props.commandRegistry,
      target: this.refRoot
    }, _react["default"].createElement(_commands.Command, {
      command: "core:move-down",
      callback: this.props.selectNextCommit
    }), _react["default"].createElement(_commands.Command, {
      command: "core:move-up",
      callback: this.props.selectPreviousCommit
    }), _react["default"].createElement(_commands.Command, {
      command: "github:dive",
      callback: this.openSelectedCommit
    })), this.renderCommits());
  }

  renderCommits() {
    if (this.props.commits.length === 0) {
      if (this.props.isLoading) {
        return _react["default"].createElement("div", {
          className: "github-RecentCommits-message"
        }, "Recent commits");
      } else {
        return _react["default"].createElement("div", {
          className: "github-RecentCommits-message"
        }, "Make your first commit");
      }
    } else {
      return _react["default"].createElement("ul", {
        className: "github-RecentCommits-list"
      }, this.props.commits.map((commit, i) => {
        return _react["default"].createElement(RecentCommitView, {
          key: commit.getSha(),
          isMostRecent: i === 0,
          commit: commit,
          undoLastCommit: this.props.undoLastCommit,
          openCommit: () => this.props.openCommit({
            sha: commit.getSha(),
            preserveFocus: true
          }),
          isSelected: this.props.selectedCommitSha === commit.getSha()
        });
      }));
    }
  }

  advanceFocusFrom(focus) {
    if (focus === this.constructor.focus.RECENT_COMMIT) {
      return Promise.resolve(this.constructor.focus.RECENT_COMMIT);
    }

    return Promise.resolve(null);
  }

  retreatFocusFrom(focus) {
    if (focus === this.constructor.focus.RECENT_COMMIT) {
      return Promise.resolve(_commitView["default"].lastFocus);
    }

    return Promise.resolve(null);
  }

}

exports["default"] = RecentCommitsView;

_defineProperty(RecentCommitsView, "propTypes", {
  // Model state
  commits: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  selectedCommitSha: _propTypes["default"].string.isRequired,
  // Atom environment
  commandRegistry: _propTypes["default"].object.isRequired,
  // Action methods
  undoLastCommit: _propTypes["default"].func.isRequired,
  openCommit: _propTypes["default"].func.isRequired,
  selectNextCommit: _propTypes["default"].func.isRequired,
  selectPreviousCommit: _propTypes["default"].func.isRequired
});

_defineProperty(RecentCommitsView, "focus", {
  RECENT_COMMIT: Symbol('recent_commit')
});

_defineProperty(RecentCommitsView, "firstFocus", RecentCommitsView.focus.RECENT_COMMIT);

_defineProperty(RecentCommitsView, "lastFocus", RecentCommitsView.focus.RECENT_COMMIT);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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