"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.PrCommitsView = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _propTypes2 = require("../prop-types");

var _prCommitView = _interopRequireDefault(require("./pr-commit-view"));

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class PrCommitsView extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'loadMore');
  }

  loadMore() {
    this.props.relay.loadMore(_helpers.PAGE_SIZE, () => {
      this.forceUpdate();
    });
    this.forceUpdate();
  }

  render() {
    return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement("div", {
      className: "github-PrCommitsView-commitWrapper"
    }, this.renderCommits()), this.renderLoadMore());
  }

  renderLoadMore() {
    if (!this.props.relay.hasMore()) {
      return null;
    }

    return _react["default"].createElement("button", {
      className: "github-PrCommitsView-load-more-button btn",
      onClick: this.loadMore
    }, "Load more");
  }

  renderCommits() {
    return this.props.pullRequest.commits.edges.map(edge => {
      const commit = edge.node.commit;
      return _react["default"].createElement(_prCommitView["default"], {
        key: commit.id,
        item: commit,
        onBranch: this.props.onBranch,
        openCommit: this.props.openCommit
      });
    });
  }

}

exports.PrCommitsView = PrCommitsView;

_defineProperty(PrCommitsView, "propTypes", {
  relay: _propTypes["default"].shape({
    hasMore: _propTypes["default"].func.isRequired,
    loadMore: _propTypes["default"].func.isRequired,
    isLoading: _propTypes["default"].func.isRequired
  }).isRequired,
  pullRequest: _propTypes["default"].shape({
    commits: (0, _propTypes2.RelayConnectionPropType)(_propTypes["default"].shape({
      commit: _propTypes["default"].shape({
        id: _propTypes["default"].string.isRequired
      })
    }))
  }),
  onBranch: _propTypes["default"].bool.isRequired,
  openCommit: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createPaginationContainer)(PrCommitsView, {
  pullRequest: function () {
    const node = require("./__generated__/prCommitsView_pullRequest.graphql");

    if (node.hash && node.hash !== "4945c525c20aac5e24befbe8b217c2c9") {
      console.error("The definition of 'prCommitsView_pullRequest' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/prCommitsView_pullRequest.graphql");
  }
}, {
  direction: 'forward',

  getConnectionFromProps(props) {
    return props.pullRequest.commits;
  },

  getFragmentVariables(prevVars, totalCount) {
    return _objectSpread({}, prevVars, {
      commitCount: totalCount
    });
  },

  getVariables(props, {
    count,
    cursor
  }, fragmentVariables) {
    return {
      commitCount: count,
      commitCursor: cursor,
      url: props.pullRequest.url
    };
  },

  query: function () {
    const node = require("./__generated__/prCommitsViewQuery.graphql");

    if (node.hash && node.hash !== "5fae6bf54831a4d4a70eda4117e56b7f") {
      console.error("The definition of 'prCommitsViewQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/prCommitsViewQuery.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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