/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.common;

import javax.annotation.concurrent.Immutable;

@Immutable
public final class Timestamp {
    private static final long MAX_SECONDS = 315576000000L;
    private static final int MAX_NANOS = 999999999;
    private static final long NUM_MILLIS_PER_SECOND = 1000L;
    private static final int NUM_NANOS_PER_MILLI = 1000000;
    private static final long NUM_NANOS_PER_SECOND = 1000000000L;
    private final long seconds;
    private final int nanos;

    private Timestamp(long seconds, int nanos) {
        this.seconds = seconds;
        this.nanos = nanos;
    }

    public static Timestamp create(long seconds, int nanos) {
        if (seconds < -315576000000L || seconds > 315576000000L) {
            return new Timestamp(0L, 0);
        }
        if (nanos < 0 || nanos > 999999999) {
            return new Timestamp(0L, 0);
        }
        return new Timestamp(seconds, nanos);
    }

    public static Timestamp fromMillis(long millis) {
        long seconds = millis / 1000L;
        int nanos = (int)(millis % 1000L) * 1000000;
        if (nanos < 0) {
            return new Timestamp(seconds - 1L, (int)((long)nanos + 1000000000L));
        }
        return new Timestamp(seconds, nanos);
    }

    public long getSeconds() {
        return this.seconds;
    }

    public int getNanos() {
        return this.nanos;
    }

    public Timestamp addNanos(long nanos) {
        long newSeconds = this.seconds + nanos / 1000000000L;
        long newNanos = (nanos %= 1000000000L) + (long)this.nanos;
        newSeconds += newNanos / 1000000000L;
        if ((newNanos %= 1000000000L) >= 0L) {
            return Timestamp.create(newSeconds, (int)newNanos);
        }
        return Timestamp.create(newSeconds - 1L, (int)(newNanos + 1000000000L));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Timestamp)) {
            return false;
        }
        Timestamp that = (Timestamp)obj;
        return this.seconds == that.seconds && this.nanos == that.nanos;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (int)(this.seconds ^ this.seconds >>> 32);
        result = 31 * result + this.nanos;
        return result;
    }

    public String toString() {
        return "Timestamp<" + this.seconds + "," + this.nanos + ">";
    }
}

