/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.junit.Ignore;

@Ignore
@GwtCompatible
public class MapEqualsTester<K, V>
extends AbstractMapTester<K, V> {
    public void testEquals_otherMapWithSameEntries() {
        MapEqualsTester.assertTrue((String)"A Map should equal any other Map containing the same entries.", (boolean)this.getMap().equals(MapEqualsTester.newHashMap(this.getSampleEntries())));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testEquals_otherMapWithDifferentEntries() {
        HashMap other = MapEqualsTester.newHashMap(this.getSampleEntries(this.getNumEntries() - 1));
        other.put(this.k3(), this.v3());
        MapEqualsTester.assertFalse((String)"A Map should not equal another Map containing different entries.", (boolean)this.getMap().equals(other));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    public void testEquals_containingNullKey() {
        Collection entries = this.getSampleEntries(this.getNumEntries() - 1);
        entries.add(this.entry(null, this.v3()));
        this.resetContainer(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(entries.toArray()));
        MapEqualsTester.assertTrue((String)"A Map should equal any other Map containing the same entries, even if some keys are null.", (boolean)this.getMap().equals(MapEqualsTester.newHashMap(entries)));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testEquals_otherContainsNullKey() {
        Collection entries = this.getSampleEntries(this.getNumEntries() - 1);
        entries.add(this.entry(null, this.v3()));
        HashMap other = MapEqualsTester.newHashMap(entries);
        MapEqualsTester.assertFalse((String)"Two Maps should not be equal if exactly one of them contains a null key.", (boolean)this.getMap().equals(other));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    public void testEquals_containingNullValue() {
        Collection entries = this.getSampleEntries(this.getNumEntries() - 1);
        entries.add(this.entry(this.k3(), null));
        this.resetContainer(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).create(entries.toArray()));
        MapEqualsTester.assertTrue((String)"A Map should equal any other Map containing the same entries, even if some values are null.", (boolean)this.getMap().equals(MapEqualsTester.newHashMap(entries)));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testEquals_otherContainsNullValue() {
        Collection entries = this.getSampleEntries(this.getNumEntries() - 1);
        entries.add(this.entry(this.k3(), null));
        HashMap other = MapEqualsTester.newHashMap(entries);
        MapEqualsTester.assertFalse((String)"Two Maps should not be equal if exactly one of them contains a null value.", (boolean)this.getMap().equals(other));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testEquals_smallerMap() {
        Collection fewerEntries = this.getSampleEntries(this.getNumEntries() - 1);
        MapEqualsTester.assertFalse((String)"Maps of different sizes should not be equal.", (boolean)this.getMap().equals(MapEqualsTester.newHashMap(fewerEntries)));
    }

    public void testEquals_largerMap() {
        Collection moreEntries = this.getSampleEntries(this.getNumEntries() + 1);
        MapEqualsTester.assertFalse((String)"Maps of different sizes should not be equal.", (boolean)this.getMap().equals(MapEqualsTester.newHashMap(moreEntries)));
    }

    public void testEquals_list() {
        MapEqualsTester.assertFalse((String)"A List should never equal a Map.", (boolean)this.getMap().equals(Helpers.copyToList(this.getMap().entrySet())));
    }

    private static <K, V> HashMap<K, V> newHashMap(Collection<? extends Map.Entry<? extends K, ? extends V>> entries) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }
}

