/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.progress.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.progress.ui.RunOffEDTImpl;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

abstract class AbstractWindowRunner<T>
extends WindowAdapter
implements Runnable,
Callable<T> {
    private volatile JDialog dlg;
    private final boolean includeDetail;
    protected final ProgressHandle handle;
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile T operationResult;
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final CountDownLatch waitForTaskAssignment = new CountDownLatch(1);
    private RunOffEDTImpl.CancellableFutureTask<T> future;
    private final boolean showCancel;
    private static final RequestProcessor RP = new RequestProcessor(AbstractWindowRunner.class.getName(), 10);
    boolean isDispatchThread;
    private Component oldGlassPane;

    AbstractWindowRunner(ProgressHandle progressHandle, boolean bl, boolean bl2) {
        this.includeDetail = bl;
        this.handle = progressHandle;
        this.showCancel = bl2;
    }

    @Override
    public T call() throws Exception {
        try {
            T t = this.runBackground();
            return t;
        }
        finally {
            EventQueue.invokeLater(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<T> task() {
        RunOffEDTImpl.CancellableFutureTask<T> cancellableFutureTask;
        ProgressHandle progressHandle = this.handle;
        synchronized (progressHandle) {
            cancellableFutureTask = this.future;
        }
        return cancellableFutureTask;
    }

    Future<T> waitForStart() throws InterruptedException {
        Future<T> future = this.task();
        if (!EventQueue.isDispatchThread() && future == null) {
            this.startLatch.await();
            future = this.task();
        }
        assert (future != null);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void windowOpened(WindowEvent windowEvent) {
        RunOffEDTImpl.CancellableFutureTask<T> cancellableFutureTask;
        this.dlg = (JDialog)windowEvent.getSource();
        if (!this.isDispatchThread) {
            this.createTask();
        }
        AbstractWindowRunner abstractWindowRunner = this;
        synchronized (abstractWindowRunner) {
            cancellableFutureTask = this.future;
        }
        this.waitForTaskAssignment.countDown();
        this.grayOutMainWindow();
        cancellableFutureTask.task.schedule(0);
        this.startLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<T> createTask() {
        RunOffEDTImpl.CancellableFutureTask cancellableFutureTask = new RunOffEDTImpl.CancellableFutureTask(this);
        cancellableFutureTask.task = RP.create(cancellableFutureTask);
        ProgressHandle progressHandle = this.handle;
        synchronized (progressHandle) {
            this.future = cancellableFutureTask;
        }
        return cancellableFutureTask;
    }

    @Override
    public final void windowClosed(WindowEvent windowEvent) {
        this.ungrayMainWindow();
        this.latch.countDown();
    }

    final void await() throws InterruptedException {
        this.latch.await();
    }

    Future<T> start() {
        if (EventQueue.isDispatchThread()) {
            this.isDispatchThread = true;
            Future<T> future = this.createTask();
            this.dlg = this.createModalProgressDialog(this.handle, this.includeDetail);
            this.dlg.setVisible(true);
            return future;
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        DialogCreator dialogCreator = new DialogCreator(countDownLatch);
        EventQueue.invokeLater(dialogCreator);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
        return null;
    }

    protected abstract T runBackground();

    T getResult() {
        return this.operationResult;
    }

    @Override
    public void run() {
        if (!EventQueue.isDispatchThread()) {
            try {
                try {
                    this.waitForTaskAssignment.await();
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
                this.operationResult = this.runBackground();
            }
            finally {
                EventQueue.invokeLater(this);
            }
        }
        this.dlg.setVisible(false);
        this.dlg.dispose();
    }

    private JDialog createModalProgressDialog(ProgressHandle progressHandle, boolean bl) {
        Object object;
        Container container;
        assert (EventQueue.isDispatchThread());
        int n = Utilities.isMac() ? 12 : 8;
        int n2 = Utilities.isMac() ? 9 : 5;
        JPanel jPanel = new JPanel(new GridLayout(bl ? 3 : 2, 1, n2, n2));
        JLabel jLabel = ProgressHandleFactory.createMainLabelComponent((ProgressHandle)progressHandle);
        Font font = jLabel.getFont();
        if (font != null) {
            jLabel.setFont(font.deriveFont(1));
        }
        jPanel.add(jLabel);
        JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
        jComponent.setMinimumSize(new Dimension(400, 32));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)jComponent, gridBagConstraints);
        if (this.showCancel) {
            container = new JButton();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, Utilities.isMac() ? 12 : 5, 0, 0);
            jPanel2.add((Component)container, gridBagConstraints);
            ((AbstractButton)container).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractWindowRunner.this.task().cancel(true);
                }
            });
            ((AbstractButton)container).setBorderPainted(false);
            ((JComponent)container).setBorder(BorderFactory.createEmptyBorder());
            ((JComponent)container).setOpaque(false);
            ((AbstractButton)container).setContentAreaFilled(false);
            object = (Image)UIManager.get("nb.progress.cancel.icon");
            if (null != object) {
                ((AbstractButton)container).setIcon(ImageUtilities.image2Icon((Image)object));
            } else {
                ((AbstractButton)container).setText(NbBundle.getMessage(AbstractWindowRunner.class, (String)"ModalDialog.btnClose.text"));
            }
            object = (Image)UIManager.get("nb.progress.cancel.icon.mouseover");
            if (null != object) {
                ((AbstractButton)container).setRolloverEnabled(true);
                ((AbstractButton)container).setRolloverIcon(ImageUtilities.image2Icon((Image)object));
            }
            if (null != (object = (Image)UIManager.get("nb.progress.cancel.icon.pressed"))) {
                ((AbstractButton)container).setPressedIcon(ImageUtilities.image2Icon((Image)object));
            }
            ((JComponent)container).setToolTipText(NbBundle.getMessage(AbstractWindowRunner.class, (String)"ModalDialog.btnClose.tooltip"));
            ((JButton)container).getAccessibleContext().setAccessibleName(NbBundle.getMessage(AbstractWindowRunner.class, (String)"ModalDialog.btnClose.accessibleName"));
            ((JButton)container).getAccessibleContext().setAccessibleName(NbBundle.getMessage(AbstractWindowRunner.class, (String)"ModalDialog.btnClose.accessibleDescription"));
            jPanel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
            jPanel.getActionMap().put("cancel", new AbstractAction((JButton)container){
                final /* synthetic */ JButton val$closeButton;
                {
                    this.val$closeButton = jButton;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$closeButton.doClick();
                }
            });
        }
        jPanel.add(jPanel2);
        if (bl) {
            container = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)progressHandle);
            ((JComponent)container).setMinimumSize(new Dimension(300, 16));
            jPanel.add(container);
        }
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(n, n, n, n)));
        jPanel.setMinimumSize(new Dimension(400, 100));
        container = WindowManager.getDefault().getMainWindow();
        object = new JDialog((Frame)container, true);
        ((JDialog)object).setDefaultCloseOperation(0);
        ((Dialog)object).setUndecorated(true);
        ((Window)object).setSize(400, 100);
        ((JDialog)object).getContentPane().setLayout(new BorderLayout());
        ((JDialog)object).getContentPane().add((Component)jPanel, "Center");
        ((Window)object).pack();
        int n3 = ((Component)object).getWidth();
        ((Window)object).setSize(Math.max(n3, container instanceof JFrame ? ((JFrame)container).getContentPane().getWidth() / 3 : container.getWidth()), ((Component)object).getHeight());
        ((Window)object).setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
        ((Window)object).addWindowListener(this);
        if (EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable((JDialog)object){
                final /* synthetic */ JDialog val$result;
                {
                    this.val$result = jDialog;
                }

                @Override
                public void run() {
                    this.val$result.setVisible(true);
                }
            });
        } else {
            ((Dialog)object).setVisible(true);
        }
        return object;
    }

    private void grayOutMainWindow() {
        Map map;
        assert (EventQueue.isDispatchThread());
        Frame frame = WindowManager.getDefault().getMainWindow();
        if (frame instanceof JFrame && ((map = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints")) == null || !RenderingHints.VALUE_TEXT_ANTIALIAS_OFF.equals(map.get(RenderingHints.KEY_TEXT_ANTIALIASING)))) {
            JFrame jFrame = (JFrame)frame;
            RunOffEDTImpl.TranslucentMask translucentMask = new RunOffEDTImpl.TranslucentMask();
            this.oldGlassPane = jFrame.getGlassPane();
            jFrame.setGlassPane(translucentMask);
            translucentMask.setVisible(true);
            translucentMask.setBounds(0, 0, jFrame.getContentPane().getWidth(), jFrame.getContentPane().getHeight());
            translucentMask.invalidate();
            translucentMask.revalidate();
            translucentMask.repaint();
            jFrame.getRootPane().paintImmediately(0, 0, jFrame.getRootPane().getWidth(), jFrame.getRootPane().getHeight());
        }
    }

    private void ungrayMainWindow() {
        if (this.oldGlassPane != null) {
            JFrame jFrame = (JFrame)WindowManager.getDefault().getMainWindow();
            jFrame.setGlassPane(this.oldGlassPane);
            jFrame.getGlassPane().setVisible(false);
            jFrame.invalidate();
            jFrame.repaint();
        }
    }

    private final class DialogCreator
    implements Runnable {
        private final CountDownLatch latch;

        DialogCreator(CountDownLatch countDownLatch) {
            this.latch = countDownLatch;
        }

        @Override
        public void run() {
            AbstractWindowRunner.this.createModalProgressDialog(AbstractWindowRunner.this.handle, AbstractWindowRunner.this.includeDetail);
            this.latch.countDown();
        }
    }
}

