/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.template.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.xml.template.formatter.AbstractXmlTemplateFormattingModelBuilder;
import com.intellij.xml.template.formatter.FragmentedTemplateException;
import com.intellij.xml.template.formatter.IndentInheritingBlock;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.List;

public class TemplateXmlTagBlock
extends XmlTagBlock
implements IndentInheritingBlock {
    private final AbstractXmlTemplateFormattingModelBuilder myBuilder;
    private Indent myInheritedIndent;

    public TemplateXmlTagBlock(AbstractXmlTemplateFormattingModelBuilder builder2, ASTNode node, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent) {
        super(node, wrap, alignment, policy, indent);
        this.myBuilder = builder2;
    }

    @Override
    protected XmlTagBlock createTagBlock(ASTNode child2, Indent indent, Wrap wrap, Alignment alignment) {
        return this.myBuilder.createXmlTagBlock(child2, wrap, alignment, this.myXmlFormattingPolicy, indent);
    }

    @Override
    protected final Block createSyntheticBlock(ArrayList<Block> localResult, Indent childrenIndent) {
        try {
            List<Block> merged = this.myBuilder.mergeWithTemplateBlocks(localResult, this.myXmlFormattingPolicy.getSettings(), this.myXmlFormattingPolicy, childrenIndent);
            return this.myBuilder.createSyntheticBlock(merged, (Block)this, Indent.getNoneIndent(), this.myXmlFormattingPolicy, childrenIndent);
        }
        catch (FragmentedTemplateException e) {
            return this.myBuilder.createSyntheticBlock(localResult, (Block)this, Indent.getNoneIndent(), this.myXmlFormattingPolicy, childrenIndent);
        }
    }

    @Override
    protected XmlBlock createSimpleChild(ASTNode child2, Indent indent, Wrap wrap, Alignment alignment) {
        return this.myBuilder.createXmlBlock(child2, wrap, alignment, this.myXmlFormattingPolicy, indent, null);
    }

    @Override
    public void setIndent(Indent indent) {
        this.myInheritedIndent = indent;
    }

    @Override
    public Indent getIndent() {
        return this.myInheritedIndent == null ? super.getIndent() : this.myInheritedIndent;
    }

    @Override
    protected Indent getChildrenIndent() {
        return Indent.getIndent((Indent.Type)(this.myXmlFormattingPolicy.indentChildrenOf(this.getTag()) ? Indent.Type.NORMAL : Indent.Type.NONE), (boolean)false, (boolean)true);
    }

    boolean isScriptBlock() {
        return HtmlUtil.isScriptTag(this.getTag());
    }
}

