/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesOnServerTracker;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LazyRefreshingSelfQueue;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteRevisionsNumbersCache
implements ChangesOnServerTracker {
    public static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.RemoteRevisionsNumbersCache");
    private static final long ourRottenPeriod = 3600000L;
    private final Map<String, Pair<VcsRoot, VcsRevisionNumber>> myData;
    private final Map<VcsRoot, LazyRefreshingSelfQueue<String>> myRefreshingQueues;
    private final Map<String, VcsRevisionNumber> myLatestRevisionsMap;
    private final ProjectLevelVcsManager myVcsManager;
    private final LocalFileSystem myLfs;
    private boolean mySomethingChanged;
    private final Object myLock;
    public static final VcsRevisionNumber NOT_LOADED = new VcsRevisionNumber(){

        public String asString() {
            return "NOT_LOADED";
        }

        public int compareTo(@NotNull VcsRevisionNumber o) {
            if (o == null) {
                1.$$$reportNull$$$0(0);
            }
            return o == this ? 0 : -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/openapi/vcs/changes/RemoteRevisionsNumbersCache$1", "compareTo"));
        }
    };
    public static final VcsRevisionNumber UNKNOWN = new VcsRevisionNumber(){

        public String asString() {
            return "UNKNOWN";
        }

        public int compareTo(@NotNull VcsRevisionNumber o) {
            if (o == null) {
                2.$$$reportNull$$$0(0);
            }
            return o == this ? 0 : -1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/openapi/vcs/changes/RemoteRevisionsNumbersCache$2", "compareTo"));
        }
    };
    private final VcsConfiguration myVcsConfiguration;
    private final Project myProject;

    RemoteRevisionsNumbersCache(Project project) {
        this.myProject = project;
        this.myLock = new Object();
        this.myData = new HashMap<String, Pair<VcsRoot, VcsRevisionNumber>>();
        this.myRefreshingQueues = Collections.synchronizedMap(new HashMap());
        this.myLatestRevisionsMap = new HashMap<String, VcsRevisionNumber>();
        this.myLfs = LocalFileSystem.getInstance();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        this.myVcsConfiguration = VcsConfiguration.getInstance((Project)project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateStep() {
        HashMap<VcsRoot, LazyRefreshingSelfQueue<String>> copyMap;
        this.mySomethingChanged = false;
        Iterator<LazyRefreshingSelfQueue<String>> iterator = this.myLock;
        synchronized (iterator) {
            copyMap = new HashMap<VcsRoot, LazyRefreshingSelfQueue<String>>(this.myRefreshingQueues);
        }
        Iterator<Map.Entry<VcsRoot, LazyRefreshingSelfQueue<String>>> iterator2 = copyMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<VcsRoot, LazyRefreshingSelfQueue<String>> entry = iterator2.next();
            VcsRoot key = entry.getKey();
            boolean backgroundOperationsAllowed = key.getVcs().isVcsBackgroundOperationsAllowed(key.getPath());
            LOG.debug("backgroundOperationsAllowed: " + backgroundOperationsAllowed + " for " + key.getVcs().getName() + ", " + key.getPath().getPath());
            if (backgroundOperationsAllowed) continue;
            iterator2.remove();
        }
        LOG.debug("queues refresh started, queues: " + copyMap.size());
        for (LazyRefreshingSelfQueue<String> queue2 : copyMap.values()) {
            if (this.myProject.isDisposed()) {
                throw new ProcessCanceledException();
            }
            queue2.updateStep();
        }
        return this.mySomethingChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void directoryMappingChanged() {
        HashSet<String> keys;
        Object object = this.myLock;
        synchronized (object) {
            keys = new HashSet<String>(this.myData.keySet());
        }
        HashMap<String, Pair> vFiles = new HashMap<String, Pair>();
        for (String key : keys) {
            VirtualFile vf = this.myLfs.refreshAndFindFileByIoFile(new File(key));
            AbstractVcs newVcs = vf == null ? null : this.myVcsManager.getVcsFor(vf);
            vFiles.put(key, vf == null ? Pair.create((Object)null, (Object)null) : Pair.create((Object)vf, (Object)newVcs));
        }
        Object object2 = this.myLock;
        synchronized (object2) {
            keys = new HashSet<String>(this.myData.keySet());
            for (String key : keys) {
                Pair<VcsRoot, VcsRevisionNumber> value = this.myData.get(key);
                VcsRoot storedVcsRoot = (VcsRoot)value.getFirst();
                Pair pair = (Pair)vFiles.get(key);
                if (pair == null) continue;
                VirtualFile vf = (VirtualFile)pair.getFirst();
                AbstractVcs newVcs = (AbstractVcs)pair.getSecond();
                if (newVcs == null) {
                    this.myData.remove(key);
                    this.getQueue(storedVcsRoot).forceRemove(key);
                    continue;
                }
                VirtualFile newRoot = this.myVcsManager.getVcsRootFor(vf);
                VcsRoot newVcsRoot = new VcsRoot(newVcs, newRoot);
                if (storedVcsRoot.equals((Object)newVcsRoot)) continue;
                this.switchVcs(storedVcsRoot, newVcsRoot, key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchVcs(VcsRoot oldVcsRoot, VcsRoot newVcsRoot, String key) {
        Object object = this.myLock;
        synchronized (object) {
            LazyRefreshingSelfQueue<String> oldQueue = this.getQueue(oldVcsRoot);
            LazyRefreshingSelfQueue<String> newQueue = this.getQueue(newVcsRoot);
            this.myData.put(key, (Pair<VcsRoot, VcsRevisionNumber>)Pair.create((Object)newVcsRoot, (Object)NOT_LOADED));
            oldQueue.forceRemove(key);
            newQueue.addRequest(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeUpdated(@NotNull String path, @NotNull AbstractVcs vcs) {
        if (path == null) {
            RemoteRevisionsNumbersCache.$$$reportNull$$$0(0);
        }
        if (vcs == null) {
            RemoteRevisionsNumbersCache.$$$reportNull$$$0(1);
        }
        if (vcs.getDiffProvider() == null) {
            return;
        }
        VirtualFile root = this.getRootForPath(path);
        if (root == null) {
            return;
        }
        VcsRoot vcsRoot = new VcsRoot(vcs, root);
        Object object = this.myLock;
        synchronized (object) {
            Pair<VcsRoot, VcsRevisionNumber> value = this.myData.get(path);
            if (value == null) {
                LazyRefreshingSelfQueue<String> queue2 = this.getQueue(vcsRoot);
                this.myData.put(path, (Pair<VcsRoot, VcsRevisionNumber>)Pair.create((Object)vcsRoot, (Object)NOT_LOADED));
                queue2.addRequest(path);
            } else if (!((VcsRoot)value.getFirst()).equals((Object)vcsRoot)) {
                this.switchVcs((VcsRoot)value.getFirst(), vcsRoot, path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(Collection<String> paths) {
        Object object = this.myLock;
        synchronized (object) {
            for (String path : paths) {
                Pair<VcsRoot, VcsRevisionNumber> pair = this.myData.remove(path);
                if (pair == null) continue;
                VcsRoot vcsRoot = (VcsRoot)pair.getFirst();
                LazyRefreshingSelfQueue<String> queue2 = this.getQueue(vcsRoot);
                queue2.forceRemove(path);
                queue2.addRequest(path);
                this.myData.put(path, (Pair<VcsRoot, VcsRevisionNumber>)Pair.create((Object)vcsRoot, (Object)NOT_LOADED));
            }
        }
    }

    @Nullable
    private VirtualFile getRootForPath(String s) {
        return this.myVcsManager.getVcsRootFor(VcsUtil.getFilePath((String)s, (boolean)false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeRemoved(@NotNull String path, @NotNull AbstractVcs vcs) {
        LazyRefreshingSelfQueue<String> queue2;
        if (path == null) {
            RemoteRevisionsNumbersCache.$$$reportNull$$$0(2);
        }
        if (vcs == null) {
            RemoteRevisionsNumbersCache.$$$reportNull$$$0(3);
        }
        if (vcs.getDiffProvider() == null) {
            return;
        }
        VirtualFile root = this.getRootForPath(path);
        if (root == null) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            queue2 = this.getQueue(new VcsRoot(vcs, root));
            this.myData.remove(path);
        }
        queue2.forceRemove(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private LazyRefreshingSelfQueue<String> getQueue(VcsRoot vcsRoot) {
        Object object = this.myLock;
        // MONITORENTER : object
        LazyRefreshingSelfQueue<String> queue2 = this.myRefreshingQueues.get(vcsRoot);
        if (queue2 != null) {
            LazyRefreshingSelfQueue<String> lazyRefreshingSelfQueue = queue2;
            // MONITOREXIT : object
            if (lazyRefreshingSelfQueue != null) return lazyRefreshingSelfQueue;
            RemoteRevisionsNumbersCache.$$$reportNull$$$0(4);
            return lazyRefreshingSelfQueue;
        }
        queue2 = new LazyRefreshingSelfQueue<String>((Getter<Long>)((Getter)() -> this.myVcsConfiguration.CHANGED_ON_SERVER_INTERVAL > 0 ? (long)(this.myVcsConfiguration.CHANGED_ON_SERVER_INTERVAL * 60000) : 3600000L), new MyShouldUpdateChecker(vcsRoot), new MyUpdater(vcsRoot));
        this.myRefreshingQueues.put(vcsRoot, queue2);
        LazyRefreshingSelfQueue<String> lazyRefreshingSelfQueue = queue2;
        // MONITOREXIT : object
        if (lazyRefreshingSelfQueue != null) return lazyRefreshingSelfQueue;
        RemoteRevisionsNumbersCache.$$$reportNull$$$0(5);
        return lazyRefreshingSelfQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VcsRevisionNumber getNumber(String path) {
        Object object = this.myLock;
        synchronized (object) {
            Pair<VcsRoot, VcsRevisionNumber> pair = this.myData.get(path);
            return pair == null ? NOT_LOADED : (VcsRevisionNumber)pair.getSecond();
        }
    }

    @Override
    public boolean isUpToDate(@NotNull Change change, @NotNull AbstractVcs vcs) {
        if (change == null) {
            RemoteRevisionsNumbersCache.$$$reportNull$$$0(6);
        }
        if (vcs == null) {
            RemoteRevisionsNumbersCache.$$$reportNull$$$0(7);
        }
        if (change.getBeforeRevision() != null && change.getAfterRevision() != null && !change.isMoved() && !change.isRenamed()) {
            return this.getRevisionState(change.getBeforeRevision());
        }
        return this.getRevisionState(change.getBeforeRevision()) && this.getRevisionState(change.getAfterRevision());
    }

    private boolean getRevisionState(ContentRevision revision) {
        if (revision != null) {
            VcsRevisionNumber local = revision.getRevisionNumber();
            String path = revision.getFile().getPath();
            VcsRevisionNumber remote = this.getNumber(path);
            return NOT_LOADED == remote || UNKNOWN == remote || local.compareTo((Object)remote) >= 0;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/RemoteRevisionsNumbersCache";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/RemoteRevisionsNumbersCache";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "changeUpdated";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "changeRemoved";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyShouldUpdateChecker
    implements Computable<Boolean> {
        private final VcsRoot myVcsRoot;

        MyShouldUpdateChecker(VcsRoot vcsRoot) {
            this.myVcsRoot = vcsRoot;
        }

        public Boolean compute() {
            AbstractVcs vcs = this.myVcsRoot.getVcs();
            String vcsName = vcs.getName();
            LOG.debug("should update for: " + vcsName + " root: " + this.myVcsRoot.getPath().getPath());
            VcsRevisionNumber latestNew = vcs.getDiffProvider().getLatestCommittedRevision(this.myVcsRoot.getPath());
            VcsRevisionNumber latestKnown = (VcsRevisionNumber)RemoteRevisionsNumbersCache.this.myLatestRevisionsMap.get(vcsName);
            if (latestNew == null) {
                return true;
            }
            if (latestKnown == null || latestNew.compareTo((Object)latestKnown) != 0) {
                RemoteRevisionsNumbersCache.this.myLatestRevisionsMap.put(vcsName, latestNew);
                return true;
            }
            return false;
        }
    }

    private class MyUpdater
    implements Consumer<String> {
        private final VcsRoot myVcsRoot;

        MyUpdater(VcsRoot vcsRoot) {
            this.myVcsRoot = vcsRoot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consume(String s) {
            Pair oldPair;
            LOG.debug("update for: " + s);
            VirtualFile vf = RemoteRevisionsNumbersCache.this.myLfs.refreshAndFindFileByIoFile(new File(s));
            DiffProvider diffProvider = this.myVcsRoot.getVcs().getDiffProvider();
            ItemLatestState state = vf == null ? diffProvider.getLastRevision(VcsUtil.getFilePath((String)s, (boolean)false)) : diffProvider.getLastRevision(vf);
            VcsRevisionNumber newNumber = state == null || state.isDefaultHead() ? UNKNOWN : state.getNumber();
            Object object = RemoteRevisionsNumbersCache.this.myLock;
            synchronized (object) {
                oldPair = (Pair)RemoteRevisionsNumbersCache.this.myData.get(s);
                RemoteRevisionsNumbersCache.this.myData.put(s, Pair.create((Object)this.myVcsRoot, (Object)newNumber));
            }
            if (oldPair == null || ((VcsRevisionNumber)oldPair.getSecond()).compareTo((Object)newNumber) != 0) {
                LOG.debug("refresh triggered by " + s);
                RemoteRevisionsNumbersCache.this.mySomethingChanged = true;
            }
        }
    }
}

