/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.profile.codeInspection.BaseInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.WeakStringInterner;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemDescriptionNode
extends SuppressableInspectionTreeNode {
    private final CommonProblemDescriptor myDescriptor;
    private final HighlightDisplayLevel myLevel;
    protected final int myLineNumber;
    protected final RefEntity myElement;
    private static final WeakStringInterner NAME_INTERNER = new WeakStringInterner();

    public ProblemDescriptionNode(RefEntity element, @NotNull CommonProblemDescriptor descriptor, @NotNull InspectionToolPresentation presentation) {
        if (descriptor == null) {
            ProblemDescriptionNode.$$$reportNull$$$0(0);
        }
        if (presentation == null) {
            ProblemDescriptionNode.$$$reportNull$$$0(1);
        }
        this(element, descriptor, presentation, null);
    }

    protected ProblemDescriptionNode(@Nullable RefEntity element, CommonProblemDescriptor descriptor, @NotNull InspectionToolPresentation presentation, @Nullable IntSupplier lineNumberCounter) {
        if (presentation == null) {
            ProblemDescriptionNode.$$$reportNull$$$0(2);
        }
        super((Object)descriptor, presentation);
        this.myElement = element;
        this.myDescriptor = descriptor;
        this.myLevel = (HighlightDisplayLevel)ObjectUtils.notNull((Object)ProblemDescriptionNode.calculatePreciseLevel(element, descriptor, presentation), () -> {
            String shortName = presentation.getToolWrapper().getShortName();
            InspectionProfileImpl profile2 = presentation.getContext().getCurrentProfile();
            return profile2.getTools(shortName, presentation.getContext().getProject()).getLevel();
        });
        this.myLineNumber = this.myDescriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)this.myDescriptor).getLineNumber() : (lineNumberCounter == null ? -1 : lineNumberCounter.getAsInt());
    }

    private static HighlightDisplayLevel calculatePreciseLevel(@Nullable RefEntity element, @Nullable CommonProblemDescriptor descriptor, @NotNull InspectionToolPresentation presentation) {
        if (presentation == null) {
            ProblemDescriptionNode.$$$reportNull$$$0(3);
        }
        if (element == null) {
            return null;
        }
        InspectionProfileImpl profile2 = presentation.getContext().getCurrentProfile();
        String shortName = presentation.getToolWrapper().getShortName();
        if (descriptor instanceof ProblemDescriptor) {
            BaseInspectionProfileManager inspectionProfileManager = profile2.getProfileManager();
            RefElement refElement = (RefElement)element;
            SeverityRegistrar severityRegistrar = inspectionProfileManager.getSeverityRegistrar();
            HighlightSeverity severity = presentation.getSeverity(refElement);
            if (severity == null) {
                return null;
            }
            HighlightInfoType highlightInfoType = ProblemDescriptorUtil.highlightTypeFromDescriptor((ProblemDescriptor)descriptor, severity, severityRegistrar);
            HighlightSeverity highlightSeverity = highlightInfoType.getSeverity(refElement.getPsiElement());
            return HighlightDisplayLevel.find((HighlightSeverity)highlightSeverity);
        }
        return profile2.getTools(shortName, presentation.getContext().getProject()).getLevel();
    }

    @Nullable
    public String getToolTipText() {
        if (!this.isValid()) {
            return null;
        }
        CommonProblemDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            return null;
        }
        PsiElement element = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : null;
        return ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element, false);
    }

    @Override
    public final boolean isAlreadySuppressedFromView() {
        return this.myDescriptor != null && this.getPresentation().isSuppressed(this.myDescriptor);
    }

    public int getLineNumber() {
        return this.myLineNumber;
    }

    @Override
    public boolean canSuppress() {
        return super.canSuppress() && !this.isQuickFixAppliedFromView();
    }

    @NotNull
    public InspectionToolWrapper getToolWrapper() {
        InspectionToolWrapper inspectionToolWrapper = this.getPresentation().getToolWrapper();
        if (inspectionToolWrapper == null) {
            ProblemDescriptionNode.$$$reportNull$$$0(4);
        }
        return inspectionToolWrapper;
    }

    @Override
    @Nullable
    public RefEntity getElement() {
        return this.myElement;
    }

    @Override
    @Nullable
    public CommonProblemDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    @Override
    public void excludeElement() {
        CommonProblemDescriptor descriptor = this.getDescriptor();
        if (descriptor != null) {
            this.getPresentation().exclude(descriptor);
        }
    }

    @Override
    public void amnestyElement() {
        CommonProblemDescriptor descriptor = this.getDescriptor();
        if (descriptor != null) {
            this.getPresentation().amnesty(descriptor);
        }
    }

    @Override
    protected void visitProblemSeverities(@NotNull TObjectIntHashMap<HighlightDisplayLevel> counter) {
        if (counter == null) {
            ProblemDescriptionNode.$$$reportNull$$$0(5);
        }
        if (this.isValid() && !this.isExcluded() && !this.isQuickFixAppliedFromView() && !this.isAlreadySuppressedFromView()) {
            counter.put((Object)this.myLevel, counter.get((Object)this.myLevel) + 1);
        }
    }

    @Override
    protected boolean calculateIsValid() {
        if (this.myDescriptor == null) {
            return false;
        }
        if (this.myElement == null || !this.myElement.isValid()) {
            return false;
        }
        if (this.myDescriptor instanceof ProblemDescriptor) {
            PsiElement psiElement = ((ProblemDescriptor)this.myDescriptor).getPsiElement();
            return psiElement != null && psiElement.isValid();
        }
        return true;
    }

    @Override
    public boolean isExcluded() {
        return this.getPresentation().isExcluded(this.getDescriptor());
    }

    @Override
    @NotNull
    protected String calculatePresentableName() {
        CommonProblemDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            if ("" == null) {
                ProblemDescriptionNode.$$$reportNull$$$0(6);
            }
            return "";
        }
        PsiElement element = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : null;
        String name = XmlStringUtil.stripHtml((String)ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element, 4));
        String string = NAME_INTERNER.intern(name);
        if (string == null) {
            ProblemDescriptionNode.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public boolean isQuickFixAppliedFromView() {
        return this.myDescriptor != null && this.getPresentation().isProblemResolved(this.myDescriptor) && !this.isAlreadySuppressedFromView();
    }

    @Override
    @Nullable
    public String getTailText() {
        String text = super.getTailText();
        return text == null ? "" : text;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ui/ProblemDescriptionNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "counter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ui/ProblemDescriptionNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWrapper";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calculatePreciseLevel";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitProblemSeverities";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

