/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint.rules;

import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.modules.profiler.heapwalk.memorylint.Histogram;
import org.netbeans.modules.profiler.heapwalk.memorylint.IteratingRule;
import org.netbeans.modules.profiler.heapwalk.memorylint.MemoryLint;
import org.netbeans.modules.profiler.heapwalk.memorylint.Utils;
import org.openide.util.NbBundle;

public class RetainedSetByInstance
extends IteratingRule {
    private static String CLASSNAME = "java.io.File";
    private Heap heap;
    private Set<Histogram> allDocs = new HashSet<Histogram>();

    public RetainedSetByInstance() {
        super(NbBundle.getMessage(RetainedSetByInstance.class, (String)"LBL_RSBI_Name"), NbBundle.getMessage(RetainedSetByInstance.class, (String)"LBL_RSBI_Desc"), CLASSNAME);
    }

    @Override
    public String getHTMLDescription() {
        return NbBundle.getMessage(RetainedSetByInstance.class, (String)"LBL_RSBI_LongDesc");
    }

    @Override
    public void perform(Instance hm) {
        Set<Instance> retained = Utils.getRetainedSet(hm, this.heap);
        Histogram hist = new Histogram();
        for (Instance i : retained) {
            String key = Utils.printClass(this.getContext(), i.getJavaClass().getName());
            hist.add(key, new Histogram.Entry(i.getSize()));
        }
        this.allDocs.add(hist);
    }

    @Override
    protected JComponent createCustomizer() {
        return new Customizer();
    }

    @Override
    protected void prepareRule(MemoryLint context) {
        this.heap = context.getHeap();
    }

    @Override
    protected String resultsHeader() {
        return "<h2>" + this.getDisplayName() + " (" + Utils.printClass(this.getContext(), CLASSNAME) + ")</h2>";
    }

    @Override
    protected void summary() {
        for (Histogram h : this.allDocs) {
            this.getContext().appendResults(h.toString(0));
        }
    }

    void updateClassName(String className) {
        CLASSNAME = className;
        this.setClassNamePattern(className);
    }

    private class Customizer
    extends JPanel {
        JTextField txtFld;

        Customizer() {
            this.setLayout(new BoxLayout(this, 0));
            JLabel caption = new JLabel(NbBundle.getMessage(RetainedSetByInstance.class, (String)"LBL_ClassName"));
            caption.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.add(caption);
            this.txtFld = new JTextField(CLASSNAME, 15);
            this.txtFld.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    RetainedSetByInstance.this.updateClassName(Customizer.this.txtFld.getText());
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    RetainedSetByInstance.this.updateClassName(Customizer.this.txtFld.getText());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    RetainedSetByInstance.this.updateClassName(Customizer.this.txtFld.getText());
                }
            });
            this.add(this.txtFld);
        }
    }
}

