/*
 * Decompiled with CFR 0.152.
 */
package org.jvyamlb;

import java.util.ArrayList;
import java.util.HashMap;
import org.jruby.util.ByteList;
import org.jvyamlb.TestBean2;
import org.jvyamlb.YAML;
import org.jvyamlb.YAMLTestCase;

public class YAMLDumpTest
extends YAMLTestCase {
    public YAMLDumpTest(String name) {
        super(name);
    }

    public void testBasicStringDump() {
        YAMLDumpTest.assertEquals((Object)ByteList.create((CharSequence)"--- str\n"), (Object)YAML.dump(ByteList.create((CharSequence)"str")));
    }

    public void testBasicHashDump() {
        HashMap<ByteList, ByteList> ex = new HashMap<ByteList, ByteList>();
        ex.put(ByteList.create((CharSequence)"a"), ByteList.create((CharSequence)"b"));
        YAMLDumpTest.assertEquals((Object)ByteList.create((CharSequence)"--- \na: b\n"), (Object)YAML.dump(ex));
    }

    public void testBasicListDump() {
        ArrayList<ByteList> ex = new ArrayList<ByteList>();
        ex.add(ByteList.create((CharSequence)"a"));
        ex.add(ByteList.create((CharSequence)"b"));
        ex.add(ByteList.create((CharSequence)"c"));
        YAMLDumpTest.assertEquals((Object)ByteList.create((CharSequence)"--- \n- a\n- b\n- c\n"), (Object)YAML.dump(ex));
    }

    public void testVersionDumps() {
        YAMLDumpTest.assertEquals((Object)ByteList.create((CharSequence)"--- !!int 1\n"), (Object)YAML.dump((Object)new Integer(1), YAML.config().explicitTypes(true)));
        YAMLDumpTest.assertEquals((Object)ByteList.create((CharSequence)"--- !int 1\n"), (Object)YAML.dump((Object)new Integer(1), YAML.config().version("1.0").explicitTypes(true)));
    }

    public void testMoreScalars() {
        YAMLDumpTest.assertEquals((Object)ByteList.create((CharSequence)"--- \"1.0\"\n"), (Object)YAML.dump(ByteList.create((CharSequence)"1.0")));
    }

    public void testPrefersQuotesToExplicitTag() {
        YAMLDumpTest.assertEquals((Object)ByteList.create((CharSequence)"--- \"30\"\n"), (Object)YAML.dump(ByteList.create((CharSequence)"30")));
    }

    public void testEmptyList() {
        YAMLDumpTest.assertEquals((Object)ByteList.create((CharSequence)"--- []\n\n"), (Object)YAML.dump(new ArrayList()));
    }

    public void testEmptyMap() {
        YAMLDumpTest.assertEquals((Object)ByteList.create((CharSequence)"--- {}\n\n"), (Object)YAML.dump(new HashMap()));
    }

    public void testEmptyListAsKey() {
        HashMap m = new HashMap();
        m.put(new ArrayList(), "");
        YAMLDumpTest.assertEquals((Object)ByteList.create((CharSequence)"--- \n? []\n\n: \"\"\n"), (Object)YAML.dump(m));
    }

    public void testEmptyMapAsKey() {
        HashMap m = new HashMap();
        m.put(new HashMap(), "");
        YAMLDumpTest.assertEquals((Object)ByteList.create((CharSequence)"--- \n? {}\n\n: \"\"\n"), (Object)YAML.dump(m));
    }

    public void testDumpJavaBean() {
        TestBean2 toDump = new TestBean2(ByteList.create((CharSequence)"Ola Bini"), 24);
        ByteList v = YAML.dump(toDump);
        String s = v.toString();
        YAMLDumpTest.assertTrue((String)("something is wrong with: \"" + v + "\""), (ByteList.create((CharSequence)"--- !java/object:org.jvyamlb.TestBean2 \nname: Ola Bini\nage: 24\n").equals((Object)v) || ByteList.create((CharSequence)"--- !java/object:org.jvyamlb.TestBean2 \nage: 24\nname: Ola Bini\n").equals((Object)v) ? 1 : 0) != 0);
    }
}

