/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartOverlay;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemsModel;
import org.netbeans.modules.profiler.snaptracer.impl.swing.ColorIcon;
import org.netbeans.modules.profiler.snaptracer.impl.swing.LabelRenderer;
import org.netbeans.modules.profiler.snaptracer.impl.swing.LegendFont;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineChart;

final class TimelineUnitsOverlay
extends ChartOverlay {
    private final TimelineChart chart;
    private final LabelRenderer painter;
    private Model model;

    TimelineUnitsOverlay(TimelineChart chart) {
        this.chart = chart;
        this.painter = new LabelRenderer();
        this.painter.setFont(new LegendFont());
        int size = this.painter.getFont().getSize() - 3;
        ColorIcon.setup(size, size, LegendFont.FOREGROUND_COLOR, LegendFont.BACKGROUND_COLOR);
    }

    void setupModel(Model model) {
        this.model = model;
    }

    private boolean hasValues() {
        return ((SynchronousXYItemsModel)this.chart.getItemsModel()).getTimeline().getTimestampsCount() > 0;
    }

    private void setupPainter(String text, Color color) {
        this.painter.setText(text);
        this.painter.setIcon(color == null ? null : ColorIcon.fromColor(color));
    }

    public void paint(Graphics g) {
        if (this.model == null || !this.hasValues()) {
            return;
        }
        int w = this.getWidth();
        this.model.prefetch();
        int rowsCount = this.chart.getRowsCount();
        for (int rowIndex = 0; rowIndex < rowsCount; ++rowIndex) {
            int itemIndex;
            TimelineChart.Row row = this.chart.getRow(rowIndex);
            ChartContext rowContext = row.getContext();
            int y = Utils.checkedInt((double)rowContext.getViewportOffsetY());
            int h = rowContext.getViewportHeight();
            Color[] colors = this.model.getColors(row);
            int xx = w - 2;
            int yy = y;
            for (itemIndex = colors.length - 1; itemIndex >= 0; --itemIndex) {
                this.setupPainter(this.model.getMaxUnits(row)[itemIndex], colors[itemIndex]);
                this.paint(g, xx -= this.painter.getPreferredSize().width, yy);
                xx -= 10;
            }
            xx = w - 2;
            yy = -1;
            for (itemIndex = colors.length - 1; itemIndex >= 0; --itemIndex) {
                this.setupPainter(this.model.getMinUnits(row)[itemIndex], colors[itemIndex]);
                Dimension pd = this.painter.getPreferredSize();
                xx -= pd.width;
                if (yy == -1) {
                    yy = y + h - pd.height - 1;
                }
                this.paint(g, xx, yy);
                xx -= 10;
            }
        }
    }

    private void paint(Graphics g, int x, int y) {
        this.painter.setLocation(x, y + 1);
        this.painter.setForeground(LegendFont.BACKGROUND_COLOR);
        this.painter.paint(g);
        this.painter.setLocation(x, y);
        this.painter.setForeground(LegendFont.FOREGROUND_COLOR);
        if (this.painter.getIcon() != null) {
            this.painter.setIcon(ColorIcon.BOTTOM_SHADOW);
        }
        this.painter.paint(g);
    }

    public void invalidate() {
    }

    public void update(Graphics g) {
    }

    static interface Model {
        public void prefetch();

        public Color[] getColors(TimelineChart.Row var1);

        public String[] getMinUnits(TimelineChart.Row var1);

        public String[] getMaxUnits(TimelineChart.Row var1);
    }
}

