/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.List;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChartContext;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.PointsComputer;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineXYPainter;

final class DiscreteXYPainter
extends TimelineXYPainter {
    private static final Polygon POLYGON = new Polygon();
    private static final int[] x3arr = new int[3];
    private static final int[] y3arr = new int[3];
    private static final int[] x4arr = new int[4];
    private static final int[] y4arr = new int[4];
    protected final int lineWidth;
    protected final Color lineColor;
    protected final Color fillColor;
    protected final Color definingColor;
    protected final Stroke lineStroke;
    protected final int width;
    protected final boolean fixedWidth;
    protected final boolean topLineOnly;
    protected final boolean outlineOnly;
    private final PointsComputer computer;

    DiscreteXYPainter(float lineWidth, Color lineColor, Color fillColor, int width, boolean fixedWidth, boolean topLineOnly, boolean outlineOnly, double dataFactor, PointsComputer computer) {
        super((int)Math.ceil(lineWidth), fillColor != null || !topLineOnly && !outlineOnly, dataFactor);
        if (lineColor == null && fillColor == null) {
            throw new IllegalArgumentException("lineColor or fillColor must not be null");
        }
        this.lineWidth = (int)Math.ceil(lineWidth);
        this.lineColor = Utils.checkedColor((Color)lineColor);
        this.fillColor = Utils.checkedColor((Color)fillColor);
        this.definingColor = lineColor != null ? lineColor : fillColor;
        this.lineStroke = new BasicStroke(lineWidth, 1, 1);
        this.width = width;
        this.fixedWidth = fixedWidth;
        this.topLineOnly = topLineOnly;
        this.outlineOnly = outlineOnly;
        this.computer = computer;
    }

    @Override
    protected Color getDefiningColor() {
        return this.definingColor;
    }

    @Override
    protected void paint(XYItem item, List<ItemSelection> highlighted, List<ItemSelection> selected, Graphics2D g, Rectangle dirtyArea, SynchronousXYChartContext context) {
        block21: {
            int valuesCount;
            int zeroYLimit;
            int zeroY;
            block22: {
                int startX;
                zeroY = 0;
                zeroYLimit = 0;
                if (this.fillColor != null || !this.topLineOnly) {
                    zeroY = Utils.checkedInt((double)context.getViewY((double)context.getDataOffsetY()));
                    zeroY = Math.max(Utils.checkedInt((double)context.getViewportOffsetY()), zeroY);
                    zeroY = Math.min(Utils.checkedInt((double)(context.getViewportOffsetY() + (long)context.getViewportHeight())), zeroY);
                    zeroYLimit = zeroY - this.lineWidth + 1;
                }
                int outlineWidth = this.lineColor == null || this.topLineOnly || this.outlineOnly ? 0 : Math.max(1, (this.width > 0 ? 2 : 1) * this.lineWidth - 1);
                valuesCount = item.getValuesCount();
                if (this.width <= 0 && this.lineColor != null && !this.topLineOnly) break block22;
                int[][] idxs = this.computer.getVisible(dirtyArea, valuesCount, context, 1, 0);
                if (idxs == null) {
                    return;
                }
                int[] visibleIndexes = idxs[0];
                int npoints = idxs[1][0];
                int[][] points = this.computer.createPoints(visibleIndexes, npoints, item, this.dataFactor, context);
                int[] xpoints = points[0];
                int[] ypoints = points[1];
                int currentX = startX = xpoints[0];
                int nextX = 0;
                int itemsOffset = this.fixedWidth ? 0 : this.width;
                for (int i = 0; i < npoints; ++i) {
                    int stopX;
                    int height = zeroY - ypoints[i];
                    if (this.fixedWidth) {
                        startX = Math.max(startX, currentX - this.width / 2);
                        nextX = i == npoints - 1 ? xpoints[i] : xpoints[i + 1];
                        stopX = currentX + Math.min(this.width / 2, (nextX - currentX) / 2);
                    } else {
                        nextX = i == npoints - 1 ? xpoints[i] : xpoints[i + 1];
                        int diff = nextX - currentX;
                        itemsOffset = Math.min(diff, this.width + 1);
                        stopX = currentX + (diff - itemsOffset) / 2;
                    }
                    int segmentWidth = stopX - startX;
                    if (this.fillColor != null && segmentWidth >= outlineWidth) {
                        g.setColor(this.fillColor);
                        g.fillRect(startX, zeroY - height, segmentWidth + 1, height);
                    }
                    if (this.lineColor != null) {
                        g.setColor(this.lineColor);
                        g.setStroke(this.lineStroke);
                        if (this.topLineOnly) {
                            g.drawLine(startX, zeroY - height, Math.max(startX + 1, stopX), zeroY - height);
                        } else if (segmentWidth + 1 <= this.lineWidth) {
                            g.drawLine(startX, zeroY - height, startX, zeroYLimit);
                        } else {
                            int[] yy;
                            int[] xx;
                            if (i == 0) {
                                xx = DiscreteXYPainter.xArr(startX, stopX, stopX);
                                yy = DiscreteXYPainter.yArr(zeroY - height, zeroY - height, zeroYLimit);
                            } else if (i == npoints - 1) {
                                xx = DiscreteXYPainter.xArr(startX, startX, stopX);
                                yy = DiscreteXYPainter.yArr(zeroYLimit, zeroY - height, zeroY - height);
                            } else {
                                xx = DiscreteXYPainter.xArr(startX, startX, stopX, stopX);
                                yy = DiscreteXYPainter.yArr(zeroYLimit, zeroY - height, zeroY - height, zeroYLimit);
                            }
                            g.drawPolyline(xx, yy, xx.length);
                        }
                    }
                    currentX = nextX;
                    startX = stopX + itemsOffset;
                }
                break block21;
            }
            int extraPoints = this.fillColor != null ? 2 : 0;
            int[][] idxs = this.computer.getVisible(dirtyArea, valuesCount, context, 2, extraPoints);
            if (idxs == null) {
                return;
            }
            int[] visibleIndexes = idxs[0];
            int npoints = idxs[1][0];
            int[][] points = this.computer.createPoints(visibleIndexes, npoints, item, this.dataFactor, context);
            int[] xpoints = points[0];
            int[] ypoints = points[1];
            int npointse = npoints;
            npoints -= extraPoints;
            int lastX = xpoints[0];
            for (int index = 1; index < npoints - 2; index += 2) {
                int currentX = xpoints[index + 1];
                currentX -= (currentX - lastX) / 2;
                xpoints[index] = currentX;
                lastX = xpoints[index + 1];
                xpoints[index + 1] = currentX;
            }
            if (this.fillColor != null) {
                xpoints[npointse - 2] = xpoints[npointse - 3];
                ypoints[npointse - 2] = zeroY;
                xpoints[npointse - 1] = xpoints[0];
                ypoints[npointse - 1] = ypoints[npointse - 2];
                DiscreteXYPainter.POLYGON.xpoints = xpoints;
                DiscreteXYPainter.POLYGON.ypoints = ypoints;
                DiscreteXYPainter.POLYGON.npoints = npointse;
                g.setPaint(this.fillColor);
                g.fill(POLYGON);
            }
            g.setColor(this.lineColor);
            g.setStroke(this.lineStroke);
            g.drawPolyline(xpoints, ypoints, npoints);
            if (this.outlineOnly) break block21;
            g.setColor(this.lineColor);
            g.setStroke(this.lineStroke);
            for (int i = 1; i < npoints - 1; ++i) {
                int y = ypoints[i] + this.lineWidth / 2;
                if (y < zeroYLimit) {
                    g.drawLine(xpoints[i], y, xpoints[i], zeroYLimit);
                }
                if ((i += 3) < npoints - 1) {
                    y = ypoints[i] + this.lineWidth / 2;
                    if (y >= zeroYLimit) continue;
                    g.drawLine(xpoints[i], y, xpoints[i], zeroYLimit);
                    continue;
                }
                break;
            }
        }
    }

    private static int[] xArr(int ... vals) {
        if (vals.length == 3) {
            DiscreteXYPainter.x3arr[0] = vals[0];
            DiscreteXYPainter.x3arr[1] = vals[1];
            DiscreteXYPainter.x3arr[2] = vals[2];
            return x3arr;
        }
        DiscreteXYPainter.x4arr[0] = vals[0];
        DiscreteXYPainter.x4arr[1] = vals[1];
        DiscreteXYPainter.x4arr[2] = vals[2];
        DiscreteXYPainter.x4arr[3] = vals[3];
        return x4arr;
    }

    private static int[] yArr(int ... vals) {
        if (vals.length == 3) {
            DiscreteXYPainter.y3arr[0] = vals[0];
            DiscreteXYPainter.y3arr[1] = vals[1];
            DiscreteXYPainter.y3arr[2] = vals[2];
            return y3arr;
        }
        DiscreteXYPainter.y4arr[0] = vals[0];
        DiscreteXYPainter.y4arr[1] = vals[1];
        DiscreteXYPainter.y4arr[2] = vals[2];
        DiscreteXYPainter.y4arr[3] = vals[3];
        return y4arr;
    }
}

