/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.swing;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class DropdownButton
extends JToggleButton {
    public static final String KEY_CLASS = "KEY_CLASS";
    public static final String KEY_BOOLVALUE = "KEY_BOOLVALUE";
    private final List<Action> actions = new ArrayList<Action>();

    public DropdownButton(Icon icon) {
        super(icon);
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    public void addSeparator() {
        this.actions.add(null);
    }

    @Override
    protected void fireActionPerformed(ActionEvent event) {
        JPopupMenu popup = new JPopupMenu();
        for (Action action : this.actions) {
            this.addAction(popup, action);
        }
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                DropdownButton.this.setSelected(true);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                DropdownButton.this.setSelected(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        popup.show(this, this.getWidth() - popup.getPreferredSize().width, this.getHeight());
    }

    private void addAction(JPopupMenu popup, Action action) {
        if (action == null) {
            popup.addSeparator();
        } else {
            Class cls = (Class)action.getValue(KEY_CLASS);
            if (Boolean.class.equals((Object)cls)) {
                Boolean boolvalue = (Boolean)action.getValue(KEY_BOOLVALUE);
                JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
                item.setSelected(boolvalue);
                popup.add(item);
            } else {
                popup.add(action);
            }
        }
    }
}

