/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.unit;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.xml.catalog.spi.CatalogDescriptor2;
import org.netbeans.modules.xml.catalog.spi.CatalogListener;
import org.netbeans.modules.xml.catalog.spi.CatalogReader;
import org.openide.util.NbBundle;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PersistenceCatalog
implements CatalogReader,
CatalogDescriptor2,
EntityResolver {
    private static final String PERSISTENCE_OLD_NS = "http://java.sun.com/xml/ns/persistence";
    private static final String PERSISTENCE_NS = "http://xmlns.jcp.org/xml/ns/persistence";
    private static final String ORM_OLD_NS = "http://java.sun.com/xml/ns/persistence/orm";
    private static final String ORM_NS = "http://xmlns.jcp.org/xml/ns/persistence/orm";
    private static final String RESOURCE_PATH = "nbres:/org/netbeans/modules/j2ee/persistence/dd/resources/";
    private List<SchemaInfo> schemas = new ArrayList<SchemaInfo>();

    public PersistenceCatalog() {
        this.initialize();
    }

    private void initialize() {
        this.schemas.add(new SchemaInfo("persistence_1_0.xsd", RESOURCE_PATH, PERSISTENCE_OLD_NS));
        this.schemas.add(new SchemaInfo("persistence_2_0.xsd", RESOURCE_PATH, PERSISTENCE_OLD_NS));
        this.schemas.add(new SchemaInfo("persistence_2_1.xsd", RESOURCE_PATH, PERSISTENCE_NS));
        this.schemas.add(new SchemaInfo("orm_1_0.xsd", RESOURCE_PATH, ORM_OLD_NS));
        this.schemas.add(new SchemaInfo("orm_2_0.xsd", RESOURCE_PATH, ORM_OLD_NS));
        this.schemas.add(new SchemaInfo("orm_2_1.xsd", RESOURCE_PATH, ORM_NS));
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId == null) {
            return null;
        }
        for (SchemaInfo each : this.schemas) {
            if (!systemId.endsWith(each.getSchemaName())) continue;
            return new InputSource(each.getResourcePath());
        }
        return null;
    }

    public Iterator getPublicIDs() {
        ArrayList<String> result = new ArrayList<String>();
        for (SchemaInfo each : this.schemas) {
            result.add(each.getPublicId());
        }
        return result.iterator();
    }

    public void refresh() {
    }

    public String getSystemID(String publicId) {
        if (publicId == null) {
            return null;
        }
        for (SchemaInfo each : this.schemas) {
            if (!each.getPublicId().equals(publicId)) continue;
            return each.getResourcePath();
        }
        return null;
    }

    public String resolveURI(String name) {
        return null;
    }

    public String resolvePublic(String publicId) {
        return null;
    }

    public void addCatalogListener(CatalogListener l) {
    }

    public void removeCatalogListener(CatalogListener l) {
    }

    public String getIconResource(int type) {
        return "org/netbeans/modules/j2ee/persistence/dd/resources/persistenceCatalog.gif";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(PersistenceCatalog.class, (String)"LBL_PersistenceCatalog");
    }

    public String getShortDescription() {
        return NbBundle.getMessage(PersistenceCatalog.class, (String)"DESC_PersistenceCatalog");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
    }

    private static class SchemaInfo {
        private final String schemaName;
        private final String resourcePath;
        private final String namespace;

        public SchemaInfo(String schemaName, String resourcePath, String namespace) {
            this.schemaName = schemaName;
            this.resourcePath = resourcePath + schemaName;
            this.namespace = namespace;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getPublicId() {
            return "SCHEMA:" + this.namespace + "/" + this.schemaName;
        }
    }
}

